/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.impl.gitlab;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.service.UserResolution;
import jetbrains.youtrack.integration.vcs.impl.AbstractVcsChangesConsumer;
import jetbrains.youtrack.integration.vcs.impl.gitlab.GitLabChangeDTO;
import jetbrains.youtrack.integration.vcs.impl.gitlab.GitLabPayloadMethodsKt;
import jetbrains.youtrack.integration.vcs.impl.gitlab.GitLabService;
import jetbrains.youtrack.integration.vcs.impl.gitlab.api.GitLabCommit;
import jetbrains.youtrack.integration.vcs.impl.gitlab.api.GitLabHookPushPayload;
import jetbrains.youtrack.integration.vcs.impl.gitlab.api.GitLabRestV4;
import jetbrains.youtrack.integration.vcs.impl.gitlab.api.GitLabUser;
import jetbrains.youtrack.integration.vcs.persistence.XdGitLabChangesProcessor;
import jetbrains.youtrack.integration.vcs.persistence.XdVcsHostingChangesProcessor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\u00142\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0014J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0004H\u0014J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0004H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Ljetbrains/youtrack/integration/vcs/impl/gitlab/GitLabPushConsumer;", "Ljetbrains/youtrack/integration/vcs/impl/AbstractVcsChangesConsumer;", "Ljetbrains/youtrack/integration/vcs/persistence/XdGitLabChangesProcessor;", "Ljetbrains/youtrack/integration/vcs/impl/gitlab/api/GitLabHookPushPayload;", "Ljetbrains/youtrack/integration/vcs/impl/gitlab/api/GitLabCommit;", "vcsService", "Ljetbrains/youtrack/integration/vcs/impl/gitlab/GitLabService;", "processor", "(Ljetbrains/youtrack/integration/vcs/impl/gitlab/GitLabService;Ljetbrains/youtrack/integration/vcs/persistence/XdGitLabChangesProcessor;)V", "getVcsService", "()Ljetbrains/youtrack/integration/vcs/impl/gitlab/GitLabService;", "createDto", "Ljetbrains/youtrack/integration/vcs/impl/gitlab/GitLabChangeDTO;", "commit", "userResolution", "Ljetbrains/youtrack/integration/service/UserResolution;", "getBranch", "", "payload", "getCommits", "", "getRepositoryPath", "getVersion", "resolveUser", "youtrack-vcs-hosting-integration"})
public final class GitLabPushConsumer
extends AbstractVcsChangesConsumer<XdGitLabChangesProcessor, GitLabHookPushPayload, GitLabCommit> {
    @NotNull
    private final GitLabService vcsService;

    @Override
    @NotNull
    protected String getBranch(@NotNull GitLabHookPushPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        String string = payload.getRef();
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    @Nullable
    protected String getRepositoryPath(@NotNull GitLabHookPushPayload payload) {
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        return GitLabPayloadMethodsKt.extractRepositoryPath(payload, (XdVcsChangeProcessor)this.getProcessor());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected List<GitLabCommit> getCommits(@NotNull GitLabHookPushPayload payload) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)payload, (String)"payload");
        List list2 = payload.getCommits();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        List commits = list2;
        Iterable $this$map$iv = commits;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GitLabCommit gitLabCommit = (GitLabCommit)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getId();
            collection.add(string);
        }
        Set commitIDS = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (commits.size() < payload.getTotalCommitsCount()) {
            void $this$filterTo$iv$iv;
            ((XdGitLabChangesProcessor)((Object)this.getProcessor())).logInfo("Push has truncated payload, loading commits manually");
            GitLabCommit gitLabCommit = (GitLabCommit)CollectionsKt.lastOrNull((List)commits);
            if (gitLabCommit == null) {
                return commits;
            }
            GitLabCommit lastCommit = gitLabCommit;
            GitLabRestV4 rest = this.getVcsService().rest((XdGitLabChangesProcessor)((Object)this.getProcessor()));
            long l = payload.getProjectId();
            String string = lastCommit.getDate();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            int n = payload.getTotalCommitsCount() + commits.size();
            String string2 = ((XdGitLabChangesProcessor)((Object)this.getProcessor())).getToken();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Iterable $this$filter$iv = rest.loadExtraCommits(l, string, n, string2, this.getBranch(payload));
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                GitLabCommit it = (GitLabCommit)element$iv$iv;
                boolean bl = false;
                if (!(!commitIDS.contains(it.getId()))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List extraCommits = (List)destination$iv$iv2;
            return CollectionsKt.plus((Collection)extraCommits, (Iterable)commits);
        }
        return commits;
    }

    @NotNull
    protected GitLabChangeDTO createDto(@NotNull GitLabCommit commit, @NotNull UserResolution userResolution) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        Intrinsics.checkParameterIsNotNull((Object)userResolution, (String)"userResolution");
        return new GitLabChangeDTO(null, userResolution.getUser(), userResolution.getNoUserReason(), commit, (XdVcsChangeProcessor)this.getProcessor());
    }

    @Override
    @NotNull
    protected String getVersion(@NotNull GitLabCommit commit) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        return commit.getId();
    }

    @Override
    @NotNull
    public UserResolution resolveUser(@NotNull GitLabCommit commit) {
        Intrinsics.checkParameterIsNotNull((Object)commit, (String)"commit");
        GitLabUser gitLabUser = new GitLabUser();
        boolean bl = false;
        boolean bl2 = false;
        GitLabUser $this$apply = gitLabUser;
        boolean bl3 = false;
        GitLabUser gitLabUser2 = commit.getAuthor();
        $this$apply.setId(gitLabUser2 != null ? gitLabUser2.getId() : null);
        GitLabUser gitLabUser3 = commit.getAuthor();
        $this$apply.setUsername(gitLabUser3 != null ? gitLabUser3.getUsername() : null);
        $this$apply.setName(commit.getAuthorName());
        $this$apply.setEmail(commit.getAuthorEmail());
        return GitLabPayloadMethodsKt.resolveUser(gitLabUser, (XdVcsChangeProcessor)this.getProcessor());
    }

    @NotNull
    public GitLabService getVcsService() {
        return this.vcsService;
    }

    public GitLabPushConsumer(@NotNull GitLabService vcsService, @NotNull XdGitLabChangesProcessor processor2) {
        Intrinsics.checkParameterIsNotNull((Object)vcsService, (String)"vcsService");
        Intrinsics.checkParameterIsNotNull((Object)((Object)processor2), (String)"processor");
        super(vcsService, (XdVcsHostingChangesProcessor)processor2);
        this.vcsService = vcsService;
    }
}

