/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs.plugin;

import javax.ws.rs.BadRequestException;
import jetbrains.charisma.user.XdApiKey;
import jetbrains.youtrack.api.application.ApplicationState;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.integration.vcs.impl.VcsHostingService;
import jetbrains.youtrack.integration.vcs.impl.VcsHostingsServiceRegistry;
import jetbrains.youtrack.integration.vcs.persistence.XdVcsHostingChangesProcessor;
import jetbrains.youtrack.integration.vcs.plugin.HostedVcsRepoChangesListener$updatedSyncBeforeConstraints$1;
import jetbrains.youtrack.integration.vcs.plugin.HostedVcsRepoChangesListener$updatedSyncBeforeConstraints$3;
import jetbrains.youtrack.integration.vcs.plugin.HostedVcsRepoChangesListener$updatedSyncBeforeConstraints$4;
import jetbrains.youtrack.persistent.listeners.GlobalXdListener;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\n\b\u0007\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002H\u0016R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/integration/vcs/plugin/HostedVcsRepoChangesListener;", "Ljetbrains/youtrack/persistent/listeners/GlobalXdListener;", "Ljetbrains/youtrack/integration/vcs/persistence/XdVcsHostingChangesProcessor;", "servicesRegistry", "Ljetbrains/youtrack/integration/vcs/impl/VcsHostingsServiceRegistry;", "(Ljetbrains/youtrack/integration/vcs/impl/VcsHostingsServiceRegistry;)V", "isCorrectStage", "", "()Z", "addedSyncBeforeConstraints", "", "added", "createApiKeyIfNeeded", "proc", "removedSyncAfterConstraints", "removed", "updatedSyncBeforeConstraints", "old", "current", "Companion", "youtrack-vcs-hosting-integration"})
public final class HostedVcsRepoChangesListener
extends GlobalXdListener<XdVcsHostingChangesProcessor> {
    private final VcsHostingsServiceRegistry servicesRegistry;
    public static final Companion Companion = new Companion(null);

    public void addedSyncBeforeConstraints(@NotNull XdVcsHostingChangesProcessor added) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)added), (String)"added");
        if (!this.isCorrectStage()) {
            return;
        }
        if (added.isEnabled()) {
            this.createApiKeyIfNeeded(added);
            this.servicesRegistry.serviceOf(added).createHook(added);
        }
    }

    public void updatedSyncBeforeConstraints(@NotNull XdVcsHostingChangesProcessor old, @NotNull XdVcsHostingChangesProcessor current) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)old), (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)((Object)current), (String)"current");
        if (!this.isCorrectStage()) {
            return;
        }
        VcsHostingService<XdVcsHostingChangesProcessor, ?> oldService = this.servicesRegistry.serviceOf(old);
        VcsHostingService<XdVcsHostingChangesProcessor, ?> currentService = this.servicesRegistry.serviceOf(current);
        if (ReflectionUtilKt.hasChanges((XdEntity)((XdEntity)current), (KProperty1)((KProperty1)HostedVcsRepoChangesListener$updatedSyncBeforeConstraints$1.INSTANCE))) {
            if (!current.getServer().isEnabled()) {
                String action = current.getEnabled() ? "enable" : "disable";
                Companion.getLogger().warn((Function0)new Function0<String>(action){
                    final /* synthetic */ String $action;

                    @NotNull
                    public final String invoke() {
                        return "Can not " + this.$action + " the integration as its parent server is disabled";
                    }
                    {
                        this.$action = string;
                        super(0);
                    }
                });
                return;
            }
            this.createApiKeyIfNeeded(current);
            if (current.getEnabled()) {
                currentService.createHook(current);
            } else {
                oldService.deleteHook(old, current.getCredentials());
                current.setHookId(null);
                XdApiKey apiKey = current.getApiKey();
                current.setApiKey(null);
                XdApiKey xdApiKey = apiKey;
                if (xdApiKey != null) {
                    xdApiKey.delete();
                }
            }
        } else if (ReflectionUtilKt.hasChanges((XdEntity)((XdEntity)current), (KProperty1)((KProperty1)HostedVcsRepoChangesListener$updatedSyncBeforeConstraints$3.INSTANCE))) {
            this.createApiKeyIfNeeded(current);
            current.setHookId(null);
            current.setId(null);
            if (!current.isEnabled()) {
                return;
            }
            oldService.deleteHook(old, ReflectionUtilKt.hasChanges((XdEntity)((XdEntity)current), (KProperty1)((KProperty1)HostedVcsRepoChangesListener$updatedSyncBeforeConstraints$4.INSTANCE)) ? old.getCredentials() : current.getCredentials());
            currentService.createHook(current);
        } else if (current.getEnabled() && current.hasChangesInCredentials()) {
            try {
                currentService.ping(current);
            }
            catch (Throwable e) {
                throw (Throwable)new BadRequestException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("GithubRepoChangesListener.Invalid_credentials", new Object[0]), e);
            }
        }
    }

    public void removedSyncAfterConstraints(@NotNull XdVcsHostingChangesProcessor removed) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)removed), (String)"removed");
        VcsHostingService<XdVcsHostingChangesProcessor, ?> service = this.servicesRegistry.serviceOf(removed);
        service.deleteHook(removed, removed.getCredentials());
    }

    private final void createApiKeyIfNeeded(XdVcsHostingChangesProcessor proc) {
        if (proc.getApiKey() == null) {
            proc.setApiKey(XdApiKey.Companion.create());
        }
    }

    private final boolean isCorrectStage() {
        return BeansKt.getApplicationStateHolder().get() == ApplicationState.RUNNING;
    }

    public HostedVcsRepoChangesListener(@NotNull VcsHostingsServiceRegistry servicesRegistry) {
        Intrinsics.checkParameterIsNotNull((Object)servicesRegistry, (String)"servicesRegistry");
        this.servicesRegistry = servicesRegistry;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/integration/vcs/plugin/HostedVcsRepoChangesListener$Companion;", "Lmu/KLogging;", "()V", "youtrack-vcs-hosting-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

