/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.webapp.filters;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.webapp.filters.CORSRequestFilter;
import jetbrains.youtrack.webapp.filters.FilterAdapter;
import jetbrains.youtrack.webapp.filters.FilterAdapterKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0005H\u0002R\u001c\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/webapp/filters/CORSRequestFilter;", "Ljetbrains/youtrack/webapp/filters/FilterAdapter;", "()V", "allowedOrigins", "", "", "getAllowedOrigins", "()Ljava/lang/Iterable;", "doFilter", "", "request", "Ljavax/servlet/http/HttpServletRequest;", "response", "Ljavax/servlet/http/HttpServletResponse;", "chain", "Ljavax/servlet/FilterChain;", "isAllowedOrigin", "", "requestOrigin", "Companion", "youtrack-webapp"})
public final class CORSRequestFilter
extends FilterAdapter {
    @NotNull
    public static final String ACCESS_CONTROL_HEADER = "Access-Control-Allow-Origin";
    @NotNull
    public static final String ORIGIN_HEADER = "Origin";
    private static final String ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    private static final String ACCESS_CONTROL_ALLOW_HEADERS_HEADER = "Access-Control-Allow-Headers";
    private static final String ACCESS_CONTROL_REQUEST_HEADERS_HEADER = "Access-Control-Request-Headers";
    @NotNull
    public static final String ACCESS_CONTROL_REQUEST_METHOD_HEADER = "Access-Control-Request-Method";
    private static final String ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    private static final String ACCESS_CONTROL_EXPOSE_HEADERS = "Access-Control-Expose-Headers";
    public static final Companion Companion = new Companion(null);

    private final Iterable<String> getAllowedOrigins() {
        return (Iterable)LegacySupportKt.transactional((Function1)allowedOrigins.1.INSTANCE);
    }

    @Override
    public void doFilter(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull FilterChain chain) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        Intrinsics.checkParameterIsNotNull((Object)chain, (String)"chain");
        boolean isOptions = StringsKt.equals((String)"OPTIONS", (String)request.getMethod(), (boolean)true);
        Function0<Boolean> $fun$allowAllOrigins$1 = new Function0<Boolean>(isOptions, request){
            final /* synthetic */ boolean $isOptions;
            final /* synthetic */ HttpServletRequest $request;

            public final boolean invoke() {
                return StringsKt.contains((CharSequence)this.$request.getRequestURI().toString(), (CharSequence)"vcshooksreceiver", (boolean)true) || !this.$isOptions && !BeansKt.getRingConfig().hasEmbeddedHub();
            }
            {
                this.$isOptions = bl;
                this.$request = httpServletRequest;
                super(0);
            }
        };
        FilterAdapterKt.baseAppContext(request, response, (Function0<Unit>)((Function0)new Function0<Unit>(this, request, $fun$allowAllOrigins$1, response){
            final /* synthetic */ CORSRequestFilter this$0;
            final /* synthetic */ HttpServletRequest $request;
            final /* synthetic */ doFilter.1 $allowAllOrigins$1;
            final /* synthetic */ HttpServletResponse $response;

            public final void invoke() {
                boolean bl;
                CharSequence charSequence;
                String requestOrigin = this.$request.getHeader("Origin");
                boolean explicitlyAllowedOrigin = CORSRequestFilter.access$isAllowedOrigin(this.this$0, requestOrigin);
                if (this.$allowAllOrigins$1.invoke() || explicitlyAllowedOrigin) {
                    String requestedHeadersToAllow;
                    String string = requestOrigin;
                    if (string == null) {
                        string = "*";
                    }
                    this.$response.addHeader("Access-Control-Allow-Origin", string);
                    if (explicitlyAllowedOrigin) {
                        this.$response.addHeader("Access-Control-Allow-Credentials", "true");
                    }
                    if ((requestedHeadersToAllow = this.$request.getHeader("Access-Control-Request-Headers")) != null) {
                        charSequence = requestedHeadersToAllow;
                        bl = false;
                        if (charSequence.length() > 0) {
                            this.$response.addHeader("Access-Control-Allow-Headers", requestedHeadersToAllow);
                        }
                    }
                }
                this.$response.addHeader("Access-Control-Expose-Headers", "Location");
                String requestedMethod = this.$request.getHeader("Access-Control-Request-Method");
                if (requestedMethod != null) {
                    charSequence = requestedMethod;
                    bl = false;
                    if (charSequence.length() > 0) {
                        this.$response.addHeader("Access-Control-Allow-Methods", requestedMethod);
                    }
                }
            }
            {
                this.this$0 = cORSRequestFilter;
                this.$request = httpServletRequest;
                this.$allowAllOrigins$1 = var3_3;
                this.$response = httpServletResponse;
                super(0);
            }
        }));
        if (isOptions) {
            response.setStatus(200);
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private final boolean isAllowedOrigin(String requestOrigin) {
        Object object;
        if (requestOrigin == null) {
            return false;
        }
        try {
            object = new URL(requestOrigin).getAuthority();
        }
        catch (MalformedURLException ignore) {
            object = Unit.INSTANCE;
        }
        Unit calculatedOrigin = object;
        Iterable<String> iterable = this.getAllowedOrigins();
        if (iterable == null) {
            return true;
        }
        Iterable<String> allowedOrigins2 = iterable;
        return CollectionsKt.contains(allowedOrigins2, (Object)calculatedOrigin);
    }

    public static final /* synthetic */ boolean access$isAllowedOrigin(CORSRequestFilter $this, String requestOrigin) {
        return $this.isAllowedOrigin(requestOrigin);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/youtrack/webapp/filters/CORSRequestFilter$Companion;", "Lmu/KLogging;", "()V", "ACCESS_CONTROL_ALLOW_CREDENTIALS_HEADER", "", "ACCESS_CONTROL_ALLOW_HEADERS_HEADER", "ACCESS_CONTROL_ALLOW_METHODS", "ACCESS_CONTROL_EXPOSE_HEADERS", "ACCESS_CONTROL_HEADER", "ACCESS_CONTROL_REQUEST_HEADERS_HEADER", "ACCESS_CONTROL_REQUEST_METHOD_HEADER", "ORIGIN_HEADER", "youtrack-webapp"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

