/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.webapp.filters;

import com.intellij.hub.auth.OAuthException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.UriInfo;
import jetbrains.charisma.authentication.LoginContext;
import jetbrains.charisma.main.BeansKt;
import jetbrains.charisma.user.XdApiKey;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.rpc.rest.provider.exception.UnauthorizedException;
import jetbrains.youtrack.core.KSecurityLogging;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.rest.AuthIgnoredResourceAnalyzer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdExtensionsKt;
import mu.KLogger;
import mu.KLogging;
import org.apache.log4j.MDC;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import webr.framework.controller.BaseApplication;

@Service(value="restLoginFilter")
@PreMatching
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u001e\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/webapp/filters/RESTLoginRequestFilter;", "Ljavax/ws/rs/container/ContainerRequestFilter;", "()V", "authIgnoredResourceAnalyzer", "Ljetbrains/youtrack/rest/AuthIgnoredResourceAnalyzer;", "getAuthIgnoredResourceAnalyzer", "()Ljetbrains/youtrack/rest/AuthIgnoredResourceAnalyzer;", "setAuthIgnoredResourceAnalyzer", "(Ljetbrains/youtrack/rest/AuthIgnoredResourceAnalyzer;)V", "filter", "", "req", "Ljavax/ws/rs/container/ContainerRequestContext;", "Companion", "youtrack-webapp"})
public final class RESTLoginRequestFilter
implements ContainerRequestFilter {
    @Autowired
    @NotNull
    public AuthIgnoredResourceAnalyzer authIgnoredResourceAnalyzer;
    @NotNull
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String API_KEY_HEADER = "X-YouTrack-ApiKey";
    private static final String API_KEY_PARAM = "apiKey";
    private static final KLogger securityLogger;
    public static final Companion Companion;

    @NotNull
    public final AuthIgnoredResourceAnalyzer getAuthIgnoredResourceAnalyzer() {
        AuthIgnoredResourceAnalyzer authIgnoredResourceAnalyzer = this.authIgnoredResourceAnalyzer;
        if (authIgnoredResourceAnalyzer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"authIgnoredResourceAnalyzer");
        }
        return authIgnoredResourceAnalyzer;
    }

    public final void setAuthIgnoredResourceAnalyzer(@NotNull AuthIgnoredResourceAnalyzer authIgnoredResourceAnalyzer) {
        Intrinsics.checkParameterIsNotNull((Object)authIgnoredResourceAnalyzer, (String)"<set-?>");
        this.authIgnoredResourceAnalyzer = authIgnoredResourceAnalyzer;
    }

    /*
     * WARNING - void declaration
     */
    public void filter(@Nullable ContainerRequestContext req) {
        if (req != null && !StringsKt.equals((String)"OPTIONS", (String)req.getMethod(), (boolean)true)) {
            void found;
            String apiKeyValue = RESTLoginRequestFilter.Companion.getApiKey(req);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = null;
            String authHeaderValue = req.getHeaderString(AUTHORIZATION_HEADER);
            if (apiKeyValue != null) {
                LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, String>(req, apiKeyValue, (Ref.ObjectRef)found){
                    final /* synthetic */ ContainerRequestContext $req;
                    final /* synthetic */ String $apiKeyValue;
                    final /* synthetic */ Ref.ObjectRef $found;

                    public final String invoke(@NotNull TransientStoreSession it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        UriInfo uriInfo = this.$req.getUriInfo();
                        Intrinsics.checkExpressionValueIsNotNull((Object)uriInfo, (String)"req.uriInfo");
                        String path = uriInfo.getPath();
                        CharSequence charSequence = path;
                        boolean bl = false;
                        boolean bl2 = false;
                        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || !StringsKt.startsWith((String)path, (String)"vcshooksreceiver", (boolean)true)) {
                            throw (Throwable)new ForbiddenException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("YouTrackCorsContainerResponseFilter.An_API_key_can_only_be_used_for_VCS_hooks", new Object[0]));
                        }
                        XdApiKey xdApiKey = XdApiKey.Companion.find(this.$apiKeyValue);
                        if (xdApiKey == null) {
                            throw (Throwable)new ForbiddenException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("RESTLoginRequestFilter.Unknown_api_key", new Object[0]));
                        }
                        XdApiKey apiKey = xdApiKey;
                        this.$found.element = (XdUser)apiKey.getOwner();
                        return (String)BaseApplication.setSessionField((String)"SessionOrigin", (Object)"API key");
                    }
                    {
                        this.$req = containerRequestContext;
                        this.$apiKeyValue = string;
                        this.$found = objectRef;
                        super(1);
                    }
                }));
            } else {
                try {
                    XdUser xdUser = jetbrains.charisma.persistent.BeansKt.getHubUuidResolver().resolveUserByAuthHeader(authHeaderValue);
                    if (xdUser != null) {
                        XdUser xdUser2 = xdUser;
                        boolean bl = false;
                        boolean bl2 = false;
                        XdUser it = xdUser2;
                        boolean bl3 = false;
                        String cfr_ignored_0 = (String)LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, String>(it, (Ref.ObjectRef)found){
                            final /* synthetic */ XdUser $it;
                            final /* synthetic */ Ref.ObjectRef $found$inlined;
                            {
                                this.$it = xdUser;
                                this.$found$inlined = objectRef;
                                super(1);
                            }

                            public final String invoke(@NotNull TransientStoreSession $noName_0) {
                                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                this.$found$inlined.element = this.$it;
                                return (String)BaseApplication.setSessionField((String)"SessionOrigin", (Object)"Hub token");
                            }
                        }));
                    }
                }
                catch (OAuthException e) {
                    String message = "Got invalid Hub token: " + authHeaderValue + ". Error: " + e.getOAuthError().getDeveloperMessage();
                    StringBuilder stringBuilder = new StringBuilder().append("Failed REST API login with Oauth token. Remote IP is ");
                    HttpServletRequest httpServletRequest = BaseApplication.getRequest();
                    Intrinsics.checkExpressionValueIsNotNull((Object)httpServletRequest, (String)"BaseApplication.getRequest()");
                    securityLogger.warn(stringBuilder.append(httpServletRequest.getRemoteAddr()).append('.').toString());
                    Companion.getLogger().warn(message);
                    throw (Throwable)new NotAuthorizedException((Object)message, new Object[0]);
                }
            }
            LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>((Ref.ObjectRef)found, authHeaderValue){
                final /* synthetic */ Ref.ObjectRef $found;
                final /* synthetic */ String $authHeaderValue;

                public final void invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if ((XdUser)this.$found.element == null && this.$authHeaderValue != null && StringsKt.startsWith$default((String)this.$authHeaderValue, (String)"Basic ", (boolean)false, (int)2, null)) {
                        String string = this.$authHeaderValue;
                        int n = "Basic ".length();
                        boolean bl = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string3 = string2.substring(n);
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                        String authString = string3;
                        byte[] byArray = Base64.getDecoder().decode(authString);
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().decode(authString)");
                        byte[] byArray2 = byArray;
                        Charset charset = StandardCharsets.UTF_8;
                        Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"StandardCharsets.UTF_8");
                        Charset charset2 = charset;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        String encoded = new String(byArray2, charset2);
                        List credentials = StringsKt.split$default((CharSequence)encoded, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
                        if (credentials.size() == 2) {
                            LoginContext context = new LoginContext((String)CollectionsKt.first((List)credentials), (String)CollectionsKt.last((List)credentials));
                            Entity entity = jetbrains.charisma.persistent.BeansKt.getAuthenticationManager().authorize(context);
                            Object object = this.$found.element = entity != null ? (XdUser)XdExtensionsKt.toXd((Entity)entity) : null;
                            if ((XdUser)this.$found.element == null) {
                                KLogger kLogger = RESTLoginRequestFilter.access$getSecurityLogger$cp();
                                StringBuilder stringBuilder = new StringBuilder().append("Failed REST API login with Basic auth. Remote IP is ");
                                HttpServletRequest httpServletRequest = BaseApplication.getRequest();
                                Intrinsics.checkExpressionValueIsNotNull((Object)httpServletRequest, (String)"BaseApplication.getRequest()");
                                kLogger.warn(stringBuilder.append(httpServletRequest.getRemoteAddr()).append('.').toString());
                            }
                        }
                    }
                }
                {
                    this.$found = objectRef;
                    this.$authHeaderValue = string;
                    super(1);
                }
            }));
            LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this, (Ref.ObjectRef)found, req){
                final /* synthetic */ RESTLoginRequestFilter this$0;
                final /* synthetic */ Ref.ObjectRef $found;
                final /* synthetic */ ContainerRequestContext $req;

                @Nullable
                public final Unit invoke(@NotNull TransientStoreSession it) {
                    Unit unit;
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    if ((XdUser)this.$found.element == null) {
                        Entity entity;
                        UriInfo uriInfo = this.$req.getUriInfo();
                        Intrinsics.checkExpressionValueIsNotNull((Object)uriInfo, (String)"req.uriInfo");
                        String string = uriInfo.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"req.uriInfo.path");
                        if (StringsKt.endsWith$default((String)string, (String)"/workflows/import", (boolean)false, (int)2, null)) {
                            entity = jetbrains.charisma.service.BeansKt.getUserService().getGuest();
                        } else {
                            entity = jetbrains.youtrack.core.security.BeansKt.getLoggedInUserOrNull();
                            if (entity == null) {
                                entity = jetbrains.charisma.service.BeansKt.getUserService().getGuest();
                            }
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"if (req.uriInfo.path.end\u2026est\n                    }");
                        this.$found.element = (XdUser)XdExtensionsKt.toXd((Entity)entity);
                    }
                    XdUser xdUser = (XdUser)this.$found.element;
                    if (xdUser != null) {
                        XdUser xdUser2 = xdUser;
                        boolean bl = false;
                        boolean bl2 = false;
                        XdUser it2 = xdUser2;
                        boolean bl3 = false;
                        if (it2.getBanned() && !this.this$0.getAuthIgnoredResourceAnalyzer().isAnonymousAccessAllowed(this.$req)) {
                            if (it2.isGuest()) {
                                throw (Throwable)new UnauthorizedException("You are not logged in.");
                            }
                            KLogger kLogger = RESTLoginRequestFilter.access$getSecurityLogger$cp();
                            StringBuilder stringBuilder = new StringBuilder().append("Failed REST API login from under the banned user account '").append(it2.getLogin()).append("'. Remote IP is ");
                            HttpServletRequest httpServletRequest = BaseApplication.getRequest();
                            Intrinsics.checkExpressionValueIsNotNull((Object)httpServletRequest, (String)"BaseApplication.getRequest()");
                            kLogger.warn(stringBuilder.append(httpServletRequest.getRemoteAddr()).append('.').toString());
                            throw (Throwable)new ForbiddenException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("User_is_banned", new Object[0]));
                        }
                        BeansKt.getSecurityNavigator().login((Object)it2.getEntity(), false);
                        StringBuilder stringBuilder = new StringBuilder().append(it2.getLogin()).append('@');
                        HttpServletRequest httpServletRequest = BaseApplication.getRequest();
                        Intrinsics.checkExpressionValueIsNotNull((Object)httpServletRequest, (String)"BaseApplication.getRequest()");
                        MDC.put((String)"username", (String)stringBuilder.append(httpServletRequest.getRemoteAddr()).toString());
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    return unit;
                }
                {
                    this.this$0 = rESTLoginRequestFilter;
                    this.$found = objectRef;
                    this.$req = containerRequestContext;
                    super(1);
                }
            }));
        }
        Companion.getLogger().debug((Function0)new Function0<String>(req){
            final /* synthetic */ ContainerRequestContext $req;

            @NotNull
            public final String invoke() {
                ContainerRequestContext containerRequestContext = this.$req;
                StringBuilder builder = new StringBuilder("Rest request: ").append(containerRequestContext != null && (containerRequestContext = containerRequestContext.getUriInfo()) != null ? containerRequestContext.getRequestUri() : null);
                if (RESTLoginRequestFilter.Companion.getLogger().isTraceEnabled()) {
                    StringBuilder stringBuilder = builder;
                    Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder, (String)"builder");
                    ContainerRequestContext containerRequestContext2 = this.$req;
                    StringsKt.appendln((StringBuilder)stringBuilder).append(containerRequestContext2 != null ? containerRequestContext2.getHeaders() : null);
                }
                return builder.toString();
            }
            {
                this.$req = containerRequestContext;
                super(0);
            }
        });
    }

    static {
        Companion = new Companion(null);
        securityLogger = new KSecurityLogging().getSecurityLogger();
    }

    public static final /* synthetic */ KLogger access$getSecurityLogger$cp() {
        return securityLogger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/youtrack/webapp/filters/RESTLoginRequestFilter$Companion;", "Lmu/KLogging;", "()V", "API_KEY_HEADER", "", "API_KEY_PARAM", "AUTHORIZATION_HEADER", "securityLogger", "Lmu/KLogger;", "getApiKey", "req", "Ljavax/ws/rs/container/ContainerRequestContext;", "youtrack-webapp"})
    public static final class Companion
    extends KLogging {
        private final String getApiKey(ContainerRequestContext req) {
            String string = req.getHeaderString(RESTLoginRequestFilter.API_KEY_HEADER);
            if (string == null) {
                UriInfo uriInfo = req.getUriInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)uriInfo, (String)"req.uriInfo");
                string = (String)uriInfo.getQueryParameters().getFirst((Object)RESTLoginRequestFilter.API_KEY_PARAM);
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

