angular.module('xodus').config(['$httpProvider', function ($httpProvider) {
    $httpProvider.interceptors.push('YTAuthInterceptor');
}]).factory('YTAuthInterceptor', function ($window, $q, $location) {

    function getAuthorizationHeader() {
        var accessToken = null;
        try {
            var ringId = window.YOUTRACK_SERVICE_ID; // this YOUTRACK_SERVICE_ID rendered from backend code
            accessToken = JSON.parse($window.localStorage.getItem(ringId + "-token")).accessToken;
            return 'Bearer ' + accessToken;
        } catch (e) {
            return undefined;
        }
    }

    return {
        request: function (config) {
            config.headers.Authorization = getAuthorizationHeader();
            return config || $q.when(config);
        },
        responseError: function(response) {
            if (response.status === 403) {
                var url = $location.absUrl();
                // redirecting back to home url.
                // It should do auth for us and user will be able to get back with `Authorization` header
                var start = url.toLowerCase().indexOf('/entitybro');
                $window.location.href = url.substring(0, start);
            }
            return response || $q.when(response);
        }
    };
});