package jetbrains.charisma.wiki;

/*Generated by MPS */

import jetbrains.mps.webr.wiki.processor.runtime.BaseProcessor;
import jetbrains.mps.webr.wiki.processor.runtime.utils.AttributeManufacture;
import jetbrains.mps.webr.wiki.processor.runtime.utils.TagStack;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import java.io.IOException;
import jetbrains.mps.webr.wiki.processor.runtime.utils.HtmlTag;
import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import jetbrains.mps.webr.wiki.processor.runtime.utils.ClosingHtmlTag;
import webr.framework.function.HtmlStringUtil;
import jetbrains.mps.webr.wiki.processor.runtime.utils.OpeningHtmlTag;
import jetbrains.mps.webr.runtime.builderContext.BuilderThreadContext;
import jetbrains.mps.webr.wiki.processor.runtime.LinkAppender;
import jetbrains.mps.gtext.runtime.BaseHtmlStringUtil;
import java.io.Reader;
import jetbrains.mps.webr.wiki.processor.runtime.TrailingCharStringReader;
import jetbrains.mps.webr.wiki.processor.runtime.utils.CommonWikiUtils;
import jetbrains.mps.webr.wiki.processor.runtime.WikiUtil;

%%

%class CharismaHtmlTextWikiProcessorMarkup
%extends BaseProcessor

%public 
%buffer 124
%final
%unicode

%{

  public AttributeManufacture HtmlTextattributeManufacture = new AttributeManufacture();
  public String HtmlTextadditionalHtmlStyleClass = "";
  private TagStack HtmlTextstack = new TagStack();
  public boolean IssueLinkuseGlobalLinks = false;
  public WikiIssueAdapter IssueLinkissue = null;
  public boolean IssueLinkfromWorkflow = false;
  public List<WikiUserAdapter> IssueLinkmentionedUsers = ListSequence.fromList(new ArrayList<WikiUserAdapter>());
  public List<WikiIssueAdapter> IssueLinkmentionedIssues = ListSequence.fromList(new ArrayList<WikiIssueAdapter>());
  public String IssueLinklogoUrl = null;
  public WikiAppContextProvider IssueLinkappContextProvider = null;
  public boolean QueryLinkuseGlobalLinks = false;
  public WikiAppContextProvider QueryLinkcontextProvider = null;
  private int NewLinesSimplenewLineCount;
  private boolean liveModePreview = false;

  public IWikiProcessor clone(String input) {
    CharismaHtmlTextWikiProcessorMarkup cloned = create(input);
    cloned.HtmlTextattributeManufacture = this.HtmlTextattributeManufacture;
    cloned.HtmlTextadditionalHtmlStyleClass = this.HtmlTextadditionalHtmlStyleClass;
    cloned.IssueLinkuseGlobalLinks = this.IssueLinkuseGlobalLinks;
    cloned.IssueLinkissue = this.IssueLinkissue;
    cloned.IssueLinkfromWorkflow = this.IssueLinkfromWorkflow;
    cloned.IssueLinkmentionedUsers = this.IssueLinkmentionedUsers;
    cloned.IssueLinkmentionedIssues = this.IssueLinkmentionedIssues;
    cloned.IssueLinklogoUrl = this.IssueLinklogoUrl;
    cloned.IssueLinkappContextProvider = this.IssueLinkappContextProvider;
    cloned.QueryLinkuseGlobalLinks = this.QueryLinkuseGlobalLinks;
    cloned.QueryLinkcontextProvider = this.QueryLinkcontextProvider;
    return cloned;
  }

  protected void processInternal() throws IOException {
    if (this.wrapWithDiv) {
      this.builderContext.append(PROLOG);
    }
    this.yylex();
    this.finish();
    if (this.wrapWithDiv) {
      this.builderContext.append(EPILOG);
    }
  }

  protected void finish() {
  }

  protected boolean readerNotExists() {
    return this.zzReader == null;
  }

  private String yytext(int prefixLength, int suffixLength) {
    return new String(this.zzBuffer, this.zzStartRead + prefixLength, this.zzMarkedPos - this.zzStartRead - suffixLength - prefixLength);
  }

  public CharismaHtmlTextWikiProcessorMarkup setIssueLinkuseGlobalLinks(boolean value) {
    this.IssueLinkuseGlobalLinks = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setIssueLinkissue(WikiIssueAdapter value) {
    this.IssueLinkissue = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setIssueLinkfromWorkflow(boolean value) {
    this.IssueLinkfromWorkflow = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setIssueLinkmentionedUsers(List<WikiUserAdapter> value) {
    this.IssueLinkmentionedUsers = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setIssueLinkmentionedIssues(List<WikiIssueAdapter> value) {
    this.IssueLinkmentionedIssues = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setIssueLinklogoUrl(String value) {
    this.IssueLinklogoUrl = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setIssueLinkappContextProvider(WikiAppContextProvider value) {
    this.IssueLinkappContextProvider = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setQueryLinkuseGlobalLinks(boolean value) {
    this.QueryLinkuseGlobalLinks = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setQueryLinkcontextProvider(WikiAppContextProvider value) {
    this.QueryLinkcontextProvider = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setCharismaHtmlTextWikiProcessor_attributeManufacture(AttributeManufacture value) {
    this.HtmlTextattributeManufacture = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setCharismaHtmlTextWikiProcessor_additionalHtmlStyleClass(String value) {
    this.HtmlTextadditionalHtmlStyleClass = value;
    return this;
  }

  public CharismaHtmlTextWikiProcessorMarkup setLivePreviewMode(boolean value) {
    return this;
  }

  public void appendNewLines(HtmlTag tag) {
    int start = this.getText().lastIndexOf(">") + 1;
    boolean skipFirstNewLine = !(tag.getTagTitle().isInline()) && this.getText().indexOf("\n", start) != -1;
    for (int i = start; i < this.getText().length(); ++i) {
      if (this.getText().charAt(i) == '\n') {
        if (skipFirstNewLine) {
          skipFirstNewLine = false;
        } else {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("<br/>");
          }
        }
      } else if ((this.getText().charAt(i) == ' ' || this.getText().charAt(i) == '\t') && !(skipFirstNewLine)) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(BaseProcessor.characterToStringSafe(this.getText().charAt(i)));
        }
      }
    }
  }

  public int endOfTagIdx() {
    int idx = this.getText().indexOf('>');
    if (idx == -1) {
      return idx;
    }
    for (int i = idx; i < this.getText().length(); ++i) {
      if (this.getText().charAt(i) != '\r' && this.getText().charAt(i) != '\n') {
        if (this.getText().charAt(i) != ' ' && this.getText().charAt(i) != '\t') {
          return idx;
        }
      } else {
        idx = i;
      }
    }
    return idx;
  }

  public void processClosingTag() {
    ClosingHtmlTag tag = new ClosingHtmlTag(this.getText());

    if (tag.getTagTitle() == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(BaseProcessor.characterToStringSafe(this.getText().charAt(0))).processSafe(builderContext);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(StringUtils.substring(this.getText(), 1)).processSafe(builderContext);
      }
    } else {
      int stackSizeBefore = this.HtmlTextstack.size();
      this.builderContext = this.HtmlTextstack.closeTag(tag, this.builderContext, this);
      if ((stackSizeBefore > 0 && this.HtmlTextstack.isEmpty())) {
        this.endState();
        this.appendNewLines(tag);
      } else if (stackSizeBefore == this.HtmlTextstack.size()) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.getText().substring(this.getText().lastIndexOf('>') + 1)));
        }
      }
    }
  }

  public void processClosingTagNoMarkup() {
    ClosingHtmlTag tag = new ClosingHtmlTag(this.getText());

    if (tag.getTagTitle() == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(this.getText()));
      }
      return;
    }

    if (tag.isIgnoredTagWithIgnoredBody() && !(this.HtmlTextstack.isEmpty())) {
      this.builderContext = this.HtmlTextstack.closeTag(tag, this.builderContext, this, true);
      if (this.HtmlTextstack.isEmpty()) {
        this.endState();
      }
    }
    String t = this.getText();
    int idx = t.lastIndexOf(">") + 1;
    int stopIdx = t.length();
    char c = t.charAt(stopIdx - 1);
    for (int i = idx; i < stopIdx; ++i) {
      if (t.charAt(i) == ' ' || t.charAt(i) == '\n' || t.charAt(i) == '\t') {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(" ");
        }
        break;
      }
    }
  }

  public void processOpeningTag() {
    OpeningHtmlTag tag = new OpeningHtmlTag(this.getText(), this.HtmlTextattributeManufacture, this.HtmlTextadditionalHtmlStyleClass);

    if (tag.getTagTitle() == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(BaseProcessor.characterToStringSafe(this.getText().charAt(0))).processSafe(builderContext);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(StringUtils.substring(this.getText(), 1)).processSafe(builderContext);
      }
    } else {
      boolean stackWasEmpty = this.HtmlTextstack.isEmpty();
      if ((tag.isSingletonTag() || tag.getTagTitle().canBeUnclosed()) && tag.isValidTag()) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(tag.toString());
        }
        if (tag.getTagTitle().canBeUnclosed()) {
          this.HtmlTextstack.openTag(tag, this.builderContext);
        }
      } else if (!(tag.isSingletonTag())) {
        this.builderContext = this.HtmlTextstack.openTag(tag, this.builderContext);
      }

      if (stackWasEmpty && !(this.HtmlTextstack.isEmpty())) {
        this.beginState(this.HTML);
      }
    }
  }

  public void processOpeningTagNoMarkup() {
    OpeningHtmlTag tag = new OpeningHtmlTag(this.getText());

    if (tag.getTagTitle() == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(this.getText()));
      }
    } else if (tag.isIgnoredTagWithIgnoredBody()) {
      boolean wasEmpty = this.HtmlTextstack.isEmpty();
      this.builderContext = this.HtmlTextstack.openTag(tag, this.builderContext);
      if (wasEmpty && !(this.HtmlTextstack.isEmpty())) {
        this.beginState(this.HTML);
      }
    }
  }

  public void transformIssue() {
    WikiIssueAdapter i = this.IssueLinkappContextProvider.getIssueById(this.getText());
    if (i == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(this.getText()));
      }
    } else {
      if (this.IssueLinkuseGlobalLinks) {
        try {
          BuilderThreadContext.initNonLocalBuilderThreadContext();
          this.appendIssueLink(i, this.getText());
        } finally {
          BuilderThreadContext.close();
        }
      } else {
        this.appendIssueLink(i, this.getText());
      }
    }
  }

  public void appendIssueLink(WikiIssueAdapter i, String mentionedId) {
    LinkAppender.appendHrefForMobile(this.builderContext, false);
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(i.getUrl(this.IssueLinkuseGlobalLinks) + "\"");
    }
    if (i.isResolved()) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(" class=\"issue-resolved\"");
      }
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" target=\"_self\"");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" data-issue-id=\"" + i.getId() + "\"");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" title=\"" + BaseHtmlStringUtil.html(i.getSummary()) + "\">" + mentionedId + "</a>");
    }
    ListSequence.fromList(this.IssueLinkmentionedIssues).addElement(i);
  }

  public void appendImage(boolean noMarkup) throws IOException {
    if (noMarkup) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("!");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(this.yytext(1, 1)).processSafe(builderContext);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("!");
      }
    } else {
      String[] result = this.yytext(1, 1).split("[|]");
      String name = null;
      int last = -1;
      if (result.length > 0) {
        last = result.length - 1;
        name = result[last];
      }

      if (this.IssueLinkissue == null && this.getText().equals("!".concat(this.IssueLinklogoUrl.substring(this.IssueLinklogoUrl.lastIndexOf('/') + 1)).concat("!"))) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<div class=\"wiki picture\"><img src=\"");
          builderContext.append(this.IssueLinklogoUrl);
          builderContext.append("\"/></div>");
        }
        return;
      }

      WikiAttachmentAdapter attach = this.IssueLinkappContextProvider.getAttachmentByName(this.IssueLinkissue, name);

      if (attach == null) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("!");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          this.clone(this.yytext(1, 1)).processSafe(builderContext);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("!");
        }
      } else {
        String alt = null;
        String position = null;
        for (int i = 0; i < last; i++) {
          String value = result[i].trim();
          if (IssueLinkConst.POS.contains(value)) {
            position = value;
          } else {
            alt = value;
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<div class=\"wiki picture\"");
        }
        if (position != null) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(" style=\"");
          }
          if (position.equals(IssueLinkConst.INLINE)) {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("display:inline;");
            }
          } else {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html("align:"));
              builderContext.append(HtmlStringUtil.html(position));
              builderContext.append(HtmlStringUtil.html(";"));
            }
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("\"");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("><img src=\"");
          builderContext.append(attach.getUrl(this.IssueLinkfromWorkflow));
          builderContext.append("\"");
        }
        if (alt != null) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(" alt=\"");
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(HtmlStringUtil.html(alt));
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("\"");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("/></div>");
        }
      }
    }
  }

  private void fixForRTL(String str) {
    if (!(this.IssueLinkappContextProvider.isRtlEnabled())) {
      return;
    }

    boolean flag = false;
    for (int i = 0; i < str.length(); ++i) {
      if (str.charAt(i) > '\u05BE') {
        flag = true;
      }
    }

    if (!(flag)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("&lrm;");
      }
    }
  }

  private void appendUsername() {
    WikiUserAdapter user = this.IssueLinkappContextProvider.getUserByLogin(StringUtils.substring(this.getText(), 1));

    int pushBackCount;
    if (user != null) {
      if (user.isAccessible()) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<a href=\"");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(user.getProfileUrl(this.IssueLinkfromWorkflow));
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\" title=\"");
          builderContext.append(user.getLogin());
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\" data-user-id=\"");
          builderContext.append(user.getId());
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\">");
        }
        String displayedText = BaseHtmlStringUtil.html(user.getFullName());
        this.fixForRTL(displayedText);
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(displayedText);
          builderContext.append("</a>");
        }
      } else {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<b ");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("data-user-id=\"");
          builderContext.append(user.getId());
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\">");
        }
        String displayedText = BaseHtmlStringUtil.html(user.getFullName());
        this.fixForRTL(displayedText);
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(displayedText);
          builderContext.append("</b>");
        }
      }
      pushBackCount = (this.getText().length() - 1 - user.getLogin().length());
      ListSequence.fromList(this.IssueLinkmentionedUsers).addElement(user);
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(Character.toString(this.getText().charAt(0)));
      }
      pushBackCount = this.getText().length() - 1;
    }
    if (pushBackCount > 0) {
      this.yypushback(pushBackCount);
    }
  }

  public void appendAttachment(boolean removeMarkup) {
    String name = StringUtils.substring(this.getText(), 6, this.getText().length() - 1);
    WikiAttachmentAdapter attach = this.IssueLinkappContextProvider.getAttachmentByName(this.IssueLinkissue, name);
    if (attach != null) {
      if (removeMarkup) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(name));
        }
      } else {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<a href=\"");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(attach.getUrl(this.IssueLinkfromWorkflow));
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\">");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(name));
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("</a>");
        }
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(this.getText());
      }
    }
  }

  private void addVcsLink(boolean skip) {
    String t;
    if (skip) {
      t = this.getText().substring(1);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(BaseHtmlStringUtil.html(Character.toString(this.getText().charAt(0))));
      }
    } else {
      t = this.getText();
    }
    String link = this.IssueLinkappContextProvider.getVcsLink(this.IssueLinkissue, t);
    if (link == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(t);
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<a href=\"");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(link);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(t);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</a>");
      }

    }
  }

  public void appendQuery(boolean removeMarkup) {
    String query = this.yytext(7, 1);
    if (removeMarkup) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(query);
      }
    } else {
      LinkAppender.appendHrefForMobile(this.builderContext, false);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(this.QueryLinkcontextProvider.getIssueListUrlUrl(query));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(query));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</a>");
      }
    }
  }


  public static CharismaHtmlTextWikiProcessorMarkup create(String s) {
    CharismaHtmlTextWikiProcessorMarkup result;
    if (s == null) {
      Reader reader = null;
      result = new CharismaHtmlTextWikiProcessorMarkup(reader);
    } else {
      result = new CharismaHtmlTextWikiProcessorMarkup(new TrailingCharStringReader(s, '\r'));
    }
    return result;
  }
%}

%type Void

newLineTralling = ([ \t\n\r]*)
newLineLeading = ([ \t\n\r]*)
newLineTralling_old = ((([ ]*)([\n\r]+))*)
newLineLeading_old = ((([\n\r]+)([ ]*))*)
tagAttributes = (([\n\r\t ]+[^\>\<]*)?)
tagAttributes_old = (([ ]+[ =\"\'A-Za-z0-9\*-_.+():;\\\/]*)?)
all = ((.)|[\r\n])*
prefix = ([:jletterdigit:]+[:])?
separator = [ \t\,\;\.\:\"()\?#\^]
ussueStart = [#\^]
issue = [a-zA-Z0-9_]+ \- [0-9]+
hash = [a-fA-F0-9]{40}
space = [ \n\t]
attachment = "[file:"[^\]]+"]"
image = "!"[^!\n]+"!"
username = [@]([:jletterdigit:]|[\+\.\|\-\=\@]){1,32}
newline = \n
base64Symbol = ([:jletterdigit:]|[\+\/=])

%state HTML, HTML, HTML, HTML

%%

/* Tag */
<YYINITIAL> {
(\<{prefix}[a-zA-Z]+[1-6]*){tagAttributes}([\/]*)(\>) {
          try {
            this.processOpeningTag();
          } finally {
            this.text = null;
          }
}}
/* Tag */
<HTML> {
{newLineLeading}(\<{prefix}[a-zA-Z]+[1-6]*){tagAttributes}([\/]*)(\>) {
          try {
            this.processOpeningTag();
          } finally {
            this.text = null;
          }
}}
/* ClosingTag */
<YYINITIAL> {
"</"{prefix}([a-zA-Z]+)([1-6]*)([ \r\n\t]*)">" {
          try {
            this.processClosingTag();
          } finally {
            this.text = null;
          }
}}
/* ClosingTag */
<HTML> {
"</"{prefix}([a-zA-Z]+)([1-6]*)([ \r\n\t]*)">"{newLineTralling} {
          try {
            this.processClosingTag();
          } finally {
            this.text = null;
          }
}}
/* HtmlComment */
<YYINITIAL, HTML> {
"<!-"~"->"[ \r\n\t]* {
          try {
          } finally {
            this.text = null;
          }
}}
/* Doctype */
<YYINITIAL, HTML> {
"<!"([dD][oO][cC][tT][yY][pP][eE])~">"{newLineTralling} {
          try {
          } finally {
            this.text = null;
          }
}}
/* Eof */
<HTML> {
<<EOF>> {
          try {
            this.endState();
            this.builderContext = this.HtmlTextstack.closeAllTags(this.builderContext, this);
            return null;
          } finally {
            this.text = null;
          }
}}
/* EmptyHtml */
<HTML> {
"\r" {
          try {
          } finally {
            this.text = null;
          }
}}
/* TabHtml */
<HTML> {
"\t" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("\t");
            }
          } finally {
            this.text = null;
          }
}}
/* AmpHtml */
<HTML> {
"&" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&amp;");
            }
          } finally {
            this.text = null;
          }
}}
/* LtHtml */
<HTML> {
"<" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&lt;");
            }
          } finally {
            this.text = null;
          }
}}
/* GtHtml */
<HTML> {
">" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&gt;");
            }
          } finally {
            this.text = null;
          }
}}
/* DoubleQuoteHtml */
<HTML> {
[\"] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&quot;");
            }
          } finally {
            this.text = null;
          }
}}
/* SingleQuoteHtml */
<HTML> {
[\'] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&#39;");
            }
          } finally {
            this.text = null;
          }
}}
/* BreaklineHtml */
<HTML> {
"\n" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("\n");
            }
          } finally {
            this.text = null;
          }
}}
/* EscapeCharacterCode */
<HTML, YYINITIAL> {
&#[1-9][0-9]{1,3}; {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* EscapeCharacterHexCode */
<HTML, YYINITIAL> {
&#[xX][1-9a-fA-F][0-9a-fA-F]{1,3}; {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* EscapeCharacterCodeAliases */
<HTML, YYINITIAL> {
&[a-zA-Z][a-zA-Z0-9]+; {
          try {
            CommonWikiUtils.appendEscapeCodeAlias(this.getText(), builderContext, this);
          } finally {
            this.text = null;
          }
}}
/* MDash */
<YYINITIAL, HTML> {
[-]{3} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&mdash;");
            }
          } finally {
            this.text = null;
          }
}}
/* NDash */
<YYINITIAL, HTML> {
[-]{2} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&ndash;");
            }
          } finally {
            this.text = null;
          }
}}
/* HtmlIfStatement */
<HTML, YYINITIAL> {
"<!["[iI][fF][ \r\n\t]*[a-zA-Z0-9=!<>]*"]>" {
          try {
          } finally {
            this.text = null;
          }
}}
/* HtmlEndIfStatement */
<HTML, YYINITIAL> {
"<!["[eE][nN][dD][iI][fF]"]>" {
          try {
          } finally {
            this.text = null;
          }
}}
/* Issue */
<YYINITIAL, HTML> {
{issue} {
          try {
            this.transformIssue();
          } finally {
            this.text = null;
          }
}}
/* Issue */
<YYINITIAL, HTML> {
{issue}/([\.]?[:jletterdigit:]) {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html(this.getText()));
            }
          } finally {
            this.text = null;
          }
}}
/* issueAttachment */
<YYINITIAL> {
{attachment} {
          try {
            if (this.IssueLinkuseGlobalLinks) {
              try {
                BuilderThreadContext.initNonLocalBuilderThreadContext();
                this.appendAttachment(false);
              } finally {
                BuilderThreadContext.close();
              }
            } else {
              this.appendAttachment(false);
            }
          } finally {
            this.text = null;
          }
}}
/* Image */
<YYINITIAL> {
{image} {
          try {
            if (this.IssueLinkuseGlobalLinks) {
              try {
                BuilderThreadContext.initNonLocalBuilderThreadContext();
                this.appendImage(false);
              } finally {
                BuilderThreadContext.close();
              }
            } else {
              this.appendImage(false);
            }
          } finally {
            this.text = null;
          }
}}
/* Username */
<YYINITIAL, HTML> {
{username} {
          try {
            this.appendUsername();
          } finally {
            this.text = null;
          }
}}
/* UsernameCanNotBeInTheMiddle */
<YYINITIAL, HTML> {
[:jletterdigit:][@] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* CommitHash0 */
<YYINITIAL, HTML> {
{separator}{hash} {
          try {
            this.addVcsLink(true);
          } finally {
            this.text = null;
          }
}}
/* CommitHash1 */
<YYINITIAL, HTML> {
^{hash} {
          try {
            this.addVcsLink(false);
          } finally {
            this.text = null;
          }
}}
/* Query */
<YYINITIAL, HTML> {
"[query:"~"]" {
          try {
            if (this.QueryLinkuseGlobalLinks) {
              try {
                BuilderThreadContext.initNonLocalBuilderThreadContext();
                this.appendQuery(false);
              } finally {
                BuilderThreadContext.close();
              }
            } else {
              this.appendQuery(false);
            }
          } finally {
            this.text = null;
          }
}}
/* NewLineCount */
<YYINITIAL> {
{newline}+$ {
          try {
            this.NewLinesSimplenewLineCount += this.getText().length();
          } finally {
            this.text = null;
          }
}}
/* NewLineEnd */
<YYINITIAL> {
{newline}+/. {
          try {
            this.NewLinesSimplenewLineCount += this.getText().length();
            for (int i = 0; i < this.NewLinesSimplenewLineCount; i++) {
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append(WikiUtil.newLine());
              }
            }
            this.NewLinesSimplenewLineCount = 0;
          } finally {
            this.text = null;
          }
}}
/* NewLineEofIgnore */
<YYINITIAL> {
({newline})+ {
          try {
            //  just ignore, newlines at the end of input are not appended
          } finally {
            this.text = null;
          }
}}
/* SkipedCharacters */
<YYINITIAL> {
[\u0000-\u0008\u000B-\u000C\u000E-\u001F] {
          try {
          } finally {
            this.text = null;
          }
}}
/* empty */
<YYINITIAL> {
\r {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("");
}}
/* tab */
<YYINITIAL> {
\t {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<span class=\"wiki tab\">&nbsp;&nbsp;&nbsp;&nbsp;</span>");
}}
/* Amp */
<YYINITIAL> {
"&" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&amp;");
}}
/* Lt */
<YYINITIAL> {
"<" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&lt;");
}}
/* Gt */
<YYINITIAL> {
">" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&gt;");
}}
/* DoubleQuote */
<YYINITIAL> {
\" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&quot;");
}}
/* SingleQuote */
<YYINITIAL> {
\' {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&#39;");
}}
/* breakline */
<YYINITIAL> {
\n {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<br/>");
}}
/* LongString */
<YYINITIAL, HTML> {
{base64Symbol}{666}{base64Symbol}* {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html(this.getText()));
            }
          } finally {
            this.text = null;
          }
}}
/* Finish */
<YYINITIAL, HTML, HTML, HTML, HTML> {
. {
          this.builderContext.append(BaseProcessor.characterToStringSafe(this.yycharat(0)));
}}
