package jetbrains.charisma.wiki;

/*Generated by MPS */

import jetbrains.mps.webr.wiki.processor.runtime.BaseProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import jetbrains.mps.webr.wiki.processor.runtime.WikiUtil;
import jetbrains.mps.webr.wiki.processor.runtime.utils.AttributeManufacture;
import jetbrains.mps.webr.wiki.processor.runtime.LinkAppender;
import java.util.regex.Pattern;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import java.io.IOException;
import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import jetbrains.mps.webr.wiki.processor.runtime.utils.CommonWikiUtils;
import webr.framework.function.HtmlStringUtil;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import java.util.Arrays;
import jetbrains.mps.webr.wiki.processor.runtime.TextColorerProcessorMarkup;
import jetbrains.mps.webr.wiki.processor.runtime.TextColorerProcessor;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.JsDependencyManager;
import webr.framework.textBuilder.TBuilderContext;
import jetbrains.mps.webr.runtime.templateComponent.LinkUtil;
import jetbrains.mps.webr.runtime.util.ContentBuilder;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.webr.wiki.processor.runtime.StackProcessorUniversal;
import jetbrains.mps.webr.wiki.processor.runtime.MarkupClass;
import jetbrains.mps.webr.wiki.processor.runtime.RichTextWikiProcessor;
import org.apache.commons.lang.StringEscapeUtils;
import jetbrains.mps.gtext.runtime.BaseHtmlStringUtil;
import jetbrains.mps.webr.runtime.builderContext.BuilderThreadContext;
import java.io.Reader;
import jetbrains.mps.webr.wiki.processor.runtime.TrailingCharStringReader;
import jetbrains.mps.webr.wiki.processor.runtime.utils.HtmlProcessorWrapper;
import jetbrains.mps.webr.wiki.processor.runtime.WikiLinksManager;
import java.util.HashMap;
import jetbrains.mps.webr.wiki.processor.runtime.Table;

%%

%class CharismaWikiProcessorMarkup
%extends BaseProcessor

%public 
%buffer 124
%final
%unicode

%{

  private Log QuotingLog = LogFactory.getLog(WikiUtil.class);
  public boolean QuotingnoJs = false;
  private int QuotingmonospaceKeyLength = "{monospace}".length();
  private int QuotingnoformatKeyLength = "{noformat}".length();
  private int QuotingmonospaceBracketLength = "{{".length();
  public AttributeManufacture HtmlTextCallerattributeManufacture = new AttributeManufacture();
  public boolean HtmlTextCallernoJs = false;
  private int HtmlTextCallertagLength = "{html}".length();
  public boolean WikiLinkmobile = false;
  public String WikiLinkbaseUrl = "";
  public boolean WikiLinknoJs = false;
  private LinkAppender WikiLinklinkAppender = new LinkAppender();
  private int HighlightCallercodeSize = 0;
  public int HighlightCallermaxCodeSize = 100 * 1024;
  public boolean HighlightCallernoJs = false;
  public boolean HighlightCallerlivePreviewMode = false;
  public String HighlightCallerbaseUrl = "";
  private int TextColorercolorSuffixKeyLength = "{color}".length();
  private int TextColorercolorPrefixKeyLength = "{color:".length();
  private Log UniversalStacktraceCallerCustomlog = LogFactory.getLog(WikiUtil.class);
  public boolean UniversalStacktraceCallerCustomnoJS = false;
  public boolean UniversalStacktraceCallerCustomexceptionsExpanded = false;
  private Pattern UniversalStacktraceCallerCustompattern = Pattern.compile("[^\n]*\n?");
  private List<Character> ListslistPrefix = ListSequence.fromList(new ArrayList<Character>());
  private List<Integer> Listsnumeration = ListSequence.fromList(new ArrayList<Integer>());
  private List<Character> Listsresult = ListSequence.fromList(new ArrayList<Character>());
  private int ListsnewLineCount;
  public boolean ListsjabberMode = false;
  private String ListsrememberFirstPrefix;
  public boolean Linksmobile = false;
  public boolean LinksnoJs = false;
  public String LinksbaseUrl = "";
  private LinkAppender LinkslinkAppender = new LinkAppender();
  public boolean IssueLinkuseGlobalLinks = false;
  public WikiIssueAdapter IssueLinkissue = null;
  public boolean IssueLinkfromWorkflow = false;
  public List<WikiUserAdapter> IssueLinkmentionedUsers = ListSequence.fromList(new ArrayList<WikiUserAdapter>());
  public List<WikiIssueAdapter> IssueLinkmentionedIssues = ListSequence.fromList(new ArrayList<WikiIssueAdapter>());
  public String IssueLinklogoUrl = null;
  public WikiAppContextProvider IssueLinkappContextProvider = null;
  public boolean QueryLinkuseGlobalLinks = false;
  public WikiAppContextProvider QueryLinkcontextProvider = null;
  private boolean liveModePreview = false;

  public IWikiProcessor clone(String input) {
    CharismaWikiProcessorMarkup cloned = create(input);
    cloned.QuotingnoJs = this.QuotingnoJs;
    cloned.HtmlTextCallerattributeManufacture = this.HtmlTextCallerattributeManufacture;
    cloned.HtmlTextCallernoJs = this.HtmlTextCallernoJs;
    cloned.WikiLinkmobile = this.WikiLinkmobile;
    cloned.WikiLinkbaseUrl = this.WikiLinkbaseUrl;
    cloned.WikiLinknoJs = this.WikiLinknoJs;
    cloned.HighlightCallermaxCodeSize = this.HighlightCallermaxCodeSize;
    cloned.HighlightCallernoJs = this.HighlightCallernoJs;
    cloned.HighlightCallerlivePreviewMode = this.HighlightCallerlivePreviewMode;
    cloned.HighlightCallerbaseUrl = this.HighlightCallerbaseUrl;
    cloned.UniversalStacktraceCallerCustomnoJS = this.UniversalStacktraceCallerCustomnoJS;
    cloned.UniversalStacktraceCallerCustomexceptionsExpanded = this.UniversalStacktraceCallerCustomexceptionsExpanded;
    cloned.ListsjabberMode = this.ListsjabberMode;
    cloned.Linksmobile = this.Linksmobile;
    cloned.LinksnoJs = this.LinksnoJs;
    cloned.LinksbaseUrl = this.LinksbaseUrl;
    cloned.IssueLinkuseGlobalLinks = this.IssueLinkuseGlobalLinks;
    cloned.IssueLinkissue = this.IssueLinkissue;
    cloned.IssueLinkfromWorkflow = this.IssueLinkfromWorkflow;
    cloned.IssueLinkmentionedUsers = this.IssueLinkmentionedUsers;
    cloned.IssueLinkmentionedIssues = this.IssueLinkmentionedIssues;
    cloned.IssueLinklogoUrl = this.IssueLinklogoUrl;
    cloned.IssueLinkappContextProvider = this.IssueLinkappContextProvider;
    cloned.QueryLinkuseGlobalLinks = this.QueryLinkuseGlobalLinks;
    cloned.QueryLinkcontextProvider = this.QueryLinkcontextProvider;
    return cloned;
  }

  protected void processInternal() throws IOException {
    if (this.wrapWithDiv) {
      this.builderContext.append(PROLOG);
    }
    this.yylex();
    this.finish();
    if (this.wrapWithDiv) {
      this.builderContext.append(EPILOG);
    }
  }

  protected void finish() {
    for (int i = ListSequence.fromList(this.ListslistPrefix).count() - 1; i >= 0; i--) {
      char it = ListSequence.fromList(this.ListslistPrefix).getElement(i);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append((it == '#' ?
          "<br/></li></ol>" :
          "<br/></li></ul>"
        ));
      }
    }
    //  ^[*]?([#][*])*[#]?(([-][*]?(([#][*])+|[#]))+|[-])?[^#-\*]
  }

  protected boolean readerNotExists() {
    return this.zzReader == null;
  }

  private String yytext(int prefixLength, int suffixLength) {
    return new String(this.zzBuffer, this.zzStartRead + prefixLength, this.zzMarkedPos - this.zzStartRead - suffixLength - prefixLength);
  }

  public CharismaWikiProcessorMarkup setHtmlTextCallernoJs(boolean value) {
    this.HtmlTextCallernoJs = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setHighlightCallermaxCodeSize(int value) {
    this.HighlightCallermaxCodeSize = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setListsjabberMode(boolean value) {
    this.ListsjabberMode = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setIssueLinkuseGlobalLinks(boolean value) {
    this.IssueLinkuseGlobalLinks = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setIssueLinkissue(WikiIssueAdapter value) {
    this.IssueLinkissue = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setIssueLinkmentionedUsers(List<WikiUserAdapter> value) {
    this.IssueLinkmentionedUsers = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setIssueLinkmentionedIssues(List<WikiIssueAdapter> value) {
    this.IssueLinkmentionedIssues = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setIssueLinklogoUrl(String value) {
    this.IssueLinklogoUrl = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setIssueLinkappContextProvider(WikiAppContextProvider value) {
    this.IssueLinkappContextProvider = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setQueryLinkuseGlobalLinks(boolean value) {
    this.QueryLinkuseGlobalLinks = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setQueryLinkcontextProvider(WikiAppContextProvider value) {
    this.QueryLinkcontextProvider = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setWikiLinkmobile(boolean value) {
    this.WikiLinkmobile = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setCharismaWikiProcessor_noJS(boolean value) {
    this.UniversalStacktraceCallerCustomnoJS = value;
    this.QuotingnoJs = value;
    this.HighlightCallernoJs = value;
    this.LinksnoJs = value;
    this.WikiLinknoJs = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setCharismaWikiProcessor_mobile(boolean value) {
    this.WikiLinkmobile = value;
    this.WikiLinkmobile = value;
    this.Linksmobile = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setCharismaWikiProcessor_exceptionsExpanded(boolean value) {
    this.UniversalStacktraceCallerCustomexceptionsExpanded = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setCharismaWikiProcessor_attrFilter(AttributeManufacture value) {
    this.HtmlTextCallerattributeManufacture = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setCharismaWikiProcessor_fromWorkflow(boolean value) {
    this.IssueLinkfromWorkflow = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setCharismaWikiProcessor_baseUrl(String value) {
    this.WikiLinkbaseUrl = value;
    this.LinksbaseUrl = value;
    this.HighlightCallerbaseUrl = value;
    return this;
  }

  public CharismaWikiProcessorMarkup setLivePreviewMode(boolean value) {
    this.HighlightCallerlivePreviewMode = value;
    return this;
  }

  private boolean isNewline(char a) {
    return a == '\n' || a == '\r';
  }

  public void appendNoformat(boolean noMarkup) {
    String result = CommonWikiUtils.valuableSubstring(this.getText(), this.QuotingnoformatKeyLength, this.getText().length() - this.QuotingnoformatKeyLength);
    int last = -1;
    for (int pos = 0; pos < result.length(); pos++) {
      if (this.isNewline(result.charAt(pos))) {
        if (!(noMarkup)) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(HtmlStringUtil.html(result.substring(last + 1, pos)));
          }
        } else {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(result.substring(last + 1, pos));
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          if (!(noMarkup)) {
            builderContext.append("<br/>");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          if (noMarkup) {
            builderContext.append("\n");
          }
        }
        last = pos;
      }
    }
    if (!(noMarkup)) {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(HtmlStringUtil.html(result.substring(last + 1)));
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      if (noMarkup) {
        builderContext.append(result.substring(last + 1));
      }
    }
  }

  public void transformQuote(int from, int to, boolean noMarkup) {
    if (!(noMarkup)) {
      String t = CommonWikiUtils.valuableSubstring(this.getText(), from, this.getText().length() - to);
      if ((t == null || t.length() == 0)) {
        return;
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<div class=\"wiki quote\">");
      }
      try {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          this.clone(t).processSafe(builderContext);
        }
      } catch (Exception e) {
        if (this.QuotingLog.isErrorEnabled()) {
          this.QuotingLog.error("Exception while processing recursive content [" + t + "]", e);
        }

        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.getErrorMessage(e, t)));
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</div>");
      }
    } else {
      String t = this.yytext(from, to);
      try {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          this.clone(t).processSafe(builderContext);
        }
      } catch (Exception e) {
        if (this.QuotingLog.isErrorEnabled()) {
          this.QuotingLog.error("Exception while processing recursive content [" + t + "]", e);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(this.getErrorMessage(e, t));
        }
      }
    }
  }

  private String getErrorMessage(Exception e, String text) {
    return "Can't apply wiki recursive markup:" + e.getMessage() + "\n. Original text:\n" + text;
  }

  /*package*/ void appendLink(String link, String displayedText) {
    if (!(this.WikiLinklinkAppender.isInitialized())) {
      this.WikiLinklinkAppender.init(this.builderContext, this.WikiLinkmobile, this.WikiLinkbaseUrl);
    }
    this.WikiLinklinkAppender.appendLink(link, displayedText, this.WikiLinknoJs);
  }

  public void appendTitle(String title) {
    if (title != null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<div class=\"java code title\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(title));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</div>");
      }
    }
  }

  private String getTitleCodeLimitExeededMessage() {
    return ((Localizer) ServiceLocator.getBean("localizer")).localizedMsg("HighlightCaller.The_code-tagged_content_in_this_issue_is_too_large_Code_highlighting_has_been_switched_off");
  }

  public void appendBackGap() {
    int len = 0;
    for (int i = this.getText().length() - 1; i >= 0 && this.getText().charAt(i) == ' '; --i) {
      ++len;
    }
    char[] a = new char[len];
    Arrays.fill(a, ' ');
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(new String(a));
    }
  }

  public void appendInlineCode(String code) {
    if ((code != null && code.length() > 0)) {
      code = ((TextColorerProcessorMarkup) TextColorerProcessor.getInstance().createProcessor(code)).setTextColorerProcessor_baseUrl(this.HighlightCallerbaseUrl).processSafe();
      this.HighlightCallercodeSize += code.length();
      this.appendHighlight(WikiUtil.PLAIN_TEXT, code, "code", "inline-code");
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(this.getText()));
      }
    }
  }

  public void appendHighlightPre(String langName, String code) {
    this.appendHighlight(langName, code, "pre", "wikicode");
  }

  public void appendHighlightCode(String code) {
    this.appendHighlight(null, code, "code", "inline-code");
  }

  public void appendHighlight(String langName, String code, String tag, String styleClass) {
    if (isEmpty_2r2ryz_a0a0jb(((code == null ?
      null :
      code.trim()
    )))) {
      return;
    }
    if (this.HighlightCallercodeSize > this.HighlightCallermaxCodeSize) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<");
        builderContext.append(tag);
        builderContext.append(" class=\"" + styleClass);
      }
      if (this.HighlightCallercodeSize > this.HighlightCallermaxCodeSize) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\" title=\"");
          builderContext.append(this.getTitleCodeLimitExeededMessage());
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(code);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</");
        builderContext.append(tag);
        builderContext.append(">");
      }
      return;
    }

    boolean nonDefaultLang = (langName != null && langName.length() > 0) && (((((JsDependencyManager) ServiceLocator.getOptionalBean("jsDependencyManager"))) != null && ((JsDependencyManager) ServiceLocator.getBean("jsDependencyManager")).containsDependency("jetbrains.mps.webr.prettify." + "lang-" + langName + "-min")));
    if (!(this.HighlightCallernoJs)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<span class=\"");
        builderContext.append("js-wrapper");
        builderContext.append("\">");
      }
      {
        TBuilderContext builderContext = (TBuilderContext) this.builderContext;
        LinkUtil.addScriptDependencies(builderContext, ListSequence.fromListAndArray(new ArrayList<String>(), "jetbrains.mps.webr.prettify.prettify"));
      }
      if (nonDefaultLang) {
        {
          TBuilderContext builderContext = (TBuilderContext) this.builderContext;
          String fname = "jetbrains.mps.webr.prettify." + "lang-" + langName + "-min";
          LinkUtil.addScriptDependencies(builderContext, ListSequence.fromListAndArray(new ArrayList<String>(), fname));
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</span>");
      }
    }

    boolean isPlainText = eq_2r2ryz_a0a6a53(langName, WikiUtil.PLAIN_TEXT);
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("<");
      builderContext.append(tag);
      builderContext.append(" class=\"");
      builderContext.append(styleClass);
    }
    if (nonDefaultLang) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(" lang-");
        builderContext.append(langName);
      }
    }
    if (!(isPlainText)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(" prettyprint");
      }
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("\">");
    }

    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(code);
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("</");
      builderContext.append(tag);
      builderContext.append(">");
    }

    if (isPlainText || this.HighlightCallernoJs) {
      return;
    }

    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("<span class=\"");
      builderContext.append("js-wrapper");
      builderContext.append("\">");
    }
    if (this.HighlightCallerlivePreviewMode) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(ContentBuilder.toString(new _FunctionTypes._void_P1_E0<TBuilderContext>() {
          public void invoke(TBuilderContext builderContext) {
            builderContext.appendIndent();
            builderContext.append("<script type=\"text/javascript\">");
            builderContext.appendIndent();
            LinkUtil.addScriptDependencies(builderContext, ListSequence.fromList(new ArrayList<String>()));
            builderContext.appendIndent();
            builderContext.append("setTimeout(function () {");
            builderContext.appendNewLine();
            builderContext.increaseIndent();
            builderContext.appendIndent();
            builderContext.append("prettyPrint();");
            builderContext.appendNewLine();
            builderContext.decreaseIndent();
            builderContext.appendIndent();
            builderContext.append("}, 3000);");
            builderContext.appendNewLine();
            builderContext.appendNewLine();
            builderContext.append("</script>");
            builderContext.appendNewLine();
          }
        }, false));
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(ContentBuilder.toString(new _FunctionTypes._void_P1_E0<TBuilderContext>() {
          public void invoke(TBuilderContext builderContext) {
            builderContext.appendIndent();
            builderContext.append("<script type=\"text/javascript\">");
            builderContext.appendIndent();
            LinkUtil.addScriptDependencies(builderContext, ListSequence.fromList(new ArrayList<String>()));
            builderContext.appendIndent();
            builderContext.append("prettyPrint();");
            builderContext.appendNewLine();
            builderContext.appendNewLine();
            builderContext.append("</script>");
            builderContext.appendNewLine();
          }
        }, false));
      }
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("</span>");
    }
  }

  public void processStackTrace(String input) {
    try {
      input = input.trim();
      StackProcessorUniversal.getInstance().createProcessor(input).process(this.builderContext);
    } catch (Exception e) {
      if (this.UniversalStacktraceCallerCustomlog.isErrorEnabled()) {
        this.UniversalStacktraceCallerCustomlog.error("Exception while processing exception content [" + input + "]", e);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html("Can't apply wiki stacktrace markup: " + e.getMessage() + "\n" + "Original text:"));
        builderContext.append(HtmlStringUtil.html("\n"));
        builderContext.append(HtmlStringUtil.html(input));
      }
    }
  }

  public void appendException(int pos) {
    String stacktrace = this.yytext(pos, 0);
    int endOfFirstLine = stacktrace.indexOf('\n');
    try {
      TBaseBuilderContext ctx = new TBaseBuilderContext();
      ctx.initBuffer();

      if (this.UniversalStacktraceCallerCustompattern.matcher(stacktrace).matches()) {
        String s1 = "<div><pre class=\"";
        String s2 = "wiki-exception-title";
        String s3 = "\">";
        ctx.append(s1);
        ctx.append(s2);
        ctx.append(s3);
        StackProcessorUniversal.getInstance().createProcessor(((stacktrace == null ?
          null :
          stacktrace.trim()
        ))).processSafe(ctx);
        String s4 = "</pre></div>";
        ctx.append(s4);
      } else {
        CharismaStackTraceCollapser collapser = new CharismaStackTraceCollapser(ctx, this.UniversalStacktraceCallerCustomnoJS);
        String head = stacktrace.substring(0, endOfFirstLine);
        IWikiProcessor headProccessor = StackProcessorUniversal.getInstance().createProcessor(((head == null ?
          null :
          head.trim()
        )));
        IWikiProcessor bodyProccessor = StackProcessorUniversal.getInstance().createProcessor(((stacktrace == null ?
          null :
          stacktrace.trim()
        )));
        if (!(this.UniversalStacktraceCallerCustomexceptionsExpanded)) {
          collapser.appendCollapsedExceptionMarkup(headProccessor, bodyProccessor);
        } else {
          collapser.appendExpandedExceptionMarkup(headProccessor, bodyProccessor);
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(ctx.getText());
      }
    } catch (Throwable t) {
      // TODO remove this when WD-1493 is implemented 
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<div><pre class=\"");
        builderContext.append("wiki-exception");
        builderContext.append("\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(stacktrace));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</pre></div>");
      }
    }
  }

  public String getNewline(int n, String val) {
    StringBuilder sb = new StringBuilder();
    for (int i = 0; i < n; i++) {
      sb.append(val);
    }
    return sb.toString();
  }

  private String giveMeNumber(int number) {
    return number + ".";
  }

  private int diff(String str, List<Character> source, List<Character> result) {
    int count = 0;
    int bound = ListSequence.fromList(source).count();
    for (int i = 0; i < str.length(); i++) {
      if (i >= bound || str.charAt(i) != ListSequence.fromList(source).getElement(count)) {
        this.appendResult(str, result, i);
        return count;
      }
      count++;
    }
    return count;
  }

  private void appendResult(String str, List<Character> result, int i) {
    for (char __; i < str.length(); i++) {
      ListSequence.fromList(result).addElement(str.charAt(i));
    }
  }

  private void flushNewLines(boolean noMarkup) {
    for (int i = 0; i < this.ListsnewLineCount; i++) {
      MarkupClass.newLine(this.builderContext, noMarkup, this.ListsjabberMode);
    }
    this.ListsnewLineCount = 0;
  }

  private void transformList(String str, boolean noMarkup) throws IOException {
    ListSequence.fromList(this.Listsresult).clear();
    int length = this.diff(str, this.ListslistPrefix, this.Listsresult);
    this.flushNewLines(noMarkup);
    while (ListSequence.fromList(this.ListslistPrefix).count() > length) {
      char it = ListSequence.fromList(this.ListslistPrefix).removeLastElement();
      if (!(noMarkup)) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append((it == '#' ?
            "</li></ol>" :
            "</li></ul>"
          ));
        }
      }
    }
    switch (ListSequence.fromList(this.Listsresult).count()) {
      case 0:
        //  empty item
        if (!(noMarkup)) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("</li><li>");
          }
        } else {
          char[] shift = new char[ListSequence.fromList(this.ListslistPrefix).count() - 1];
          Arrays.fill(shift, ' ');
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(new String(shift));
          }
          if ((int) ListSequence.fromList(this.Listsnumeration).last() == -1) {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("*");
            }
          } else {
            int last = ListSequence.fromList(this.Listsnumeration).removeLastElement();
            last++;
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.giveMeNumber(last));
            }
            ListSequence.fromList(this.Listsnumeration).addElement(last);
          }
        }
        break;
      case 1:
        //  nested item
        char it = ListSequence.fromList(this.Listsresult).first();
        if (!(noMarkup)) {
          if (it == '#') {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("<ol class=\"wiki-list");
              builderContext.append(Integer.toString(ListSequence.fromList(this.ListslistPrefix).count()));
              builderContext.append("\">");
            }
          } else {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("<ul class=\"wiki-list");
              builderContext.append(Integer.toString(ListSequence.fromList(this.ListslistPrefix).count()));
              builderContext.append("\">");
            }
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("<li>");
          }
        } else {
          char[] shift = new char[ListSequence.fromList(this.ListslistPrefix).count()];
          Arrays.fill(shift, ' ');
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(new String(shift));
          }
          if (it != '#') {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("*");
            }
            ListSequence.fromList(this.Listsnumeration).addElement(-1);
          } else {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.giveMeNumber(1));
            }
            ListSequence.fromList(this.Listsnumeration).addElement(1);
          }
        }
        ListSequence.fromList(this.ListslistPrefix).addElement(it);
        break;
      default:
        //  too many items
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(str);
        }
    }
  }

  private void processNewLineChecking(boolean nomarkup) throws IOException {
    if (this.getText().length() > 0 && this.getText().charAt(this.getText().length() - 1) == '\n') {
      this.transformList(this.ListsrememberFirstPrefix, nomarkup);
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(this.ListsrememberFirstPrefix);
      }
    }
    this.ListsrememberFirstPrefix = "";
    this.yypushback(this.getText().length());
    this.endState();
  }

  private void processList(boolean nomarkup) throws IOException {
    if (ListSequence.fromList(this.ListslistPrefix).isEmpty() && this.getText().length() == 1) {
      this.ListsrememberFirstPrefix = this.getText();
      this.beginState(this.CHECK_NEW_LINE);
    } else {
      this.transformList(this.getText(), nomarkup);
    }
  }

  private void appendLabeledLink() throws IOException {
    int linkEnds = this.getLinkEnds();
    if (linkEnds != -1) {
      String link = StringUtils.substring(this.getText(), 1, linkEnds).trim();
      this.appendLinkTag(link, RichTextWikiProcessor.getInstance().createProcessor(StringUtils.substring(this.getText(), linkEnds + 1, this.getText().length() - 1)).processSafe());
    } else {
      String link = StringUtils.substring(this.getText(), 1, this.getText().length() - 1).trim();
      this.appendLinkTag(link, StringEscapeUtils.escapeHtml(link));
    }
  }

  private int getLinkEnds() {
    int linkEnds = this.getText().indexOf(' ');
    while (linkEnds > 1 && this.getText().charAt(linkEnds - 1) == ',' && (Character.isLetter(this.getText().charAt(linkEnds - 2)) || Character.isDigit(linkEnds - 2))) {
      boolean flag = false;
      for (int i = linkEnds; i >= 0; --i) {
        flag = this.getText().charAt(i) == '(';
        if (flag || this.getText().charAt(i) == ')' || this.getText().charAt(i) == '[') {
          break;
        }
      }
      if (flag) {
        for (int i = linkEnds; i < this.getText().length(); ++i) {
          flag = this.getText().charAt(i) == ')';
          if (flag || this.getText().charAt(i) == '(' || this.getText().charAt(i) == ']') {
            break;
          }
        }
      }
      if (flag) {
        linkEnds = this.getText().indexOf(' ', linkEnds + 1);
      } else {
        break;
      }
    }
    return linkEnds;
  }

  public void appendConfluenceStyledLink() throws IOException {
    int linkEnds = this.getText().indexOf('|');
    String link = StringUtils.substring(this.getText(), linkEnds + 1, this.getText().length() - 1).trim();
    String label = RichTextWikiProcessor.getInstance().createProcessor(StringUtils.substring(this.getText(), 1, linkEnds)).processSafe();
    this.appendLinkTag(link.trim(), label);
  }

  public void appendHttpLink(String url) {
    url = url.trim();
    int lastCharIndex = url.length() - 1;
    char lastChar = url.charAt(lastCharIndex);
    boolean append = lastChar == '.' || lastChar == ',' || lastChar == ':' || lastChar == ';';
    if (append) {
      url = StringUtils.substring(url, 0, lastCharIndex);
      this.appendLinkTag(url, url);
      BaseHtmlStringUtil.html(BaseProcessor.characterToStringSafe(lastChar));
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(BaseHtmlStringUtil.html(BaseProcessor.characterToStringSafe(lastChar)));
      }
    } else {
      this.appendLinkTag(url, url);
    }
  }

  /*package*/ void appendMailToLinkTag(String link) {
    if (!(this.LinkslinkAppender.isInitialized())) {
      this.LinkslinkAppender.init(this.builderContext, this.Linksmobile, this.LinksbaseUrl);
    }
    this.LinkslinkAppender.appendMailToLink(link);
  }

  /*package*/ void appendLinkTag(String link, String displayedText) {
    if (!(this.LinkslinkAppender.isInitialized())) {
      this.LinkslinkAppender.init(this.builderContext, this.Linksmobile, this.LinksbaseUrl);
    }
    this.LinkslinkAppender.appendLink(link, displayedText, this.LinksnoJs);
  }

  public final void appendBlank(char a) {
    switch (a) {
      case '\n':
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<br/>");
        }
        break;
      case '\t':
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\t");
        }
        break;
      case ' ':
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(" ");
        }
        break;
      default:
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("" + a);
        }
    }
  }

  public final void appendBlank(String s) {
    for (int i = 0; i < s.length(); i++) {
      this.appendBlank(s.charAt(i));
    }
  }

  public void appendTitledText() {
    int contentEnds = this.getText().lastIndexOf('|');
    String title = StringUtils.substring(this.getText(), contentEnds + 1, this.getText().length() - 2).trim();
    String content = StringUtils.substring(this.getText(), 2, contentEnds);
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("<span title=\"");
      builderContext.append(title.trim());
      builderContext.append("\">");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      this.clone(content).processSafe(builderContext);
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("</span>");
    }
  }

  public void removeFramingMarkup(String symbol, String tag, boolean addHtml) {
    int indexOfSymbol = this.getText().indexOf(symbol);
    int indexOfLastSymbol = this.getText().lastIndexOf(symbol);
    this.appendBlank(StringUtils.substring(this.getText(), 0, indexOfSymbol));
    int delemiterIdx = indexOfSymbol + 1;
    String[] strings = StringUtils.substring(this.getText(), indexOfSymbol + 1, indexOfLastSymbol).split('\\' + symbol + "[ \t\r\n]" + '\\' + symbol);
    for (String str : strings) {
      if (addHtml) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(tag);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(">");
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(str).processSafe(builderContext);
      }
      if (addHtml) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("</");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(tag);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(">");
        }
      }
      delemiterIdx += str.length() + symbol.length();
      if (str != strings[strings.length - 1]) {
        this.appendBlank(this.getText().charAt(delemiterIdx));
        delemiterIdx += symbol.length() + 1;
      }
    }
    this.appendBlank((this.getText().charAt(this.getText().length() - 1) == '\r' ?
      StringUtils.substring(this.getText(), indexOfLastSymbol + 1, this.getText().length() - 2) :
      StringUtils.substring(this.getText(), indexOfLastSymbol + 1)
    ));
  }

  public void transformIssue() {
    WikiIssueAdapter i = this.IssueLinkappContextProvider.getIssueById(this.getText());
    if (i == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(this.getText()));
      }
    } else {
      if (this.IssueLinkuseGlobalLinks) {
        try {
          BuilderThreadContext.initNonLocalBuilderThreadContext();
          this.appendIssueLink(i, this.getText());
        } finally {
          BuilderThreadContext.close();
        }
      } else {
        this.appendIssueLink(i, this.getText());
      }
    }
  }

  public void appendIssueLink(WikiIssueAdapter i, String mentionedId) {
    LinkAppender.appendHrefForMobile(this.builderContext, false);
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(i.getUrl(this.IssueLinkuseGlobalLinks) + "\"");
    }
    if (i.isResolved()) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(" class=\"issue-resolved\"");
      }
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" target=\"_self\"");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" data-issue-id=\"" + i.getId() + "\"");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" title=\"" + BaseHtmlStringUtil.html(i.getSummary()) + "\">" + mentionedId + "</a>");
    }
    ListSequence.fromList(this.IssueLinkmentionedIssues).addElement(i);
  }

  public void appendImage(boolean noMarkup) throws IOException {
    if (noMarkup) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("!");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(this.yytext(1, 1)).processSafe(builderContext);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("!");
      }
    } else {
      String[] result = this.yytext(1, 1).split("[|]");
      String name = null;
      int last = -1;
      if (result.length > 0) {
        last = result.length - 1;
        name = result[last];
      }

      if (this.IssueLinkissue == null && this.getText().equals("!".concat(this.IssueLinklogoUrl.substring(this.IssueLinklogoUrl.lastIndexOf('/') + 1)).concat("!"))) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<div class=\"wiki picture\"><img src=\"");
          builderContext.append(this.IssueLinklogoUrl);
          builderContext.append("\"/></div>");
        }
        return;
      }

      WikiAttachmentAdapter attach = this.IssueLinkappContextProvider.getAttachmentByName(this.IssueLinkissue, name);

      if (attach == null) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("!");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          this.clone(this.yytext(1, 1)).processSafe(builderContext);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("!");
        }
      } else {
        String alt = null;
        String position = null;
        for (int i = 0; i < last; i++) {
          String value = result[i].trim();
          if (IssueLinkConst.POS.contains(value)) {
            position = value;
          } else {
            alt = value;
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<div class=\"wiki picture\"");
        }
        if (position != null) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(" style=\"");
          }
          if (position.equals(IssueLinkConst.INLINE)) {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("display:inline;");
            }
          } else {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html("align:"));
              builderContext.append(HtmlStringUtil.html(position));
              builderContext.append(HtmlStringUtil.html(";"));
            }
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("\"");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("><img src=\"");
          builderContext.append(attach.getUrl(this.IssueLinkfromWorkflow));
          builderContext.append("\"");
        }
        if (alt != null) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(" alt=\"");
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(HtmlStringUtil.html(alt));
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("\"");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("/></div>");
        }
      }
    }
  }

  private void fixForRTL(String str) {
    if (!(this.IssueLinkappContextProvider.isRtlEnabled())) {
      return;
    }

    boolean flag = false;
    for (int i = 0; i < str.length(); ++i) {
      if (str.charAt(i) > '\u05BE') {
        flag = true;
      }
    }

    if (!(flag)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("&lrm;");
      }
    }
  }

  private void appendUsername() {
    WikiUserAdapter user = this.IssueLinkappContextProvider.getUserByLogin(StringUtils.substring(this.getText(), 1));

    int pushBackCount;
    if (user != null) {
      if (user.isAccessible()) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<a href=\"");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(user.getProfileUrl(this.IssueLinkfromWorkflow));
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\" title=\"");
          builderContext.append(user.getLogin());
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\" data-user-id=\"");
          builderContext.append(user.getId());
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\">");
        }
        String displayedText = BaseHtmlStringUtil.html(user.getFullName());
        this.fixForRTL(displayedText);
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(displayedText);
          builderContext.append("</a>");
        }
      } else {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<b ");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("data-user-id=\"");
          builderContext.append(user.getId());
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\">");
        }
        String displayedText = BaseHtmlStringUtil.html(user.getFullName());
        this.fixForRTL(displayedText);
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(displayedText);
          builderContext.append("</b>");
        }
      }
      pushBackCount = (this.getText().length() - 1 - user.getLogin().length());
      ListSequence.fromList(this.IssueLinkmentionedUsers).addElement(user);
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(Character.toString(this.getText().charAt(0)));
      }
      pushBackCount = this.getText().length() - 1;
    }
    if (pushBackCount > 0) {
      this.yypushback(pushBackCount);
    }
  }

  public void appendAttachment(boolean removeMarkup) {
    String name = StringUtils.substring(this.getText(), 6, this.getText().length() - 1);
    WikiAttachmentAdapter attach = this.IssueLinkappContextProvider.getAttachmentByName(this.IssueLinkissue, name);
    if (attach != null) {
      if (removeMarkup) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(name));
        }
      } else {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<a href=\"");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(attach.getUrl(this.IssueLinkfromWorkflow));
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\">");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(name));
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("</a>");
        }
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(this.getText());
      }
    }
  }

  private void addVcsLink(boolean skip) {
    String t;
    if (skip) {
      t = this.getText().substring(1);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(BaseHtmlStringUtil.html(Character.toString(this.getText().charAt(0))));
      }
    } else {
      t = this.getText();
    }
    String link = this.IssueLinkappContextProvider.getVcsLink(this.IssueLinkissue, t);
    if (link == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(t);
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<a href=\"");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(link);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(t);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</a>");
      }

    }
  }

  public void appendQuery(boolean removeMarkup) {
    String query = this.yytext(7, 1);
    if (removeMarkup) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(query);
      }
    } else {
      LinkAppender.appendHrefForMobile(this.builderContext, false);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(this.QueryLinkcontextProvider.getIssueListUrlUrl(query));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(query));
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</a>");
      }
    }
  }


  public static CharismaWikiProcessorMarkup create(String s) {
    CharismaWikiProcessorMarkup result;
    if (s == null) {
      Reader reader = null;
      result = new CharismaWikiProcessorMarkup(reader);
    } else {
      result = new CharismaWikiProcessorMarkup(new TrailingCharStringReader(s, '\r'));
    }
    result.setCharismaWikiProcessor_noJS(false);
    result.setCharismaWikiProcessor_mobile(false);
    result.setCharismaWikiProcessor_exceptionsExpanded(false);
    result.setCharismaWikiProcessor_fromWorkflow(false);
    result.setCharismaWikiProcessor_baseUrl(null);
    return result;
  }

  public static boolean isEmpty_2r2ryz_a0a0jb(String str) {
    return str == null || str.length() == 0;
  }

  private static boolean eq_2r2ryz_a0a6a53(Object a, Object b) {
    return (a != null ?
      a.equals(b) :
      a == b
    );
  }

  public static String trim_2r2ryz_a0a3a3a0a0m(String str) {
    return (str == null ?
      null :
      str.trim()
    );
  }
%}

%type Void

color = ([a-zA-Z]+)|("#"[0-9a-fA-F]{6})
newline = \n
line = "|"[^\n]*"|"
block = {newline}*({line}\n)*{line}\n?
KeyWord = [:jletter:]+
EscapeHtmlCode = "&"[:jletterdigit:]+";"
SingleNetAngleId = ([0-9A-Za-z_<>`$\/]|{EscapeHtmlCode})
NetAngleId = {SingleNetAngleId}+
PossibleNetAngleId = {SingleNetAngleId}*
NetBrackId = ([0-9A-Za-z<>`\[\],$_\/]|{EscapeHtmlCode})+
KeyExcWord = ("Failure"|"Exception"|"Error"|"Throwable")
SquareBracketExpression = (("~")?"["[^ \r\n\t]+"]")
ExceptionClass = ({PossibleNetAngleId}".")+{PossibleNetAngleId}{KeyExcWord}
Exception = ({ExceptionClass}((":"([^\n-]|-*[^\n>])*("->"|\n)?)|({SpaceLine}))?)
Address = "<"0x[:jletterdigit:]+">"
SingleSpace = [\t ]
Space = ({SingleSpace}+)
PossibleSpace = ({SingleSpace}*)
SpaceLine = ({PossibleSpace}\n)
PossibleSpaceLine = ({PossibleSpace}(\n)?)
Number = [:digit:]+
NetLock = {Space}-({Space}{KeyWord}){0,5}({PossibleSpaceLine}{Address}{Space}"(" ~")" )?{PossibleSpaceLine}
ElementSuffix = {KeyWord}([^()]+(":"{KeyWord})){Space}{Number}({Space}{KeyWord}{Space}{Number})?
atFunctionWithSuffix = {PossibleSpace}{KeyWord}{Space}({NetAngleId}".")+"."?{NetBrackId}"("[^)\n]*")"{PossibleSpace}({ElementSuffix}|{SquareBracketExpression})?{PossibleSpaceLine}
Selector = {PossibleSpace}"---"~("---"){PossibleSpaceLine}
Cause = \n{PossibleSpace}{KeyWord}({Space}{KeyWord})+":"(({SpaceLine}{Space}[-])|({Space}{KeyWord}([.]{KeyWord})+)).*(\n)?
CauseOrDashes = ({Cause}|{Selector})
MorePart = ({PossibleSpace}"..."{Space}{Number}{Space}{KeyWord}{PossibleSpaceLine})
ExceptionLine = ({atFunctionWithSuffix}|{NetLock}|{MorePart})
Exc = {Exception}*({atFunctionWithSuffix})({ExceptionLine}|{CauseOrDashes}{Exception}*)*
newline = (\n)
listSymbol = [-#*]
schemas = "ftp" | "http" | "https" | "gopher" | "mailto" | "news" | "nntp" | "irc" | "prospero" | "telnet" | "wais" | "xmpp" | "file" | "data" | "afs" | "cid" | "mid" | "mailserver" | "nfs" | "tn3270" | "z39.50" | "skype" | "smsto" | "ed2k"
baseAllowedUrlSymbol = ([:jletterdigit:]|[-_.!\*$&+/:;=?@#%{}|\^~`',])
bracketsExpressionAllowedSymbol = (([:jletterdigit:]+", ")|{baseAllowedUrlSymbol})
indexExpression = "["{baseAllowedUrlSymbol}*"]"
brecketsExpression = "("{bracketsExpressionAllowedSymbol}*")"
allowedUrlSymbol = {indexExpression}|{baseAllowedUrlSymbol}|{brecketsExpression}|[()]
allowedUrlSymbolWOB = {indexExpression}|{baseAllowedUrlSymbol}|{brecketsExpression}
urlTemplate = {allowedUrlSymbol}*{allowedUrlSymbolWOB}
email = ([a-zA-Z]([:jletterdigit:]|[_.-])*[@][a-zA-Z]([:jletterdigit:]|[_.-])*[.]([a-zA-Z]{2,5}))
nonEmptyWord = [^ \t\n\r-]
baseUnderlineRegexp = [ \t\n\r]\+([^ \t\n\r\+]([ ]|\\\+)*)*(([^ \t\n\r\+\\]|\\\+)\+)
baseAsteriskRegexp = [ \t\n\r]\*([^ \t\n\r\*]([ ]|\\\*)*)*(([^ \t\n\r\*\\]|\\\*)\*)
nonWordSymbol = [ \r\n\t\/\[\]\(\)\`\"-_.!\*$&+/:;=?@#%{}|\^~`',]
separator = [ \t\,\;\.\:\"()\?#\^]
ussueStart = [#\^]
issue = [a-zA-Z0-9_]+ \- [0-9]+
hash = [a-fA-F0-9]{40}
space = [ \n\t]
attachment = "[file:"[^\]]+"]"
image = "!"[^!\n]+"!"
username = [@]([:jletterdigit:]|[\+\.\|\-\=\@]){1,32}
base64Symbol = ([:jletterdigit:]|[\+\/=])

%state CHECK_NEW_LINE, HTML, HTML, HTML

%%

/* ReplyQuotation */
<YYINITIAL> {
^">"(.)*([\n$]">"(.)*)* {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("<div class=\"wiki quote\">");
            }
            StringBuilder sb = new StringBuilder();
            boolean notFirst = false;
            for (String line : this.getText().split("\n")) {
              if (notFirst) {
                sb.append('\n');
              } else {
                notFirst = true;
              }
              sb.append(line.substring(1));
            }
            {
              TBaseBuilderContext builderContext = this.builderContext;
              this.clone(sb.toString()).processSafe(builderContext);
            }
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("</div>");
            }
          } finally {
            this.text = null;
          }
}}
/* Quote */
<YYINITIAL> {
("{quote}")~("{quote}") {
          try {
            this.transformQuote(7, 7, false);
          } finally {
            this.text = null;
          }
}}
/* Monospace */
<YYINITIAL> {
("{monospace}")~("{monospace}") {
          try {
            String body = CommonWikiUtils.valuableSubstring(this.getText(), this.QuotingmonospaceKeyLength, this.getText().length() - this.QuotingmonospaceKeyLength);
            if ((body != null && body.length() > 0)) {
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append("<span class=\"monospace\">");
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                this.clone(body).processSafe(builderContext);
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append("</span>");
              }
            }
          } finally {
            this.text = null;
          }
}}
/* MonospaceBracket */
<YYINITIAL> {
("{{")([^{}]|[{][^{]|[}][^}])*("}}") {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("<span class=\"monospace\">");
            }
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html(this.yytext(this.QuotingmonospaceBracketLength, this.QuotingmonospaceBracketLength)));
            }
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("</span>");
            }
          } finally {
            this.text = null;
          }
}}
/* NoFormat */
<YYINITIAL> {
("{noformat}")~("{noformat}") {
          try {
            this.appendNoformat(false);
          } finally {
            this.text = null;
          }
}}
/* CollapseExpand */
<YYINITIAL> {
"{cut"[ ]+[^}]+"}"\n?~("{cut}") {
          try {
            int first = this.getText().indexOf('}');
            int last = this.getText().lastIndexOf('{');
            String head = this.getText().substring(5, first);
            String body = CommonWikiUtils.valuableSubstring(this.getText(), first + 1, last);
            if ((body == null || body.length() == 0)) {
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append(head);
              }
            } else {
              if (!(this.QuotingnoJs)) {
                {
                  TBuilderContext builderContext = (TBuilderContext) this.builderContext;
                  LinkUtil.addScriptDependencies(builderContext, ListSequence.fromListAndArray(new ArrayList<String>(), "jetbrains.mps.webr.wiki.processor.scripts.WikiUtil"));
                }
              }
              WikiUtil collapser = new WikiUtil(builderContext);
              collapser.appendCutMarkup(head, body, this, this.QuotingnoJs);
            }
          } finally {
            this.text = null;
          }
}}
/* Html */
<YYINITIAL> {
"{html" ([ ]+ "class" [ ]* "=" [ ]* [a-zA-Z]+)? "}"~"{html}" {
          try {
            int htmlStartPosition = this.getText().indexOf("}") + 1;
            boolean hasClass = htmlStartPosition > this.HtmlTextCallertagLength;
            String className = "";
            if (hasClass) {
              int classStartPosition = this.getText().indexOf("=") + 1;
              className = StringUtils.stripStart(this.getText().substring(classStartPosition, htmlStartPosition - 1), " \n\r\t");
            }
            String str = CommonWikiUtils.valuableSubstring(this.getText(), htmlStartPosition, this.getText().length() - this.HtmlTextCallertagLength);
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(((HtmlProcessorWrapper) ServiceLocator.getBean("htmlProcessorWrapper")).markup(str, this.HtmlTextCallerattributeManufacture, className));
            }
          } finally {
            this.text = null;
          }
}}
/* MDash */
<YYINITIAL> {
[-]{3} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&mdash;");
            }
          } finally {
            this.text = null;
          }
}}
/* NDash */
<YYINITIAL> {
[-]{2} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("&ndash;");
            }
          } finally {
            this.text = null;
          }
}}
/* WikiLink */
<YYINITIAL> {
"[["[^\]]+"]]" {
          try {
            int linkEnd = this.getText().indexOf('|');
            String label;
            String url;
            if (linkEnd >= 0) {
              url = ((WikiLinksManager) ServiceLocator.getBean("wikiLinksManager")).getUrl(this.getText().substring(2, linkEnd).trim());
              if (url != null) {
                label = this.getText().substring(linkEnd + 1, this.getText().length() - 2).trim();
                this.appendLink(url, StringEscapeUtils.escapeHtml(label));
              } else {
                {
                  TBaseBuilderContext builderContext = this.builderContext;
                  builderContext.append(HtmlStringUtil.html(this.getText()));
                }
              }
            } else {
              label = this.getText().substring(2, this.getText().length() - 2);
              url = ((WikiLinksManager) ServiceLocator.getBean("wikiLinksManager")).getUrl(label);
              if (url != null) {
                this.appendLink(url, StringEscapeUtils.escapeHtml(label));
              } else {
                {
                  TBaseBuilderContext builderContext = this.builderContext;
                  builderContext.append(HtmlStringUtil.html(this.getText()));
                }
              }
            }
          } finally {
            this.text = null;
          }
}}
/* CodeSemicolon */
<YYINITIAL> {
"{code:"[^{}|]*("|"[^{}|]*)*~"{code}"([\n]?) {
          try {
            int first = this.getText().indexOf('}');
            int last = this.getText().lastIndexOf('{');
            String code = CommonWikiUtils.valuableSubstring(this.getText(), first + 1, last);
            if ((code != null && code.length() > 0)) {
              code = ((TextColorerProcessorMarkup) TextColorerProcessor.getInstance().createProcessor(code)).setTextColorerProcessor_baseUrl(this.HighlightCallerbaseUrl).processSafe();
              this.HighlightCallercodeSize += code.length();
              String[] result = this.getText().substring(0, first).split("[|}:]");
              HashMap<String, String> parametr = new HashMap<String, String>();
              for (int i = 1; i < result.length; i++) {
                int pos = result[i].indexOf('=');
                if (pos != -1) {
                  parametr.put(result[i].substring(0, pos).trim().toLowerCase(), result[i].substring(pos + 1).trim());
                } else {
                  parametr.put("lang", result[i]);
                }
              }
              this.appendTitle(parametr.get("title"));
              this.appendHighlightPre(parametr.get("lang"), code);
            }
          } finally {
            this.text = null;
          }
}}
/* Code */
<YYINITIAL> {
"{code" ([ ]+ "lang" [ ]* "=" [ ]* [a-zA-Z]+)? "}" ~"{code}"([\n]?) {
          try {
            int first = this.getText().indexOf('}');
            int last = this.getText().lastIndexOf('{');
            String code = CommonWikiUtils.valuableSubstring(this.getText(), first + 1, last);
            if ((code != null && code.length() > 0)) {
              code = ((TextColorerProcessorMarkup) TextColorerProcessor.getInstance().createProcessor(code)).setTextColorerProcessor_baseUrl(this.HighlightCallerbaseUrl).processSafe();
              this.HighlightCallercodeSize += code.length();
              int langNamePos = this.getText().indexOf('=');
              String langName = null;
              if (langNamePos != -1 && first > langNamePos) {
                langName = this.getText().substring(langNamePos + 1, first).trim();
              }
              this.appendHighlightPre(langName, code);
            }
          } finally {
            this.text = null;
          }
}}
/* ThreeBackicksCode */
<YYINITIAL> {
^([`]{3}([`]*)([ ]*)([a-z]*)([ ]*)[\n])~(\n[`]{3}([`]*)([\n]?)) {
          try {
            int first = this.getText().indexOf('\n');
            int last = this.getText().lastIndexOf("\n`");
            String code = CommonWikiUtils.valuableSubstring(this.getText(), first + 1, last);
            if ((code != null && code.length() > 0)) {
              code = ((TextColorerProcessorMarkup) TextColorerProcessor.getInstance().createProcessor(code)).setTextColorerProcessor_baseUrl(this.HighlightCallerbaseUrl).processSafe();
              this.HighlightCallercodeSize += code.length();
              String parameterStr = this.getText().substring(0, first + 1);
              String langName = trim_2r2ryz_a0a3a3a0a0m(parameterStr.substring(parameterStr.lastIndexOf('`') + 1));
              this.appendHighlightPre(langName, code);
            }
          } finally {
            this.text = null;
          }
}}
/* InlineCodeSingleBacktick */
<YYINITIAL> {
("`")~(([^\\`])"`") {
          try {
            this.appendInlineCode(this.yytext(1, 1));
          } finally {
            this.text = null;
          }
}}
/* InlineCodeTwoBackticks */
<YYINITIAL> {
("``")~(([^\\`])"``") {
          try {
            this.appendInlineCode(this.yytext(2, 2));
          } finally {
            this.text = null;
          }
}}
/* Coloring */
<YYINITIAL> {
"{color:"{color}"}"~"{color}" {
          try {
            int beg = this.getText().indexOf('}');
            String textToColor = CommonWikiUtils.valuableSubstring(this.getText(), beg + 1, this.getText().length() - this.TextColorercolorSuffixKeyLength);
            if ((textToColor != null && textToColor.length() > 0)) {
              String color = this.getText().substring(this.TextColorercolorPrefixKeyLength, beg);
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append("<font color=\"");
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append(color);
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append("\">");
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                this.clone(textToColor).processSafe(builderContext);
              }
              {
                TBaseBuilderContext builderContext = this.builderContext;
                builderContext.append("</font>");
              }
            }
          } finally {
            this.text = null;
          }
}}
/* TableFst */
<YYINITIAL> {
^{block} {
          try {
            Table t = new Table(this.getText());
            t.append(this.builderContext, this);
          } finally {
            this.text = null;
          }
}}
/* Exception1 */
<YYINITIAL> {
[\t\n\r]{Space}?{Exc} {
          try {
            int pos = 1;
            {
              TBaseBuilderContext builderContext = this.builderContext;
              if (this.getText().charAt(0) == '\n') {
                builderContext.append(WikiUtil.newLine());
              }
            }
            if (this.getText().charAt(0) != '\n') {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html(this.getText().substring(0, pos)));
            }
            this.appendException(pos);
          } finally {
            this.text = null;
          }
}}
/* Exception2 */
<YYINITIAL> {
^{Space}?{Exc} {
          try {
            this.appendException(0);
          } finally {
            this.text = null;
          }
}}
/* List */
<YYINITIAL> {
^{listSymbol}+ {
          try {
            this.processList(false);
          } finally {
            this.text = null;
          }
}}
/* NewLineCount */
<YYINITIAL> {
({newline})+$ {
          try {
            this.ListsnewLineCount += this.getText().length();
          } finally {
            this.text = null;
          }
}}
/* ListEnd */
<YYINITIAL> {
({newline})+/[^#*-] {
          try {
            this.ListsnewLineCount += this.getText().length();
            if (ListSequence.fromList(this.ListslistPrefix).isNotEmpty()) {
              this.ListsnewLineCount--;
              for (int i = ListSequence.fromList(this.ListslistPrefix).count() - 1; i >= 0; i--) {
                char it = ListSequence.fromList(this.ListslistPrefix).getElement(i);
                {
                  TBaseBuilderContext builderContext = this.builderContext;
                  builderContext.append((it == '#' ?
                    "</li></ol>" :
                    "</li></ul>"
                  ));
                }
              }
              ListSequence.fromList(this.ListslistPrefix).clear();
            }
            this.flushNewLines(false);
          } finally {
            this.text = null;
          }
}}
/* NewLineEofIgnore */
<YYINITIAL> {
{newline}+/. {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getNewline(this.getText().length(), "<br/>"));
            }
            //  just ignore, newlines at the end of input are not appended
          } finally {
            this.text = null;
          }
}}
/* CheckNewLine */
<CHECK_NEW_LINE> {
[^\n]*(\n)? {
          try {
            this.processNewLineChecking(false);
          } finally {
            this.text = null;
          }
}}
/* NewLineEofIgnore */
<YYINITIAL> {
{newline}* {
          try {
            //  just ignore, newlines at the end of input are not appended
          } finally {
            this.text = null;
          }
}}
/* LabeledHttpLink */
<YYINITIAL> {
"["{schemas}"://"{allowedUrlSymbol}+(" "[^\n\[\]]+)?"]" {
          try {
            this.appendLabeledLink();
          } finally {
            this.text = null;
          }
}}
/* ConfluenceStyledLink */
<YYINITIAL> {
"["[^\n\]]+"|"{schemas}"://"({allowedUrlSymbol}|[ ])+"]" {
          try {
            this.appendConfluenceStyledLink();
          } finally {
            this.text = null;
          }
}}
/* SchemaLink */
<YYINITIAL> {
{schemas}"://"({allowedUrlSymbolWOB}|"("{allowedUrlSymbolWOB}*")")+ {
          try {
            this.appendHttpLink(this.getText());
          } finally {
            this.text = null;
          }
}}
/* SchemaLinkInBraces */
<YYINITIAL> {
"("{schemas}"://"{allowedUrlSymbolWOB}+")" {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("(");
            }
            this.appendHttpLink(StringUtils.substring(this.getText(), 1, this.getText().length() - 1));
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(")");
            }
          } finally {
            this.text = null;
          }
}}
/* LinkToWithTagBrackets */
<YYINITIAL> {
"<"{schemas}"://"({allowedUrlSymbolWOB}+)">" {
          try {
            this.appendHttpLink(this.yytext(1, 1));
          } finally {
            this.text = null;
          }
}}
/* Email */
<YYINITIAL> {
"<"{email}">" {
          try {
            this.appendMailToLinkTag(this.yytext(1, 1));
          } finally {
            this.text = null;
          }
}}
/* EmailImportFromHtml */
<YYINITIAL> {
"&lt;"{email}"&gt;" {
          try {
            this.appendMailToLinkTag(this.yytext(4, 4));
          } finally {
            this.text = null;
          }
}}
/* H4 */
<YYINITIAL> {
^"===="~"===="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<h4>");
          this.clone(this.yytext(4, 5)).process(builderContext);
          builderContext.append("</h4>");
}}
/* H3 */
<YYINITIAL> {
^"==="~"==="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<h3>");
          this.clone(this.yytext(3, 4)).process(builderContext);
          builderContext.append("</h3>");
}}
/* H2 */
<YYINITIAL> {
^"=="~"=="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<h2>");
          this.clone(this.yytext(2, 3)).process(builderContext);
          builderContext.append("</h2>");
}}
/* H1 */
<YYINITIAL> {
^"="~"="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<h1>");
          this.clone(this.yytext(1, 2)).process(builderContext);
          builderContext.append("</h1>");
}}
/* BoldItalic */
<YYINITIAL> {
"'''''"~"'''''" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<strong><em>");
          this.clone(this.yytext(5, 5)).process(builderContext);
          builderContext.append("</em></strong>");
}}
/* Bold */
<YYINITIAL> {
"'''"~"'''" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<strong>");
          this.clone(this.yytext(3, 3)).process(builderContext);
          builderContext.append("</strong>");
}}
/* Italic */
<YYINITIAL> {
"''"~"''" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<em>");
          this.clone(this.yytext(2, 2)).process(builderContext);
          builderContext.append("</em>");
}}
/* Strikethrough */
<YYINITIAL> {
--[^ \t\n\r-]-- {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("<del>");
            }
            String out = "" + this.getText().charAt(2);
            {
              TBaseBuilderContext builderContext = this.builderContext;
              this.clone(BaseHtmlStringUtil.html(out)).processSafe(builderContext);
            }
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("</del>");
            }
          } finally {
            this.text = null;
          }
}}
/* Strikethrough */
<YYINITIAL> {
--[^ \t\n\r-]([^\n\r-]|([-][^-]))*[-]?[^ \t\n\r-]-- {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("<del>");
            }
            {
              TBaseBuilderContext builderContext = this.builderContext;
              this.clone(this.yytext(2, 2)).processSafe(builderContext);
            }
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("</del>");
            }
          } finally {
            this.text = null;
          }
}}
/* Line */
<YYINITIAL> {
("-"){5}("-")*(" "*[\r\n])? {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("<hr/>");
            }
          } finally {
            this.text = null;
          }
}}
/* TitledText */
<YYINITIAL> {
\~\~~\|~(\~\~) {
          try {
            this.appendTitledText();
          } finally {
            this.text = null;
          }
}}
/* Underlined */
<YYINITIAL> {
{baseUnderlineRegexp}({nonWordSymbol}|{baseUnderlineRegexp}) {
          try {
            this.removeFramingMarkup("+", "u", true);
          } finally {
            this.text = null;
          }
}}
/* Underlined */
<YYINITIAL> {
^\+([^ \t\n\r\+]([ ]|\\\+)*)*(([^ \t\n\r\+\\]|\\\+)\+)({nonWordSymbol}|{baseUnderlineRegexp}) {
          try {
            this.removeFramingMarkup("+", "u", true);
          } finally {
            this.text = null;
          }
}}
/* BoldAsterisk */
<YYINITIAL> {
{baseAsteriskRegexp}({nonWordSymbol}|{baseAsteriskRegexp}) {
          try {
            this.removeFramingMarkup("*", "strong", true);
          } finally {
            this.text = null;
          }
}}
/* BoldAsterisk */
<YYINITIAL> {
^\*([^ \t\n\r\*]([ ]|\\\*)*)*(([^ \t\n\r\*\\]|\\\*)\*)({nonWordSymbol}|{baseAsteriskRegexp}) {
          try {
            this.removeFramingMarkup("*", "strong", true);
          } finally {
            this.text = null;
          }
}}
/* EscapeSymbol */
<YYINITIAL> {
"\\"[+*_\-`{}\[\]\(\)#\.\!] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.yytext(1, 0));
            }
          } finally {
            this.text = null;
          }
}}
/* SkipedCharacters */
<YYINITIAL> {
[\u0000-\u0008\u000B-\u000C\u000E-\u001F] {
          try {
          } finally {
            this.text = null;
          }
}}
/* empty */
<YYINITIAL> {
\r {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("");
}}
/* tab */
<YYINITIAL> {
\t {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<span class=\"wiki tab\">&nbsp;&nbsp;&nbsp;&nbsp;</span>");
}}
/* Amp */
<YYINITIAL> {
"&" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&amp;");
}}
/* Lt */
<YYINITIAL> {
"<" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&lt;");
}}
/* Gt */
<YYINITIAL> {
">" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&gt;");
}}
/* DoubleQuote */
<YYINITIAL> {
\" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&quot;");
}}
/* SingleQuote */
<YYINITIAL> {
\' {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&#39;");
}}
/* breakline */
<YYINITIAL> {
\n {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<br/>");
}}
/* Issue */
<YYINITIAL, HTML> {
{issue} {
          try {
            this.transformIssue();
          } finally {
            this.text = null;
          }
}}
/* Issue */
<YYINITIAL, HTML> {
{issue}/([\.]?[:jletterdigit:]) {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html(this.getText()));
            }
          } finally {
            this.text = null;
          }
}}
/* issueAttachment */
<YYINITIAL> {
{attachment} {
          try {
            if (this.IssueLinkuseGlobalLinks) {
              try {
                BuilderThreadContext.initNonLocalBuilderThreadContext();
                this.appendAttachment(false);
              } finally {
                BuilderThreadContext.close();
              }
            } else {
              this.appendAttachment(false);
            }
          } finally {
            this.text = null;
          }
}}
/* Image */
<YYINITIAL> {
{image} {
          try {
            if (this.IssueLinkuseGlobalLinks) {
              try {
                BuilderThreadContext.initNonLocalBuilderThreadContext();
                this.appendImage(false);
              } finally {
                BuilderThreadContext.close();
              }
            } else {
              this.appendImage(false);
            }
          } finally {
            this.text = null;
          }
}}
/* Username */
<YYINITIAL, HTML> {
{username} {
          try {
            this.appendUsername();
          } finally {
            this.text = null;
          }
}}
/* UsernameCanNotBeInTheMiddle */
<YYINITIAL, HTML> {
[:jletterdigit:][@] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* CommitHash0 */
<YYINITIAL, HTML> {
{separator}{hash} {
          try {
            this.addVcsLink(true);
          } finally {
            this.text = null;
          }
}}
/* CommitHash1 */
<YYINITIAL, HTML> {
^{hash} {
          try {
            this.addVcsLink(false);
          } finally {
            this.text = null;
          }
}}
/* Query */
<YYINITIAL, HTML> {
"[query:"~"]" {
          try {
            if (this.QueryLinkuseGlobalLinks) {
              try {
                BuilderThreadContext.initNonLocalBuilderThreadContext();
                this.appendQuery(false);
              } finally {
                BuilderThreadContext.close();
              }
            } else {
              this.appendQuery(false);
            }
          } finally {
            this.text = null;
          }
}}
/* LongString */
<YYINITIAL, HTML> {
{base64Symbol}{666}{base64Symbol}* {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html(this.getText()));
            }
          } finally {
            this.text = null;
          }
}}
/* Finish */
<YYINITIAL, CHECK_NEW_LINE, HTML, HTML, HTML> {
. {
          this.builderContext.append(BaseProcessor.characterToStringSafe(this.yycharat(0)));
}}
