package jetbrains.charisma.wiki;

/*Generated by MPS */

import jetbrains.mps.webr.wiki.processor.runtime.BaseProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import java.util.List;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import java.util.ArrayList;
import jetbrains.mps.webr.wiki.processor.runtime.IWikiProcessor;
import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import webr.framework.function.HtmlStringUtil;
import jetbrains.mps.webr.runtime.builderContext.BuilderThreadContext;
import jetbrains.mps.webr.wiki.processor.runtime.LinkAppender;
import jetbrains.mps.gtext.runtime.BaseHtmlStringUtil;
import java.io.IOException;
import java.io.Reader;
import jetbrains.mps.webr.wiki.processor.runtime.TrailingCharStringReader;

%%

%class IssueLinkProcessorRemoveMarkup
%extends BaseProcessor

%public 
%buffer 128
%final
%unicode

%{

  private Log log = LogFactory.getLog(IssueLinkProcessorRemoveMarkup.class);
  private boolean IssueLinkuseGlobalLinks;
  private WikiIssueAdapter IssueLinkissue;
  private boolean IssueLinkfromWorkflow = false;
  private List<WikiUserAdapter> IssueLinkmentionedUsers = ListSequence.fromList(new ArrayList<WikiUserAdapter>());
  private List<WikiIssueAdapter> IssueLinkmentionedIssues = ListSequence.fromList(new ArrayList<WikiIssueAdapter>());
  private String IssueLinklogoUrl;
  private WikiAppContextProvider IssueLinkappContextProvider;
  private int TextColorercolorSuffixKeyLength = "{color}".length();
  private int TextColorercolorPrefixKeyLength = "{color:".length();
  private boolean liveModePreview = false;

  public IWikiProcessor clone(String input) {
    IssueLinkProcessorRemoveMarkup cloned = create(input);
    cloned.IssueLinkuseGlobalLinks = this.IssueLinkuseGlobalLinks;
    cloned.IssueLinkissue = this.IssueLinkissue;
    cloned.IssueLinkfromWorkflow = this.IssueLinkfromWorkflow;
    cloned.IssueLinkmentionedUsers = this.IssueLinkmentionedUsers;
    cloned.IssueLinkmentionedIssues = this.IssueLinkmentionedIssues;
    cloned.IssueLinklogoUrl = this.IssueLinklogoUrl;
    cloned.IssueLinkappContextProvider = this.IssueLinkappContextProvider;
    return cloned;
  }

  protected boolean readerNotExists() {
    return this.zzReader == null;
  }

  private String yytext(int prefixLength, int suffixLength) {
    //  zzBuffer, zzStartRead and zzMarkedPos are generated by jFlex, we don't declare them
    return new String(this.zzBuffer, this.zzStartRead + prefixLength, this.zzMarkedPos - this.zzStartRead - suffixLength - prefixLength);
  }

  public IssueLinkProcessorRemoveMarkup setIssueLinkuseGlobalLinks(boolean value) {
    this.IssueLinkuseGlobalLinks = value;
    return this;
  }

  public IssueLinkProcessorRemoveMarkup setIssueLinkissue(WikiIssueAdapter value) {
    this.IssueLinkissue = value;
    return this;
  }

  public IssueLinkProcessorRemoveMarkup setIssueLinkfromWorkflow(boolean value) {
    this.IssueLinkfromWorkflow = value;
    return this;
  }

  public IssueLinkProcessorRemoveMarkup setIssueLinkmentionedUsers(List<WikiUserAdapter> value) {
    this.IssueLinkmentionedUsers = value;
    return this;
  }

  public IssueLinkProcessorRemoveMarkup setIssueLinkmentionedIssues(List<WikiIssueAdapter> value) {
    this.IssueLinkmentionedIssues = value;
    return this;
  }

  public IssueLinkProcessorRemoveMarkup setIssueLinklogoUrl(String value) {
    this.IssueLinklogoUrl = value;
    return this;
  }

  public IssueLinkProcessorRemoveMarkup setIssueLinkappContextProvider(WikiAppContextProvider value) {
    this.IssueLinkappContextProvider = value;
    return this;
  }

  public IssueLinkProcessorRemoveMarkup setLivePreviewMode(boolean value) {
    return this;
  }

  public void transformIssue() {
    WikiIssueAdapter i = this.IssueLinkappContextProvider.getIssueById(this.getText());
    if (i == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(HtmlStringUtil.html(this.getText()));
      }
    } else {
      if (this.IssueLinkuseGlobalLinks) {
        try {
          BuilderThreadContext.initNonLocalBuilderThreadContext();
          this.appendIssueLink(i, this.getText());
        } finally {
          BuilderThreadContext.close();
        }
      } else {
        this.appendIssueLink(i, this.getText());
      }
    }
  }

  public void appendIssueLink(WikiIssueAdapter i, String mentionedId) {
    LinkAppender.appendHrefForMobile(this.builderContext, false);
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(i.getUrl(this.IssueLinkuseGlobalLinks) + "\"");
    }
    if (i.isResolved()) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(" class=\"issue-resolved\"");
      }
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" target=\"_self\"");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" data-issue-id=\"" + i.getId() + "\"");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append(" title=\"" + BaseHtmlStringUtil.html(i.getSummary()) + "\">" + mentionedId + "</a>");
    }
    ListSequence.fromList(this.IssueLinkmentionedIssues).addElement(i);
  }

  public void appendImage(boolean noMarkup) throws IOException {
    if (noMarkup) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("!");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(this.yytext(1, 1)).processSafe(builderContext);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("!");
      }
    } else {
      String[] result = this.yytext(1, 1).split("[|]");
      String name = null;
      int last = -1;
      if (result.length > 0) {
        last = result.length - 1;
        name = result[last];
      }

      if (this.IssueLinkissue == null && this.getText().equals("!".concat(this.IssueLinklogoUrl.substring(this.IssueLinklogoUrl.lastIndexOf('/') + 1)).concat("!"))) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<div class=\"wiki picture\"><img src=\"");
          builderContext.append(this.IssueLinklogoUrl);
          builderContext.append("\"/></div>");
        }
        return;
      }

      WikiAttachmentAdapter attach = this.IssueLinkappContextProvider.getAttachmentByName(this.IssueLinkissue, name);

      if (attach == null) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("!");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          this.clone(this.yytext(1, 1)).processSafe(builderContext);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("!");
        }
      } else {
        String alt = null;
        String position = null;
        for (int i = 0; i < last; i++) {
          String value = result[i].trim();
          if (IssueLinkConst.POS.contains(value)) {
            position = value;
          } else {
            alt = value;
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<div class=\"wiki picture\"");
        }
        if (position != null) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(" style=\"");
          }
          if (position.equals(IssueLinkConst.INLINE)) {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("display:inline;");
            }
          } else {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html("align:"));
              builderContext.append(HtmlStringUtil.html(position));
              builderContext.append(HtmlStringUtil.html(";"));
            }
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("\"");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("><img src=\"");
          builderContext.append(attach.getUrl(this.IssueLinkfromWorkflow));
          builderContext.append("\"");
        }
        if (alt != null) {
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(" alt=\"");
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append(HtmlStringUtil.html(alt));
          }
          {
            TBaseBuilderContext builderContext = this.builderContext;
            builderContext.append("\"");
          }
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("/></div>");
        }
      }
    }
  }

  private void fixForRTL(String str) {
    if (!(this.IssueLinkappContextProvider.isRtlEnabled())) {
      return;
    }

    boolean flag = false;
    for (int i = 0; i < str.length(); ++i) {
      if (str.charAt(i) > '\u05BE') {
        flag = true;
      }
    }

    if (!(flag)) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("&lrm;");
      }
    }
  }

  private void appendUsername() {
    WikiUserAdapter user = this.IssueLinkappContextProvider.getUserByLogin(StringUtils.substring(this.getText(), 1));

    int pushBackCount;
    if (user != null) {
      if (user.isAccessible()) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<a href=\"");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(user.getProfileUrl(this.IssueLinkfromWorkflow));
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\" title=\"");
          builderContext.append(user.getLogin());
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\" data-user-id=\"");
          builderContext.append(user.getId());
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\">");
        }
        String displayedText = BaseHtmlStringUtil.html(user.getFullName());
        this.fixForRTL(displayedText);
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(displayedText);
          builderContext.append("</a>");
        }
      } else {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<b ");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("data-user-id=\"");
          builderContext.append(user.getId());
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\">");
        }
        String displayedText = BaseHtmlStringUtil.html(user.getFullName());
        this.fixForRTL(displayedText);
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(displayedText);
          builderContext.append("</b>");
        }
      }
      pushBackCount = (this.getText().length() - 1 - user.getLogin().length());
      ListSequence.fromList(this.IssueLinkmentionedUsers).addElement(user);
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(Character.toString(this.getText().charAt(0)));
      }
      pushBackCount = this.getText().length() - 1;
    }
    if (pushBackCount > 0) {
      this.yypushback(pushBackCount);
    }
  }

  public void appendAttachment(boolean removeMarkup) {
    String name = StringUtils.substring(this.getText(), 6, this.getText().length() - 1);
    WikiAttachmentAdapter attach = this.IssueLinkappContextProvider.getAttachmentByName(this.IssueLinkissue, name);
    if (attach != null) {
      if (removeMarkup) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(name));
        }
      } else {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<a href=\"");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(attach.getUrl(this.IssueLinkfromWorkflow));
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\">");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(name));
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("</a>");
        }
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(this.getText());
      }
    }
  }

  private void addVcsLink(boolean skip) {
    String t;
    if (skip) {
      t = this.getText().substring(1);
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(BaseHtmlStringUtil.html(Character.toString(this.getText().charAt(0))));
      }
    } else {
      t = this.getText();
    }
    String link = this.IssueLinkappContextProvider.getVcsLink(this.IssueLinkissue, t);
    if (link == null) {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(t);
      }
    } else {
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("<a href=\"");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(link);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("\">");
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append(t);
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        builderContext.append("</a>");
      }

    }
  }

  public final void appendBlank(char a) {
    switch (a) {
      case '\n':
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<br/>");
        }
        break;
      case '\t':
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\t");
        }
        break;
      case ' ':
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(" ");
        }
        break;
      default:
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("" + a);
        }
    }
  }

  public final void appendBlank(String s) {
    for (int i = 0; i < s.length(); i++) {
      this.appendBlank(s.charAt(i));
    }
  }

  public void appendTitledText() {
    int contentEnds = this.getText().lastIndexOf('|');
    String title = StringUtils.substring(this.getText(), contentEnds + 1, this.getText().length() - 2).trim();
    String content = StringUtils.substring(this.getText(), 2, contentEnds);
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("<span title=\"");
      builderContext.append(title.trim());
      builderContext.append("\">");
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      this.clone(content).processSafe(builderContext);
    }
    {
      TBaseBuilderContext builderContext = this.builderContext;
      builderContext.append("</span>");
    }
  }

  public void removeFramingMarkup(String symbol, String tag, boolean addHtml) {
    int indexOfSymbol = this.getText().indexOf(symbol);
    int indexOfLastSymbol = this.getText().lastIndexOf(symbol);
    this.appendBlank(StringUtils.substring(this.getText(), 0, indexOfSymbol));
    int delemiterIdx = indexOfSymbol + 1;
    String[] strings = StringUtils.substring(this.getText(), indexOfSymbol + 1, indexOfLastSymbol).split('\\' + symbol + "[ \t\r\n]" + '\\' + symbol);
    for (String str : strings) {
      if (addHtml) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(tag);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(">");
        }
      }
      {
        TBaseBuilderContext builderContext = this.builderContext;
        this.clone(str).processSafe(builderContext);
      }
      if (addHtml) {
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("</");
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(tag);
        }
        {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(">");
        }
      }
      delemiterIdx += str.length() + symbol.length();
      if (str != strings[strings.length - 1]) {
        this.appendBlank(this.getText().charAt(delemiterIdx));
        delemiterIdx += symbol.length() + 1;
      }
    }
    this.appendBlank((this.getText().charAt(this.getText().length() - 1) == '\r' ?
      StringUtils.substring(this.getText(), indexOfLastSymbol + 1, this.getText().length() - 2) :
      StringUtils.substring(this.getText(), indexOfLastSymbol + 1)
    ));
  }


  public static IssueLinkProcessorRemoveMarkup create(String s) {
    if (s == null) {
      Reader reader = null;
      return new IssueLinkProcessorRemoveMarkup(reader);
    } else {
      return new IssueLinkProcessorRemoveMarkup(new TrailingCharStringReader(s, '\n'));
    }
  }
%}

%type Void

separator = [ \t\,\;\.\:\"()\?#\^]
ussueStart = [#\^]
issue = [a-zA-Z0-9_]+ \- [0-9]+
hash = [a-fA-F0-9]{40}
space = [ \n\t]
attachment = "[file:"[^\]]+"]"
image = "!"[^!\n]+"!"
username = [@]([:jletterdigit:]|[\+\.\|\-\=\@]){1,32}
color = ([a-zA-Z]+)|("#"[0-9a-fA-F]{6})
nonEmptyWord = [^ \t\n\r-]
baseUnderlineRegexp = [ \t\n\r]\+([^ \t\n\r\+]([ ]|\\\+)*)*(([^ \t\n\r\+\\]|\\\+)\+)
baseAsteriskRegexp = [ \t\n\r]\*([^ \t\n\r\*]([ ]|\\\*)*)*(([^ \t\n\r\*\\]|\\\*)\*)
nonWordSymbol = [ \r\n\t\/\[\]\(\)\`\"-_.!\*$&+/:;=?@#%{}|\^~`',]

%state HTML

%%

/* Issue */
<YYINITIAL, HTML> {
{issue} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* Issue */
<YYINITIAL, HTML> {
{issue}/([\.]?[:jletterdigit:]) {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* issueAttachment */
<YYINITIAL> {
{attachment} {
          try {
            this.appendAttachment(true);
          } finally {
            this.text = null;
          }
}}
/* Image */
<YYINITIAL> {
{image} {
          try {
            this.appendImage(true);
          } finally {
            this.text = null;
          }
}}
/* Username */
<YYINITIAL, HTML> {
{username} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* UsernameCanNotBeInTheMiddle */
<YYINITIAL, HTML> {
[:jletterdigit:][@] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* CommitHash0 */
<YYINITIAL, HTML> {
{separator}{hash} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* CommitHash1 */
<YYINITIAL, HTML> {
^{hash} {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.getText());
            }
          } finally {
            this.text = null;
          }
}}
/* SkipedCharacters */
<YYINITIAL> {
[\u0000-\u0008\u000B-\u000C\u000E-\u001F] {
          try {
          } finally {
            this.text = null;
          }
}}
/* empty */
<YYINITIAL> {
\r {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\r");
}}
/* tab */
<YYINITIAL> {
\t {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\t");
}}
/* Amp */
<YYINITIAL> {
"&" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("&");
}}
/* Lt */
<YYINITIAL> {
"<" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("<");
}}
/* Gt */
<YYINITIAL> {
">" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(">");
}}
/* DoubleQuote */
<YYINITIAL> {
\" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\"");
}}
/* SingleQuote */
<YYINITIAL> {
\' {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\'");
}}
/* breakline */
<YYINITIAL> {
\n {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append("\n");
}}
/* Coloring */
<YYINITIAL> {
"{color:"{color}"}"~"{color}" {
          try {
            int beg = this.getText().indexOf('}');
            {
              TBaseBuilderContext builderContext = this.builderContext;
              this.clone(this.yytext(beg + 1, this.TextColorercolorSuffixKeyLength)).processSafe(builderContext);
            }
          } finally {
            this.text = null;
          }
}}
/* H4 */
<YYINITIAL> {
^"===="~"===="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(4, 5)));
          this.builderContext.append(" ");
}}
/* H3 */
<YYINITIAL> {
^"==="~"==="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(3, 4)));
          this.builderContext.append(" ");
}}
/* H2 */
<YYINITIAL> {
^"=="~"=="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(2, 3)));
          this.builderContext.append(" ");
}}
/* H1 */
<YYINITIAL> {
^"="~"="[\r\n] {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(1, 2)));
          this.builderContext.append(" ");
}}
/* BoldItalic */
<YYINITIAL> {
"'''''"~"'''''" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(5, 5)));
}}
/* Bold */
<YYINITIAL> {
"'''"~"'''" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(3, 3)));
}}
/* Italic */
<YYINITIAL> {
"''"~"''" {
          TBaseBuilderContext builderContext = this.builderContext;
          builderContext.append(HtmlStringUtil.html(this.yytext(2, 2)));
}}
/* Strikethrough */
<YYINITIAL> {
--[^ \t\n\r-]-- {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append("" + this.getText().charAt(2));
            }
          } finally {
            this.text = null;
          }
}}
/* Strikethrough */
<YYINITIAL> {
--[^ \t\n\r-]([^\n\r-]|([-][^-]))*[-]?[^ \t\n\r-]-- {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              this.clone(this.yytext(2, 2)).processSafe(builderContext);
            }
          } finally {
            this.text = null;
          }
}}
/* Line */
<YYINITIAL> {
("-"){5}("-")*(" "*[\r\n])? {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(HtmlStringUtil.html(this.getText()));
            }
          } finally {
            this.text = null;
          }
}}
/* TitledText */
<YYINITIAL> {
\~\~~\|~(\~\~) {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              this.clone(StringUtils.substring(this.getText(), 2, this.getText().lastIndexOf("|"))).processSafe(builderContext);
            }
          } finally {
            this.text = null;
          }
}}
/* Underlined */
<YYINITIAL> {
{baseUnderlineRegexp}({nonWordSymbol}|{baseUnderlineRegexp}) {
          try {
            this.removeFramingMarkup("+", "u", false);
          } finally {
            this.text = null;
          }
}}
/* Underlined */
<YYINITIAL> {
^\+([^ \t\n\r\+]([ ]|\\\+)*)*(([^ \t\n\r\+\\]|\\\+)\+)({nonWordSymbol}|{baseUnderlineRegexp}) {
          try {
            this.removeFramingMarkup("+", "u", false);
          } finally {
            this.text = null;
          }
}}
/* BoldAsterisk */
<YYINITIAL> {
{baseAsteriskRegexp}({nonWordSymbol}|{baseAsteriskRegexp}) {
          try {
            this.removeFramingMarkup("*", "strong", false);
          } finally {
            this.text = null;
          }
}}
/* BoldAsterisk */
<YYINITIAL> {
^\*([^ \t\n\r\*]([ ]|\\\*)*)*(([^ \t\n\r\*\\]|\\\*)\*)({nonWordSymbol}|{baseAsteriskRegexp}) {
          try {
            this.removeFramingMarkup("*", "strong", false);
          } finally {
            this.text = null;
          }
}}
/* EscapeSymbol */
<YYINITIAL> {
"\\"[+*_\-`{}\[\]\(\)#\.\!] {
          try {
            {
              TBaseBuilderContext builderContext = this.builderContext;
              builderContext.append(this.yytext(1, 0));
            }
          } finally {
            this.text = null;
          }
}}
/* Finish */
<YYINITIAL, HTML> {
. {
          this.builderContext.append(BaseProcessor.characterToStringSafe(this.yycharat(0)));
}}
