/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.api;

import eu.medsea.mimeutil.MimeUtil;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.util.DeferredIO;
import jetbrains.exodus.util.IOUtil;
import jetbrains.mps.internationalization.runtime.Localization;
import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.webr.runtime.templateComponent.LocalizedLogicException;
import jetbrains.youtrack.article.persistent.ArticleExtKt;
import jetbrains.youtrack.article.persistent.XdArticleAttachment;
import jetbrains.youtrack.config.BeansKt;
import jetbrains.youtrack.core.annotations.ApiDoc;
import jetbrains.youtrack.core.annotations.ApiDocReturns;
import jetbrains.youtrack.core.annotations.ApiJsAcceptsJson;
import jetbrains.youtrack.core.annotations.ApiJsDocIgnore;
import jetbrains.youtrack.core.annotations.ApiMethod;
import jetbrains.youtrack.core.annotations.ApiMpsIgnore;
import jetbrains.youtrack.core.annotations.ApiScope;
import jetbrains.youtrack.core.annotations.ApiSince;
import jetbrains.youtrack.core.persistent.XdProjectDocument;
import jetbrains.youtrack.core.persistent.article.XdArticle;
import jetbrains.youtrack.core.persistent.article.XdBaseArticle;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.persistent.XdAttachment;
import jetbrains.youtrack.persistent.XdBaseAttachment;
import jetbrains.youtrack.persistent.XdIssueAttachment;
import jetbrains.youtrack.persistent.attachment.IssueAttachementServiceKt;
import jetbrains.youtrack.workflow.api.IssueAttachmentsWorkflowApiExtensionKt;
import jetbrains.youtrack.workflow.api.log;
import jetbrains.youtrack.workflow.sandbox.InputStreamWrapper;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000N\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a.\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n\u001a8\u0010\u0006\u001a\u00020\r*\u00020\u000e2\b\b\u0001\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\nH\u0007\u001a8\u0010\u0006\u001a\u00020\u000f*\u00020\u00102\b\b\u0001\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\t\u001a\u00020\n2\n\b\u0001\u0010\u000b\u001a\u0004\u0018\u00010\n2\n\b\u0001\u0010\f\u001a\u0004\u0018\u00010\nH\u0007\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u000fH\u0007\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\u0003*\u00020\u000fH\u0007\u001a>\u0010\u0014\u001a\u00020\u0012*\u00020\u00152\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u0017H\u0002\u001a\u0016\u0010\u0018\u001a\u00020\u0012*\u00020\u000f2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0007\u00a8\u0006\u0019"}, d2={"writeContentToFile", "", "content", "Ljava/io/InputStream;", "file", "Ljava/io/File;", "addAttachment", "Ljetbrains/youtrack/persistent/XdBaseAttachment;", "Ljetbrains/youtrack/core/persistent/XdProjectDocument;", "name", "", "charset", "mimeType", "Ljetbrains/youtrack/article/persistent/XdArticleAttachment;", "Ljetbrains/youtrack/core/persistent/article/XdArticle;", "Ljetbrains/youtrack/persistent/XdIssueAttachment;", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "delete", "", "getContent", "init", "Ljetbrains/youtrack/persistent/XdAttachment;", "addToContainer", "Lkotlin/Function0;", "setContent", "youtrack-workflow"})
public final class IssueAttachmentsWorkflowApiExtensionKt {
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiSince(value="2018.1.40030")
    @ApiMpsIgnore
    @ApiDoc(value="Permanently deletes the attachment.")
    public static final void delete(@NotNull XdIssueAttachment $this$delete) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)$this$delete, (String)"$this$delete");
            XdIssue xdIssue = $this$delete.getIssue();
            if (xdIssue == null) break block0;
            IssueAttachementServiceKt.removeAttachment((XdIssue)xdIssue, (XdIssueAttachment)$this$delete);
        }
    }

    @NotNull
    public static final XdBaseAttachment addAttachment(@NotNull XdProjectDocument $this$addAttachment, @NotNull InputStream content, @NotNull String name2, @Nullable String charset, @Nullable String mimeType) {
        XdBaseAttachment xdBaseAttachment;
        Intrinsics.checkParameterIsNotNull((Object)$this$addAttachment, (String)"$this$addAttachment");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        XdProjectDocument xdProjectDocument = $this$addAttachment;
        if (xdProjectDocument instanceof XdIssue) {
            xdBaseAttachment = (XdBaseAttachment)IssueAttachmentsWorkflowApiExtensionKt.addAttachment((XdIssue)$this$addAttachment, content, name2, charset, mimeType);
        } else if (xdProjectDocument instanceof XdArticle) {
            xdBaseAttachment = (XdBaseAttachment)IssueAttachmentsWorkflowApiExtensionKt.addAttachment((XdArticle)$this$addAttachment, content, name2, charset, mimeType);
        } else {
            throw (Throwable)new IllegalArgumentException("Unknown descendant of XdProjectDocument: " + $this$addAttachment.getClass().getName());
        }
        return xdBaseAttachment;
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiJsAcceptsJson
    @ApiMpsIgnore
    @ApiSince(value="2019.2.53994")
    @ApiDoc(value="Attaches a file to the issue.\nMakes `issue.attachments.isChanged` return `true` for the current transaction.")
    @ApiDocReturns(value="The attachment that is added to the issue.")
    @NotNull
    public static final XdIssueAttachment addAttachment(@NotNull XdIssue $this$addAttachment, @ApiDoc(value="The content of the file in binary form.") @NotNull InputStream content, @ApiDoc(value="The name of the file.") @NotNull String name2, @ApiDoc(value="The charset of the file. Only applicable to text files.") @Nullable String charset, @ApiDoc(value="The MIME type of the file.") @Nullable String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$addAttachment, (String)"$this$addAttachment");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        XdIssueAttachment xdIssueAttachment = XdIssueAttachment.Companion.new$default((XdIssueAttachment.Companion)XdIssueAttachment.Companion, null, null, (int)2, null);
        boolean bl = false;
        boolean bl2 = false;
        XdIssueAttachment it = xdIssueAttachment;
        boolean bl3 = false;
        IssueAttachmentsWorkflowApiExtensionKt.init((XdAttachment)it, content, name2, charset, mimeType, (Function0<Unit>)((Function0)new Function0<Unit>(it, $this$addAttachment, content, name2, charset, mimeType){
            final /* synthetic */ XdIssueAttachment $it;
            final /* synthetic */ XdIssue $this_addAttachment$inlined;
            final /* synthetic */ InputStream $content$inlined;
            final /* synthetic */ String $name$inlined;
            final /* synthetic */ String $charset$inlined;
            final /* synthetic */ String $mimeType$inlined;
            {
                this.$it = xdIssueAttachment;
                this.$this_addAttachment$inlined = xdIssue;
                this.$content$inlined = inputStream;
                this.$name$inlined = string;
                this.$charset$inlined = string2;
                this.$mimeType$inlined = string3;
                super(0);
            }

            public final void invoke() {
                IssueAttachementServiceKt.addAttachment((XdIssue)this.$this_addAttachment$inlined, (XdIssueAttachment)this.$it);
            }
        }));
        return xdIssueAttachment;
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiJsAcceptsJson
    @ApiMpsIgnore
    @ApiJsDocIgnore
    @ApiSince(value="2020.2")
    @ApiDoc(value="Attaches a file to the article.\nMakes `article.attachments.isChanged` return `true` for the current transaction.")
    @ApiDocReturns(value="The attachment that is added to the article.")
    @NotNull
    public static final XdArticleAttachment addAttachment(@NotNull XdArticle $this$addAttachment, @ApiDoc(value="The content of the file in binary form.") @NotNull InputStream content, @ApiDoc(value="The name of the file.") @NotNull String name2, @ApiDoc(value="The charset of the file. Only applicable to text files.") @Nullable String charset, @ApiDoc(value="The MIME type of the file.") @Nullable String mimeType) {
        Intrinsics.checkParameterIsNotNull((Object)$this$addAttachment, (String)"$this$addAttachment");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        XdArticleAttachment xdArticleAttachment = XdArticleAttachment.Companion.new$default((XdArticleAttachment.Companion)XdArticleAttachment.Companion, null, null, (int)2, null);
        boolean bl = false;
        boolean bl2 = false;
        XdArticleAttachment it = xdArticleAttachment;
        boolean bl3 = false;
        IssueAttachmentsWorkflowApiExtensionKt.init((XdAttachment)it, content, name2, charset, mimeType, (Function0<Unit>)((Function0)new Function0<Unit>(it, $this$addAttachment, content, name2, charset, mimeType){
            final /* synthetic */ XdArticleAttachment $it;
            final /* synthetic */ XdArticle $this_addAttachment$inlined;
            final /* synthetic */ InputStream $content$inlined;
            final /* synthetic */ String $name$inlined;
            final /* synthetic */ String $charset$inlined;
            final /* synthetic */ String $mimeType$inlined;
            {
                this.$it = xdArticleAttachment;
                this.$this_addAttachment$inlined = xdArticle;
                this.$content$inlined = inputStream;
                this.$name$inlined = string;
                this.$charset$inlined = string2;
                this.$mimeType$inlined = string3;
                super(0);
            }

            public final void invoke() {
                ArticleExtKt.getAttachments((XdBaseArticle)((XdBaseArticle)this.$this_addAttachment$inlined)).add((XdEntity)this.$it);
                this.$it.setArticle((XdBaseArticle)this.$this_addAttachment$inlined);
            }
        }));
        return xdArticleAttachment;
    }

    private static final void init(@NotNull XdAttachment $this$init, InputStream content, String name2, String charset, String mimeType, Function0<Unit> addToContainer) {
        XdAttachment xdAttachment = $this$init;
        if (xdAttachment == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlinx.dnq.XdEntity");
        }
        XdEntity cfr_ignored_0 = (XdEntity)xdAttachment;
        $this$init.setFileName(name2);
        $this$init.setCharset(charset);
        String string = mimeType;
        if (string == null) {
            string = MimeUtil.getMostSpecificMimeType((Collection)MimeUtil.getMimeTypes((String)name2)).toString();
        }
        $this$init.setMimeType(string);
        File tmpFile = jetbrains.youtrack.scripts.persistent.BeansKt.getScriptingContextHolder().addTmpFile("attachment", ".blob");
        $this$init.setSize((long)IssueAttachmentsWorkflowApiExtensionKt.writeContentToFile(content, tmpFile));
        try {
            $this$init.getEntity().setBlob("content", tmpFile);
            $this$init.doInit(null);
            addToContainer.invoke();
            BeansKt.getPersistentDataEnvironment().executeTransactionSafeTask(new Runnable(tmpFile){
                final /* synthetic */ File $tmpFile;

                public final void run() {
                    DeferredIO.getJobProcessor().queueIn(new Job(this){
                        final /* synthetic */ init.2 this$0;

                        protected void execute() {
                            IOUtil.deleteFile((File)this.this$0.$tmpFile);
                        }
                        {
                            this.this$0 = $outer;
                        }
                    }, 5000L);
                }
                {
                    this.$tmpFile = file;
                }
            });
        }
        catch (Exception e) {
            ((XdEntity)$this$init).delete();
            IOUtil.deleteFile((File)tmpFile);
            log.INSTANCE.getLogger().error((Throwable)e, (Function0)init.3.INSTANCE);
            throw (Throwable)new LocalizedLogicException((Localization)new LocalizationObject("IssueAttachmentsWorkflowApiExtension.Error_writing_attachment_content", new Object[0]), e);
        }
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="The content of the file in binary form.")
    @ApiSince(value="2019.2.53994")
    @ApiMpsIgnore
    @Nullable
    public static final InputStream getContent(@NotNull XdIssueAttachment $this$getContent) {
        InputStreamWrapper inputStreamWrapper;
        Intrinsics.checkParameterIsNotNull((Object)$this$getContent, (String)"$this$getContent");
        InputStream inputStream = $this$getContent.getContent();
        if (inputStream != null) {
            InputStream inputStream2 = inputStream;
            boolean bl = false;
            boolean bl2 = false;
            InputStream it = inputStream2;
            boolean bl3 = false;
            inputStreamWrapper = new InputStreamWrapper(it);
        } else {
            inputStreamWrapper = null;
        }
        return inputStreamWrapper;
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW, ApiScope.PLUGIN})
    @ApiMpsIgnore
    public static final void setContent(@NotNull XdIssueAttachment $this$setContent, @Nullable InputStream content) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setContent, (String)"$this$setContent");
        $this$setContent.setContentWithLicenseCheck(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int writeContentToFile(InputStream content, File file) {
        int n;
        Closeable closeable = content;
        boolean bl = false;
        Throwable throwable = null;
        try {
            int n2;
            InputStream it = (InputStream)closeable;
            boolean bl2 = false;
            Closeable closeable2 = new BufferedOutputStream(new FileOutputStream(file));
            boolean bl3 = false;
            Throwable throwable2 = null;
            try {
                BufferedOutputStream it2 = (BufferedOutputStream)closeable2;
                boolean bl4 = false;
                int size = IOUtils.copy((InputStream)content, (OutputStream)it2);
                it2.flush();
                n2 = size;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            n = n2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return n;
    }
}

