/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.api;

import jetbrains.youtrack.core.annotations.ApiDoc;
import jetbrains.youtrack.core.annotations.ApiDocReturns;
import jetbrains.youtrack.core.annotations.ApiMethod;
import jetbrains.youtrack.core.annotations.ApiScope;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\b\u001a\u00020\u0001*\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\t\u001a\u00020\u0001*\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0001H\u0007\u001a\u0016\u0010\n\u001a\u00020\u0001*\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\u0001H\u0007\u00a8\u0006\u000b"}, d2={"setType", "Lorg/mozilla/javascript/NativeObject;", "no", "type", "", "action", "Ljetbrains/youtrack/core/persistent/issue/XdIssue$Companion;", "ruleProperties", "onChange", "onSchedule", "stateMachine", "youtrack-workflow"})
public final class RuleConstructorFunctionsKt {
    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Creates a declaration of a rule that is triggered when a change is applied to an issue.\nThe object that is returned by this method is normally exported to the `rule` property, otherwise it is not treated as a rule.\n@example\nvar entities = require('@jetbrains/youtrack-scripting-api/entities');\nexports.rule = entities.Issue.onChange({\n  title: 'On issue change, log its id',\n  action: function(ctx) {\n    console.log(ctx.issue.id);\n  }\n});\n@param {Object} ruleProperties A JSON object that defines the properties for the rule.\n@param {string} ruleProperties.title The human-readable name of the rule. Displayed in the administrative UI in YouTrack.\n@param {Issue~actionFunction} ruleProperties.action The function that is invoked on issue change.\n@param {Requirements} ruleProperties.requirements The set of entities that must be present for the script to work as expected.\n@param {Object} [ruleProperties.runOn] Determines which issue events trigger the on-change rule. When not specified, the rule is triggered on issue change.\n@param {boolean} [ruleProperties.runOn.change] When `true`, the rule is triggered on issue change.\n@param {boolean} [ruleProperties.runOn.removal] When `true`, the rule is triggered when an issue is logically deleted.")
    @ApiDocReturns(value="The object representation of the rule.")
    @NotNull
    public static final NativeObject onChange(@NotNull XdIssue.Companion $this$onChange, @ApiDoc(value="$ignore") @NotNull NativeObject ruleProperties) {
        Intrinsics.checkParameterIsNotNull((Object)$this$onChange, (String)"$this$onChange");
        Intrinsics.checkParameterIsNotNull((Object)ruleProperties, (String)"ruleProperties");
        return RuleConstructorFunctionsKt.setType(ruleProperties, "onChange");
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Creates a declaration of a rule that is triggered on a set schedule.\nThe object that is returned by this method is normally exported to the `rule` property, otherwise it is not treated as a rule.\n@example\nvar entities = require('@jetbrains/youtrack-scripting-api/entities');\nexports.rule = entities.Issue.onSchedule({\n  title: 'Log id of major issues every 5 seconds',\n  search: '#Major',\n  cron: '0/5 * * * * ?',\n  action: function(ctx) {\n    console.log(ctx.issue.id);\n  }\n});\n@param {Object} ruleProperties A JSON object that defines the properties for the rule.\n@param {string} [ruleProperties.title] The human-readable name of the rule. Displayed in the administrative UI in YouTrack.\n@param {string|function} ruleProperties.search A YouTrack search string or a function with no parameters that returns such a string.\nThe specified action is applied to all issues that match the search and belong to the project that this rule is attached to.\n@param {string} ruleProperties.cron A cron expression that specifies the interval for applying the rule.\n@param {boolean} [ruleProperties.muteUpdateNotifications] `true` if no notifications should be sent on changes made by this rule or any rule that reacted on a change made by this rule.\n@param {Issue~actionFunction} ruleProperties.action The function that is invoked on schedule for each issue that matches the search.\n@param {Requirements} ruleProperties.requirements The set of entities that must be present for the script to work as expected.")
    @ApiDocReturns(value="The object representation of the rule.")
    @NotNull
    public static final NativeObject onSchedule(@NotNull XdIssue.Companion $this$onSchedule, @ApiDoc(value="$ignore") @NotNull NativeObject ruleProperties) {
        Intrinsics.checkParameterIsNotNull((Object)$this$onSchedule, (String)"$this$onSchedule");
        Intrinsics.checkParameterIsNotNull((Object)ruleProperties, (String)"ruleProperties");
        return RuleConstructorFunctionsKt.setType(ruleProperties, "onSchedule");
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Creates a declaration of a rule that a user can apply to one or more issues with a command or menu option.\nThe object that is returned by this method is normally exported to the `rule` property, otherwise it is not treated as a rule.\n@example\nvar entities = require('@jetbrains/youtrack-scripting-api/entities');\nexports.rule = entities.Issue.action({\n  title: 'Log comments',\n  command: 'log',\n  guard: function(ctx) {\n    return ctx.issue.isReported;\n  },\n  action: function(ctx) {\n    ctx.issue.comments.forEach(function(comment) {\n      console.log(comment.text);\n    });\n  }\n});\n@param {Object} ruleProperties A JSON object that defines the properties for the rule.\n@param {string} ruleProperties.title The human-readable name of the rule. Displayed in the administrative UI in YouTrack.\n@param {string} ruleProperties.command The custom command that triggers the action.\n@param {Issue~guardFunction} ruleProperties.guard A function that is invoked to determine whether the action is applicable to an issue.\n@param {Issue~actionFunction} ruleProperties.action The function that is invoked when a user triggers this action.\n@param {Requirements} ruleProperties.requirements The set of entities that must be present for the script to work as expected.")
    @ApiDocReturns(value="The object representation of the rule.")
    @NotNull
    public static final NativeObject action(@NotNull XdIssue.Companion $this$action, @ApiDoc(value="$ignore") @NotNull NativeObject ruleProperties) {
        Intrinsics.checkParameterIsNotNull((Object)$this$action, (String)"$this$action");
        Intrinsics.checkParameterIsNotNull((Object)ruleProperties, (String)"ruleProperties");
        return RuleConstructorFunctionsKt.setType(ruleProperties, "action");
    }

    @ApiMethod(scopes={ApiScope.WORKFLOW})
    @ApiDoc(value="Creates a declaration of a state-machine rule. The state-machine imposes restrictions for the transitions between values in a custom field.\nYou can execute actions when the custom field is set to a value, changes from a value, or transitions from two specific values.\nThe object that is returned by this method is normally exported to the `rule` property, otherwise it is not treated as a rule.\n@example\nvar entities = require('@jetbrains/youtrack-scripting-api/entities');\nexports.rule = entities.Issue.stateMachine({\n  title: 'Status state-machine',\n  fieldName: 'Status',\n  states: {\n    Open: {\n      initial: true,\n      transitions: {\n        start: {\n          targetState: 'In progress'\n        }\n      }\n    },\n    'In progress': {\n      onEnter: function(ctx) {\n        ctx.issue.fields.Assignee = ctx.currentUser;\n      },\n      transitions: {\n        fix: {\n          targetState: 'Fixed'\n        },\n        reopen: {\n          targetState: 'Open'\n        }\n      }\n    },\n    Fixed: {\n      transitions: {\n      }\n    }\n  },\n  requirements: {\n    Assignee: {\n      type: entities.User.fieldType\n    }\n  }\n});\n@param {Object} ruleProperties A JSON object that defines the properties for the rule.\n@param {string} ruleProperties.title The human-readable name of the rule. Displayed in the administrative UI in YouTrack.\n@param {string} [ruleProperties.fieldName] The name of a field that is managed by the state-machine rule. Declare either fieldName or stateFieldName, not both.\n@param {string} [ruleProperties.stateFieldName] An alias for ruleProperties.fieldName for building state-machines per issue type. When both stateFieldName and fieldName are declared, an exception is thrown.\n@param {Object} [ruleProperties.states] A list of values for a custom field and the possible transitions between them. Declare either states or defaultStateMachine, not both.\n@param {Object} [ruleProperties.defaultMachine] An alias for ruleProperties.states for building state-machines per issue type. When both defaultMachine and states are declared, an exception is thrown.\n@param {string} [ruleProperties.typeFieldName] The name of a field that defines which state-machine applies to the managed field.\n@param {Object} [ruleProperties.alternativeMachines] An object that contains the definitions for one or more state-machines that apply to different types of issues. Object keys are the possible values of the field that is defined by the ruleProperties.typeFieldName. Object values have the same structure that is shown for 'states' in the example.\nThis parameter is mandatory when the ruleProperties.typeFieldName parameter is specified.\n@param {Requirements} ruleProperties.requirements The set of entities that must be present for the script to work as expected.")
    @ApiDocReturns(value="The object representation of the rule.")
    @NotNull
    public static final NativeObject stateMachine(@NotNull XdIssue.Companion $this$stateMachine, @ApiDoc(value="$ignore") @NotNull NativeObject ruleProperties) {
        Intrinsics.checkParameterIsNotNull((Object)$this$stateMachine, (String)"$this$stateMachine");
        Intrinsics.checkParameterIsNotNull((Object)ruleProperties, (String)"ruleProperties");
        return RuleConstructorFunctionsKt.setType(ruleProperties, "stateMachine");
    }

    private static final NativeObject setType(NativeObject no, String type2) {
        NativeObject nativeObject = no;
        boolean bl = false;
        boolean bl2 = false;
        NativeObject $this$apply = nativeObject;
        boolean bl3 = false;
        $this$apply.put("ruleType", (Scriptable)$this$apply, (Object)type2);
        $this$apply.put("target", (Scriptable)no, (Object)"Issue");
        return nativeObject;
    }
}

