/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.checker;

import java.util.ArrayList;
import java.util.Iterator;
import jetbrains.charisma.persistent.TransactionCacheKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.api.workflow.wrappers.TypedValueResolver;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.persistent.XdIssueLinkPrototype;
import jetbrains.youtrack.scripts.model.AbstractScriptingContext;
import jetbrains.youtrack.scripts.persistent.XdScriptPackage;
import jetbrains.youtrack.scripts.wrappers.EntityValueResolver;
import jetbrains.youtrack.scripts.wrappers.ValueResolveUtil;
import jetbrains.youtrack.workflow.checker.BeansKt;
import jetbrains.youtrack.workflow.checker.TypeChecker;
import jetbrains.youtrack.workflow.checker.TypeCheckerKt;
import jetbrains.youtrack.workflow.checker.TypeProblemListener;
import jetbrains.youtrack.workflow.checker.WorkflowChecker;
import jetbrains.youtrack.workflow.checker.problem.ActionNameIsNotUniqueProblem;
import jetbrains.youtrack.workflow.checker.problem.BadCardinalityProblem;
import jetbrains.youtrack.workflow.checker.problem.BadTypeNameProblem;
import jetbrains.youtrack.workflow.checker.problem.IncompatibleVersionProblem;
import jetbrains.youtrack.workflow.checker.problem.NoSuchFieldProblem;
import jetbrains.youtrack.workflow.checker.problem.NoSuchIssueLinkProblem;
import jetbrains.youtrack.workflow.checker.problem.ValidationProblem;
import jetbrains.youtrack.workflow.model.RequirementsValidationContext;
import jetbrains.youtrack.workflow.model.Rule;
import jetbrains.youtrack.workflow.model.StatelessActionRule;
import jetbrains.youtrack.workflow.persistence.ScriptExtensionsKt;
import jetbrains.youtrack.workflow.requirement.FieldRequirement;
import jetbrains.youtrack.workflow.requirement.TypeRequirement;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mozilla.javascript.Context;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\r0\u001dJ\b\u0010\u001e\u001a\u00020\u0016H\u0002J\u0018\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\"\u001a\u00020\u00162\u0006\u0010 \u001a\u00020!2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Ljetbrains/youtrack/workflow/checker/WorkflowChecker;", "Ljetbrains/youtrack/workflow/checker/TypeProblemListener;", "rule", "Ljetbrains/youtrack/workflow/model/Rule;", "project", "Ljetbrains/youtrack/core/persistent/issue/XdProject;", "resolveUtil", "Ljetbrains/youtrack/scripts/wrappers/ValueResolveUtil;", "(Ljetbrains/youtrack/workflow/model/Rule;Ljetbrains/youtrack/core/persistent/issue/XdProject;Ljetbrains/youtrack/scripts/wrappers/ValueResolveUtil;)V", "checker", "Ljetbrains/youtrack/workflow/checker/TypeChecker;", "problems", "Ljava/util/ArrayList;", "Ljetbrains/youtrack/workflow/checker/problem/ValidationProblem;", "Lkotlin/collections/ArrayList;", "getProject", "()Ljetbrains/youtrack/core/persistent/issue/XdProject;", "getRule", "()Ljetbrains/youtrack/workflow/model/Rule;", "workflow", "Ljetbrains/youtrack/scripts/persistent/XdScriptPackage;", "badCardinality", "", "fieldRequirement", "Ljetbrains/youtrack/workflow/requirement/FieldRequirement;", "resolver", "Ljetbrains/youtrack/api/workflow/wrappers/TypedValueResolver;", "badTypeName", "check", "", "checkActionNameIsUnique", "noSuchField", "typeRequirement", "Ljetbrains/youtrack/workflow/requirement/TypeRequirement;", "noSuchValue", "typeResolver", "Ljetbrains/youtrack/scripts/wrappers/EntityValueResolver;", "value", "", "youtrack-workflow"})
public final class WorkflowChecker
implements TypeProblemListener {
    private final ArrayList<ValidationProblem> problems;
    private final XdScriptPackage workflow;
    private final TypeChecker checker;
    @NotNull
    private final Rule rule;
    @NotNull
    private final XdProject project;
    private final ValueResolveUtil resolveUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Iterable<ValidationProblem> check() {
        Rule rule2 = this.rule;
        if (!this.workflow.isCompatible()) {
            String string = this.workflow.getMinimalApiVersion();
            if (string == null) {
                throw (Throwable)new IllegalStateException("It was != null milliseconds ago");
            }
            return CollectionsKt.listOf((Object)new IncompatibleVersionProblem(XdScriptPackage.Companion.getApiVersion(), string));
        }
        this.checkActionNameIsUnique();
        BeansKt.getWorkflowRuleRunner().getContextFactory().enterContext();
        jetbrains.youtrack.scripts.persistent.BeansKt.getScriptingContextHolder().set((AbstractScriptingContext)new RequirementsValidationContext(rule2, this.project));
        try {
            Entity workflowUser2 = (Entity)TransactionCacheKt.getCachedValue((String)"workflowUser", (Function0)check.workflowUser.1.INSTANCE);
            jetbrains.youtrack.core.security.BeansKt.getPrincipalManager().setTemporaryServerPrincipal((Object)workflowUser2);
            for (TypeRequirement typeRequirement : rule2.getRequirements()) {
                Entity entity = this.project.getEntity();
                String string = typeRequirement.getName();
                if (string == null) {
                    string = "";
                }
                this.checker.check(typeRequirement, this.resolveUtil.getProjectEntityValueResolver(null, entity, string, false));
            }
        }
        finally {
            jetbrains.youtrack.core.security.BeansKt.getPrincipalManager().unsetTemporaryServerPrincipal();
            jetbrains.youtrack.scripts.persistent.BeansKt.getScriptingContextHolder().remove();
            Context.exit();
        }
        return this.problems;
    }

    private final void checkActionNameIsUnique() {
        block3: {
            StatelessActionRule olderConflictingRule;
            StatelessActionRule statelessActionRule;
            block2: {
                if (!(this.rule instanceof StatelessActionRule)) break block3;
                checkActionNameIsUnique.1 $fun$conflictsWith$1 = checkActionNameIsUnique.1.INSTANCE;
                checkActionNameIsUnique.2 $fun$isNewerThan$2 = checkActionNameIsUnique.2.INSTANCE;
                Iterable<StatelessActionRule> $this$firstOrNull$iv = ScriptExtensionsKt.getApplicableActionRulesTill(this.project, this.rule);
                boolean $i$f$firstOrNull = false;
                Iterator<StatelessActionRule> iterator = $this$firstOrNull$iv.iterator();
                while (iterator.hasNext()) {
                    StatelessActionRule element$iv;
                    StatelessActionRule it = element$iv = iterator.next();
                    boolean bl = false;
                    if (!(checkActionNameIsUnique.1.INSTANCE.invoke((StatelessActionRule)this.rule, it) && checkActionNameIsUnique.2.INSTANCE.invoke((StatelessActionRule)this.rule, it))) continue;
                    statelessActionRule = element$iv;
                    break block2;
                }
                statelessActionRule = null;
            }
            StatelessActionRule statelessActionRule2 = olderConflictingRule = (StatelessActionRule)statelessActionRule;
            if (statelessActionRule2 != null) {
                StatelessActionRule statelessActionRule3 = statelessActionRule2;
                boolean bl = false;
                boolean bl2 = false;
                StatelessActionRule it = statelessActionRule3;
                boolean bl3 = false;
                this.problems.add(new ActionNameIsNotUniqueProblem(it));
            }
        }
    }

    @Override
    public void noSuchField(@NotNull TypeRequirement typeRequirement, @NotNull FieldRequirement fieldRequirement) {
        Intrinsics.checkParameterIsNotNull((Object)typeRequirement, (String)"typeRequirement");
        Intrinsics.checkParameterIsNotNull((Object)fieldRequirement, (String)"fieldRequirement");
        String expectedType = fieldRequirement.getType().getName();
        if (Intrinsics.areEqual((Object)expectedType, (Object)XdIssueLinkPrototype.Companion.getEntityType()) || Intrinsics.areEqual((Object)expectedType, (Object)XdIssue.Companion.getEntityType())) {
            this.problems.add(new NoSuchIssueLinkProblem(this.rule, this.project, typeRequirement, fieldRequirement));
        } else {
            this.problems.add(new NoSuchFieldProblem(this.rule, this.project, typeRequirement, fieldRequirement));
        }
    }

    @Override
    public void noSuchValue(@NotNull TypeRequirement typeRequirement, @NotNull EntityValueResolver typeResolver, @NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)typeRequirement, (String)"typeRequirement");
        Intrinsics.checkParameterIsNotNull((Object)typeResolver, (String)"typeResolver");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.problems.add(BeansKt.getWorkflowProblemProvider().createProblem(this.rule, this.project, typeRequirement, typeResolver, value2));
    }

    @Override
    public void badTypeName(@NotNull FieldRequirement fieldRequirement, @NotNull TypedValueResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)fieldRequirement, (String)"fieldRequirement");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        this.problems.add(new BadTypeNameProblem(fieldRequirement, resolver));
    }

    @Override
    public void badCardinality(@NotNull FieldRequirement fieldRequirement, @NotNull TypedValueResolver resolver) {
        Intrinsics.checkParameterIsNotNull((Object)fieldRequirement, (String)"fieldRequirement");
        Intrinsics.checkParameterIsNotNull((Object)resolver, (String)"resolver");
        this.problems.add(new BadCardinalityProblem(fieldRequirement, resolver));
    }

    @NotNull
    public final Rule getRule() {
        return this.rule;
    }

    @NotNull
    public final XdProject getProject() {
        return this.project;
    }

    public WorkflowChecker(@NotNull Rule rule2, @NotNull XdProject project2, @NotNull ValueResolveUtil resolveUtil) {
        Intrinsics.checkParameterIsNotNull((Object)rule2, (String)"rule");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)resolveUtil, (String)"resolveUtil");
        this.rule = rule2;
        this.project = project2;
        this.resolveUtil = resolveUtil;
        WorkflowChecker workflowChecker = this;
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        workflowChecker.problems = arrayList;
        this.workflow = this.rule.getXdScript().getWorkflow();
        this.checker = TypeCheckerKt.getTypeChecker(this.workflow, this.resolveUtil, (TypeProblemListener)this);
    }
}

