/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.checker.problem;

import java.util.UUID;
import jetbrains.charisma.user.UserUtil;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Permission;
import jetbrains.youtrack.workflow.checker.problem.fix.QuickFix;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import webr.framework.function.HtmlStringUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ljetbrains/youtrack/workflow/checker/problem/RegisterUserQuickFix;", "Ljetbrains/youtrack/workflow/checker/problem/fix/QuickFix;", "login", "", "(Ljava/lang/String;)V", "description", "getDescription", "()Ljava/lang/String;", "apply", "", "isAccessible", "", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "youtrack-workflow"})
public final class RegisterUserQuickFix
implements QuickFix {
    private final String login;

    @Override
    @NotNull
    public String getDescription() {
        String string = BeansKt.getLocalizer().localizedMsg("RegisterUserQuickFix.Create_User_with_Login_{0}", new Object[]{"<span class=\"bold\">" + HtmlStringUtil.html((Object)this.login) + "</span>"});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\"\u2026til.html(login)}</span>\")");
        return string;
    }

    @Override
    public void apply() {
        if (XdUser.Companion.findUser(this.login) == null) {
            UserUtil.INSTANCE.findOrCreateAndImport(this.login, "", UUID.randomUUID().toString(), this.login);
        }
    }

    @Override
    public boolean isAccessible(@NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return user.hasPermission(Permission.CREATE_USER);
    }

    public RegisterUserQuickFix(@NotNull String login) {
        Intrinsics.checkParameterIsNotNull((Object)login, (String)"login");
        this.login = login;
    }
}

