/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.checker.problem.fix;

import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.persistence.fields.XdBundle;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.workflow.checker.problem.fix.AddValuesUtilKt;
import jetbrains.youtrack.workflow.checker.problem.fix.QuickFix;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import webr.framework.function.HtmlStringUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0007\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/workflow/checker/problem/fix/AddValueToCustomFieldFix;", "Ljetbrains/youtrack/workflow/checker/problem/fix/QuickFix;", "field", "Ljetbrains/charisma/customfields/persistence/XdProjectCustomField;", "value", "", "(Ljetbrains/charisma/customfields/persistence/XdProjectCustomField;Ljava/lang/String;)V", "description", "getDescription", "()Ljava/lang/String;", "apply", "", "isAccessible", "", "user", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "youtrack-workflow"})
public final class AddValueToCustomFieldFix
implements QuickFix {
    private final XdProjectCustomField field;
    private final String value;

    @Override
    public void apply() {
        AddValuesUtilKt.addValues(this.field, CollectionsKt.listOf((Object)this.value));
    }

    @Override
    @NotNull
    public String getDescription() {
        String string = BeansKt.getLocalizer().localizedMsg("AddValueToCustomFieldFix.Add_value_{0}_to_the_field_{1}", new Object[]{"<span class=\"bold\">" + HtmlStringUtil.html((Object)this.value) + "</span>", "<span class=\"bold\">" + HtmlStringUtil.html((Object)this.field.getPrototype().getPresentation()) + "</span>"});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"localizer.localizedMsg(\n\u2026e.presentation)}</span>\")");
        return string;
    }

    @Override
    public boolean isAccessible(@NotNull XdUser user) {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        XdBundle xdBundle = this.field.getBundle();
        return xdBundle != null ? xdBundle.isAccessible(Operation.UPDATE, user) : false;
    }

    public AddValueToCustomFieldFix(@NotNull XdProjectCustomField field, @NotNull String value2) {
        Intrinsics.checkParameterIsNotNull((Object)field, (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        this.field = field;
        this.value = value2;
    }
}

