/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.loaders;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.scripts.loader.PackageDistribution;
import jetbrains.youtrack.scripts.loader.PredefinedScriptPackagesLoader;
import jetbrains.youtrack.scripts.loader.ScriptSource;
import jetbrains.youtrack.scripts.persistent.XdScript;
import jetbrains.youtrack.scripts.persistent.XdScriptPackage;
import jetbrains.youtrack.workflow.loaders.XdPredefinedWorkflowDescriptor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\rH\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u000eJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u000eH\u0014J\u000e\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u000eJ\u0016\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u001aJ\f\u0010\u001f\u001a\u00020\u001a*\u00020\u000eH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006!"}, d2={"Ljetbrains/youtrack/workflow/loaders/PredefinedWorkflowsLoader;", "Ljetbrains/youtrack/scripts/loader/PredefinedScriptPackagesLoader;", "rootFolderPath", "", "(Ljava/lang/String;)V", "availablePackages", "", "packages", "", "Ljetbrains/youtrack/scripts/loader/PackageDistribution;", "getPackages", "()Ljava/lang/Iterable;", "relatedScriptSources", "Ljetbrains/youtrack/scripts/loader/ScriptSource;", "Ljetbrains/youtrack/scripts/persistent/XdScriptPackage;", "getRelatedScriptSources", "(Ljetbrains/youtrack/scripts/persistent/XdScriptPackage;)Ljava/lang/Iterable;", "findExistingScriptByHash", "Ljetbrains/youtrack/scripts/persistent/XdScript;", "pkg", "scriptSource", "hasWorkflowsToRestore", "", "isLegibleForAutoUpdate", "packageEntity", "load", "", "packageProcessed", "restore", "name", "restoreAll", "calculateHashes", "Companion", "youtrack-workflow"})
public final class PredefinedWorkflowsLoader
extends PredefinedScriptPackagesLoader {
    private Set<String> availablePackages;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void load() {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = super.getPackages();
        PredefinedWorkflowsLoader predefinedWorkflowsLoader = this;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PackageDistribution packageDistribution = (PackageDistribution)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getInfo().getName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        predefinedWorkflowsLoader.availablePackages = CollectionsKt.toSet((Iterable)collection);
        super.load();
        Set<String> set = this.availablePackages;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"availablePackages");
        }
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (XdPredefinedWorkflowDescriptor.Companion.findByName(it) != null) continue;
            XdPredefinedWorkflowDescriptor.Companion.new$default(XdPredefinedWorkflowDescriptor.Companion, it, null, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<PackageDistribution> getPackages() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = super.getPackages();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            PackageDistribution it = (PackageDistribution)element$iv$iv;
            boolean bl2 = false;
            String workflowName = it.getInfo().getName();
            XdScriptPackage newWorkflow = XdScriptPackage.Companion.find(workflowName);
            if (newWorkflow != null) {
                if (!newWorkflow.getAllowAutoUpdate()) {
                    Companion.getLogger().info((Function0)new Function0<String>(newWorkflow, workflowName){
                        final /* synthetic */ XdScriptPackage $newWorkflow;
                        final /* synthetic */ String $workflowName;

                        @NotNull
                        public final String invoke() {
                            return this.$newWorkflow.getLanguage().getName() + " script package " + this.$workflowName + " does not allow auto updates";
                        }
                        {
                            this.$newWorkflow = xdScriptPackage;
                            this.$workflowName = string;
                            super(0);
                        }
                    });
                    bl = false;
                } else if (!this.isLegibleForAutoUpdate(newWorkflow)) {
                    Companion.getLogger().info((Function0)new Function0<String>(newWorkflow, workflowName){
                        final /* synthetic */ XdScriptPackage $newWorkflow;
                        final /* synthetic */ String $workflowName;

                        @NotNull
                        public final String invoke() {
                            return this.$newWorkflow.getLanguage().getName() + " script package " + this.$workflowName + " is not legible for loading";
                        }
                        {
                            this.$newWorkflow = xdScriptPackage;
                            this.$workflowName = string;
                            super(0);
                        }
                    });
                    bl = false;
                } else {
                    bl = true;
                }
            } else if (XdPredefinedWorkflowDescriptor.Companion.findByName(workflowName) != null) {
                Companion.getLogger().info((Function0)new Function0<String>(workflowName){
                    final /* synthetic */ String $workflowName;

                    @NotNull
                    public final String invoke() {
                        return "Skip package " + this.$workflowName + " as it was removed by user";
                    }
                    {
                        this.$workflowName = string;
                        super(0);
                    }
                });
                bl = false;
            } else {
                bl = true;
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    protected void packageProcessed(@NotNull XdScriptPackage pkg) {
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        XdScriptPackage xdScriptPackage = pkg;
        boolean bl = false;
        boolean bl2 = false;
        XdScriptPackage $this$apply = xdScriptPackage;
        boolean bl3 = false;
        if ($this$apply.isNew()) {
            $this$apply.setAllowAutoUpdate(true);
        }
        this.calculateHashes($this$apply);
    }

    private final void calculateHashes(@NotNull XdScriptPackage $this$calculateHashes) {
        List rulesList = XdQueryKt.toList((XdQuery)((XdQuery)$this$calculateHashes.getRules()));
        Iterable $this$forEach$iv = rulesList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XdScript it = (XdScript)element$iv;
            boolean bl = false;
            String script = it.getScript();
            if (script == null) {
                Companion.getLogger().error((Function0)new Function0<String>(it){
                    final /* synthetic */ XdScript $it;

                    @NotNull
                    public final String invoke() {
                        return "Script is null for rule " + this.$it.getName() + " in workflow " + this.$it.getEntity().getLink("workflow");
                    }
                    {
                        this.$it = xdScript;
                        super(0);
                    }
                });
                continue;
            }
            String hash = XdScript.Companion.calculateScriptHash(script);
            if (!(Intrinsics.areEqual((Object)hash, (Object)it.getOriginalHash()) ^ true)) continue;
            it.setOriginalHash(hash);
        }
        int size = rulesList.size();
        if ($this$calculateHashes.getOriginalScriptsCount() != size) {
            $this$calculateHashes.setOriginalScriptsCount(size);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void restore(@NotNull XdScriptPackage pkg) {
        void $this$filterTo$iv$iv;
        XdScript it;
        Iterable $this$mapTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)pkg, (String)"pkg");
        XdScriptPackage xdScriptPackage = pkg;
        boolean bl = false;
        boolean bl2 = false;
        XdScriptPackage $this$apply = xdScriptPackage;
        boolean bl3 = false;
        $this$apply.setUpdated(0L);
        $this$apply.setUpdatedBy((XdUser)null);
        Iterable<ScriptSource> $this$map$iv = this.getRelatedScriptSources($this$apply);
        boolean $i$f$map = false;
        Iterable<ScriptSource> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ScriptSource scriptSource = (ScriptSource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl4 = false;
            XdScript existing2 = this.findExistingScriptByHash($this$apply, (ScriptSource)it);
            this.processScript((ScriptSource)it, $this$apply, existing2);
            String string = it.getName();
            collection.add(string);
        }
        List processedScripts = (List)destination$iv$iv;
        Iterable $this$filter$iv = XdQueryKt.toList((XdQuery)((XdQuery)$this$apply.getRules()));
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (XdScript)element$iv$iv;
            boolean bl5 = false;
            if (!(!processedScripts.contains(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XdScript it2 = (XdScript)element$iv;
            boolean bl6 = false;
            it2.delete();
        }
        $this$apply.setAllowAutoUpdate(true);
        this.calculateHashes($this$apply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final XdScript findExistingScriptByHash(XdScriptPackage pkg, ScriptSource scriptSource) {
        String string;
        Closeable closeable = scriptSource.getBody();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            InputStreamReader it = (InputStreamReader)closeable;
            boolean bl3 = false;
            string = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String body = string;
        String hash = XdScript.Companion.calculateScriptHash(body);
        return (XdScript)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)pkg.getRules()), (Function2)((Function2)new Function2<FilteringContext, XdScript, XdSearchingNode>(hash){
            final /* synthetic */ String $hash;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdScript it) {
                Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $this$filter.eq((Comparable)((Object)it.getOriginalHash()), (Comparable)((Object)this.$hash));
            }
            {
                this.$hash = string;
                super(2);
            }
        })));
    }

    public final void restore(@NotNull XdScriptPackage packageEntity, @NotNull String name2) {
        Intrinsics.checkParameterIsNotNull((Object)packageEntity, (String)"packageEntity");
        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
        Set<String> set = this.availablePackages;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"availablePackages");
        }
        if (set.contains(name2)) {
            this.restore(packageEntity);
        }
    }

    public final void restoreAll() {
        Set<String> set = this.availablePackages;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"availablePackages");
        }
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            XdScriptPackage xdScriptPackage = XdScriptPackage.Companion.find(it);
            if (xdScriptPackage == null) {
                xdScriptPackage = XdScriptPackage.Companion.new((Function1)new Function1<XdScriptPackage, Unit>(it){
                    final /* synthetic */ String $it;

                    public final void invoke(@NotNull XdScriptPackage $this$new) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$new, (String)"$receiver");
                        $this$new.setName(this.$it);
                    }
                    {
                        this.$it = string;
                        super(1);
                    }
                });
            }
            this.restore(xdScriptPackage);
        }
    }

    public final boolean hasWorkflowsToRestore() {
        boolean bl;
        block4: {
            Set<String> set = this.availablePackages;
            if (set == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"availablePackages");
            }
            Iterable $this$any$iv = set;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    XdScriptPackage workflow2 = XdScriptPackage.Companion.find(it);
                    boolean bl3 = workflow2 == null || !workflow2.getAllowAutoUpdate();
                    if (!bl3) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * Unable to fully structure code
     */
    public final boolean isLegibleForAutoUpdate(@NotNull XdScriptPackage packageEntity) {
        block4: {
            block3: {
                Intrinsics.checkParameterIsNotNull((Object)packageEntity, (String)"packageEntity");
                var2_2 = false;
                var3_3 = false;
                $this$with = packageEntity;
                $i$a$-with-PredefinedWorkflowsLoader$isLegibleForAutoUpdate$1 = false;
                v0 = $this$with.getName();
                if (v0 == null) break block3;
                var6_6 = v0;
                var7_7 = false;
                var8_8 = false;
                it = var6_6;
                $i$a$-let-PredefinedWorkflowsLoader$isLegibleForAutoUpdate$1$1 = false;
                if (!StringsKt.startsWith$default((String)it, (String)"@jetbrains/youtrack-workflow-", (boolean)false, (int)2, null)) ** GOTO lbl-1000
                v1 = this.availablePackages;
                if (v1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"availablePackages");
                }
                if (v1.contains(it)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                v3 = v2;
                break block4;
            }
            v3 = null;
        }
        return v3;
    }

    private final Iterable<ScriptSource> getRelatedScriptSources(@NotNull XdScriptPackage $this$relatedScriptSources) {
        Object object;
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = super.getPackages();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PackageDistribution it = (PackageDistribution)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getInfo().getName(), (Object)$this$relatedScriptSources.getName())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (PackageDistribution)v0) == null || (object = object.getScriptSources()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public PredefinedWorkflowsLoader(@NotNull String rootFolderPath) {
        Intrinsics.checkParameterIsNotNull((Object)rootFolderPath, (String)"rootFolderPath");
        super(rootFolderPath, "workflow");
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/workflow/loaders/PredefinedWorkflowsLoader$Companion;", "Lmu/KLogging;", "()V", "youtrack-workflow"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

