/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.refactorings;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.service.BeansKt;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.notifications.NotificationService;
import jetbrains.youtrack.notifications.NotificationServiceKt;
import jetbrains.youtrack.persistent.XdProjectExtKt;
import jetbrains.youtrack.refactoring.XdRefactoring;
import jetbrains.youtrack.scripts.persistent.XdScriptPackage;
import jetbrains.youtrack.workflow.persistence.XdScriptUsageKt;
import jetbrains.youtrack.workflow.refactorings.NotificationInfo;
import jetbrains.youtrack.workflow.refactorings.NotificationInfos;
import jetbrains.youtrack.workflow.refactorings.RefactoringNotifyAboutObsoleteWorkflows;
import jetbrains.youtrack.workflow.refactorings.RefactoringNotifyAboutObsoleteWorkflowsKt;
import jetbrains.youtrack.workflow.refactorings.RefactoringNotifyAboutObsoleteWorkflowsKt$sam$java_util_function_BiConsumer$0;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001e\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Ljetbrains/youtrack/workflow/refactorings/RefactoringNotifyAboutObsoleteWorkflows;", "Ljetbrains/youtrack/refactoring/XdRefactoring;", "()V", "name", "", "getName", "()Ljava/lang/String;", "apply", "", "doApply", "notifyProjectsLead", "lead", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "infos", "Ljetbrains/youtrack/workflow/refactorings/NotificationInfos;", "notifyRoot", "root", "wfs", "", "Ljetbrains/youtrack/scripts/persistent/XdScriptPackage;", "youtrack-workflow"})
public final class RefactoringNotifyAboutObsoleteWorkflows
extends XdRefactoring {
    @NotNull
    private final String name = "Notifies project leads and root about existing MPS workflows";

    @NotNull
    public String getName() {
        return this.name;
    }

    public void apply() {
        try {
            this.doApply();
        }
        catch (Throwable t) {
            XdRefactoring.Companion.getLogger().error(t, (Function0)apply.1.INSTANCE);
        }
    }

    private final void doApply() {
        boolean allowMeToTest = Intrinsics.areEqual((Object)System.getProperty("jetbrains.youtrack.allowMeToTestWfRefactoring"), (Object)"true");
        boolean bl = false;
        HashMap notificationInfos = new HashMap();
        Entity entity = BeansKt.getUserService().getRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)entity, (String)"userService.root");
        XdUser root = (XdUser)XdExtensionsKt.toXd((Entity)entity);
        boolean bl2 = false;
        HashSet<XdScriptPackage> wfsToNotifyRootAbout = new HashSet<XdScriptPackage>();
        XdQuery packages2 = allowMeToTest ? XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdScriptPackage.Companion), (Function2)doApply.packages.1.INSTANCE) : XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdScriptPackage.Companion), (Function2)doApply.packages.2.INSTANCE);
        Sequence $this$forEach$iv = XdQueryKt.asSequence((XdQuery)packages2);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            XdScriptPackage wf = (XdScriptPackage)element$iv;
            boolean bl3 = false;
            Iterable<XdProject> $this$forEach$iv2 = XdScriptUsageKt.getProjects(wf);
            boolean $i$f$forEach2 = false;
            Iterator<XdProject> iterator = $this$forEach$iv2.iterator();
            while (iterator.hasNext()) {
                XdProject element$iv2;
                XdProject project2 = element$iv2 = iterator.next();
                boolean bl4 = false;
                NotificationInfos notificationInfos2 = (NotificationInfos)notificationInfos.get(XdProjectExtKt.getLeader((XdProject)project2));
                if (notificationInfos2 == null) {
                    NotificationInfos notificationInfos3 = new NotificationInfos(null, 1, null);
                    boolean bl5 = false;
                    boolean bl6 = false;
                    NotificationInfos it = notificationInfos3;
                    boolean bl7 = false;
                    ((Map)notificationInfos).put(XdProjectExtKt.getLeader((XdProject)project2), it);
                    notificationInfos2 = notificationInfos3;
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)notificationInfos2, (String)"notificationInfos[projec\u2026s[project.leader] = it })");
                NotificationInfos infos = notificationInfos2;
                infos.add(project2, wf);
                if (!(Intrinsics.areEqual((Object)XdProjectExtKt.getLeader((XdProject)project2), (Object)root) ^ true)) continue;
                wfsToNotifyRootAbout.add(wf);
            }
        }
        Collection collection = wfsToNotifyRootAbout;
        boolean bl8 = false;
        if (!collection.isEmpty()) {
            this.notifyRoot(root, (Set<XdScriptPackage>)wfsToNotifyRootAbout);
        }
        collection = (Function2)new Function2<XdUser, NotificationInfos, Unit>(this){

            public final void invoke(@NotNull XdUser p1, @NotNull NotificationInfos p2) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                Intrinsics.checkParameterIsNotNull((Object)p2, (String)"p2");
                RefactoringNotifyAboutObsoleteWorkflows.access$notifyProjectsLead((RefactoringNotifyAboutObsoleteWorkflows)((Object)this.receiver), p1, p2);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(RefactoringNotifyAboutObsoleteWorkflows.class);
            }

            public final String getName() {
                return "notifyProjectsLead";
            }

            public final String getSignature() {
                return "notifyProjectsLead(Ljetbrains/youtrack/core/persistent/user/XdUser;Ljetbrains/youtrack/workflow/refactorings/NotificationInfos;)V";
            }
        };
        notificationInfos.forEach(new RefactoringNotifyAboutObsoleteWorkflowsKt$sam$java_util_function_BiConsumer$0((Function2)collection));
        if (!allowMeToTest) {
            this.markApplied();
        }
    }

    private final void notifyProjectsLead(XdUser lead, NotificationInfos infos) {
        Object object = CollectionsKt.first((List)infos.getInfos());
        XdUser xdUser = null;
        XdUser xdUser2 = lead;
        NotificationService notificationService = NotificationServiceKt.getNotificationService();
        boolean bl = false;
        boolean bl2 = false;
        NotificationInfo it = (NotificationInfo)object;
        boolean bl3 = false;
        Object object2 = infos.getInfos().size() == 1 ? object : null;
        NotificationInfo notificationInfo = (NotificationInfo)object2;
        notificationService.notifyInstantEmail(xdUser2, xdUser, (XdProject)(notificationInfo != null ? notificationInfo.getProject() : null), "[IMPORTANT] You have projects in YouTrack that require your attention", StringsKt.trimIndent((String)("\nThere are one or more projects in your YouTrack installation that still use legacy workflows. Here's a complete list:\n<table>\n  <thead>\n    <tr><th width=\"20%\">Project Name</th><th width=\"10%\"><th align=\"left\">Workflow(s)</th></tr>\n  </thead>\n  <tbody>\n    " + CollectionsKt.joinToString$default((Iterable)infos.getInfos(), (CharSequence)"", null, null, (int)0, null, (Function1)notifyProjectsLead.2.INSTANCE, (int)30, null) + "\n  </tbody>\n</table>\n<p>\nThe YouTrack team officially discontinued support for legacy workflows in 2019. In YouTrack 2020.5, which is scheduled for release in November 2020, we plan to remove the logic that supports legacy workflows completely. As a result, any legacy workflow attached to a project in YouTrack will no longer work as expected.\n<p>\nIf any of your projects rely on these workflows to support your business processes, please migrate them to JavaScript as soon as possible. For detailed instructions, <a href=\"https://blog.jetbrains.com/youtrack/2019/03/state-of-youtrack-workflow-apis/\">read this blog post</a>.\n<p>\nIf you have any questions or need assistance with migration to JavaScript, please <a href=\"https://www.jetbrains.com/support/youtrack/\">contact our support team</a> or <a href=\"http://youtrack-community.herokuapp.com/\">join the YouTrack Community in Slack</a>. We're always happy to help!\n        ")));
    }

    private final void notifyRoot(XdUser root, Set<XdScriptPackage> wfs) {
        NotificationServiceKt.getNotificationService().notifyInstantEmail(root, null, null, "[IMPORTANT] Your YouTrack installation requires attention", StringsKt.trimIndent((String)("\nYour YouTrack installation contains legacy <a href=\"" + RefactoringNotifyAboutObsoleteWorkflowsKt.access$getWorkflowsUrl$p() + "\">workflows</a> that are attached to at least one project. Here's a complete list:\n<p>\n" + CollectionsKt.joinToString$default((Iterable)wfs, null, null, null, (int)0, null, (Function1)notifyRoot.1.INSTANCE, (int)31, null) + "\n<p>\nThe YouTrack team officially discontinued support for legacy workflows in 2019. In YouTrack 2020.5, which is scheduled for release in November 2020, we plan to remove the logic that supports legacy workflows completely. As a result, any legacy workflow attached to a project in YouTrack will no longer work as expected.\n<p>\nIf any of your projects rely on these workflows to support your business processes, please migrate them to JavaScript as soon as possible. For detailed instructions, <a href=\"https://blog.jetbrains.com/youtrack/2019/03/state-of-youtrack-workflow-apis/\">read this blog post</a>.\n<p>\nIf you have any questions or need assistance with migration to JavaScript, please <a href=\"https://www.jetbrains.com/support/youtrack/\">contact our support team</a> or <a href=\"http://youtrack-community.herokuapp.com/\">join the YouTrack Community in Slack</a>. We're always happy to help!\n        ")));
    }

    public static final /* synthetic */ void access$notifyProjectsLead(RefactoringNotifyAboutObsoleteWorkflows $this, XdUser lead, NotificationInfos infos) {
        $this.notifyProjectsLead(lead, infos);
    }
}

