/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.workflow.scheduled;

import java.util.List;
import java.util.Locale;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessor;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.dates.runtime.DateTimeOperations;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.BeansKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.workflow.model.StateMachine;
import jetbrains.youtrack.workflow.model.TimeEvent;
import jetbrains.youtrack.workflow.scheduled.ScheduledEventsQueue;
import jetbrains.youtrack.workflow.scheduled.ScheduledEventsQueue$RunnerJob$events$1$2;
import jetbrains.youtrack.workflow.scheduled.ScheduledEventsQueue$RunnerJob$execute$;
import jetbrains.youtrack.workflow.scheduled.ScheduledEventsQueue$reschedule$1$1;
import jetbrains.youtrack.workflow.scheduled.XdScheduledEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0013\u001a\n \u0014*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\u000f\u001a\u00020\u0006H\u0002J*\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\fH\u0014J\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u0019\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0011R\u0014\u0010\u0005\u001a\u00020\u00068TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ljetbrains/youtrack/workflow/scheduled/ScheduledEventsQueue;", "", "jobProcessor", "Ljetbrains/exodus/core/execution/JobProcessor;", "(Ljetbrains/exodus/core/execution/JobProcessor;)V", "eps", "", "getEps", "()J", "job", "Ljetbrains/youtrack/workflow/scheduled/ScheduledEventsQueue$RunnerJob;", "add", "Ljetbrains/youtrack/workflow/scheduled/XdScheduledEvent;", "issue", "Ljetbrains/exodus/entitystore/Entity;", "time", "event", "", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "getReadableDate", "kotlin.jvm.PlatformType", "onEventAdded", "existingEvent", "reschedule", "", "run", "Companion", "RunnerJob", "youtrack-workflow"})
public class ScheduledEventsQueue {
    private final RunnerJob job;
    private final JobProcessor jobProcessor;
    private static final long EPS = 1000L;
    private static final int MAX_EVENTS_ONE_HANDLE = 1000;
    private static final int BAG_SIZE = 100;
    public static final Companion Companion = new Companion(null);

    public final void run(@NotNull XdIssue issue, @NotNull String event) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (issue.isRemoved()) {
            Companion.getLogger().warn((Function0)new Function0<String>(event, issue){
                final /* synthetic */ String $event;
                final /* synthetic */ XdIssue $issue;

                @NotNull
                public final String invoke() {
                    return "Handle time event [" + this.$event + "] called for deleted issue [" + this.$issue.getIdReadable() + "], skipping";
                }
                {
                    this.$event = string;
                    this.$issue = xdIssue;
                    super(0);
                }
            });
        } else {
            Companion.getLogger().debug((Function0)new Function0<String>(event, issue){
                final /* synthetic */ String $event;
                final /* synthetic */ XdIssue $issue;

                @NotNull
                public final String invoke() {
                    return "Handle time event [" + this.$event + "] for issue [" + this.$issue.getIdReadable() + ']';
                }
                {
                    this.$event = string;
                    this.$issue = xdIssue;
                    super(0);
                }
            });
            TimeEvent timeEvent = TimeEvent.Companion.fromString(event);
            StateMachine stateMachine = StateMachine.Companion.getStateMachine(issue.getProject(), timeEvent.getStateFieldName());
            if (stateMachine != null) {
                stateMachine.handle(timeEvent.getName(), issue.getEntity());
            } else {
                Companion.getLogger().warn((Function0)new Function0<String>(timeEvent){
                    final /* synthetic */ TimeEvent $timeEvent;

                    @NotNull
                    public final String invoke() {
                        return "Can't find statemachine for field [" + this.$timeEvent.getStateFieldName() + ']';
                    }
                    {
                        this.$timeEvent = timeEvent;
                        super(0);
                    }
                });
            }
        }
    }

    @NotNull
    public final XdScheduledEvent add(@NotNull Entity issue, long time, @NotNull String event) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        return this.add((XdIssue)XdExtensionsKt.toXd((Entity)issue), time, event);
    }

    @NotNull
    public final XdScheduledEvent add(@NotNull XdIssue issue, long time, @NotNull String event) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        XdScheduledEvent existing2 = (XdScheduledEvent)((Object)LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, XdScheduledEvent>(issue, event){
            final /* synthetic */ XdIssue $issue;
            final /* synthetic */ String $event;

            @Nullable
            public final XdScheduledEvent invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (XdScheduledEvent)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdScheduledEvent.Companion), (Function2)((Function2)new Function2<FilteringContext, XdScheduledEvent, XdSearchingNode>(this){
                    final /* synthetic */ add.existing.1 this$0;

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdScheduledEvent it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                        return $this$filter.eq((XdEntity)it.getIssue(), (XdEntity)this.this$0.$issue).and($this$filter.eq((Comparable)((Object)it.getEvent()), (Comparable)((Object)this.this$0.$event)));
                    }
                    {
                        this.this$0 = var1_1;
                        super(2);
                    }
                })));
            }
            {
                this.$issue = xdIssue;
                this.$event = string;
                super(1);
            }
        })));
        return this.onEventAdded(issue, time, event, existing2);
    }

    @NotNull
    protected XdScheduledEvent onEventAdded(@NotNull XdIssue issue, long time, @NotNull String event, @Nullable XdScheduledEvent existingEvent) {
        Object object;
        block3: {
            boolean bl;
            boolean bl2;
            Object object2;
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                object = existingEvent;
                if (object == null) break block2;
                object2 = object;
                bl2 = false;
                bl = false;
                Object $this$apply = object2;
                boolean bl3 = false;
                ((XdScheduledEvent)((Object)$this$apply)).setTime(time);
                object = object2;
                if (object != null) break block3;
            }
            object2 = this;
            bl2 = false;
            bl = false;
            ScheduledEventsQueue it = (ScheduledEventsQueue)object2;
            boolean bl4 = false;
            Companion.getLogger().debug((Function0)new Function0<String>(this, event, time, issue){
                final /* synthetic */ ScheduledEventsQueue this$0;
                final /* synthetic */ String $event$inlined;
                final /* synthetic */ long $time$inlined;
                final /* synthetic */ XdIssue $issue$inlined;
                {
                    this.this$0 = scheduledEventsQueue;
                    this.$event$inlined = string;
                    this.$time$inlined = l;
                    this.$issue$inlined = xdIssue;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Add new schedule event [" + this.$event$inlined + "] at [" + ScheduledEventsQueue.access$getReadableDate(this.this$0, this.$time$inlined) + "] for issue [" + this.$issue$inlined.getIdReadable() + ']';
                }
            });
            object = XdScheduledEvent.Companion.new(issue, time, event);
        }
        return object;
    }

    public final void reschedule() {
        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Job>(this){
            final /* synthetic */ ScheduledEventsQueue this$0;

            @Nullable
            public final Job invoke(@NotNull TransientStoreSession it) {
                Job job;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdScheduledEvent xdScheduledEvent = (XdScheduledEvent)XdQueryKt.firstOrNull((XdQuery)XdQueryKt.sortedBy$default((XdQuery)XdScheduledEvent.Companion.all(), (KProperty1)((KProperty1)ScheduledEventsQueue$reschedule$1$1.INSTANCE), (boolean)false, (int)2, null));
                if (xdScheduledEvent != null) {
                    XdScheduledEvent xdScheduledEvent2 = xdScheduledEvent;
                    boolean bl = false;
                    boolean bl2 = false;
                    XdScheduledEvent it2 = xdScheduledEvent2;
                    boolean bl3 = false;
                    ScheduledEventsQueue.Companion.getLogger().debug((Function0)new Function0<String>(it2, this){
                        final /* synthetic */ XdScheduledEvent $it;
                        final /* synthetic */ reschedule.1 this$0;
                        {
                            this.$it = xdScheduledEvent;
                            this.this$0 = var2_2;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Reschedule next nearest time event [" + this.$it.getEvent() + "] at [" + ScheduledEventsQueue.access$getReadableDate(this.this$0.this$0, this.$it.getTime()) + "] for issue [" + this.$it.getIssue().getIdReadable() + ']';
                        }
                    });
                    job = ScheduledEventsQueue.access$getJobProcessor$p(this.this$0).queueAt((Job)ScheduledEventsQueue.access$getJob$p(this.this$0), it2.getTime());
                } else {
                    job = null;
                }
                return job;
            }
            {
                this.this$0 = scheduledEventsQueue;
                super(1);
            }
        }));
    }

    private final String getReadableDate(long time) {
        return DateTimeOperations.print((DateTime)DateTimeOperations.convert((Long)time, (DateTimeZone)DateTimeZone.getDefault()), (DateTimeFormatter)DateTimeFormat.longDateTime(), (Locale)Locale.ENGLISH);
    }

    protected long getEps() {
        return 1000L;
    }

    public ScheduledEventsQueue(@NotNull JobProcessor jobProcessor) {
        Intrinsics.checkParameterIsNotNull((Object)jobProcessor, (String)"jobProcessor");
        this.jobProcessor = jobProcessor;
        String string = BeansKt.getPersistentEntityStore().getLocation();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"persistentEntityStore.location");
        this.job = new RunnerJob(string);
    }

    public static final /* synthetic */ String access$getReadableDate(ScheduledEventsQueue $this, long time) {
        return $this.getReadableDate(time);
    }

    public static final /* synthetic */ JobProcessor access$getJobProcessor$p(ScheduledEventsQueue $this) {
        return $this.jobProcessor;
    }

    public static final /* synthetic */ RunnerJob access$getJob$p(ScheduledEventsQueue $this) {
        return $this.job;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Ljetbrains/youtrack/workflow/scheduled/ScheduledEventsQueue$RunnerJob;", "Ljetbrains/exodus/core/execution/Job;", "g", "", "(Ljetbrains/youtrack/workflow/scheduled/ScheduledEventsQueue;Ljava/lang/String;)V", "events", "", "Ljetbrains/youtrack/workflow/scheduled/XdScheduledEvent;", "getEvents", "()Ljava/lang/Iterable;", "getG", "()Ljava/lang/String;", "execute", "", "getGroup", "getName", "youtrack-workflow"})
    public final class RunnerJob
    extends Job {
        @NotNull
        private final String g;

        @NotNull
        public String getGroup() {
            return this.g;
        }

        @NotNull
        public String getName() {
            return "Trig statemachine time events";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void execute() {
            Iterable<XdScheduledEvent> events2 = this.getEvents();
            XdUser user$iv = (XdUser)LegacySupportKt.transactional((Function1)execute.1.INSTANCE);
            boolean $i$f$runAs = false;
            Entity user$iv$iv = user$iv.getEntity();
            boolean $i$f$runAs2 = false;
            PrincipalManager _principalManager$iv$iv = jetbrains.youtrack.core.security.BeansKt.getPrincipalManager();
            try {
                _principalManager$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv);
                boolean bl = false;
                List list = CollectionsKt.windowed(events2, (int)100, (int)100, (boolean)true, (Function1)((Function1)new Function1<List<? extends XdScheduledEvent>, Unit>(this, events2){
                    final /* synthetic */ RunnerJob this$0;
                    final /* synthetic */ Iterable $events$inlined;
                    {
                        this.this$0 = runnerJob;
                        this.$events$inlined = iterable;
                        super(1);
                    }

                    public final void invoke(@NotNull List<XdScheduledEvent> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this, it){
                            final /* synthetic */ RunnerJob$execute$$inlined$runAs$lambda$1 this$0;
                            final /* synthetic */ List $it;
                            {
                                this.this$0 = var1_1;
                                this.$it = list;
                                super(1);
                            }

                            public final void invoke(@NotNull TransientStoreSession $noName_0) {
                                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                                Iterable $this$forEach$iv = this.$it;
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    XdScheduledEvent event = (XdScheduledEvent)((Object)element$iv);
                                    boolean bl = false;
                                    try {
                                        this.this$0.this$0.ScheduledEventsQueue.this.run(event.getIssue(), event.getEvent());
                                    }
                                    catch (Exception e) {
                                        ScheduledEventsQueue.Companion.getLogger().error((Throwable)e, (Function0)execute.2.1.1.1.INSTANCE);
                                    }
                                    event.delete();
                                }
                            }
                        }));
                    }
                }));
            }
            finally {
                _principalManager$iv$iv.unsetTemporaryServerPrincipal();
            }
        }

        private final Iterable<XdScheduledEvent> getEvents() {
            return (Iterable)LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, List<? extends XdScheduledEvent>>(this){
                final /* synthetic */ RunnerJob this$0;

                @NotNull
                public final List<XdScheduledEvent> invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    long threshold = System.currentTimeMillis() + this.this$0.ScheduledEventsQueue.this.getEps();
                    return XdQueryKt.toList((XdQuery)XdQueryKt.take((XdQuery)XdQueryKt.sortedBy$default((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdScheduledEvent.Companion), (Function2)((Function2)new Function2<FilteringContext, XdScheduledEvent, XdSearchingNode>(threshold){
                        final /* synthetic */ long $threshold;

                        @NotNull
                        public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdScheduledEvent it) {
                            Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                            Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                            return $this$filter.lt((Comparable)Long.valueOf(it.getTime()), (Comparable)Long.valueOf(this.$threshold));
                        }
                        {
                            this.$threshold = l;
                            super(2);
                        }
                    })), (KProperty1)((KProperty1)ScheduledEventsQueue$RunnerJob$events$1$2.INSTANCE), (boolean)false, (int)2, null), (int)1000));
                }
                {
                    this.this$0 = runnerJob;
                    super(1);
                }
            }));
        }

        @NotNull
        public final String getG() {
            return this.g;
        }

        public RunnerJob(String g) {
            Intrinsics.checkParameterIsNotNull((Object)g, (String)"g");
            this.g = g;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ljetbrains/youtrack/workflow/scheduled/ScheduledEventsQueue$Companion;", "Lmu/KLogging;", "()V", "BAG_SIZE", "", "EPS", "", "MAX_EVENTS_ONE_HANDLE", "youtrack-workflow"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

