var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Warn when issue is not visible to assignee'),
  guard: function(ctx) {
    return ctx.issue.fields.isChanged(ctx.Assignee) && ctx.issue.fields.Assignee;
  },
  action: function(ctx) {
    var issue = ctx.issue;
    var assignee = issue.fields.Assignee;
    if (issue.permittedGroups.isNotEmpty() || issue.permittedUsers.isNotEmpty()) {
      if (assignee.login === issue.reporter.login) {
        return;
      }
      if (issue.permittedUsers.find(function(user) {
          return user.login === assignee.login;
        })) {
        return;
      }
      if (issue.permittedGroups.find(function(group) {
          return assignee.isInGroup(group.name);
        })) {
        return;
      }
      workflow.message(workflow.i18n('Please take into account that new assignee \'{0}\' isn\'t included into the visibility groups and users!', assignee.fullName));
    }
  },
  requirements: {
    Assignee: {
      type: entities.User.fieldType
    }
  }
});