var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var entities = require('@jetbrains/youtrack-scripting-api/entities');

exports.rule = entities.Issue.action({
    title: workflow.i18n('Clone issue as draft'),
    command: workflow.i18n('clone as draft'),
    guard: function(ctx) {
        return ctx.issue.isReported;
    },
    action: function (ctx) {
        var newIssue = ctx.issue.createDraftCopy(); // WARNING! Do not use this method in your workflows. Use Issue#copy() instead
        workflow.message(workflow.i18n('A clone of the current issue was saved to your list of drafts. <a href="{0}">Edit draft</a>', newIssue.url));
    }
});