var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var entities = require('@jetbrains/youtrack-scripting-api/entities');

exports.rule = entities.Issue.action({
  title: workflow.i18n('Clone issue'),
  command: workflow.i18n('clone'),
  guard: function(ctx) {
    return ctx.issue.isReported;
  },
  action: function (ctx) {
    var newIssue = ctx.issue.createCopy(); // WARNING! Do not use this method in your workflows. Use Issue#copy() instead
    workflow.message(workflow.i18n('A clone of the current issue has been created: <a href="{0}">{1}</a>', newIssue.url, newIssue.id));
  }
});