var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Block users from resolving issues with unresolved dependencies'),
  guard: function(ctx) {
    return ctx.issue.fields.becomes(ctx.State, ctx.State.Fixed) && ctx.issue.links['depends on'].isNotEmpty();
  },
  action: function(ctx) {
    ctx.issue.links['depends on'].forEach(function(dep) {
      if (!dep.project.isArchived && dep.isReported) {
        workflow.check(dep.isResolved, workflow.i18n('The issue has unresolved dependencies and thus cannot be set Fixed! (depends on {0})', dep.id));
      }
    });
  },
  requirements: {
    State: {
      type: entities.State.fieldType,
      Fixed: {}
    },
    Depend: {
      type: entities.IssueLinkPrototype,
      outward: 'is required for',
      inward: 'depends on'
    }
  }
});