var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Require due dates for submitted issues'),
  guard: function(ctx) {
    return ctx.issue.becomesReported;
  },
  action: function(ctx) {
    ctx.issue.fields.required(ctx.DueDate, workflow.i18n('You must set the Due date!'));
  },
  requirements: {
    DueDate: {
      type: entities.Field.dateType,
      name: "Due Date"
    }
  }
});