var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var entities = require('@jetbrains/youtrack-scripting-api/entities');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Attach duplicate links to single duplicated issue'),
  guard: function(ctx) {
    var issue = ctx.issue;
    return issue.links.duplicates.isChanged || issue.links['is duplicated by'].isChanged || issue.isChanged('duplicateCluster');
  },
  action: function(ctx) {
    var issue = ctx.issue;
    var duplicateRoot = issue.duplicateRoot;
    if (duplicateRoot !== null && duplicateRoot.id !== (issue.links.duplicates.first() || {}).id) {
      workflow.message(workflow.i18n('Link was reattached to {0}', duplicateRoot.id));
      issue.links.duplicates.clear();
      if (issue.id !== duplicateRoot.id) {
        issue.links.duplicates.add(duplicateRoot);
        duplicateRoot.links.duplicates.clear();
      }
    }
  },
  requirements: {
    Duplicate: {
      type: entities.IssueLinkPrototype,
      outward: 'is duplicated by',
      inward: 'duplicates'
    }
  }
});