var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var entities = require('@jetbrains/youtrack-scripting-api/entities');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Reopen issue when all duplicates links are removed'),
  guard: function(ctx) {
    var issue = ctx.issue;
    return issue.fields.State && issue.fields.State.name === ctx.State.Duplicate.name &&
      issue.links.duplicates.removed.isNotEmpty() && issue.links.duplicates.isEmpty();
  },
  action: function(ctx) {
    ctx.issue.fields.State = ctx.State.Open;
  },
  requirements: {
    State: {
      type: entities.State.fieldType,
      Duplicate: {},
      Open: {}
    },
    Duplicate: {
      type: entities.IssueLinkPrototype,
      outward: 'is duplicated by',
      inward: 'duplicates'
    }
  }
});