var entities = require('@jetbrains/youtrack-scripting-api/entities');
var utils = require('./attach-file-utils');

exports.rule = entities.Issue.onChange({
  title: 'Check comment for reference to attachment',
  guard: function(ctx) {
    return !ctx.issue.comments.added.isEmpty();
  },
  action: function(ctx) {
    ctx.issue.comments.added.forEach(function(comment) {
      if (comment.attachments.isEmpty()) {
        utils.findAndShowMessage(comment.text);
      }
    });
  }
});