var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Block incompatible value combinations for custom fields'),
  action: function(ctx) {
    var issueFields = ctx.issue.fields;

    workflow.check(!(issueFields.Priority && issueFields.State &&
      issueFields.Priority.name === ctx.Priority.ShowStopper.name &&
      issueFields.State.name === ctx.State.Submitted.name),
      workflow.i18n('Denied fields combination detected (Submitted Show-stopper)'));

    workflow.check(!(!issueFields.Assignee && issueFields.State &&
      issueFields.State.name === ctx.State.Open.name),
      workflow.i18n('Denied fields combination detected (Open Unassigned)'));
  },
  requirements: {
    Priority: {
      type: entities.EnumField.fieldType,
      ShowStopper: {
        name: 'Show-stopper'
      }
    },
    State: {
      type: entities.State.fieldType,
      Submitted: {},
      Open: {}
    },
    Assignee: {
      type: entities.User.fieldType
    }
  }
});