// The Pomodoro technique is a time management method created by Francesco Cirillo in the 1980s. For details visit http://www.pomodorotechnique.com/
var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Block changes to interruption cause without stopping timer'),
  guard: function(ctx) {
    var issueFields = ctx.issue.fields;
    return issueFields.isChanged(ctx.PomodoroInterruption) && !issueFields.isChanged(ctx.PomodoroState);
  },
  action: function() {
    workflow.check(
      false,
      workflow.i18n('Cannot change the interruption cause without changing the timer state.')
    );
  },
  requirements: {
    'PomodoroInterruption': {
      name: 'Pomodoro interruption',
      type: entities.EnumField.fieldType,
      'Boss interrupted': {},
      'Facebook chat': {},
      'Phone call': {},
      'Urgent email': {}
    },
    'PomodoroState': {
      name: 'Pomodoro state',
      type: entities.EnumField.fieldType
    }
  }
});