var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var profanity = require('./profanity-common');

exports.rule = entities.Issue.onChange({
  title: 'Block descriptions and comments that contain stop words',
  action: function(ctx) {
    var issue = ctx.issue;
    var texts = [];

    function add(text) {
      if (text) {
        texts.push(text);
      }
    }

    issue.getAdded('comments').forEach(function(comment) {
      add(comment.text);
    });

    var becomesReported = issue.becomesReported;

    if (becomesReported || issue.isChanged('summary')) {
      add(issue.summary);
    }

    if (becomesReported || issue.isChanged('description')) {
      add(issue.description);
    }

    texts.forEach(function(text) {
      text = text.toLowerCase();

      profanity.words.forEach(function(badWord) {
        var index = text.indexOf(badWord);

        while (index !== -1) {
          var sepBefore = index === 0 || profanity.separators.indexOf(text.substring(index - 1, index)) > -1;
          var endIndex = index + badWord.length;
          var sepAfter = endIndex === text.length || profanity.separators.indexOf(text.substring(endIndex, endIndex + 1)) > -1;

          workflow.check(!(sepBefore && sepAfter), workflow.i18n('Using the word {0} is prohibited', badWord));

          index = text.indexOf(badWord, endIndex);
        }
      });
    });
  }
});