var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Set subsystem owner as assignee for unassigned issues'),
  guard: function(ctx) {
    return !ctx.issue.fields.Assignee && ctx.issue.fields.Subsystem;
  },
  action: function(ctx) {
    var issue = ctx.issue;
    var fs = issue.fields;
    if ((issue.isReported && (fs.isChanged(ctx.Subsystem) || issue.isChanged('project'))) || issue.becomesReported) {
      if (fs.Subsystem.owner) {
        if (ctx.Assignee.values.has(fs.Subsystem.owner))
          fs.Assignee = fs.Subsystem.owner;
        else
          workflow.message(fs.Subsystem.owner.fullName + " is set as the owner of the " +
            fs.Subsystem.name + " subsystem but isn't included in the list of assignees for issues in this project. " +
            "The workflow that automatically assigns issues to the subsystem owner cannot apply this change.");
      }
    }
  },
  requirements: {
    Assignee: {
      type: entities.User.fieldType
    },
    Subsystem: {
      type: entities.OwnedField.fieldType
    }
  }
});