var entities = require('@jetbrains/youtrack-scripting-api/entities');

exports.rule = entities.Issue.onChange({
  title: 'Set fixed in build for duplicate issues',
  guard: function(ctx) {
    return ctx.issue.fields.isChanged(ctx.FixedInBuild) && ctx.issue.fields.FixedInBuild;
  },
  action: function(ctx) {
    var issue = ctx.issue;
    issue.links['is duplicated by'].forEach(function(duplicate) {
      if (issue.project.name === duplicate.project.name) {
        duplicate.fields[ctx.FixedInBuild.name] = issue.fields.FixedInBuild;
      }
    });
  },
  requirements: {
    FixedInBuild: {
      name: 'Fixed in build',
      type: entities.Build.fieldType
    }
  }
});