var entities = require('@jetbrains/youtrack-scripting-api/entities');
var workflow = require('@jetbrains/youtrack-scripting-api/workflow');
var votes = 'votes';

exports.rule = entities.Issue.onChange({
  title: workflow.i18n('Add project lead to watchers list when an issue receives 10 votes'),
  guard: function(ctx) {
    return ctx.issue.oldValue(votes) <= 9 && ctx.issue[votes] >= 10;
  },
  action: function(ctx) {
    ctx.issue.project.leader.watchIssue(ctx.issue);
  },
  requirements: {}
});