/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.zendesk;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jetbrains.charisma.customfields.complex.common.BundleCustomFieldType;
import jetbrains.charisma.customfields.complex.common.XdBundleProjectCustomField;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.XdProjectCustomField;
import jetbrains.charisma.customfields.persistence.XdProjectCustomFieldKt;
import jetbrains.charisma.customfields.persistence.fields.XdField;
import jetbrains.charisma.customfields.persistence.fields.XdFieldBundle;
import jetbrains.charisma.customfields.plugin.XdCustomFieldType;
import jetbrains.charisma.customfields.simple.common.SimpleCustomFieldType;
import jetbrains.charisma.persistent.CharismaJob;
import jetbrains.exodus.core.crypto.MessageDigestUtil;
import jetbrains.exodus.core.execution.Job;
import jetbrains.exodus.core.execution.JobProcessorAdapter;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.core.legacy.LegacySupportKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.core.persistent.issue.XdProject;
import jetbrains.youtrack.core.persistent.user.XdUser;
import jetbrains.youtrack.core.security.BeansKt;
import jetbrains.youtrack.persistent.XdIssueComment;
import jetbrains.youtrack.zendesk.TicketSharingInfoService;
import jetbrains.youtrack.zendesk.persistent.ExtensionsKt;
import jetbrains.youtrack.zendesk.persistent.XdTicketSharingInfo;
import jetbrains.youtrack.zendesk.rest.integration.NHDRest;
import jetbrains.youtrack.zendesk.rest.integration.resources.UnprocessableEntityException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Service;

@Service(value="ticketSharingInfoService")
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0016\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0014\u001a\u00020\nJ\u001e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\rJ\u0018\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\rJ \u0010\u001d\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"Ljetbrains/youtrack/zendesk/TicketSharingInfoService;", "", "()V", "integrationsJobProcessor", "Ljetbrains/exodus/core/execution/JobProcessorAdapter;", "getIntegrationsJobProcessor", "()Ljetbrains/exodus/core/execution/JobProcessorAdapter;", "addProcessedComments", "", "sharingInfo", "Ljetbrains/youtrack/zendesk/persistent/XdTicketSharingInfo;", "ids", "", "", "findOrCreateCommentUUID", "comment", "Ljetbrains/youtrack/persistent/XdIssueComment;", "getProcessedComments", "", "getTicketStatus", "ticketSharingInfo", "setCustomFieldIfPossible", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "key", "value", "setTicketStatus", "xdTicketSharingInfo", "status", "syncWithZendesk", "author", "Ljetbrains/youtrack/core/persistent/user/XdUser;", "ignoreStatus", "", "Companion", "youtrack-zendesk-integration"})
public class TicketSharingInfoService {
    private static final long JOB_QUEUE_INTERVAL = 60L;
    public static final Companion Companion = new Companion(null);

    private final JobProcessorAdapter getIntegrationsJobProcessor() {
        String name$iv = "integrationsJobProcessor";
        boolean $i$f$getBean = false;
        Object object = ServiceLocator.getBean((String)name$iv);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.core.execution.JobProcessorAdapter");
        }
        return (JobProcessorAdapter)object;
    }

    @Nullable
    public final String getTicketStatus(@NotNull XdTicketSharingInfo ticketSharingInfo) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)ticketSharingInfo), (String)"ticketSharingInfo");
        boolean bl = false;
        boolean bl2 = false;
        XdTicketSharingInfo $this$with = ticketSharingInfo;
        boolean bl3 = false;
        if (!$this$with.getAgreement().getAllowsPublicComments()) {
            return null;
        }
        Object object = $this$with.getAgreement().getStatusField();
        XdField xdField = (XdField)(object != null && (object = object.getPrototype()) != null && (object = object.getValues($this$with.getIssue())) != null ? CollectionsKt.firstOrNull((Iterable)object) : null);
        if (xdField == null) {
            return null;
        }
        XdField value = xdField;
        String string = value.getName();
        boolean bl4 = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        string = string3;
        bl4 = false;
        boolean bl5 = false;
        String $this$with2 = string;
        boolean bl6 = false;
        return XdTicketSharingInfo.Companion.getAVAILABLE_STATUSES().contains($this$with2) ? $this$with2 : null;
    }

    public final void setTicketStatus(@NotNull XdTicketSharingInfo xdTicketSharingInfo, @Nullable String status2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)xdTicketSharingInfo), (String)"xdTicketSharingInfo");
        boolean bl = false;
        boolean bl2 = false;
        XdTicketSharingInfo $this$with = xdTicketSharingInfo;
        boolean bl3 = false;
        if ($this$with.getAgreement().getAllowsPublicComments()) {
            XdFieldBundle bundle;
            XdField xdField;
            if (status2 == null) {
                Companion.getLogger().warn((Function0)setTicketStatus.1.1.INSTANCE);
                throw (Throwable)new UnprocessableEntityException();
            }
            XdProjectCustomField statusField = $this$with.getAgreement().getStatusField();
            if (statusField == null) {
                Companion.getLogger().warn((Function0)setTicketStatus.1.2.INSTANCE);
                throw (Throwable)new UnprocessableEntityException();
            }
            Entity entity = statusField.getBundleEntity();
            if (entity == null) {
                Intrinsics.throwNpe();
            }
            if ((xdField = (bundle = (XdFieldBundle)XdExtensionsKt.toXd((Entity)entity)).findElement(status2)) == null) {
                xdField = bundle.createElement(status2);
            }
            XdField value = xdField;
            statusField.getPrototype().setValue($this$with.getIssue(), (Object)value);
        }
    }

    public final void addProcessedComments(@NotNull XdTicketSharingInfo sharingInfo2, @NotNull Iterable<String> ids) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)sharingInfo2), (String)"sharingInfo");
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        ByteArrayOutputStream $this$with = byteArrayOutputStream;
        boolean bl3 = false;
        try {
            GZIPOutputStream os = new GZIPOutputStream($this$with);
            Iterable $this$forEach$iv = CollectionsKt.plus(this.getProcessedComments(sharingInfo2), ids);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                byte[] byArray;
                String it = (String)element$iv;
                boolean bl4 = false;
                String string = it;
                GZIPOutputStream gZIPOutputStream = os;
                Charset charset = Charsets.UTF_8;
                boolean bl5 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)string2.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
                gZIPOutputStream.write(byArray);
                os.write(10);
            }
            os.close();
        }
        catch (IOException ex) {
            throw (Throwable)new RuntimeException(ex);
        }
        sharingInfo2.setProcessedComments(new ByteArrayInputStream($this$with.toByteArray()));
    }

    @NotNull
    public final Collection<String> getProcessedComments(@NotNull XdTicketSharingInfo sharingInfo2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)sharingInfo2), (String)"sharingInfo");
        boolean bl = false;
        boolean bl2 = false;
        XdTicketSharingInfo $this$with = sharingInfo2;
        boolean bl3 = false;
        boolean bl4 = false;
        HashSet<String> lines = new HashSet<String>();
        String string = $this$with.getCommentMappedToDescriptionUuid();
        if (string != null) {
            String string2 = string;
            boolean bl5 = false;
            boolean bl6 = false;
            String it = string2;
            boolean bl7 = false;
            lines.add(it);
        }
        if ($this$with.getProcessedComments() == null) {
            return lines;
        }
        try {
            GZIPInputStream stream = new GZIPInputStream(sharingInfo2.getProcessedComments());
            Closeable closeable = stream;
            HashSet<String> hashSet = lines;
            Charset charset = Charsets.UTF_8;
            boolean bl8 = false;
            Reader reader = new InputStreamReader((InputStream)closeable, charset);
            closeable = reader;
            int n = 8192;
            bl8 = false;
            reader = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            hashSet.addAll(TextStreamsKt.readLines((Reader)reader));
        }
        catch (IOException ex) {
            throw (Throwable)new RuntimeException(ex);
        }
        return lines;
    }

    @NotNull
    public final String findOrCreateCommentUUID(@NotNull XdTicketSharingInfo sharingInfo2, @NotNull XdIssueComment comment) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)sharingInfo2), (String)"sharingInfo");
        Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
        if (ExtensionsKt.getZendeskCommentUUID(comment) == null) {
            ExtensionsKt.setZendeskCommentUUID(comment, MessageDigestUtil.sha1((String)(sharingInfo2.getSenderUrl() + "comment" + comment.getEntity().toIdString())));
            String string = ExtensionsKt.getZendeskCommentUUID(comment);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.addProcessedComments(sharingInfo2, CollectionsKt.listOf((Object)string));
        }
        String string = ExtensionsKt.getZendeskCommentUUID(comment);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        return string;
    }

    public final void setCustomFieldIfPossible(@NotNull XdIssue issue2, @NotNull String key, @NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        String id = issue2.getIdReadable();
        XdProjectCustomField customField = XdProjectCustomFieldKt.getProjectCustomField((XdProject)issue2.getProject(), (String)key);
        if (customField != null) {
            Companion.getLogger().info((Function0)new Function0<String>(id, value, key){
                final /* synthetic */ String $id;
                final /* synthetic */ String $value;
                final /* synthetic */ String $key;

                @NotNull
                public final String invoke() {
                    return "updating issue " + this.$id + " from zendesk: setting field value '" + this.$value + "' for '" + this.$key + "' field";
                }
                {
                    this.$id = string;
                    this.$value = string2;
                    this.$key = string3;
                    super(0);
                }
            });
            XdCustomFieldPrototype prototype = customField.getPrototype();
            XdCustomFieldType type = prototype.getType();
            if (type instanceof BundleCustomFieldType) {
                XdBundleProjectCustomField bpcf = (XdBundleProjectCustomField)customField;
                XdField xdField = (XdField)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)((XdQuery)bpcf.getBundle().getChildren()), (Function2)((Function2)new Function2<FilteringContext, XdField, XdSearchingNode>(value){
                    final /* synthetic */ String $value;

                    @NotNull
                    public final XdSearchingNode invoke(@NotNull FilteringContext $this$filter, @NotNull XdField it) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$filter, (String)"$receiver");
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return $this$filter.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$value));
                    }
                    {
                        this.$value = string;
                        super(2);
                    }
                })));
                if (xdField == null) {
                    xdField = bpcf.getBundle().createElement(value);
                }
                XdField bundleValue2 = xdField;
                prototype.setValues(issue2, (Iterable)CollectionsKt.listOf((Object)bundleValue2));
            } else {
                Object obj = customField.createValueFromString(value);
                XdCustomFieldType xdCustomFieldType = type;
                if (xdCustomFieldType == null) {
                    throw new TypeCastException("null cannot be cast to non-null type jetbrains.charisma.customfields.simple.common.SimpleCustomFieldType<kotlin.Any>");
                }
                ((SimpleCustomFieldType)xdCustomFieldType).setValue(issue2.getEntity(), prototype.getEntity(), obj);
            }
        }
    }

    public final void syncWithZendesk(@NotNull XdIssue issue2, @NotNull XdUser author, boolean ignoreStatus) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)author, (String)"author");
        XdTicketSharingInfo ticketSharingInfo = ExtensionsKt.getTicketInfo(issue2);
        if (ticketSharingInfo != null) {
            this.getIntegrationsJobProcessor().queueIn((Job)new CharismaJob(author, ticketSharingInfo, ignoreStatus, issue2, issue2.getIdReadable()){
                final /* synthetic */ XdUser $author;
                final /* synthetic */ XdTicketSharingInfo $ticketSharingInfo;
                final /* synthetic */ boolean $ignoreStatus;
                final /* synthetic */ XdIssue $issue;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected void execute() {
                    XdUser user$iv = this.$author;
                    boolean $i$f$runAs = false;
                    Entity user$iv$iv = user$iv.getEntity();
                    boolean $i$f$runAs2 = false;
                    PrincipalManager _principalManager$iv$iv = BeansKt.getPrincipalManager();
                    try {
                        _principalManager$iv$iv.setTemporaryServerPrincipal((Object)user$iv$iv);
                        boolean bl = false;
                        LegacySupportKt.transactional((Function1)((Function1)new Function1<TransientStoreSession, Unit>(this){
                            final /* synthetic */ syncWithZendesk.1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(@NotNull TransientStoreSession it) {
                                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                                new NHDRest(this.this$0.$ticketSharingInfo.getAgreement()).putTicket(this.this$0.$ticketSharingInfo, this.this$0.$ignoreStatus);
                            }
                        }));
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        _principalManager$iv$iv.unsetTemporaryServerPrincipal();
                    }
                }
                {
                    this.$author = $captured_local_variable$0;
                    this.$ticketSharingInfo = $captured_local_variable$1;
                    this.$ignoreStatus = $captured_local_variable$2;
                    this.$issue = $captured_local_variable$3;
                    super($super_call_param$4);
                }
            }, JOB_QUEUE_INTERVAL);
        }
    }

    public static /* synthetic */ void syncWithZendesk$default(TicketSharingInfoService ticketSharingInfoService, XdIssue xdIssue, XdUser xdUser, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: syncWithZendesk");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        ticketSharingInfoService.syncWithZendesk(xdIssue, xdUser, bl);
    }

    static {
        JOB_QUEUE_INTERVAL = 60L;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/youtrack/zendesk/TicketSharingInfoService$Companion;", "Lmu/KLogging;", "()V", "JOB_QUEUE_INTERVAL", "", "youtrack-zendesk-integration"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

