/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.zendesk;

import jetbrains.charisma.persistent.ExternalIssueLinksProvider;
import jetbrains.youtrack.api.l10n.BeansKt;
import jetbrains.youtrack.core.persistent.issue.XdIssue;
import jetbrains.youtrack.zendesk.persistent.ExtensionsKt;
import jetbrains.youtrack.zendesk.persistent.XdAgreement;
import jetbrains.youtrack.zendesk.persistent.XdTicketSharingInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Ljetbrains/youtrack/zendesk/ZendeskIssueLinksProvider;", "Ljetbrains/charisma/persistent/ExternalIssueLinksProvider;", "()V", "name", "", "getName", "()Ljava/lang/String;", "accept", "", "issue", "Ljetbrains/youtrack/core/persistent/issue/XdIssue;", "getCommentsKey", "getCommentsUrl", "getHistoryKey", "getHistoryUrl", "getIssueKey", "getIssueUrl", "agreement", "Ljetbrains/youtrack/zendesk/persistent/XdAgreement;", "ticketId", "", "youtrack-zendesk-integration"})
public final class ZendeskIssueLinksProvider
implements ExternalIssueLinksProvider {
    @NotNull
    private final String name = "Zendesk";

    @NotNull
    public String getName() {
        return this.name;
    }

    public boolean accept(@NotNull XdIssue issue2) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        XdTicketSharingInfo xdTicketSharingInfo = ExtensionsKt.getTicketInfo(issue2);
        if (xdTicketSharingInfo != null) {
            XdTicketSharingInfo xdTicketSharingInfo2 = xdTicketSharingInfo;
            boolean bl2 = false;
            boolean bl3 = false;
            XdTicketSharingInfo it = xdTicketSharingInfo2;
            boolean bl4 = false;
            bl = it.getOriginalId() != 0;
        } else {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public String getIssueKey(@NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        XdTicketSharingInfo xdTicketSharingInfo = ExtensionsKt.getTicketInfo(issue2);
        return "Ticket " + (xdTicketSharingInfo != null ? Integer.valueOf(xdTicketSharingInfo.getOriginalId()) : null);
    }

    @NotNull
    public String getIssueUrl(@NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        XdTicketSharingInfo xdTicketSharingInfo = ExtensionsKt.getTicketInfo(issue2);
        if (xdTicketSharingInfo == null) {
            return "";
        }
        XdTicketSharingInfo sharingInfo2 = xdTicketSharingInfo;
        return this.getIssueUrl(sharingInfo2.getAgreement(), sharingInfo2.getOriginalId());
    }

    @NotNull
    public final String getIssueUrl(@NotNull XdAgreement agreement2, int ticketId) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)agreement2), (String)"agreement");
        return StringsKt.replace$default((String)agreement2.getSenderUrl(), (String)"/sharing", (String)("/agent/tickets/" + ticketId), (boolean)false, (int)4, null);
    }

    @NotNull
    public String getCommentsUrl(@NotNull XdIssue issue2) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
                object = ExtensionsKt.getTicketInfo(issue2);
                if (object == null || (object = object.getAgreement()) == null || (object = ((XdAgreement)((Object)object)).getSenderUrl()) == null) break block2;
                XdTicketSharingInfo xdTicketSharingInfo = ExtensionsKt.getTicketInfo(issue2);
                if ((object = StringsKt.replace$default((String)object, (String)"/sharing", (String)("/agent/tickets/" + (xdTicketSharingInfo != null ? Integer.valueOf(xdTicketSharingInfo.getOriginalId()) : null)), (boolean)false, (int)4, null)) != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public String getCommentsKey(@NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        return BeansKt.getLocalizer().localizedMsgInServerLocale("Zendesk.Shared_ticket_comments_link", new Object[0]);
    }

    @NotNull
    public String getHistoryUrl(@NotNull XdIssue issue2) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
                object = ExtensionsKt.getTicketInfo(issue2);
                if (object == null || (object = object.getAgreement()) == null || (object = ((XdAgreement)((Object)object)).getSenderUrl()) == null) break block2;
                XdTicketSharingInfo xdTicketSharingInfo = ExtensionsKt.getTicketInfo(issue2);
                if ((object = StringsKt.replace$default((String)object, (String)"/sharing", (String)("/agent/tickets/" + (xdTicketSharingInfo != null ? Integer.valueOf(xdTicketSharingInfo.getOriginalId()) : null) + "/events"), (boolean)false, (int)4, null)) != null) break block3;
            }
            object = "";
        }
        return object;
    }

    @NotNull
    public String getHistoryKey(@NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        return BeansKt.getLocalizer().localizedMsgInServerLocale("Zendesk.Shared_ticket_history_link", new Object[0]);
    }
}

