/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import com.jetbrains.launcher.CoreArguments;
import com.jetbrains.launcher.LauncherArgumentsParser;
import com.jetbrains.launcher.LogLevel;
import com.jetbrains.launcher.Static;
import com.jetbrains.launcher.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Arguments
extends CoreArguments {
    @NotNull
    public static final String RUN_ARG = "run";
    @NotNull
    public static final String RERUN_ARG = "rerun";
    @NotNull
    public static final String FROM_SERVICE_ARG = "from-service";
    @NotNull
    public static final String CONFIGURE_ARG = "configure";
    @NotNull
    public static final String DEV_OPTION = "--dev";
    @NotNull
    public static final String DEBUG_OPTION = "--debug";
    @NotNull
    public static final String QUIET_OPTION = "--quiet";
    @NotNull
    public static final String FORCE_OPTION = "--force";
    @NotNull
    public static final String LAUNCHER_OPTION = "--launcher";
    @NotNull
    public static final String APP_OPTION = "--app";
    @NotNull
    public static final String JVM_OPTION_PREFIX_1 = "-J";
    @NotNull
    public static final String JVM_OPTION_PREFIX_2 = "--J";
    @Static
    @NotNull
    private static final Set<String> ourSystemOptions = CollectionUtil.set((Object[])new String[]{"--dev", "--debug", "--quiet", "--force", "--launcher", "--app"});
    @NotNull
    private final String[] myCmdLine;
    @NotNull
    private final LauncherArgumentsParser myParser;
    @NotNull
    private final List<String> myOptions;
    @NotNull
    private final List<String> myJvmOptions1;
    @NotNull
    private final List<String> myJvmOptions2;
    @NotNull
    private final List<String> myLauncherArgs;
    @NotNull
    private final List<String> myApplicationArgs;
    private final boolean myIsEmbeddedMode;

    public Arguments(@NotNull CoreArguments coreArgs, @NotNull String[] cmdLine, @NotNull LauncherArgumentsParser parser, boolean isEmbeddedMode) {
        if (coreArgs == null) {
            Arguments.$$$reportNull$$$0(0);
        }
        if (cmdLine == null) {
            Arguments.$$$reportNull$$$0(1);
        }
        if (parser == null) {
            Arguments.$$$reportNull$$$0(2);
        }
        super(coreArgs.getAppFixedFiles(), coreArgs.isJavaApplication());
        this.myCmdLine = cmdLine;
        this.myParser = parser;
        this.myOptions = new ArrayList<String>();
        this.myJvmOptions1 = new ArrayList<String>();
        this.myJvmOptions2 = new ArrayList<String>();
        this.myLauncherArgs = new ArrayList<String>();
        this.myApplicationArgs = new ArrayList<String>();
        this.myIsEmbeddedMode = isEmbeddedMode;
        LauncherArgumentsParser.State state = parser.getInitialState();
        for (String arg : cmdLine) {
            if (state != null) {
                if (ourSystemOptions.contains(arg)) {
                    this.myOptions.add(arg);
                    continue;
                }
                if (coreArgs.isJavaApplication()) {
                    if (arg.startsWith(JVM_OPTION_PREFIX_1)) {
                        this.myJvmOptions1.add(arg.substring(JVM_OPTION_PREFIX_1.length()));
                        continue;
                    }
                    if (arg.startsWith(JVM_OPTION_PREFIX_2)) {
                        this.myJvmOptions2.add(arg.substring(JVM_OPTION_PREFIX_2.length()));
                        continue;
                    }
                }
                if ((state = state.next(arg)) != null) {
                    this.myLauncherArgs.add(arg);
                    continue;
                }
            }
            this.myApplicationArgs.add(arg);
        }
    }

    @NotNull
    public Arguments withCmdLine(String ... newCmdLine) {
        if (newCmdLine == null) {
            Arguments.$$$reportNull$$$0(3);
        }
        Arguments arguments = new Arguments(this, newCmdLine, this.myParser, this.myIsEmbeddedMode);
        if (arguments == null) {
            Arguments.$$$reportNull$$$0(4);
        }
        return arguments;
    }

    @NotNull
    public String[] getCmdLine() {
        if (this.myCmdLine == null) {
            Arguments.$$$reportNull$$$0(5);
        }
        return this.myCmdLine;
    }

    @Nullable
    public String getCommandName() {
        return (String)CollectionUtil.getOrNull(this.getAllArgs(), (int)0);
    }

    @Nullable
    public String getSubCommandName(int index) {
        return (String)CollectionUtil.getOrNull(this.getAllArgs(), (int)index);
    }

    @NotNull
    private List<String> getAllArgs() {
        ArrayList<String> arrayList = new ArrayList<String>(){
            {
                this.addAll(Arguments.this.myLauncherArgs);
                this.addAll(Arguments.this.myApplicationArgs);
            }
        };
        if (arrayList == null) {
            Arguments.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public List<String> getApplicationArguments() {
        List<String> list = Collections.unmodifiableList(this.myApplicationArgs);
        if (list == null) {
            Arguments.$$$reportNull$$$0(7);
        }
        return list;
    }

    public boolean isEmbeddedMode() {
        return this.myIsEmbeddedMode;
    }

    @NotNull
    public LogLevel getLogLevel() {
        LogLevel logLevel = this.containsOption(QUIET_OPTION) ? LogLevel.WARN : (this.containsOption(DEBUG_OPTION) ? LogLevel.DEBUG : LogLevel.INFO);
        if (logLevel == null) {
            Arguments.$$$reportNull$$$0(8);
        }
        return logLevel;
    }

    public boolean isStartedFromService() {
        return this.containsLauncherParam(FROM_SERVICE_ARG);
    }

    public boolean isSyncRun() {
        return this.containsLauncherParam(RUN_ARG) || this.containsLauncherParam(RERUN_ARG);
    }

    public boolean isConsole() {
        return this.isSyncRun() && !this.isStartedFromService();
    }

    @NotNull
    public List<String> getJvmOptions1() {
        List<String> list = Collections.unmodifiableList(this.myJvmOptions1);
        if (list == null) {
            Arguments.$$$reportNull$$$0(9);
        }
        return list;
    }

    @NotNull
    public List<String> getJvmOptions2() {
        List<String> list = Collections.unmodifiableList(this.myJvmOptions2);
        if (list == null) {
            Arguments.$$$reportNull$$$0(10);
        }
        return list;
    }

    public boolean containsLauncherParam(@NotNull String param) {
        if (param == null) {
            Arguments.$$$reportNull$$$0(11);
        }
        return this.myLauncherArgs.contains(param);
    }

    public boolean containsDevOption() {
        return this.containsOption(DEV_OPTION);
    }

    public boolean containsForceOption() {
        return this.containsOption(FORCE_OPTION);
    }

    public boolean containsLauncherOption() {
        return this.containsOption(LAUNCHER_OPTION);
    }

    public boolean containsAppOption() {
        return this.containsOption(APP_OPTION);
    }

    private boolean containsOption(@NotNull String option) {
        if (option == null) {
            Arguments.$$$reportNull$$$0(12);
        }
        return this.myOptions.contains(option);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreArgs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newCmdLine";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/Arguments";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/Arguments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "withCmdLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCmdLine";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllArgs";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationArguments";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogLevel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmOptions1";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getJvmOptions2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withCmdLine";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "containsLauncherParam";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "containsOption";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

