/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleProperties;
import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.Services;
import com.jetbrains.bundle.exceptions.BundleStartupException;
import com.jetbrains.bundle.exceptions.LauncherOutdatedConfigException;
import com.jetbrains.bundle.exceptions.RequiringShutdownException;
import com.jetbrains.bundle.exceptions.ServicesAlreadyStartedException;
import com.jetbrains.bundle.util.BundleJvmOption;
import com.jetbrains.bundle.util.CompressUtil;
import com.jetbrains.bundle.wizard.ConfigurationFileWatcher;
import com.jetbrains.bundle.wizard.WizardConfiguredProperties;
import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.ConfiguringService;
import com.jetbrains.launcher.RunningService;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.contexts.ApplicationContext;
import com.jetbrains.launcher.contexts.ConfiguringContext;
import com.jetbrains.launcher.contexts.ShutdownContext;
import com.jetbrains.launcher.contexts.StartupContext;
import com.jetbrains.launcher.contexts.StatusContext;
import com.jetbrains.launcher.exceptions.ConfiguringException;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.DeleteFileVisitor;
import com.jetbrains.service.util.PropertiesUtil;
import com.jetbrains.service.util.ServiceUtil;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.SystemUtil;
import com.jetbrains.service.util.Version;
import com.jetbrains.service.util.cmd.CmdUtil;
import com.jetbrains.service.util.cmd.ExecutionContext;
import com.jetbrains.service.util.cmd.ExecutionResult;
import com.jetbrains.service.util.logging.JavaUtilLoggingToSlf4jBridge;
import com.jetbrains.service.util.logging.log4j.LoggingUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleMain
implements ConfiguringService,
RunningService {
    private final Logger LOG;
    private static final String BUNDLE_PROCESS_LOGS_DIR_SYSTEM_PROPERTY = "bundleProcess.logs.dir";
    private BundleState myBundleState;

    public BundleMain(@NotNull ApplicationContext context) {
        LoggingUtil.setupConsoleLogging((boolean)context.getLogSettings().getLogLevel().isDebugEnabled());
        this.LOG = LoggerFactory.getLogger(this.getClass());
        JavaUtilLoggingToSlf4jBridge.install();
    }

    public void configure(@NotNull ConfiguringContext context) throws ConfiguringException {
        Throwable confException = null;
        try {
            this.myBundleState = this.createBundleState((ApplicationContext)context);
            this.configure(PropertiesUtil.convertToProperties((Map)context.getProperties()));
        }
        catch (ServicesAlreadyStartedException e) {
            confException = e;
            String errMessage = String.format("%s runtime environment was successfully configured, but configuration was not propagated to all services because some of them are still running. Normally, that is not a problem - configuration changes will be propagated to those services on the next start. Configure command might be executed one more time with additional property --%s=true if configuration should be applied to all services and it can not wait till next start by some reason. All started services %s will be stopped in that case.", this.getBundlePresentationName(), "force.services.shutdown", e.getStartedServiceNames());
            this.LOG.warn(errMessage);
        }
        catch (Throwable e) {
            confException = e;
            throw e;
        }
        finally {
            if (this.myBundleState != null) {
                this.myBundleState.onConfigureFinished(confException);
                this.myBundleState = null;
            }
        }
    }

    private BundleState createBundleState(ApplicationContext context) {
        BundleEnvironment environment = new BundleEnvironment(context.getAppFiles().getAppHome().toPath());
        BundleState bundleState = new BundleState(environment, context, UUID.randomUUID().toString());
        WizardConfiguredProperties wizardConfiguredProperties = new WizardConfiguredProperties(bundleState.getEnvironment());
        bundleState.updateBundleConfigFromWizard(wizardConfiguredProperties);
        this.restoreBundleSettingsFromService(bundleState);
        return bundleState;
    }

    private void restoreBundleSettingsFromService(BundleState state) {
        Throwable throwable;
        DirectoryStream<Path> stream;
        if (!state.getUpgradeProperties().isCleanInstallationInProgress()) {
            return;
        }
        Path serviceConfigPropertiesPath = state.getEnvironment().getConfDir().resolve("service-config.properties");
        if (!Files.exists(serviceConfigPropertiesPath, new LinkOption[0])) {
            return;
        }
        Properties serviceConfigProperties = ConfiguratorUtils.loadPropertiesFile((File)serviceConfigPropertiesPath.toFile());
        String serviceId = serviceConfigProperties.getProperty("id");
        if (serviceId == null) {
            this.LOG.warn("File service-config.properties without property [id] is found in root product conf directory. Skipping that config file");
            return;
        }
        state.getProperties().restorePropertiesFromServiceConfig(serviceConfigProperties);
        String serviceFolderName = null;
        try {
            stream = Files.newDirectoryStream(state.getEnvironment().getBundleHome().resolve("apps"));
            throwable = null;
            try {
                for (Path servicePath : stream) {
                    Properties serviceDescriptorProperties;
                    Path serviceDescriptorPath = servicePath.resolve("service.properties");
                    if (!Files.exists(serviceDescriptorPath, new LinkOption[0]) || !serviceId.equals((serviceDescriptorProperties = ConfiguratorUtils.loadPropertiesFile((File)serviceDescriptorPath.toFile())).getProperty("id"))) continue;
                    serviceFolderName = servicePath.getFileName().toString();
                    break;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.LOG.debug("Exception while loading service configs to be restored", (Throwable)e);
            return;
        }
        if (serviceFolderName == null) {
            this.LOG.warn(String.format("File service-config.properties belonging to unknown service %s is found in root product conf directory. Skipping that config file", serviceId));
            return;
        }
        try {
            stream = Files.newDirectoryStream(state.getEnvironment().getConfDir());
            throwable = null;
            try {
                for (Path path : stream) {
                    String fileName = path.getFileName().toString();
                    if (path.equals(state.getEnvironment().getInternalConfDir()) || fileName.equals(serviceId) || fileName.endsWith(".dist")) continue;
                    Files.move(path, state.getEnvironment().getConfDir().resolve(serviceId).resolve(fileName), new CopyOption[0]);
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stream != null) {
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stream.close();
                    }
                }
            }
        }
        catch (IOException e) {
            this.LOG.debug("Exception while moving restored service configs into a service conf folder", (Throwable)e);
            return;
        }
    }

    @NotNull
    private Services configure(@Nullable Properties unattendedProperties) {
        this.myBundleState.setStatus(Status.CONFIGURING);
        this.myBundleState.getProperties().consoleConfigure(unattendedProperties);
        this.afterBundleConfigured();
        if (this.myBundleState.isStartingMode()) {
            if (ServiceUtil.canConnectToLocalPort((int)this.myBundleState.getProperties().getListenPort())) {
                throw new StatusException(String.format("Port %s is already used by another program", this.myBundleState.getProperties().getListenPort()));
            }
            if (!ServiceUtil.canListenOn((String)this.myBundleState.getProperties().getListenAddress(), (int)this.myBundleState.getProperties().getListenPort(), (boolean)true)) {
                throw new StatusException("Could not listen on " + this.myBundleState.getProperties().getListenAddress() + ":" + this.myBundleState.getProperties().getListenPort());
            }
        }
        Services services = Services.createServices(this.myBundleState);
        services.configure();
        return services;
    }

    private void assertHubVersion() {
        Map<String, ServiceDescriptor> bundleServices = Services.getBundleServices(this.myBundleState);
        ServiceDescriptor hubServiceDescriptor = bundleServices.get("hub");
        if (hubServiceDescriptor != null) {
            String bundleVersion = this.myBundleState.getBuildProperties().getBundleVersion();
            String hubVersion = hubServiceDescriptor.getVersion();
            String minimalHubVersion = this.myBundleState.getBuildProperties().getMinimalHubVersion();
            if (!(minimalHubVersion == null || Version.parseVersion((String)minimalHubVersion) == null || hubVersion.startsWith("dev") || Version.parseVersion((String)hubVersion) != null && Version.parseVersion((String)hubVersion).isGreaterOrEqual(minimalHubVersion))) {
                throw new IllegalStateException(String.format("Bundle of version %s requires Hub of version >= %s, but Hub of version %s is given!", bundleVersion, minimalHubVersion, hubVersion));
            }
        }
    }

    @NotNull
    public StatusDescriptor getStatus(@NotNull StatusContext statusContext) {
        return BundleState.getStatus(this.myBundleState);
    }

    public void start(@NotNull StartupContext context) throws StartupException {
        Throwable startException = null;
        try {
            this.myBundleState = this.createBundleState((ApplicationContext)context);
            this.start(true);
        }
        catch (LauncherOutdatedConfigException e) {
            startException = e;
        }
        catch (RequiringShutdownException e) {
            startException = e;
            this.LOG.debug(String.format("Shutdown with parameters [shutdownExitCode=%s, soft=%s] is requested on startup", e.getShutdownExitCode(), e.isSoftFlag()), (Throwable)e);
            this.myBundleState.getContextHolder().requestShutdown(e.getShutdownExitCode(), e.isSoftFlag());
        }
        catch (BundleStartupException e) {
            startException = e;
            this.LOG.debug(String.format("Failed to start %s. Startup exception with exit code %s occurred", this.getBundlePresentationName(), e.getExitCode().getValue()), (Throwable)e);
            throw e.convertToStartupException();
        }
        catch (Throwable e) {
            startException = e;
            String errorMessage = String.format("Failed to start %s due to unexpected exception: %s", this.getBundlePresentationName(), e.getMessage());
            this.LOG.debug(errorMessage, e);
            throw new StartupException(errorMessage, e);
        }
        finally {
            if (this.myBundleState != null) {
                this.myBundleState.onStartFinished(startException);
            }
        }
    }

    public void start(boolean fromLauncher) throws StartupException {
        boolean shouldStartConfigurationWizard;
        Services services = this.configure((Properties)null);
        this.myBundleState.setServices(services);
        this.myBundleState.setStatus(Status.STARTING);
        this.myBundleState.getServices().start(fromLauncher);
        if (fromLauncher) {
            this.logActualEnvironmentInfo(this.myBundleState);
        }
        if (shouldStartConfigurationWizard = this.myBundleState.getServices().getServiceDescriptorsMap().containsKey("configurationWizard")) {
            this.startWizardCompletionListener();
            this.restartServices();
        }
    }

    private void startWizardCompletionListener() {
        ConfigurationFileWatcher watcher = new ConfigurationFileWatcher();
        try {
            watcher.awaitConfigFile(WizardConfiguredProperties.getConfigFilePath(this.myBundleState.getEnvironment()).toString());
        }
        catch (IOException | InterruptedException e) {
            throw new StatusException("File created by ConfigurationWizard is not accessible", (Throwable)e);
        }
        WizardConfiguredProperties wizardConfiguredProperties = new WizardConfiguredProperties(this.myBundleState.getEnvironment());
        this.myBundleState.updateBundleConfigFromWizard(wizardConfiguredProperties, true);
        wizardConfiguredProperties.registerConfiguredProductVersion(this.myBundleState);
        if (!wizardConfiguredProperties.exists()) {
            throw new StatusException("Configuration has not been finished by Wizard");
        }
    }

    @NotNull
    public AppExitCode shutdown(@NotNull ShutdownContext context) {
        return this.shutdown(!context.isSoft(), context.getSuggestedExitCode());
    }

    @NotNull
    private AppExitCode shutdown(boolean force, @NotNull AppExitCode suggestedExitCode) {
        if (this.myBundleState == null) {
            this.LOG.info("Shut down is called before application has started initializing.");
            return suggestedExitCode;
        }
        if (this.myBundleState.getServices() != null) {
            try {
                this.myBundleState.getServices().stop(force, suggestedExitCode);
            }
            catch (Exception e) {
                this.LOG.warn(String.format("Some services failed to stop: %s", e.getMessage()), (Throwable)e);
            }
        } else {
            this.LOG.debug("Shutdown is called, but services have not been initialized yet");
        }
        return suggestedExitCode;
    }

    public void restartServices() throws StartupException {
        this.shutdown(false, AppExitCode.EXIT);
        this.start(false);
    }

    private void setTempDir() {
        try {
            SystemUtil.setTempDir((Path)this.myBundleState.getProperties().getAbsoluteBundleDirectory(BundleProperties.FolderType.TEMP));
        }
        catch (IOException e) {
            this.LOG.warn(String.format("Cannot set temp dir for %s", this.getBundlePresentationName()), (Throwable)e);
        }
    }

    private void afterBundleConfigured() {
        this.checkFreePhysicalMemory();
        this.assertHubVersion();
        this.checkBundleAppFoldersAreWritable();
        this.setTempDir();
        this.restoreDistFiles();
        this.myBundleState.updateLauncherConfig();
        this.redirectLoggingToFiles(this.myBundleState);
    }

    private void checkFreePhysicalMemory() {
        OperatingSystemMXBean operatingSystemMXBean;
        if (this.myBundleState.getBuildProperties().isFreePhysicalMemoryCheckRequired() && (operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean()) instanceof com.sun.management.OperatingSystemMXBean) {
            long freeMemoryInBytes = ((com.sun.management.OperatingSystemMXBean)operatingSystemMXBean).getFreePhysicalMemorySize();
            long xmx = Runtime.getRuntime().maxMemory();
            if (xmx < Long.MAX_VALUE && xmx > freeMemoryInBytes) {
                throw new StatusException(String.format("Application can not be started, it requires %s megabytes of RAM (physical memory), but only %s is free", xmx >> 20, freeMemoryInBytes >> 20));
            }
        }
    }

    private void restoreDistFiles() {
        boolean upgradeOrCleanInstallation;
        Path distRestoredMarkerPath = this.myBundleState.getEnvironment().getConfDir().resolve(".dist.restored");
        boolean distRestoredMarkerExists = Files.exists(distRestoredMarkerPath, new LinkOption[0]);
        boolean bl = upgradeOrCleanInstallation = this.myBundleState.getUpgradeProperties().isCleanInstallationInProgress() || this.myBundleState.getUpgradeProperties().isUpgrade();
        if (upgradeOrCleanInstallation || !distRestoredMarkerExists) {
            try {
                CompressUtil.uncompressZip((Path)this.myBundleState.getEnvironment().getDistConfigs().toPath(), (Path)this.myBundleState.getEnvironment().getConfDir(), (DirectoryStream.Filter)new DirectoryStream.Filter<Path>(){

                    @Override
                    public boolean accept(Path entry) throws IOException {
                        return !Files.exists(entry, new LinkOption[0]) || upgradeOrCleanInstallation && entry.toFile().getName().endsWith(".dist");
                    }
                });
                if (!distRestoredMarkerExists) {
                    try {
                        Files.createFile(distRestoredMarkerPath, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        this.LOG.warn("Filed to create .dist.restored marker file", (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                this.LOG.warn(String.format("Filed to uncompress dist files from %s", this.myBundleState.getEnvironment().getDistConfigs()), (Throwable)e);
            }
        }
    }

    private void checkBundleAppFoldersAreWritable() {
        ArrayList<String> errors = new ArrayList<String>();
        for (BundleProperties.FolderType folderType : BundleProperties.FolderType.values()) {
            Path folderPath = this.myBundleState.getProperties().getAbsoluteBundleDirectory(folderType);
            String errorMessage = SystemUtil.checkFolderIsWritable((File)folderPath.toFile());
            if (errorMessage == null) continue;
            errors.add(errorMessage);
        }
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String errorMessage : errors) {
                sb.append(errorMessage).append(System.lineSeparator());
                this.LOG.error(errorMessage);
            }
            throw new StatusException("The following issues were identified with configured application folders: " + sb);
        }
    }

    public static void main(String[] args) throws Exception {
        BundleMain.main_cleanInstallation(Paths.get(args[0], new String[0]));
    }

    private static void main_cleanInstallation(Path installationHome) throws IOException {
        BundleMain.main_deletePath(installationHome.resolve("conf").resolve("internal"));
        BundleMain.main_deletePath(installationHome.resolve("backups"));
        BundleMain.main_deletePath(installationHome.resolve("data"));
        BundleMain.main_deletePath(installationHome.resolve("logs"));
        BundleMain.main_deletePath(installationHome.resolve("temp"));
        Files.walkFileTree(installationHome, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return super.postVisitDirectory(dir, exc);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.getFileName().toFile().getName().endsWith(".config")) {
                    Files.delete(file);
                }
                if (file.toFile().getName().equals("from.bundle.properties")) {
                    Files.delete(file);
                }
                if (file.toFile().getName().equals("cassandra.properties")) {
                    Files.delete(file);
                }
                if (file.toFile().getName().equals("service-config.properties")) {
                    Files.delete(file);
                }
                return super.visitFile(file, attrs);
            }
        });
    }

    private static void main_deletePath(Path path) throws IOException {
        if (Files.exists(path, new LinkOption[0])) {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new DeleteFileVisitor());
        }
    }

    private Object getScreenedValue(@NotNull Object keyObj, @NotNull Map map) {
        if (keyObj instanceof String) {
            String key = (String)keyObj;
            return key.contains("secret") || key.contains("password") || key.contains("license") ? "*******" : map.get(key);
        }
        return map.get(keyObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void logActualEnvironmentInfo(@NotNull BundleState bundleState) {
        block18: {
            BufferedWriter envInfoWriter;
            block17: {
                if (Boolean.valueOf(BundleJvmOption.DISABLE_ENV_INFO_LOGGING.get()).booleanValue()) {
                    return;
                }
                Path environmentInfoFilePath = bundleState.getProperties().getLogsDirectory("bundleProcess", true).resolve("environment.log");
                try {
                    envInfoWriter = Files.newBufferedWriter(environmentInfoFilePath, Charset.forName("UTF-8"), StandardOpenOption.CREATE);
                }
                catch (IOException e) {
                    this.LOG.debug(String.format("Failed to create environment info log file: %s", e.getMessage()), (Throwable)e);
                    return;
                }
                TreeMap<Object, Object> systemProperties = new TreeMap<Object, Object>(System.getProperties());
                BundleMain.write(envInfoWriter, "### System Properties: ");
                for (Object sysPropName : systemProperties.keySet()) {
                    BundleMain.write(envInfoWriter, String.format("%s=%s", sysPropName, this.getScreenedValue(sysPropName, systemProperties)));
                }
                BundleMain.write(envInfoWriter, "### End of System Properties.");
                BundleMain.write(envInfoWriter, "");
                TreeMap<String, String> env = new TreeMap<String, String>(System.getenv());
                BundleMain.write(envInfoWriter, "### Environment variables: ");
                for (String envPropName : env.keySet()) {
                    BundleMain.write(envInfoWriter, String.format("%s=%s", envPropName, this.getScreenedValue(envPropName, env)));
                }
                BundleMain.write(envInfoWriter, "### End of Environment Variables.");
                BundleMain.write(envInfoWriter, "");
                if (SystemUtil.isLinux()) {
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "uname", Collections.singletonList("-a"));
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "free", null);
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "df", null);
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "/bin/sh", Arrays.asList("-c", "ulimit -a"));
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "hostname", null);
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "hostname", Collections.singletonList("-f"));
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "id", Collections.singletonList("-a"));
                    break block17;
                }
                if (SystemUtil.isMac()) {
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "uname", Collections.singletonList("-a"));
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "df", Collections.singletonList("-H"));
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "hostinfo", null);
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "hostname", null);
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "hostname", Collections.singletonList("-s"));
                    BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "id", Collections.singletonList("-p"));
                    break block17;
                }
                if (!SystemUtil.isWindows()) break block17;
                BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "wmic", Arrays.asList("logicaldisk", "get", "size,freespace,caption"));
                BundleMain.logCmdOutput(envInfoWriter, bundleState, null, "wmic", Arrays.asList("OS", "get", "TotalVisibleMemorySize,FreePhysicalMemory"));
            }
            try {
                envInfoWriter.close();
            }
            catch (IOException e) {
                this.LOG.debug(String.format("Failed to log full environment information: %s", e.getMessage()), (Throwable)e);
            }
            break block18;
            catch (Exception e) {
                try {
                    this.LOG.debug(String.format("Failed to log full environment information: %s", e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        envInfoWriter.close();
                    }
                    catch (IOException e2) {
                        this.LOG.debug(String.format("Failed to log full environment information: %s", e2.getMessage()), (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    envInfoWriter.close();
                }
                catch (IOException e3) {
                    this.LOG.debug(String.format("Failed to log full environment information: %s", e3.getMessage()), (Throwable)e3);
                }
            }
        }
    }

    private static void logCmdOutput(@NotNull BufferedWriter envInfoWriter, @NotNull BundleState bundleState, ExecutionContext ctx, String cmd, List<String> commandArguments) throws IOException {
        if (ctx == null) {
            ExecutionContext defaultExecutionCtx = new ExecutionContext();
            defaultExecutionCtx.put(ExecutionContext.Param.executionTimeoutInMillis, (Object)1000);
            defaultExecutionCtx.put(ExecutionContext.Param.outputWaitTimeoutInMillis, (Object)200);
            defaultExecutionCtx.put(ExecutionContext.Param.logOutputToConsole, (Object)false);
            ctx = defaultExecutionCtx;
        }
        if (commandArguments == null) {
            commandArguments = Collections.emptyList();
        }
        try {
            ExecutionResult result = CmdUtil.executeCommandWithExitCode((String)cmd, (Path)bundleState.getEnvironment().getBundleHome(), (String)bundleState.getBuildProperties().getBundlePresentationName(), commandArguments, Collections.emptyList(), (ExecutionContext)ctx);
            if (!result.myCommandOutput.isEmpty()) {
                BundleMain.write(envInfoWriter, String.format("Output of command [%s]: %s", CmdUtil.buildCommand((String)cmd, commandArguments), result.myCommandOutput));
            }
        }
        catch (Exception e) {
            BundleMain.write(envInfoWriter, String.format("Can not execute command [%s]: %s", CmdUtil.buildCommand((String)cmd, commandArguments), e.getMessage()));
        }
    }

    private static void write(BufferedWriter envInfoWriter, String message) throws IOException {
        envInfoWriter.write("* ");
        envInfoWriter.write(message);
        envInfoWriter.newLine();
    }

    private void redirectLoggingToFiles(@NotNull BundleState bundleState) {
        Path log4jXmlPath;
        Path jarPath;
        Path logsDirectory = bundleState.getProperties().getLogsDirectory("bundleProcess", true);
        logsDirectory.toFile().mkdirs();
        if (!logsDirectory.toFile().isDirectory()) {
            throw new RuntimeException("Could not create logs directory: " + logsDirectory);
        }
        System.setProperty(BUNDLE_PROCESS_LOGS_DIR_SYSTEM_PROPERTY, logsDirectory.toString());
        System.setProperty("root.bundle.logs.dir", bundleState.getProperties().getAbsoluteBundleDirectory(BundleProperties.FolderType.LOGS).toString());
        try {
            jarPath = Paths.get(BundleMain.class.getProtectionDomain().getCodeSource().getLocation().toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        Path path = log4jXmlPath = !bundleState.getContextHolder().isDebugEnabled() ? jarPath.getParent().resolve("log4j.xml") : jarPath.getParent().resolve("log4j.debug.xml");
        if (!Files.isReadable(log4jXmlPath)) {
            this.LOG.error(String.format("log4j.xml is not found at %s", log4jXmlPath));
            return;
        }
        this.LOG.info(String.format("Loading logging configuration from %s", log4jXmlPath));
        this.LOG.info(String.format("Redirecting %s logging to %s", bundleState.getBuildProperties().getBundlePresentationName(), logsDirectory));
        LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
        context.setConfigLocation(log4jXmlPath.toUri());
    }

    @NotNull
    private String getBundlePresentationName() {
        return this.myBundleState != null ? this.myBundleState.getBuildProperties().getBundlePresentationName() : "Application";
    }
}

