/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleBuildProperties;
import com.jetbrains.bundle.BundleConsoleLogger;
import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.api.exceptions.BundleBackendException;
import com.jetbrains.bundle.api.internal.backend.impl.ErrorInfoCreator;
import com.jetbrains.bundle.api.model.ErrorInfo;
import com.jetbrains.bundle.client.error.BundleBackendErrorCode;
import com.jetbrains.bundle.client.error.ErrorMessageCreator;
import com.jetbrains.bundle.exceptions.BadConfigurationException;
import com.jetbrains.bundle.hub_client.util.HubClientProvider;
import com.jetbrains.bundle.hub_client.util.validation.AdditionalKeystore;
import com.jetbrains.bundle.hub_client.util.validation.UntrustedServerCertificateException;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.bundle.listener.OnePerClassListener;
import com.jetbrains.bundle.listener.event.ConfigureFinishedEvent;
import com.jetbrains.bundle.listener.event.StartFinishedEvent;
import com.jetbrains.bundle.util.tls.KeyStoreGenerationException;
import com.jetbrains.bundle.util.tls.KeyStoreGenerator;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.DeleteFileVisitor;
import com.jetbrains.service.util.PropertiesUtil;
import com.jetbrains.service.util.SecureMode;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.ServiceUtil;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.SystemUtil;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.VirtualHostsDefault;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import com.jetbrains.service.util.ssl.KeystoreUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleProperties {
    private static final String ALLOCATED_PORT_PREFIX = "port-base.";
    static final String FORCE_SHUTDOWN_INTERNAL_PROPERTY = "force.services.shutdown";
    private static final String DEFAULT_ROOT_USER = "admin";
    private static final String EXTERNAL_HUB_CERT_ALIAS_PREFIX = "hubext-";
    private static final BundleProperty[] ALL_REQUIRED_PROPERTIES = new BundleProperty[]{BundleProperty.LISTEN_PORT, BundleProperty.LISTEN_ADDRESS, BundleProperty.BASE_URL, FolderType.DATA.getBundleProperty(), FolderType.BACKUPS.getBundleProperty(), FolderType.LOGS.getBundleProperty(), FolderType.TEMP.getBundleProperty(), BundleProperty.INSTALLATION_UUID, BundleProperty.INSTALLATION_DIR, BundleProperty.CURRENT_PRODUCT_VERSION, BundleProperty.ROOT_USER, BundleProperty.ADDITIONAL_KEYSTORE_PATH, BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD, BundleProperty.SECURE_MODE};
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final Properties myProperties = new Properties();
    private final BundleEnvironment myEnvironment;
    private final BundleBuildProperties myBuildProperties;
    private final ApplicationContextHolder myContextHolder;

    public BundleProperties(BundleEnvironment environment, ApplicationContextHolder contextHolder, BundleBuildProperties buildProperties) {
        this.myEnvironment = environment;
        this.myContextHolder = contextHolder;
        this.myBuildProperties = buildProperties;
        Path bundleConfig = this.myEnvironment.getBundleConfig();
        if (Files.isReadable(bundleConfig)) {
            this.LOG.debug(String.format("Reading config from %s", bundleConfig));
            this.reloadProperties();
        } else {
            this.LOG.debug(String.format("config either does not exists or is not readable at %s", bundleConfig));
        }
    }

    private void reloadProperties() {
        try {
            Properties reloadedProperties = ConfiguratorUtils.loadPropertiesFile((File)this.myEnvironment.getBundleConfig().toFile());
            this.myProperties.clear();
            this.myProperties.putAll((Map<?, ?>)reloadedProperties);
        }
        catch (StatusException e) {
            throw new BadConfigurationException("Could not load config from " + this.myEnvironment.getBundleConfig() + ": " + e.getMessage(), e);
        }
    }

    void consoleConfigure(@Nullable Properties unattendedProperties) {
        if (!this.myContextHolder.isRestart()) {
            BundleConsoleLogger.get().info(String.format("Configuring %s", this.myBuildProperties.getBundlePresentationName()));
        }
        Properties oldProperties = (Properties)this.myProperties.clone();
        if (unattendedProperties != null) {
            this.setNewValues(unattendedProperties);
        }
        this.setDefaultValues();
        this.detectAndResolveInconsistencies(unattendedProperties, oldProperties);
        List<String> notConfiguredProperties = this.notConfiguredProperties();
        if (notConfiguredProperties != null) {
            throw new BadConfigurationException("Internal Error: required properties" + notConfiguredProperties + "where not configured on #configure phase");
        }
        if (unattendedProperties != null) {
            this.validateUnattendedPortAndAddress(unattendedProperties);
        }
        this.mergeSecureFiles(unattendedProperties);
        this.trustExternalHubIfRequested();
        if (this.isConfigurationChanged(oldProperties)) {
            this.saveConfig();
        }
        BundleConsoleLogger.get().info("{} runtime environment is successfully configured", (Object)this.myBuildProperties.getBundlePresentationName());
    }

    private void validateUnattendedPortAndAddress(@NotNull Properties unattendedProperties) {
        String port = unattendedProperties.getProperty(BundleProperty.LISTEN_PORT.getName());
        String address = unattendedProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getName());
        if (port != null && address != null) {
            if (!ServiceUtil.isPortAvailable((String)address, (int)Integer.parseInt(port), (boolean)true)) {
                throw new BadConfigurationException(String.format("Could not listen on address {%s} and port {%s}. Please specify another listen address in property %s and port in property %s", address, port, BundleProperty.LISTEN_ADDRESS.getName(), BundleProperty.LISTEN_PORT.getName()));
            }
        } else {
            if (port != null && !ServiceUtil.isPortAvailable((String)this.myProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getName()), (int)Integer.parseInt(port), (boolean)true)) {
                throw new BadConfigurationException(String.format("Could not listen on port {%s}. Please specify another listen port in property %s", port, BundleProperty.LISTEN_PORT.getName()));
            }
            if (address != null && !ServiceUtil.isPortAvailable((String)address, (int)Integer.parseInt(this.myProperties.getProperty(BundleProperty.LISTEN_PORT.getName())), (boolean)true)) {
                throw new BadConfigurationException(String.format("Could not listen on address {%s} %s. Please specify another listen address in property %s", address, "0.0.0.0".equals(address) ? "(any port)" : "", BundleProperty.LISTEN_ADDRESS.getName()));
            }
        }
    }

    private boolean isConfigurationChanged(@NotNull Properties oldProperties) {
        if (this.myProperties.size() != oldProperties.size()) {
            return true;
        }
        for (String name : this.myProperties.stringPropertyNames()) {
            if (!oldProperties.containsKey(name)) {
                return true;
            }
            if (oldProperties.getProperty(name).equals(this.myProperties.getProperty(name))) continue;
            return true;
        }
        return false;
    }

    void setNewValues(@NotNull Properties unattendedProperties) {
        for (String key : unattendedProperties.stringPropertyNames()) {
            String shortBundlePropertyName;
            String unattendedPropertyValue = unattendedProperties.getProperty(key);
            if (!BundleProperty.isBundleProperty((String)key)) {
                if (!FORCE_SHUTDOWN_INTERNAL_PROPERTY.equals(key)) {
                    throw new BadConfigurationException(String.format("The property %s is unknown and could not be set by configure command", key));
                }
            } else {
                BundleProperty property = BundleProperty.getSimplePropertyByName((String)key);
                if (property != null && property.isComputable()) {
                    throw new BadConfigurationException(String.format("The property %s is computable and could not be set by configure command", key));
                }
            }
            String string = shortBundlePropertyName = key.startsWith("bundle.") ? key.substring("bundle.".length()) : key;
            if (BundleProperty.VIRTUAL_HOSTS_DEFAULT.getName().equals(shortBundlePropertyName) && VirtualHostsDefault.fromName((String)unattendedPropertyValue) == null) {
                throw new BadConfigurationException(String.format("Property %s has unexpected value %s. The following values are allowed %s", key, unattendedPropertyValue, new HashSet(VirtualHostsDefault.getNames())));
            }
            if (BundleProperty.TRUST_EXTERNAL_HUB.getName().equals(shortBundlePropertyName) && !"true".equalsIgnoreCase(unattendedPropertyValue) && !"false".equalsIgnoreCase(unattendedPropertyValue)) {
                throw new BadConfigurationException(String.format("Property %s has unexpected value %s. The following values are allowed %s", key, unattendedPropertyValue, Arrays.asList("true", "false")));
            }
            BundleConsoleLogger.get().info(String.format("Setting property '%s' to '%s' from arguments", shortBundlePropertyName, unattendedPropertyValue));
            this.myProperties.setProperty(shortBundlePropertyName, unattendedPropertyValue);
        }
    }

    void setDefaultValues() {
        String existingBaseUrl;
        if (this.myProperties.getProperty(BundleProperty.SECURE_MODE.getName()) == null) {
            this.myProperties.setProperty(BundleProperty.SECURE_MODE.getName(), SecureMode.DISABLE.getName());
        }
        String secureMode = this.myProperties.getProperty(BundleProperty.SECURE_MODE.getName());
        if (this.myProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getName()) == null) {
            String installationListenAddress = this.myEnvironment.getInstallationConfig().getListenAddress();
            if (installationListenAddress != null) {
                this.myProperties.setProperty(BundleProperty.LISTEN_ADDRESS.getName(), installationListenAddress);
            } else {
                this.myProperties.setProperty(BundleProperty.LISTEN_ADDRESS.getName(), "0.0.0.0");
            }
        }
        if (this.myProperties.getProperty(BundleProperty.LISTEN_PORT.getName()) == null) {
            int resolvedPort;
            Integer installationPort = this.myEnvironment.getInstallationConfig().getInstallationPort();
            if (installationPort != null) {
                resolvedPort = installationPort;
            } else {
                String baseUrl = this.myProperties.getProperty(BundleProperty.BASE_URL.getName());
                if (!this.isBundleUrlNotSetOrContainsContextOnly(baseUrl)) {
                    String infoMessage = String.format("Property %s was set but %s was not, %s should be set either by calling command %s configure --listen-port=<xxxxx> --base-url=<yyyyy>", BundleProperty.BASE_URL.getName(), BundleProperty.LISTEN_PORT.getName(), BundleProperty.LISTEN_PORT.getName(), this.myContextHolder.getBundleScriptFile().toString());
                    throw new BadConfigurationException(infoMessage);
                }
                String listenAddress = this.myProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getName());
                resolvedPort = this.findFreePort(listenAddress, SecureMode.TLS.getName().equals(secureMode));
            }
            this.myProperties.setProperty(BundleProperty.LISTEN_PORT.getName(), String.valueOf(resolvedPort));
        }
        if (this.myProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT.getName()) == null && SecureMode.TLS.getName().equals(secureMode) && this.isTlsRedirectionFromHttpEnabled()) {
            String listenAddress = this.myProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getName());
            int port = this.findFreePort(listenAddress, false);
            this.myProperties.setProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT.getName(), String.valueOf(port));
        }
        if (this.isBundleUrlNotSetOrContainsContextOnly(existingBaseUrl = this.myProperties.getProperty(BundleProperty.BASE_URL.getName()))) {
            String baseUrl = this.constructDefaultBaseUrl(true, existingBaseUrl);
            this.myProperties.setProperty(BundleProperty.BASE_URL.getName(), baseUrl);
        }
        if (this.myProperties.getProperty(FolderType.DATA.getBundleProperty().getName()) == null) {
            this.myProperties.setProperty(FolderType.DATA.getBundleProperty().getName(), FolderType.DATA.getDefaultFolderName());
        }
        if (this.myProperties.getProperty(FolderType.BACKUPS.getBundleProperty().getName()) == null) {
            this.myProperties.setProperty(FolderType.BACKUPS.getBundleProperty().getName(), FolderType.BACKUPS.getDefaultFolderName());
        }
        if (this.myProperties.getProperty(FolderType.LOGS.getBundleProperty().getName()) == null) {
            this.myProperties.setProperty(FolderType.LOGS.getBundleProperty().getName(), FolderType.LOGS.getDefaultFolderName());
        }
        if (this.myProperties.getProperty(FolderType.TEMP.getBundleProperty().getName()) == null) {
            this.myProperties.setProperty(FolderType.TEMP.getBundleProperty().getName(), FolderType.TEMP.getDefaultFolderName());
        }
        if (this.myProperties.getProperty(BundleProperty.INSTALLATION_UUID.getName()) == null) {
            this.myProperties.setProperty(BundleProperty.INSTALLATION_UUID.getName(), UUID.randomUUID().toString());
        }
        if (this.myProperties.getProperty(BundleProperty.ROOT_USER.getName()) == null) {
            this.myProperties.setProperty(BundleProperty.ROOT_USER.getName(), DEFAULT_ROOT_USER);
        }
        if (this.myProperties.getProperty(BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD.getName()) == null) {
            this.myProperties.setProperty(BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD.getName(), ConfiguratorUtils.randomAlphanumeric((int)10));
        }
    }

    public int findFreePort(@NotNull String listenAddress, boolean tls) {
        return this.findFreePort(listenAddress, tls, null);
    }

    int findFreePort(@NotNull String listenAddress, boolean tls, Integer portToStartFrom) {
        int port;
        int defaultPort;
        int n = defaultPort = tls ? 443 : 80;
        if (SystemUtil.isWindows() && ServiceUtil.isPortAvailable((String)listenAddress, (int)defaultPort, (boolean)false)) {
            return defaultPort;
        }
        int n2 = portToStartFrom != null ? portToStartFrom : (port = tls ? 8443 : 8080);
        while (!ServiceUtil.isPortAvailable((String)listenAddress, (int)port, (boolean)false)) {
            ++port;
        }
        return port;
    }

    private boolean isBundleUrlNotSetOrContainsContextOnly(@Nullable String baseUrl) {
        return baseUrl == null || baseUrl.startsWith("/");
    }

    private void detectAndResolveInconsistencies(@Nullable Properties unattendedProperties, @NotNull Properties oldProperties) {
        boolean wasDefaultBaseUrl;
        if (unattendedProperties != null && unattendedProperties.containsKey(BundleProperty.LISTEN_PORT.getName()) && this.isBundleUrlNotSetOrContainsContextOnly(unattendedProperties.getProperty(BundleProperty.BASE_URL.getName())) && oldProperties.containsKey(BundleProperty.LISTEN_PORT.getName()) && (wasDefaultBaseUrl = this.isDefaultBaseUrl(Integer.parseInt(oldProperties.getProperty(BundleProperty.LISTEN_PORT.getName())), oldProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getName())))) {
            String baseUrl = this.constructDefaultBaseUrl(true);
            this.myProperties.setProperty(BundleProperty.BASE_URL.getName(), baseUrl);
        }
    }

    @NotNull
    public Map<BundleProperty, String> updatePropertyInRuntime(@NotNull String property, @NotNull String value, boolean skipValidation) throws BundleBackendException {
        Map<BundleProperty, String> updatedProperties = this.tryUpdatePropertyInRuntime(property, value, skipValidation);
        Iterator<BundleProperty> it = updatedProperties.keySet().iterator();
        while (it.hasNext()) {
            String newPropertyValue;
            BundleProperty updatedProperty = it.next();
            String oldPropertyValue = this.myProperties.getProperty(updatedProperty.getName());
            if (!Objects.equals(oldPropertyValue, newPropertyValue = updatedProperties.get(updatedProperty))) {
                this.myProperties.setProperty(updatedProperty.getName(), newPropertyValue);
                continue;
            }
            it.remove();
        }
        if (!updatedProperties.isEmpty()) {
            this.saveConfig();
        }
        return updatedProperties;
    }

    @NotNull
    public Map<BundleProperty, String> tryUpdatePropertyInRuntime(@NotNull String property, @NotNull String value, boolean skipValidation) throws BundleBackendException {
        BundleProperty bundleProperty = BundleProperty.getSimplePropertyByName((String)property);
        if (bundleProperty == null) {
            throw new BundleBackendException(property, (ErrorInfo)BundleBackendErrorCode.UNKNOWN_PROPERTY.toError(Collections.singletonMap("property", property), (ErrorMessageCreator)ErrorInfoCreator.get()));
        }
        if (skipValidation && bundleProperty != BundleProperty.BASE_URL) {
            throw new BundleBackendException(property, (ErrorInfo)BundleBackendErrorCode.SKIPPING_VALIDATION_IS_NOT_ALLOWED.toError(Collections.singletonMap("property", property), (ErrorMessageCreator)ErrorInfoCreator.get()));
        }
        HashMap<BundleProperty, String> updatedProperties = new HashMap<BundleProperty, String>();
        if (bundleProperty == BundleProperty.BASE_URL) {
            String newBaseUrlAsString;
            URL newBaseUrl;
            try {
                newBaseUrl = new URL(value);
            }
            catch (MalformedURLException e) {
                throw new BundleBackendException(bundleProperty.getPrefixedName(), (ErrorInfo)BundleBackendErrorCode.MALFORMED_URL.toError((ErrorMessageCreator)ErrorInfoCreator.get()));
            }
            String queryString = newBaseUrl.getQuery();
            if (!StringUtils.isEmpty((CharSequence)queryString)) {
                throw new BundleBackendException(bundleProperty.getPrefixedName(), (ErrorInfo)BundleBackendErrorCode.BASE_URL_SHOULD_NOT_CONTAIN_QUERY_PARAMETERS.toError((ErrorMessageCreator)ErrorInfoCreator.get()));
            }
            if (!skipValidation) {
                this.validateBaseUrlContextOnUpdate(newBaseUrl);
            }
            if (!(newBaseUrlAsString = newBaseUrl.toString()).equals(this.getBaseUrl())) {
                updatedProperties.put(BundleProperty.BASE_URL, newBaseUrlAsString);
            }
        } else if (bundleProperty == BundleProperty.BACKUPS_DIR) {
            Path newPath;
            try {
                newPath = Paths.get(value, new String[0]);
            }
            catch (InvalidPathException e) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("path", value);
                throw new BundleBackendException(bundleProperty.getPrefixedName(), (ErrorInfo)BundleBackendErrorCode.INVALID_PATH.toError(parameters, (ErrorMessageCreator)ErrorInfoCreator.get()));
            }
            Path currentBackupsDir = this.getAbsoluteBundleDirectory(FolderType.BACKUPS);
            if (!currentBackupsDir.equals(newPath)) {
                updatedProperties.put(BundleProperty.BACKUPS_DIR, BundleProperties.getPropertyValueInInternalFormat(BundleProperty.BACKUPS_DIR.getName(), newPath.toString(), this.myEnvironment));
            }
        } else {
            throw new BundleBackendException(bundleProperty.getPrefixedName(), (ErrorInfo)BundleBackendErrorCode.UNCHANGEABLE_AT_RUNTIME_PROPERTY.toError(Collections.singletonMap("property", bundleProperty.getPrefixedName()), (ErrorMessageCreator)ErrorInfoCreator.get()));
        }
        return updatedProperties;
    }

    private void validateBaseUrlContextOnUpdate(@NotNull URL newBaseUrl) throws BundleBackendException {
        String newContext = newBaseUrl.getPath();
        String currentBundleContext = this.getContext();
        if (!UrlUtil.trimSlashes((String)newContext).equals(UrlUtil.trimSlashes((String)currentBundleContext))) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("currentContext", currentBundleContext);
            parameters.put("newContext", UrlUtil.trimSlashes((String)newContext).isEmpty() ? "empty context" : newContext);
            throw new BundleBackendException(BundleProperty.BASE_URL.getPrefixedName(), (ErrorInfo)BundleBackendErrorCode.BASE_URL_CONTEXT_DOES_NOT_MATCH.toError(parameters, (ErrorMessageCreator)ErrorInfoCreator.get()));
        }
    }

    String removeLegacyProductVersion() {
        String value = (String)this.myProperties.remove(BundleProperty.PRODUCT_VERSION.getName());
        if (value != null) {
            this.saveConfig();
        }
        return value;
    }

    private boolean removeProperty(String propertyName) {
        return this.myProperties.remove(propertyName) != null;
    }

    private boolean removeRootCredentials() {
        Object removedValue = this.myProperties.remove(BundleProperty.ROOT_PASSWORD.getName());
        return removedValue != null;
    }

    @NotNull
    Collection<String> updatePropertiesByWizard(Properties properties) {
        this.reloadProperties();
        HashSet<String> overriddenBundleProperties = new HashSet<String>();
        for (String propName : properties.stringPropertyNames()) {
            if (!propName.startsWith("bundle")) continue;
            overriddenBundleProperties.add(propName);
        }
        boolean defaultBaseUrlWasSetBefore = this.isDefaultBaseUrl();
        boolean isDirty = false;
        for (String propName : overriddenBundleProperties) {
            String bundlePropertyName = propName.substring("bundle".length() + 1);
            String oldValue = this.myProperties.getProperty(bundlePropertyName);
            String newValue = properties.getProperty(propName);
            if ((oldValue != null || newValue == null) && (oldValue == null || oldValue.equals(newValue))) continue;
            this.myProperties.setProperty(bundlePropertyName, newValue);
            isDirty = true;
            if (!defaultBaseUrlWasSetBefore || overriddenBundleProperties.contains(BundleProperty.BASE_URL.getPrefixedName())) continue;
            this.recalculateBaseUrl(bundlePropertyName);
        }
        if (isDirty) {
            this.saveConfig();
        }
        return overriddenBundleProperties;
    }

    void restorePropertiesFromServiceConfig(Properties serviceProperties) {
        boolean isDirty = false;
        isDirty |= this.restoreServiceProperty(serviceProperties, "port", BundleProperty.LISTEN_PORT);
        isDirty |= this.restoreServiceProperty(serviceProperties, "listen", BundleProperty.LISTEN_ADDRESS);
        String baseUrl = serviceProperties.getProperty("base-url");
        if (baseUrl != null && baseUrl.startsWith("https")) {
            this.myProperties.setProperty(BundleProperty.BASE_URL.getName(), baseUrl);
            isDirty = true;
        } else {
            String context = serviceProperties.getProperty("context");
            if (context != null && !context.equals("/")) {
                this.myProperties.setProperty(BundleProperty.BASE_URL.getName(), this.constructDefaultBaseUrl(true, context));
                isDirty = true;
            }
        }
        HashMap<String, BundleProperty> dirPropertiesMapping = new HashMap<String, BundleProperty>();
        dirPropertiesMapping.put(ServiceProperties.LOGS_DIR_PROPERTY, BundleProperty.LOGS_DIR);
        dirPropertiesMapping.put(ServiceProperties.TEMP_DIR_PROPERTY, BundleProperty.TEMP_DIR);
        dirPropertiesMapping.put(ServiceProperties.DATA_DIR_PROPERTY, BundleProperty.DATA_DIR);
        dirPropertiesMapping.put(ServiceProperties.BACKUPS_DIR_PROPERTY, BundleProperty.BACKUPS_DIR);
        isDirty |= this.restoreDirectoriesFromServiceConfig(serviceProperties, dirPropertiesMapping);
        isDirty |= this.restoreServiceProperty(serviceProperties, "jetty.virtualHosts.names", BundleProperty.VIRTUAL_HOSTS);
        if (Boolean.parseBoolean(serviceProperties.getProperty("jetty.virtualHosts.override"))) {
            this.myProperties.setProperty(BundleProperty.VIRTUAL_HOSTS_DEFAULT.getName(), VirtualHostsDefault.NONE.getName());
            isDirty = true;
        }
        if (isDirty) {
            this.saveConfig();
        }
    }

    private boolean restoreDirectoriesFromServiceConfig(Properties serviceProperties, Map<String, BundleProperty> map) {
        HashMap<String, Path> paths = new HashMap<String, Path>();
        try {
            for (String serviceProperty : map.keySet()) {
                String dir = serviceProperties.getProperty(serviceProperty);
                if (dir == null) continue;
                paths.put(serviceProperty, Paths.get(dir, new String[0]));
            }
        }
        catch (InvalidPathException e) {
            this.LOG.debug("Failed to resolve directories from service configs. Using default values...");
            return false;
        }
        boolean isDirty = false;
        if (paths.size() > 1 && !BundleProperties.hasCommonParent(paths.values())) {
            for (String serviceProperty : paths.keySet()) {
                isDirty |= this.restoreServiceProperty(serviceProperties, serviceProperty, map.get(serviceProperty));
            }
        }
        return isDirty;
    }

    private static boolean hasCommonParent(Collection<Path> paths) {
        ArrayList<Path> parents = new ArrayList<Path>();
        for (Path path : paths) {
            if (path == null) continue;
            if (!parents.contains(path.getParent())) {
                parents.add(path.getParent());
            }
            if (parents.size() <= 1) continue;
            return false;
        }
        return true;
    }

    private boolean restoreServiceProperty(@NotNull Properties serviceProperties, @NotNull String portProperty, @NotNull BundleProperty bundleProperty) {
        String servicePropertyValue = serviceProperties.getProperty(portProperty);
        if (servicePropertyValue != null && !servicePropertyValue.equals(this.myProperties.getProperty(bundleProperty.getName()))) {
            this.myProperties.setProperty(bundleProperty.getName(), BundleProperties.getPropertyValueInInternalFormat(bundleProperty.getName(), servicePropertyValue, this.myEnvironment));
            return true;
        }
        return false;
    }

    public boolean isDefaultBaseUrl() {
        if (!this.containsProperty(BundleProperty.LISTEN_PORT) || !this.containsProperty(BundleProperty.LISTEN_ADDRESS)) {
            return true;
        }
        return this.isDefaultBaseUrl(Integer.parseInt(this.myProperties.getProperty(BundleProperty.LISTEN_PORT.getName())), this.myProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getName()));
    }

    private boolean isDefaultBaseUrl(int port, String listenAddress) {
        URL currentBaseUrl;
        if (this.isBundleUrlNotSetOrContainsContextOnly(this.myProperties.getProperty(BundleProperty.BASE_URL.getName()))) {
            return true;
        }
        try {
            currentBaseUrl = new URL(this.myProperties.getProperty(BundleProperty.BASE_URL.getName()));
        }
        catch (MalformedURLException e) {
            return true;
        }
        try {
            String defaultBaseUrl = this.constructDefaultBaseUrl(false, port, listenAddress, currentBaseUrl.getFile());
            return UrlUtil.trimSlashes((String)currentBaseUrl.toString()).equalsIgnoreCase(UrlUtil.trimSlashes((String)defaultBaseUrl));
        }
        catch (BadConfigurationException e) {
            return true;
        }
    }

    private void recalculateBaseUrl(String propertyName) {
        URL url;
        if (!BundleProperty.LISTEN_PORT.getName().equals(propertyName)) {
            return;
        }
        String baseUrl = this.getBaseUrl();
        try {
            url = new URL(baseUrl);
        }
        catch (MalformedURLException e) {
            this.LOG.error("Can not parse base url [{}]", (Object)baseUrl, (Object)e);
            return;
        }
        String newBaseUrl = baseUrl;
        String newPort = this.myProperties.getProperty(BundleProperty.LISTEN_PORT.getName());
        try {
            url = new URL(url.getProtocol(), url.getHost(), Integer.parseInt(newPort), url.getFile());
            newBaseUrl = url.toString().toLowerCase();
        }
        catch (NumberFormatException | MalformedURLException e) {
            this.LOG.error("Can not set new port [{}] in base url [{}]. ", new Object[]{newPort, baseUrl, e});
        }
        if (!baseUrl.equalsIgnoreCase(newBaseUrl)) {
            this.myProperties.setProperty(BundleProperty.BASE_URL.getName(), newBaseUrl);
        }
    }

    private void saveConfig() {
        PropertiesUtil.saveConfig((Path)this.myEnvironment.getBundleConfig(), (Properties)this.myProperties, (String)String.format("Bundle Settings. Don't update this file manually, use command line API instead: %s configure --propertyName=newValue", this.myContextHolder.getBundleScriptFile().toString()), (boolean)true);
    }

    List<String> notConfiguredProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        for (BundleProperty property : ALL_REQUIRED_PROPERTIES) {
            if (property.isComputable() || this.myProperties.getProperty(property.getName()) != null) continue;
            properties.add(property.getName());
        }
        return properties.isEmpty() ? null : properties;
    }

    Set<Integer> getAllocatedPorts() {
        HashSet<Integer> result = new HashSet<Integer>();
        for (String name : this.myProperties.stringPropertyNames()) {
            if (!name.startsWith(ALLOCATED_PORT_PREFIX)) continue;
            String value = this.myProperties.getProperty(name);
            this.checkPortPrefixValue(name, value);
            result.add(Integer.parseInt(value));
        }
        return result;
    }

    Integer getAllocatedPort(String id) {
        String value = this.myProperties.getProperty(ALLOCATED_PORT_PREFIX + id);
        if (value == null) {
            return null;
        }
        this.checkPortPrefixValue(id, value);
        return Integer.valueOf(value);
    }

    private void checkPortPrefixValue(String id, String value) {
        if (!value.endsWith("0")) {
            throw new BadConfigurationException("Port base should end with '0' for id " + id);
        }
    }

    void setAllocatedPort(String id, int port) {
        String value = Integer.toString(port);
        this.checkPortPrefixValue(id, value);
        this.myProperties.setProperty(ALLOCATED_PORT_PREFIX + id, value);
        this.saveConfig();
    }

    String constructDefaultBaseUrl(boolean shouldBeLogged) throws BadConfigurationException {
        return this.constructDefaultBaseUrl(shouldBeLogged, null);
    }

    String constructDefaultBaseUrl(boolean shouldBeLogged, String context) throws BadConfigurationException {
        if (!this.containsProperty(BundleProperty.LISTEN_PORT)) {
            throw new BadConfigurationException(String.format("Failed to calculate default base URL, property [%s] is undefined", BundleProperty.LISTEN_PORT.getName()));
        }
        if (!this.containsProperty(BundleProperty.LISTEN_ADDRESS)) {
            throw new BadConfigurationException(String.format("Failed to calculate default base URL, property [%s] is undefined", BundleProperty.LISTEN_ADDRESS.getName()));
        }
        return this.constructDefaultBaseUrl(shouldBeLogged, Integer.parseInt(this.myProperties.getProperty(BundleProperty.LISTEN_PORT.getName())), this.myProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getName()), context);
    }

    @NotNull
    String constructDefaultBaseUrl(boolean shouldBeLogged, int listenPort, String listenAddress, String context) {
        String hostname = "0.0.0.0".equals(listenAddress) ? (this.isDockerInstallation() ? "localhost" : SystemUtil.getMostSuitableHostName()) : listenAddress;
        String baseUrl = UrlUtil.constructUrl((String)"http", (String)hostname, (int)listenPort, (String)(context != null ? context : "/"));
        if (shouldBeLogged) {
            BundleConsoleLogger.get().info("Made default {} '{}' from hostname '{}' and listen port '{}'", new Object[]{BundleProperty.BASE_URL.getName(), baseUrl, hostname, listenPort});
        }
        return baseUrl;
    }

    private boolean isDockerInstallation() {
        return BundleInstallationType.DOCKER == this.myEnvironment.getInstallationConfig().getInstallationType();
    }

    @NotNull
    public String getBaseUrl() {
        this.assertConfigured();
        return this.myProperties.getProperty(BundleProperty.BASE_URL.getName());
    }

    @NotNull
    public String getRootUser() {
        this.assertConfigured();
        return this.myProperties.getProperty(BundleProperty.ROOT_USER.getName());
    }

    @NotNull
    public String getInstallationUuid() {
        this.assertConfigured();
        return this.myProperties.getProperty(BundleProperty.INSTALLATION_UUID.getName());
    }

    @Nullable
    public String getLocale() {
        return this.myProperties.getProperty(BundleProperty.LOCALE.getName());
    }

    private void assertConfigured() {
        if (this.notConfiguredProperties() != null) {
            throw new BadConfigurationException(this.myBuildProperties.getBundlePresentationName() + " is not configured yet");
        }
    }

    @NotNull
    Path getDataDirectory(@NotNull String serviceId, boolean isInternalService) {
        this.assertConfigured();
        return this.getDirectory(serviceId, FolderType.DATA, isInternalService);
    }

    @NotNull
    Path getBackupsDirectory(@NotNull String serviceId, boolean isInternalService) {
        this.assertConfigured();
        return this.getDirectory(serviceId, FolderType.BACKUPS, isInternalService);
    }

    @NotNull
    private Path getDirectory(@NotNull String serviceId, @NotNull FolderType folderType, boolean isInternalService) {
        this.assertConfigured();
        Path bundleDirectory = this.getAbsoluteBundleDirectory(folderType);
        return this.resolveRelativeServicePath(bundleDirectory, serviceId, isInternalService);
    }

    private Path resolveRelativeServicePath(@NotNull Path rootPath, @NotNull String serviceId, boolean isInternalService) {
        return !isInternalService ? rootPath.resolve(serviceId) : this.myEnvironment.getInternalServicesDir(rootPath).resolve(serviceId);
    }

    @NotNull
    public Path getAbsoluteBundleDirectory(@NotNull FolderType folderType) {
        this.assertConfigured();
        Path bundleDirPath = Paths.get(this.myProperties.getProperty(folderType.getBundleProperty().getName()), new String[0]);
        return BundleProperties.getAbsoluteBundleDirectory(bundleDirPath, this.myEnvironment);
    }

    @NotNull
    private static Path getAbsoluteBundleDirectory(@NotNull Path path, @NotNull BundleEnvironment bundleEnvironment) {
        return path.isAbsolute() ? path : bundleEnvironment.getApplicationDataRootDirectory().resolve(path);
    }

    @NotNull
    public Path getDefaultAbsoluteBundleDirectory(@NotNull FolderType folderType) {
        Path bundleDirPath = Paths.get(folderType.getDefaultFolderName(), new String[0]);
        return BundleProperties.getAbsoluteBundleDirectory(bundleDirPath, this.myEnvironment);
    }

    String getHubUrl() {
        this.assertConfigured();
        return this.myProperties.getProperty(BundleProperty.HUB_URL.getName());
    }

    public boolean isServiceEnabled(@NotNull String serviceId) {
        return this.myBuildProperties.isServiceEnabled(serviceId) && !Boolean.parseBoolean(this.myProperties.getProperty(BundleProperty.constructDisableServiceProperty((String)serviceId, (boolean)false)));
    }

    public boolean isBundleProductEntropyCheckRequired() {
        String entropyCheckBundleProperty = this.myProperties.getProperty(BundleProperty.ENTROPY_CHECK_FLAG.getName());
        return entropyCheckBundleProperty != null ? Boolean.parseBoolean(entropyCheckBundleProperty) : this.myBuildProperties.isBundleProductEntropyCheckRequired();
    }

    @Nullable
    public Boolean isAnonymousAccessAllowed() {
        String propertyValue = this.myProperties.getProperty(BundleProperty.ALLOW_ANONYMOUS_ACCESS.getName());
        return propertyValue != null ? Boolean.valueOf(propertyValue) : null;
    }

    boolean hubCanBeUsedByExternalServices() {
        return this.myBuildProperties.hubCanBeUsedByExternalServices();
    }

    @NotNull
    public String getAdditionalKeystorePath() {
        return this.myEnvironment.getAdditionalKeystorePath().toString();
    }

    @NotNull
    public String getAdditionalKeystorePassword() {
        return this.myProperties.getProperty(BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD.getName());
    }

    void resetInternalPortsProperties() {
        Set<String> propertiesName = this.myProperties.stringPropertyNames();
        for (String name : propertiesName) {
            if (!name.startsWith(ALLOCATED_PORT_PREFIX)) continue;
            this.removeProperty(name);
        }
    }

    @NotNull
    public Path getLogsDirectory(@NotNull String serviceId, boolean isInternalService) {
        this.assertConfigured();
        return this.getDirectory(serviceId, FolderType.LOGS, isInternalService);
    }

    @NotNull
    Path getTempDirectory(@NotNull String serviceId, boolean isInternalService) {
        this.assertConfigured();
        return this.getDirectory(serviceId, FolderType.TEMP, isInternalService);
    }

    public int getListenPort() {
        this.assertConfigured();
        try {
            return Integer.parseInt(this.myProperties.getProperty(BundleProperty.LISTEN_PORT.getName()));
        }
        catch (NumberFormatException e) {
            throw new BadConfigurationException("Can not parse port number from property [" + BundleProperty.LISTEN_PORT.getName() + "]", e);
        }
    }

    public String getNonSecureRedirectListenPort() {
        return this.myProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT.getName());
    }

    @NotNull
    public String getSecureMode() {
        this.assertConfigured();
        return this.myProperties.getProperty(BundleProperty.SECURE_MODE.getName());
    }

    public boolean isTlsRedirectionFromHttpEnabled() {
        return Boolean.parseBoolean(this.myProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG.getName()));
    }

    @Nullable
    public String getTlsServerCertKeyStorePassword() {
        return this.myProperties.getProperty(BundleProperty.TLS_SERVER_CERT_KEYSTORE_PASSWORD.getName());
    }

    @Nullable
    public String getTlsServerCertKeyStoreAlias() {
        return this.myProperties.getProperty(BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_ALIAS.getName());
    }

    @Nullable
    public String getTlsServerCertKeyStoreKeyPassword() {
        return this.myProperties.getProperty(BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_PASSWORD.getName());
    }

    @NotNull
    public String getListenAddress() {
        this.assertConfigured();
        return this.myProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getName());
    }

    @NotNull
    public String getContext() {
        this.assertConfigured();
        String baseUrl = this.getBaseUrl();
        try {
            String path = new URL(baseUrl).getPath();
            return "/" + UrlUtil.trimSlashes((String)path);
        }
        catch (MalformedURLException e) {
            throw new BadConfigurationException("Could not parse base url: " + baseUrl);
        }
    }

    Properties getAllProperties() {
        Properties properties = new Properties();
        for (String name : this.myProperties.stringPropertyNames()) {
            properties.setProperty(name, this.myProperties.getProperty(name));
        }
        properties.setProperty(BundleProperty.ADDITIONAL_KEYSTORE_PATH.getName(), this.getAdditionalKeystorePath());
        properties.setProperty(BundleProperty.INSTALLATION_DIR.getName(), this.myEnvironment.getBundleHome().toString());
        properties.setProperty(BundleProperty.CURRENT_PRODUCT_VERSION.getName(), this.myBuildProperties.getProductFullVersionNumber());
        return properties;
    }

    @NotNull
    public String getFullServiceUrlPath(@NotNull ServiceDescriptor descriptor) {
        return this.getFullServiceUrlPath(descriptor.getContext());
    }

    @NotNull
    public String getFullServiceUrlPath(String serviceContextPath) {
        return UrlUtil.combineContexts((String)this.getContext(), (String)serviceContextPath);
    }

    boolean shouldShutdownServicesOnConfigure() {
        return Boolean.parseBoolean(this.myProperties.getProperty(FORCE_SHUTDOWN_INTERNAL_PROPERTY));
    }

    @NotNull
    public String getServiceUrl(@NotNull ServiceDescriptor descriptor) {
        return UrlUtil.trimSlashes((String)(UrlUtil.ensureEndsWithSlash((String)this.getBaseUrl()) + UrlUtil.trimSlashes((String)descriptor.getContext())));
    }

    public void switchToExternalHub(@NotNull String externalHubUrl) {
        this.myProperties.setProperty(BundleProperty.HUB_URL.getName(), externalHubUrl);
        this.myProperties.setProperty(BundleProperty.constructDisableServiceProperty((String)"hub", (boolean)false), Boolean.TRUE.toString());
        this.saveConfig();
    }

    public void switchToInternalHub() {
        if (!this.myBuildProperties.isServiceEnabled("hub")) {
            throw new RuntimeException(String.format("Can not enable internal Hub. It is disabled in at build time config: %s", this.myEnvironment.getBundleBuildConfig()));
        }
        this.myProperties.setProperty(BundleProperty.constructDisableServiceProperty((String)"hub", (boolean)false), Boolean.FALSE.toString());
        this.myProperties.remove(BundleProperty.HUB_URL.getName());
        this.saveConfig();
    }

    public static void main(String[] args) throws Exception {
        Thread t = new Thread(() -> {
            try {
                ServerSocket serverSocket = new ServerSocket(80);
                serverSocket.accept();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        t.start();
        Thread t2 = new Thread(() -> {
            try {
                ServerSocket serverSocket = new ServerSocket(8080);
                serverSocket.accept();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        t2.start();
        t.join();
        t2.join();
    }

    private static boolean removeTemporaryProperties(@NotNull BundleProperties bundleProperties) {
        boolean isDirty = false;
        for (BundleProperty property : BundleProperty.values()) {
            if (!property.isComputable() && !property.isTransient()) continue;
            isDirty |= bundleProperties.removeProperty(property.getName());
        }
        return isDirty |= bundleProperties.removeTemporaryTlsSettings();
    }

    public String getPropertyValueInExternalFormat(@NotNull String propertyName) {
        String value = this.myProperties.getProperty(propertyName);
        return BundleProperties.getPropertyValueInExternalFormat(propertyName, value, this.myEnvironment);
    }

    private boolean containsProperty(@NotNull BundleProperty property) {
        return BundleProperties.containsProperty(this.myProperties, property);
    }

    private static boolean containsProperty(@NotNull Properties properties, @NotNull BundleProperty property) {
        return properties.containsKey(property.getName());
    }

    public static String getPropertyValueInExternalFormat(@NotNull String propertyName, String propertyValue, @NotNull BundleEnvironment bundleEnvironment) {
        if (propertyValue == null) {
            return null;
        }
        FolderType folderType = FolderType.resolve(propertyName);
        if (folderType != null) {
            return BundleProperties.getAbsoluteBundleDirectory(Paths.get(propertyValue, new String[0]), bundleEnvironment).toString();
        }
        String resultValue = propertyValue;
        return resultValue;
    }

    @NotNull
    public static String getPropertyValueInInternalFormat(@NotNull String propertyName, @NotNull String propertyValue, @NotNull BundleEnvironment bundleEnvironment) {
        String newValue = propertyValue;
        FolderType folderType = FolderType.resolve(propertyName);
        if (folderType != null) {
            Path applicationDataRootDirectory = bundleEnvironment.getApplicationDataRootDirectory();
            newValue = SystemUtil.relativizePath((Path)applicationDataRootDirectory, (Path)Paths.get(propertyValue, new String[0])).toString();
        }
        return newValue;
    }

    void mergeSecureFiles(@Nullable Properties unattendedProperties) {
        String secureMode = this.getSecureMode();
        if (SecureMode.DISABLE.getName().equals(secureMode)) {
            return;
        }
        boolean isTlsConfiguredFromCli = BundleProperties.containsAtLeastOneTlsProperty(unattendedProperties);
        if (isTlsConfiguredFromCli) {
            this.checkMissingTlsProperties();
        }
        if (this.containsProperty(BundleProperty.TLS_SERVER_CERT_KEYSTORE_FILE)) {
            this.mergeSecureSettingsFromKeystore(isTlsConfiguredFromCli);
        } else if (this.containsProperty(BundleProperty.TLS_SERVER_CERT_PRIVATE_KEY_FILE) || this.containsProperty(BundleProperty.TLS_SERVER_CERT_FILE) || this.containsProperty(BundleProperty.TLS_SERVER_CERT_CHAIN_FILE)) {
            this.mergeSecureSettingsFromPrivateKeyAndCertFiles(isTlsConfiguredFromCli);
        } else {
            return;
        }
    }

    private void trustExternalHubIfRequested() {
        KeyStore additionalKeystore;
        if (!Boolean.parseBoolean(this.myProperties.getProperty(BundleProperty.TRUST_EXTERNAL_HUB.getName()))) {
            return;
        }
        String externalHubUrl = this.getHubUrl();
        if (this.isServiceEnabled("hub")) {
            throw new BadConfigurationException(String.format("Property %s is not applicable to built-in Hub", BundleProperty.TRUST_EXTERNAL_HUB));
        }
        if (externalHubUrl == null) {
            throw new BadConfigurationException(String.format("Property %s designating URL of external Hub is undefined", BundleProperty.HUB_URL));
        }
        try {
            additionalKeystore = KeystoreUtil.loadKeyStore((Path)this.myEnvironment.getAdditionalKeystorePath(), (String)this.getAdditionalKeystorePassword());
        }
        catch (Exception e) {
            throw new BadConfigurationException("Failed to open internal keystore", e);
        }
        HubClientProvider hubClientProvider = new HubClientProvider(additionalKeystore, this.getAdditionalKeystorePassword());
        try {
            hubClientProvider.getHubClient(externalHubUrl);
        }
        catch (UntrustedServerCertificateException e) {
            try {
                for (String alias : Collections.list(additionalKeystore.aliases())) {
                    if (alias == null || !alias.toLowerCase().startsWith(EXTERNAL_HUB_CERT_ALIAS_PREFIX)) continue;
                    additionalKeystore.deleteEntry(alias);
                }
                for (X509Certificate cert : e.getCertificateChain()) {
                    additionalKeystore.setCertificateEntry(EXTERNAL_HUB_CERT_ALIAS_PREFIX + AdditionalKeystore.generateCertificateAlias((X509Certificate)cert), cert);
                }
                KeystoreUtil.saveKeyStore((KeyStore)additionalKeystore, (Path)this.myEnvironment.getAdditionalKeystorePath(), (String)this.getAdditionalKeystorePassword());
                this.LOG.info("TLS certificate of external Hub was imported successfully");
            }
            catch (Exception ex) {
                this.LOG.debug("Failed to import TLS certificate of external Hub into internal keystore", (Throwable)e);
                throw new BadConfigurationException("Failed to import TLS certificate of external Hub into keystore", ex);
            }
        }
    }

    private void mergeSecureSettingsFromPrivateKeyAndCertFiles(boolean isTlsConfiguredFromCli) {
        Path privateKeyPath = this.resolveServerCertFile(BundleProperty.TLS_SERVER_CERT_PRIVATE_KEY_FILE, isTlsConfiguredFromCli, true);
        Path certificatePath = this.resolveServerCertFile(BundleProperty.TLS_SERVER_CERT_FILE, isTlsConfiguredFromCli, true);
        Path certificateChainPath = this.resolveServerCertFile(BundleProperty.TLS_SERVER_CERT_CHAIN_FILE, isTlsConfiguredFromCli, false);
        if (privateKeyPath != null && certificatePath != null) {
            if (!Files.exists(privateKeyPath, new LinkOption[0])) {
                this.processTlsError(isTlsConfiguredFromCli, String.format("Failed configuring TLS: private key file [%s] is not found", privateKeyPath));
            } else if (!Files.exists(certificatePath, new LinkOption[0])) {
                this.processTlsError(isTlsConfiguredFromCli, String.format("Failed configuring TLS: certificate file [%s] is not found", certificatePath));
            } else {
                if (isTlsConfiguredFromCli) {
                    // empty if block
                }
                String privateKeyPassphrase = this.myProperties.getProperty(BundleProperty.TLS_SERVER_CERT_PRIVATE_KEY_PASSPHRASE.getName());
                try {
                    KeyStoreGenerator.generate((Path)this.myEnvironment.getAdditionalKeystorePath(), (String)this.getAdditionalKeystorePassword(), (String)"secureKeyStoreAlias", (Path)privateKeyPath, (String)privateKeyPassphrase, (Path)certificatePath, (Path)certificateChainPath, (boolean)true);
                    this.removeTemporaryTlsSettings();
                }
                catch (KeyStoreGenerationException e) {
                    this.processTlsError(isTlsConfiguredFromCli, String.format("KeyStore generation error: %s", e.getCause().getMessage()), e);
                }
            }
        }
    }

    @Nullable
    private Path resolveServerCertFile(@NotNull BundleProperty serverCertFileProperty, boolean isTlsConfiguredFromCli, boolean isMandatoryFile) {
        Path resultPath;
        String serverCertFilePathAsString = this.myProperties.getProperty(serverCertFileProperty.getName());
        if (serverCertFilePathAsString == null) {
            if (isMandatoryFile) {
                this.processTlsError(isTlsConfiguredFromCli, String.format("Failed configuring TLS: required property %s is missing", serverCertFileProperty.getName()));
            }
            resultPath = null;
        } else {
            Path serverCertFilePath;
            try {
                serverCertFilePath = Paths.get(serverCertFilePathAsString, new String[0]);
            }
            catch (InvalidPathException e) {
                this.processTlsError(isTlsConfiguredFromCli, String.format("Property %s specifies invalid path: %s", serverCertFileProperty, serverCertFilePathAsString));
                return null;
            }
            if (serverCertFilePath.isAbsolute()) {
                resultPath = serverCertFilePath;
            } else {
                String tlsServerCertFolderAsString = this.myProperties.getProperty(BundleProperty.TLS_SERVER_CERT_FOLDER.getName());
                if (tlsServerCertFolderAsString == null) {
                    this.processTlsError(isTlsConfiguredFromCli, String.format("Property %s specifies relative path: %s. Either specify absolute path there or add property %s (all relative paths from command line will be resolved against that path then)", serverCertFileProperty, serverCertFilePath.toString(), BundleProperty.TLS_SERVER_CERT_FOLDER.getName()));
                    resultPath = null;
                } else {
                    Path tlsServerCertFolder;
                    try {
                        tlsServerCertFolder = Paths.get(tlsServerCertFolderAsString, new String[0]);
                    }
                    catch (InvalidPathException e) {
                        this.processTlsError(isTlsConfiguredFromCli, String.format("Property %s specifies invalid path: %s", BundleProperty.TLS_SERVER_CERT_FOLDER.getName(), tlsServerCertFolderAsString));
                        return null;
                    }
                    if (!tlsServerCertFolder.isAbsolute()) {
                        this.processTlsError(isTlsConfiguredFromCli, String.format("Property %s should specify absolute directory path, but it is relative: %s", BundleProperty.TLS_SERVER_CERT_FOLDER.getName(), tlsServerCertFolderAsString));
                        resultPath = null;
                    } else {
                        resultPath = tlsServerCertFolder.resolve(serverCertFilePath);
                    }
                }
            }
        }
        return resultPath;
    }

    private void mergeSecureSettingsFromKeystore(boolean isTlsConfiguredFromCli) {
        Path keyStoreForMergePath = this.resolveServerCertFile(BundleProperty.TLS_SERVER_CERT_KEYSTORE_FILE, isTlsConfiguredFromCli, true);
        if (keyStoreForMergePath == null) {
            return;
        }
        String keyStoreForMergePassword = this.getTlsServerCertKeyStorePassword();
        String keyStoreForMergeKeyAlias = this.getTlsServerCertKeyStoreAlias();
        String keyStoreForMergeKeyPassword = this.getTlsServerCertKeyStoreKeyPassword();
        if (!Files.exists(keyStoreForMergePath, new LinkOption[0])) {
            this.processTlsError(isTlsConfiguredFromCli, String.format("Failed configuring TLS: server cert keystore file [%s] is not found", keyStoreForMergePath));
        } else if (keyStoreForMergePassword == null) {
            this.processTlsError(isTlsConfiguredFromCli, String.format("Property %s that defines server cert keystore integrity password is not set", BundleProperty.TLS_SERVER_CERT_KEYSTORE_PASSWORD.getName()));
        } else if (keyStoreForMergeKeyAlias == null) {
            this.processTlsError(isTlsConfiguredFromCli, String.format("Property %s that defines private key alias in server cert keystore is not set", BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_ALIAS.getName()));
        } else {
            KeyStore instance = null;
            try (FileInputStream fileInputStream = new FileInputStream(keyStoreForMergePath.toFile());){
                instance = KeyStore.getInstance(KeyStore.getDefaultType());
                instance.load(fileInputStream, keyStoreForMergePassword.toCharArray());
            }
            catch (Exception e) {
                this.processTlsError(isTlsConfiguredFromCli, String.format("Error loading keystore %s: %s", keyStoreForMergePath, e.getMessage()), e);
            }
            if (instance != null) {
                try {
                    AdditionalKeystore additionalKeystore = new AdditionalKeystore(this.myEnvironment.getAdditionalKeystorePath(), this.getAdditionalKeystorePassword());
                    additionalKeystore.copyKeyEntryFromAnotherKeyStore("secureKeyStoreAlias", instance, keyStoreForMergePassword, keyStoreForMergeKeyAlias, !StringUtils.isEmpty((CharSequence)keyStoreForMergeKeyPassword) ? keyStoreForMergeKeyPassword : keyStoreForMergePassword);
                    additionalKeystore.saveKeyStore();
                    this.removeTemporaryTlsSettings();
                }
                catch (Exception e) {
                    this.processTlsError(isTlsConfiguredFromCli, String.format("KeyStore merge error: %s", e.getMessage()), e);
                }
            }
        }
    }

    private void processTlsError(boolean isTlsConfiguredFromCli, @NotNull String errorMessage) {
        this.processTlsError(isTlsConfiguredFromCli, errorMessage, null);
    }

    private void processTlsError(boolean isTlsConfiguredFromCli, @NotNull String errorMessage, @Nullable Throwable t) {
        if (t != null) {
            this.LOG.debug(errorMessage, t);
        } else {
            this.LOG.debug(errorMessage);
        }
        if (isTlsConfiguredFromCli) {
            throw new BadConfigurationException(errorMessage, t);
        }
    }

    private static boolean containsAtLeastOneTlsProperty(@Nullable Properties unattendedProperties) {
        if (unattendedProperties == null) {
            return false;
        }
        return SecureMode.TLS.getName().equals(unattendedProperties.getProperty(BundleProperty.SECURE_MODE.getName())) || BundleProperties.containsProperty(unattendedProperties, BundleProperty.TLS_SERVER_CERT_KEYSTORE_FILE) || BundleProperties.containsProperty(unattendedProperties, BundleProperty.TLS_SERVER_CERT_PRIVATE_KEY_FILE) || BundleProperties.containsProperty(unattendedProperties, BundleProperty.TLS_SERVER_CERT_FILE) || BundleProperties.containsProperty(unattendedProperties, BundleProperty.TLS_SERVER_CERT_CHAIN_FILE) || BundleProperties.containsProperty(unattendedProperties, BundleProperty.TLS_SERVER_CERT_PRIVATE_KEY_PASSPHRASE) || BundleProperties.containsProperty(unattendedProperties, BundleProperty.TLS_SERVER_CERT_KEYSTORE_PASSWORD) || BundleProperties.containsProperty(unattendedProperties, BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_ALIAS) || BundleProperties.containsProperty(unattendedProperties, BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_PASSWORD) || BundleProperties.containsProperty(unattendedProperties, BundleProperty.TLS_SERVER_CERT_FOLDER) || BundleProperties.containsProperty(unattendedProperties, BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG) || BundleProperties.containsProperty(unattendedProperties, BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT);
    }

    private void checkMissingTlsProperties() {
        HashSet<BundleProperty> requiredProperties = new HashSet<BundleProperty>();
        if (this.containsProperty(BundleProperty.TLS_SERVER_CERT_KEYSTORE_FILE)) {
            requiredProperties.add(BundleProperty.TLS_SERVER_CERT_KEYSTORE_PASSWORD);
            requiredProperties.add(BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_ALIAS);
        } else if (this.containsProperty(BundleProperty.TLS_SERVER_CERT_PRIVATE_KEY_FILE) || this.containsProperty(BundleProperty.TLS_SERVER_CERT_FILE) || this.containsProperty(BundleProperty.TLS_SERVER_CERT_CHAIN_FILE)) {
            requiredProperties.add(BundleProperty.TLS_SERVER_CERT_PRIVATE_KEY_FILE);
            requiredProperties.add(BundleProperty.TLS_SERVER_CERT_FILE);
        } else {
            throw new BadConfigurationException(String.format("Server certificate files should be specified. Specify path to keystore %s if server certificate is stored in JKS or PKCS#12 format. Otherwise, to apply private key and certificate stored in PEM format specify properties %s and %s (and optionally %s defining certificate chain as well)", BundleProperty.TLS_SERVER_CERT_KEYSTORE_FILE.getName(), BundleProperty.TLS_SERVER_CERT_PRIVATE_KEY_FILE.getName(), BundleProperty.TLS_SERVER_CERT_FILE.getName(), BundleProperty.TLS_SERVER_CERT_CHAIN_FILE.getName()));
        }
        if (Boolean.parseBoolean(this.myProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG.getName()))) {
            requiredProperties.add(BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT);
        }
        HashSet<String> missingProperties = new HashSet<String>();
        for (BundleProperty property : requiredProperties) {
            if (this.containsProperty(property)) continue;
            missingProperties.add(property.getName());
        }
        if (!missingProperties.isEmpty()) {
            throw new BadConfigurationException(missingProperties.size() == 1 ? String.format("Property [%s] is missing", missingProperties.iterator().next()) : String.format("The following properties are missing: %s", missingProperties.toString()));
        }
    }

    private boolean removeTemporaryTlsSettings() {
        boolean isDirty = this.removeProperty(BundleProperty.TLS_SERVER_CERT_KEYSTORE_FILE.getName()) | this.removeProperty(BundleProperty.TLS_SERVER_CERT_KEYSTORE_PASSWORD.getName()) | this.removeProperty(BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_ALIAS.getName()) | this.removeProperty(BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_PASSWORD.getName()) | this.removeProperty(BundleProperty.TLS_SERVER_CERT_PRIVATE_KEY_PASSPHRASE.getName()) | this.removeProperty(BundleProperty.TLS_SERVER_CERT_PRIVATE_KEY_FILE.getName()) | this.removeProperty(BundleProperty.TLS_SERVER_CERT_FILE.getName()) | this.removeProperty(BundleProperty.TLS_SERVER_CERT_CHAIN_FILE.getName()) | this.removeProperty(BundleProperty.TLS_SERVER_CERT_FOLDER.getName());
        Path uploadedServerCertPath = this.myEnvironment.getUploadServerCertPath();
        if (Files.exists(uploadedServerCertPath, new LinkOption[0])) {
            try {
                Files.walkFileTree(uploadedServerCertPath, (FileVisitor<? super Path>)new DeleteFileVisitor());
            }
            catch (IOException e) {
                this.LOG.debug(String.format("Failed to remove folder %s after server certificate was successfully imported", uploadedServerCertPath.toString()), (Throwable)e);
            }
        }
        return isDirty;
    }

    static class BundleConfigureFinishedListener
    extends OnePerClassListener<ConfigureFinishedEvent> {
        BundleConfigureFinishedListener() {
        }

        @Override
        public void onSuccess(@NotNull ConfigureFinishedEvent event) {
            BundleProperties bundleProperties = event.getBundleState().getProperties();
            boolean isDirty = bundleProperties.removeProperty(BundleProperties.FORCE_SHUTDOWN_INTERNAL_PROPERTY);
            if (isDirty |= BundleProperties.removeTemporaryProperties(bundleProperties)) {
                bundleProperties.saveConfig();
            }
        }

        @Override
        public void onFailure(@NotNull ConfigureFinishedEvent event, @NotNull Throwable t) {
            BundleProperties bundleProperties = event.getBundleState().getProperties();
            boolean isDirty = BundleProperties.removeTemporaryProperties(bundleProperties);
            if (isDirty) {
                bundleProperties.saveConfig();
            }
        }
    }

    static class BundleStartFinishedListener
    extends OnePerClassListener<StartFinishedEvent> {
        BundleStartFinishedListener() {
        }

        @Override
        public void onSuccess(@NotNull StartFinishedEvent event) {
            BundleProperties bundleProperties = event.getBundleState().getProperties();
            boolean isDirty = bundleProperties.removeRootCredentials();
            if (isDirty |= BundleProperties.removeTemporaryProperties(bundleProperties)) {
                bundleProperties.saveConfig();
            }
        }

        @Override
        public void onFailure(@NotNull StartFinishedEvent event, @NotNull Throwable t) {
        }
    }

    public static enum FolderType {
        DATA(BundleProperty.DATA_DIR, "data"),
        TEMP(BundleProperty.TEMP_DIR, "temp"),
        LOGS(BundleProperty.LOGS_DIR, "logs"),
        BACKUPS(BundleProperty.BACKUPS_DIR, "backups");

        private final BundleProperty myBundleProperty;
        private final String myDefaultFolderName;
        private static final String BUNDLE_PREFIX_WITH_DOT = "bundle.";

        private FolderType(BundleProperty bundleProperty, String defaultFolderName) {
            this.myBundleProperty = bundleProperty;
            this.myDefaultFolderName = defaultFolderName;
        }

        @NotNull
        public BundleProperty getBundleProperty() {
            return this.myBundleProperty;
        }

        @NotNull
        public String getDefaultFolderName() {
            return this.myDefaultFolderName;
        }

        public static FolderType resolve(String propertyName) {
            if (propertyName.startsWith(BUNDLE_PREFIX_WITH_DOT)) {
                propertyName = propertyName.substring(BUNDLE_PREFIX_WITH_DOT.length());
            } else {
                String serviceIdPrefix = PropertiesBasedConfigurationHelper.getHelper().parseServiceIdPrefix(propertyName);
                if (serviceIdPrefix != null) {
                    propertyName = propertyName.substring(serviceIdPrefix.length());
                }
            }
            for (FolderType folderType : FolderType.values()) {
                if (!folderType.getBundleProperty().getName().equals(propertyName)) continue;
                return folderType;
            }
            return null;
        }
    }
}

