/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleProperties;
import com.jetbrains.bundle.PropertiesProvider;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.service.util.BundleProperty;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class BundlePropertiesProvider
implements PropertiesProvider {
    private final BundleProperties myBundleProperties;
    private final BundleEnvironment myBundleEnvironment;
    private final List<ServiceDescriptor> myServices;

    BundlePropertiesProvider(@NotNull BundleEnvironment environment, @NotNull BundleProperties bundleProperties, @NotNull List<ServiceDescriptor> services) {
        this.myBundleEnvironment = environment;
        this.myBundleProperties = bundleProperties;
        this.myServices = services;
    }

    @Override
    public void addToServiceProperties(@NotNull ServiceDescriptor descriptor, @NotNull Properties serviceProperties) {
        Properties bundleProperties = this.myBundleProperties.getAllProperties();
        for (String name : bundleProperties.stringPropertyNames()) {
            if (BundleProperty.ROOT_PASSWORD.getName().equals(name) && !"hub".equals(descriptor.getId()) && !"youtrack".equals(descriptor.getId())) continue;
            serviceProperties.setProperty("bundle." + name, BundleProperties.getPropertyValueInExternalFormat(name, bundleProperties.getProperty(name), this.myBundleEnvironment));
        }
        for (ServiceDescriptor someServiceDescriptor : this.myServices) {
            String disableServicePropertyName = BundleProperty.constructDisableServiceProperty((String)someServiceDescriptor.getId());
            if (serviceProperties.containsKey(disableServicePropertyName) || !this.myBundleProperties.isServiceEnabled(someServiceDescriptor.getId())) continue;
            serviceProperties.setProperty(disableServicePropertyName, Boolean.FALSE.toString());
        }
    }
}

