/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleProperties;
import com.jetbrains.service.util.ServiceUtil;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class PortAllocator {
    private static final int START_PORT = Integer.getInteger("bundle.minimal.internal.service.port", 10000);
    private static final int STEP = 10;
    private final BundleProperties myProperties;
    private final Integer myInstallationPort;

    public PortAllocator(@NotNull BundleProperties properties, @NotNull BundleEnvironment bundleEnvironment) {
        this.myProperties = properties;
        this.myInstallationPort = bundleEnvironment.getInstallationConfig().getInstallationPort();
    }

    public int allocateRange(String id) {
        Integer allocatedPort = this.myProperties.getAllocatedPort(id);
        if (allocatedPort != null) {
            return allocatedPort;
        }
        Set<Integer> allocatedPorts = this.myProperties.getAllocatedPorts();
        for (int base = START_PORT / 10; base <= 6500; ++base) {
            if (allocatedPorts.contains(base * 10) || this.isPortsInIntervalUsed(base)) continue;
            this.myProperties.setAllocatedPort(id, base * 10);
            return base * 10;
        }
        throw new RuntimeException("Could not allocate new port base");
    }

    private boolean isPortsInIntervalUsed(int base) {
        final AtomicBoolean result = new AtomicBoolean(false);
        ArrayList<Thread> threads = new ArrayList<Thread>(10);
        for (int i = 0; i < 10; ++i) {
            final int port = base * 10 + i;
            if (this.myInstallationPort != null && this.myInstallationPort == port) {
                return true;
            }
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (!ServiceUtil.isPortAvailable((String)"0.0.0.0", (int)port, (boolean)false)) {
                        result.set(true);
                    }
                }
            });
            thread.setDaemon(true);
            thread.setName("CheckPort:" + port);
            thread.start();
            threads.add(thread);
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (!result.get()) continue;
            return true;
        }
        return false;
    }
}

