/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.gzip.GzipSettings;
import com.jetbrains.service.util.LocaleUtil;
import com.jetbrains.service.util.StatusException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscovery {
    private static final String SERVICES_DIRECTORY = "apps";
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private BundleState myBundleState;

    ServiceDiscovery(BundleState bundleState) {
        this.myBundleState = bundleState;
    }

    @NotNull
    Map<String, ServiceDescriptor> discoverServices() {
        HashMap<String, ServiceDescriptor> result = new HashMap<String, ServiceDescriptor>();
        HashSet<String> idSet = new HashSet<String>();
        HashSet<String> nameSet = new HashSet<String>();
        Path dir = this.myBundleState.getEnvironment().getBundleHome().resolve(SERVICES_DIRECTORY);
        this.LOG.debug("Looking for services in {}", (Object)dir);
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            this.LOG.warn("Services directory {} does not exist", (Object)dir);
            return result;
        }
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(dir);){
            for (Path path : directoryStream) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                Path serviceDescriptorPath = path.resolve("service.properties");
                if (!Files.exists(serviceDescriptorPath, new LinkOption[0])) {
                    this.LOG.debug("Service descriptor file {} doesn't exist in folder {}", (Object)"service.properties", (Object)path);
                    continue;
                }
                this.LOG.debug("Found service descriptor {}", (Object)path);
                ServiceDescriptor descriptor = this.createServiceFromDirectory(path);
                if (idSet.contains(descriptor.getId())) {
                    throw new StatusException("Duplicate service id " + descriptor.getId() + " in " + path);
                }
                idSet.add(descriptor.getId());
                if (nameSet.contains(descriptor.getPresentableName())) {
                    throw new StatusException("Duplicate service name " + descriptor.getPresentableName() + " in " + path);
                }
                nameSet.add(descriptor.getPresentableName());
                result.put(descriptor.getId(), descriptor);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    private ServiceDescriptor createServiceFromDirectory(Path serviceHome) {
        Properties properties = new Properties();
        Path descriptorFile = ServiceDiscovery.getDescriptor(serviceHome);
        try (InputStream in = Files.newInputStream(descriptorFile, new OpenOption[0]);){
            properties.load(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.createServiceByServiceDescriptorProperties(serviceHome, properties);
    }

    private static Path getDescriptor(Path serviceHome) {
        return serviceHome.resolve("service.properties");
    }

    private ServiceDescriptor createServiceByServiceDescriptorProperties(final Path serviceHome, final Properties properties) {
        final Path descriptorFile = ServiceDiscovery.getDescriptor(serviceHome);
        final String name = this.getMandatoryProperty(descriptorFile, properties, "name");
        return new ServiceDescriptor(){

            @Override
            @NotNull
            public String getId() {
                String id = properties.getProperty("id");
                return id == null ? serviceHome.getFileName().toString() : id;
            }

            @Override
            @NotNull
            public String getPresentableName() {
                return name;
            }

            @Override
            @NotNull
            public Path getFullPath() {
                return serviceHome;
            }

            @Override
            public boolean isHubService() {
                String val = properties.getProperty("hub.service");
                return val != null && val.trim().toLowerCase().equals("true");
            }

            @Override
            @NotNull
            public String getHubServiceName() {
                String val = properties.getProperty("hub.service.name");
                return val != null ? val : this.getId();
            }

            @Override
            @Nullable
            public String getFirstMajorReleaseDate() {
                return properties.getProperty("first-major-release-date");
            }

            @Override
            public String getHubServiceBelongsTo() {
                return this.isHubService() ? properties.getProperty("hub.service.belongs_to") : null;
            }

            @Override
            @NotNull
            public List<String> getRunAfterServices() {
                String after = properties.getProperty("after");
                ArrayList<String> runAfterList = new ArrayList<String>();
                if (after != null) {
                    runAfterList.addAll(Arrays.asList(after.split(" ")));
                }
                runAfterList.add("startingPage");
                runAfterList.add("bundleProcess");
                if (runAfterList.contains("hub")) {
                    runAfterList.remove("hub");
                    runAfterList.add("bundle-hub-configurator");
                }
                return runAfterList;
            }

            @Override
            @NotNull
            public List<String> getRunBeforeServices() {
                String before = properties.getProperty("before");
                return before == null ? Collections.emptyList() : Arrays.asList(before.split(" "));
            }

            @Override
            @NotNull
            public List<String> getStartCommand() {
                return this.getCommand("start");
            }

            @Override
            @NotNull
            public List<String> getStopCommand() {
                return this.getCommand("stop");
            }

            @Override
            @NotNull
            public List<String> getStatusCommand() {
                return this.getCommand("status");
            }

            @Override
            @NotNull
            public List<String> getConfigureCommand() {
                return this.getCommand("configure");
            }

            @Override
            @NotNull
            public List<String> getListCommand() {
                if (properties.containsKey("list")) {
                    return this.getCommand("list");
                }
                List<String> command = this.getCommand("configure");
                command.set(command.size() - 1, "list");
                return command;
            }

            @Override
            @NotNull
            public String getContext() {
                String context = properties.getProperty("context");
                if (context == null) {
                    context = ServiceDiscovery.this.myBundleState.getBuildProperties().isDefaultService(this.getId()) ? "/" : this.getId();
                }
                return context;
            }

            private List<String> getCommand(String name2) {
                return Arrays.asList(ServiceDiscovery.this.getMandatoryProperty(descriptorFile, properties, name2).split(" "));
            }

            @Override
            public String getConfigureCallbackClass() {
                return properties.getProperty("configure-callback-class");
            }

            @Override
            public String getBeforeStartCallbackClass() {
                return properties.getProperty("before-start-callback-class");
            }

            @Override
            public String getAfterStartCallbackClass() {
                return properties.getProperty("after-start-callback-class");
            }

            @Override
            public String getStatusPageContextPath() {
                return properties.getProperty("status-page-context-path");
            }

            @Override
            public boolean isParentFirstClassLoading() {
                return false;
            }

            @Override
            public boolean isAnnotationBased() {
                return Boolean.valueOf(properties.getProperty("annotation-based"));
            }

            @Override
            public boolean isInternal() {
                return false;
            }

            @Override
            public boolean isBundleServiceContainer() {
                return false;
            }

            @Override
            @NotNull
            public Collection<Locale> getSupportedLocales() {
                return LocaleUtil.parseLocales((String)properties.getProperty("locales"));
            }

            @Override
            @NotNull
            public Collection<Locale> getSupportedCommunityLocales() {
                return LocaleUtil.parseLocales((String)properties.getProperty("locales.community"));
            }

            @Override
            @Nullable
            public String getHubApplicationName() {
                String serviceAppName = properties.getProperty("hub.service.application.name");
                if (serviceAppName == null && this.isHubService() && this.getHubServiceBelongsTo() == null) {
                    throw new RuntimeException(String.format("Property '%s' is mandatory for Hub-related service, but it is not found in the descriptor file '%s'", "hub.service.application.name", serviceHome));
                }
                return serviceAppName;
            }

            @Override
            @NotNull
            public String getVersion() {
                return properties.getProperty("version", "unknown");
            }

            @Override
            @NotNull
            public String getManufacturer() {
                return properties.getProperty("manufacturer", ServiceDiscovery.this.myBundleState.getBuildProperties().getBundleProductManufacturer());
            }

            @Override
            public boolean isWebApp() {
                return Boolean.valueOf(properties.getProperty("web.app", Boolean.TRUE.toString()));
            }

            @Override
            public File getLicenseAgreementFile() {
                String relativeLicenseAgreementPath = properties.getProperty("license.agreement.path");
                File agreement = null;
                if (relativeLicenseAgreementPath != null) {
                    if (Paths.get(relativeLicenseAgreementPath, new String[0]).isAbsolute()) {
                        throw new RuntimeException(String.format("Path to license agreement file relative to the service home directory (%s) should be set in service descriptor file %s as a value of property %s (instead of absolute path [%s])", serviceHome, descriptorFile, "license.agreement.path", relativeLicenseAgreementPath));
                    }
                    Path absoluteAgreementPath = serviceHome.resolve(relativeLicenseAgreementPath);
                    if (!Files.exists(absoluteAgreementPath, new LinkOption[0])) {
                        throw new RuntimeException(String.format("License agreement file [%s] defined by property %s in service descriptor file %s doesn't exist", absoluteAgreementPath, "license.agreement.path", descriptorFile));
                    }
                    agreement = absoluteAgreementPath.toFile();
                }
                return agreement;
            }

            @Override
            public String getLicenseAgreementProductName() {
                if (properties.containsKey("license.agreement.path")) {
                    return properties.getProperty("license.agreement.product.name", this.getPresentableName());
                }
                return null;
            }

            @Override
            public String getLicenseUserName() {
                LicenseInfo licenseInfo = this.getLicenseInfo(properties);
                return licenseInfo.getLicenseUserName();
            }

            private LicenseInfo getLicenseInfo(Properties properties2) {
                String licenseName = properties2.getProperty("license-user-name");
                String licenseKey = properties2.getProperty("license-key");
                if (licenseKey != null && licenseName == null || licenseKey == null && licenseName != null) {
                    throw new RuntimeException(String.format("Both properties '%s' and '%s' must be set in service descriptor file %s", "license-user-name", "license-key", descriptorFile));
                }
                return new LicenseInfo(licenseKey, licenseName);
            }

            @Override
            @NotNull
            public Collection<String> getAdditionalRedirectUris() {
                String additionalUris = properties.getProperty("hub.service.additional_redirectUris");
                return additionalUris == null ? Collections.emptyList() : Arrays.asList(additionalUris.split(" "));
            }

            @Override
            public String getLicenseKey() {
                LicenseInfo licenseInfo = this.getLicenseInfo(properties);
                return licenseInfo.getLicenseKey();
            }

            @Override
            @Nullable
            public GzipSettings getGzipSettings() {
                boolean isGzipEnabled = Boolean.valueOf(properties.getProperty("gzip-enable"));
                return isGzipEnabled ? new GzipSettings(properties) : null;
            }

            @Override
            @Nullable
            public String getPreCompressedFormats() {
                return properties.getProperty("pre-compressed-formats");
            }

            class LicenseInfo {
                private String licenseKey;
                private String licenseUserName;

                LicenseInfo(String licenseKey, String licenseUserName) {
                    this.licenseKey = licenseKey;
                    this.licenseUserName = licenseUserName;
                }

                String getLicenseKey() {
                    return this.licenseKey;
                }

                String getLicenseUserName() {
                    return this.licenseUserName;
                }
            }
        };
    }

    private String getMandatoryProperty(Path file, Properties properties, String name) {
        String value = properties.getProperty(name);
        if (value == null) {
            throw new RuntimeException(String.format("Mandatory property '%s' is not found in file '%s'", name, file));
        }
        return value;
    }

    public static class ServiceToBundleContract {
        static final String ID_PROPERTY = "id";
        static final String NAME_PROPERTY = "name";
        static final String CONTEXT_PROPERTY = "context";
        static final String START_COMMAND = "start";
        static final String STOP_COMMAND = "stop";
        static final String STATUS_COMMAND = "status";
        static final String CONFIGURE_COMMAND = "configure";
        static final String LIST_COMMAND = "list";
        static final String AFTER_PROPERTY = "after";
        static final String BEFORE_PROPERTY = "before";
        static final String HUB_SERVICE = "hub.service";
        static final String IS_WEB_APP_PROPERTY = "web.app";
        static final String VERSION_PROPERTY = "version";
        static final String MANUFACTURER_PROPERTY = "manufacturer";
        static final String HUB_SERVICE_NAME_PROPERTY = "hub.service.name";
        static final String HUB_SERVICE_BELONGS_TO_PROPERTY = "hub.service.belongs_to";
        static final String HUB_ADDITIONAL_REDIRECT_URIS = "hub.service.additional_redirectUris";
        static final String HUB_SERVICE_APPLICATION_NAME_PROPERTY = "hub.service.application.name";
        static final String AFTER_START_SERVICE_CALLBACK = "after-start-callback-class";
        static final String BEFORE_START_SERVICE_CALLBACK = "before-start-callback-class";
        static final String CONFIGURE_SERVICE_CALLBACK = "configure-callback-class";
        static final String STATUS_PAGE_CONTEXT_PATH_PROPERTY = "status-page-context-path";
        static final String IS_ANNOTATION_BASED_PROPERTY = "annotation-based";
        static final String SUPPORTED_LOCALES_PROPERTY = "locales";
        static final String SUPPORTED_LOCALES_COMMUNITY_PROPERTY = "locales.community";
        public static final String LICENSE_AGREEMENT_PATH_PROPERTY = "license.agreement.path";
        public static final String LICENSE_AGREEMENT_PRODUCT_NAME_PROPERTY = "license.agreement.product.name";
        public static final String LICENSE_USER_NAME_PROPERTY = "license-user-name";
        public static final String LICENSE_KEY_PROPERTY = "license-key";
        static final String GZIP_ENABLE = "gzip-enable";
        public static final String GZIP_INCLUDED_MIME_TYPES = "gzip-included-mime-types";
        public static final String GZIP_EXCLUDED_MIME_TYPES = "gzip-excluded-mime-types";
        public static final String GZIP_INCLUDED_METHODS = "gzip-included-methods";
        public static final String GZIP_EXCLUDED_METHODS = "gzip-excluded-methods";
        public static final String GZIP_INCLUDED_PATHS = "gzip-included-paths";
        public static final String GZIP_EXCLUDED_PATHS = "gzip-excluded-paths";
        public static final String GZIP_INCLUDED_AGENT_PATTERNS = "gzip-included-agent-patterns";
        public static final String GZIP_EXCLUDED_AGENT_PATTERNS = "gzip-excluded-agent-patterns";
        public static final String PRE_COMPRESSED_FORMATS = "pre-compressed-formats";
        public static final String GZIP_MIN_SIZE = "gzip-min-size";
        public static final String GZIP_COMPRESSION_LEVEL = "gzip-compression-level";
        public static final String GZIP_SYNC_FLUSH = "gzip-sync-flush";
        static final String FIRST_MAJOR_RELEASE_DATE_PROPERTY = "first-major-release-date";
    }
}

