/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle;

import com.jetbrains.bundle.BundleBuildProperties;
import com.jetbrains.bundle.BundleConsoleLogger;
import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleProperties;
import com.jetbrains.bundle.UpgradePropertiesProvider;
import com.jetbrains.bundle.exceptions.BadConfigurationException;
import com.jetbrains.bundle.listener.OnePerClassListener;
import com.jetbrains.bundle.listener.event.ConfigureFinishedEvent;
import com.jetbrains.bundle.listener.event.ServiceStartedEvent;
import com.jetbrains.bundle.listener.event.StartFinishedEvent;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.PropertiesUtil;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeProperties {
    @NotNull
    private final Properties myProperties = new Properties();
    @NotNull
    private final BundleBuildProperties myBuildProperties;
    @NotNull
    private final Path myPropertiesPath;
    private boolean myUpgradeFlag = false;

    public UpgradeProperties(@NotNull BundleEnvironment bundleEnvironment, @NotNull BundleBuildProperties bundleBuildProperties, @NotNull BundleProperties bundleProperties) {
        this.myBuildProperties = bundleBuildProperties;
        this.myPropertiesPath = UpgradeProperties.getServicesVersionsFile(bundleEnvironment);
        this.reloadProperties(bundleProperties);
    }

    private void updateUpgradeModeFlag() {
        boolean isUpgrade;
        String productVersion = this.myBuildProperties.getProductFullVersionNumber();
        String oldProductVersion = this.myProperties.getProperty(BundleProperty.PREVIOUSLY_STARTED_PRODUCT_VERSION.getName());
        boolean bl = isUpgrade = oldProductVersion != null && !oldProductVersion.equals(productVersion);
        if (isUpgrade && !this.myUpgradeFlag) {
            BundleConsoleLogger.get().info(String.format("%s is running in upgrade mode ( %s -> %s )", this.myBuildProperties.getBundlePresentationName(), oldProductVersion, productVersion));
        } else if (!isUpgrade && this.myUpgradeFlag) {
            BundleConsoleLogger.get().info(String.format("Upgrade mode of %s has been switched off", this.myBuildProperties.getBundlePresentationName()));
        }
        this.myUpgradeFlag = isUpgrade;
    }

    private void migrateLegacyProperties(@NotNull BundleProperties bundleProperties) {
        String oldProductVersionFromLegacyLocation = bundleProperties.removeLegacyProductVersion();
        if (oldProductVersionFromLegacyLocation != null && !this.myProperties.containsKey(BundleProperty.PREVIOUSLY_STARTED_PRODUCT_VERSION.getName())) {
            this.setProperty(BundleProperty.PREVIOUSLY_STARTED_PRODUCT_VERSION.getName(), oldProductVersionFromLegacyLocation);
            this.saveConfig();
        }
    }

    private void reloadProperties(@NotNull BundleProperties bundleProperties) {
        if (Files.isReadable(this.myPropertiesPath)) {
            UpgradeProperties.getLogger().debug(String.format("Reading config from %s", this.myPropertiesPath));
            try {
                Properties reloadedProperties = ConfiguratorUtils.loadPropertiesFile((File)this.myPropertiesPath.toFile());
                this.myProperties.clear();
                this.myProperties.putAll((Map<?, ?>)reloadedProperties);
            }
            catch (StatusException e) {
                throw new BadConfigurationException("Could not load config from " + this.myPropertiesPath + ": " + e.getMessage(), e);
            }
        } else {
            UpgradeProperties.getLogger().debug(String.format("config does not exists at %s", this.myPropertiesPath));
        }
        this.migrateLegacyProperties(bundleProperties);
        this.updateUpgradeModeFlag();
    }

    @NotNull
    Collection<String> updatePropertiesByWizard(@NotNull Properties properties, @NotNull BundleProperties bundleProperties) {
        this.reloadProperties(bundleProperties);
        HashSet<String> overriddenUpgradeProperties = new HashSet<String>();
        for (String propName : properties.stringPropertyNames()) {
            if (!propName.startsWith("upgrade")) continue;
            overriddenUpgradeProperties.add(propName);
        }
        boolean isDirty = false;
        for (String propName : overriddenUpgradeProperties) {
            String upgradePropertyName = propName.substring("upgrade".length() + 1);
            String oldValue = this.myProperties.getProperty(upgradePropertyName);
            String newValue = properties.getProperty(propName);
            if ((oldValue != null || newValue == null) && (oldValue == null || oldValue.equals(newValue))) continue;
            this.setProperty(upgradePropertyName, newValue);
            isDirty = true;
        }
        if (isDirty) {
            this.saveConfig();
        }
        return overriddenUpgradeProperties;
    }

    private void setProperty(String upgradePropertyName, String newValue) {
        this.myProperties.setProperty(upgradePropertyName, newValue);
        if (BundleProperty.PREVIOUSLY_STARTED_PRODUCT_VERSION.getName().equals(upgradePropertyName)) {
            this.updateUpgradeModeFlag();
        }
    }

    public boolean isUpgrade() {
        return this.myUpgradeFlag;
    }

    public boolean isCleanInstallationInProgress() {
        return !this.myProperties.containsKey(BundleProperty.PREVIOUSLY_STARTED_PRODUCT_VERSION.getName());
    }

    @NotNull
    Properties getProperties() {
        return this.myProperties;
    }

    @NotNull
    private static Path getServicesVersionsFile(@NotNull BundleEnvironment bundleEnvironment) {
        return bundleEnvironment.getUpgradePropertiesFile();
    }

    @NotNull
    private static Logger getLogger() {
        return LoggerFactory.getLogger(UpgradePropertiesProvider.class);
    }

    private void saveConfig() {
        UpgradeProperties.saveConfig(this.myPropertiesPath, this.myProperties);
    }

    private static void saveConfig(@NotNull Path propertiesPath, @NotNull Properties properties) {
        PropertiesUtil.saveConfig((Path)propertiesPath, (Properties)properties, (String)"Versions of services from Bundle. Don't update this file manually.", (boolean)true);
    }

    private boolean updateProductInfo() {
        this.setProperty("bundle.product.name", this.myBuildProperties.getBundleProductName());
        String productVersion = this.myBuildProperties.getProductFullVersionNumber();
        this.setProperty(BundleProperty.PREVIOUSLY_STARTED_PRODUCT_VERSION.getName(), productVersion);
        return true;
    }

    private boolean updatePreviouslyStartedVersionForService(@NotNull String serviceId, @NotNull String version) {
        String property = PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceId, "previously-started-version");
        String oldValue = this.myProperties.getProperty(property);
        if (oldValue == null || !oldValue.equals(version)) {
            this.setProperty(property, version);
            return true;
        }
        return false;
    }

    static class ConfigureFinishedListener
    extends OnePerClassListener<ConfigureFinishedEvent> {
        ConfigureFinishedListener() {
        }

        @Override
        public void onSuccess(@NotNull ConfigureFinishedEvent event) {
            UpgradeProperties upgradeProperties = event.getBundleState().getUpgradeProperties();
            boolean isDirty = false;
            if (isDirty) {
                upgradeProperties.saveConfig();
            }
        }

        @Override
        public void onFailure(@NotNull ConfigureFinishedEvent event, @NotNull Throwable t) {
        }
    }

    static class StartFinishedListener
    extends OnePerClassListener<StartFinishedEvent> {
        StartFinishedListener() {
        }

        @Override
        public void onSuccess(@NotNull StartFinishedEvent event) {
            UpgradeProperties upgradeProperties = event.getBundleState().getUpgradeProperties();
            boolean isDirty = upgradeProperties.updateProductInfo();
            if (isDirty) {
                upgradeProperties.saveConfig();
            }
        }

        @Override
        public void onFailure(@NotNull StartFinishedEvent event, @NotNull Throwable t) {
        }
    }

    public static class ServiceStartedListener
    extends OnePerClassListener<ServiceStartedEvent> {
        @Override
        public void onSuccess(@NotNull ServiceStartedEvent event) {
            UpgradeProperties upgradeProperties;
            if (!event.getServiceDescriptor().isInternal() && (upgradeProperties = event.getBundleState().getUpgradeProperties()).updatePreviouslyStartedVersionForService(event.getServiceDescriptor().getId(), event.getServiceDescriptor().getVersion())) {
                upgradeProperties.saveConfig();
            }
        }

        @Override
        public void onFailure(@NotNull ServiceStartedEvent event, @NotNull Throwable t) {
        }
    }
}

