/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.api.internal.awc.ext.impl;

import com.jetbrains.bundle.api.internal.auth.AuthResult;
import com.jetbrains.bundle.api.internal.awc.ext.AdminConsoleExtension;
import com.jetbrains.bundle.api.internal.awc.ext.model.HubSettings;
import com.jetbrains.bundle.api.internal.awc.ext.model.KeyStoreSettings;
import com.jetbrains.bundle.api.internal.awc.ext.model.ProductState;
import com.jetbrains.bundle.api.internal.awc.ext.model.migration.Migration;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;

public class DelegatingAdminConsoleExtension
implements AdminConsoleExtension {
    private static ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static volatile AdminConsoleExtension myAdminConsoleExtension;

    public void init() {
        DelegatingAdminConsoleExtension.getAdminConsoleExtension().init();
    }

    public Migration getMigration() {
        return DelegatingAdminConsoleExtension.getAdminConsoleExtension().getMigration();
    }

    public Migration storeMigration(@NotNull Migration migration) {
        return DelegatingAdminConsoleExtension.getAdminConsoleExtension().storeMigration(migration);
    }

    public void deleteMigration(boolean backup) {
        DelegatingAdminConsoleExtension.getAdminConsoleExtension().deleteMigration(backup);
    }

    public Collection<Migration> getBackedUpMigrations() {
        return DelegatingAdminConsoleExtension.getAdminConsoleExtension().getBackedUpMigrations();
    }

    @NotNull
    public HubSettings getHubSettings() {
        return DelegatingAdminConsoleExtension.getAdminConsoleExtension().getHubSettings();
    }

    @NotNull
    public ProductState getProductState() {
        return DelegatingAdminConsoleExtension.getAdminConsoleExtension().getProductState();
    }

    public void applyExternalHub(@NotNull String hubUrl) {
        DelegatingAdminConsoleExtension.getAdminConsoleExtension().applyExternalHub(hubUrl);
    }

    public void switchToInternalHub() {
        DelegatingAdminConsoleExtension.getAdminConsoleExtension().switchToInternalHub();
    }

    @NotNull
    public AuthResult authenticate(@NotNull String awcToken) {
        return DelegatingAdminConsoleExtension.getAdminConsoleExtension().authenticate(awcToken);
    }

    @NotNull
    public KeyStoreSettings getKeyStoreSettings() {
        return DelegatingAdminConsoleExtension.getAdminConsoleExtension().getKeyStoreSettings();
    }

    public void storeClientCertificatePassword(@NotNull String clientCertificateAlias, @NotNull String clientCertificatePassword) {
        DelegatingAdminConsoleExtension.getAdminConsoleExtension().storeClientCertificatePassword(clientCertificateAlias, clientCertificatePassword);
    }

    public static void setProvider(AdminConsoleExtension adminConsoleExtension) {
        try {
            rwLock.writeLock().lock();
            myAdminConsoleExtension = adminConsoleExtension;
        }
        finally {
            rwLock.writeLock().unlock();
        }
    }

    private static AdminConsoleExtension getAdminConsoleExtension() {
        try {
            rwLock.readLock().lock();
            if (myAdminConsoleExtension == null) {
                throw new RuntimeException(String.format("%s is not initialized", AdminConsoleExtension.class.getSimpleName()));
            }
            AdminConsoleExtension adminConsoleExtension = myAdminConsoleExtension;
            return adminConsoleExtension;
        }
        finally {
            rwLock.readLock().unlock();
        }
    }
}

