/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.exceptions;

import com.jetbrains.bundle.ServiceDescriptor;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ServicesAlreadyStartedException
extends RuntimeException {
    private final List<ServiceDescriptor> myServiceList;

    public ServicesAlreadyStartedException(@NotNull List<ServiceDescriptor> serviceList) {
        super(ServicesAlreadyStartedException.getErrorMessage(serviceList));
        this.myServiceList = serviceList;
    }

    public ServicesAlreadyStartedException(@NotNull List<ServiceDescriptor> serviceList, Throwable cause) {
        super(ServicesAlreadyStartedException.getErrorMessage(serviceList), cause);
        this.myServiceList = serviceList;
    }

    public List<ServiceDescriptor> getStartedServices() {
        return this.myServiceList;
    }

    public static String getErrorMessage(List<ServiceDescriptor> serviceDescriptors) {
        StringBuilder sb = new StringBuilder();
        sb.append("Service").append(serviceDescriptors.size() > 1 ? "s" : "").append(" [");
        for (int i = 0; i < serviceDescriptors.size(); ++i) {
            sb.append(serviceDescriptors.get(i).getId()).append(i < serviceDescriptors.size() - 1 ? ", " : "]");
        }
        sb.append(" ha").append(serviceDescriptors.size() > 1 ? "ve" : "s").append(" been started already.");
        return sb.toString();
    }

    public String getStartedServiceIds() {
        HashSet<String> serviceIds = new HashSet<String>();
        for (ServiceDescriptor descriptor : this.myServiceList) {
            serviceIds.add(descriptor.getId());
        }
        return serviceIds.toString();
    }

    public String getStartedServiceNames() {
        HashSet<String> serviceIds = new HashSet<String>();
        for (ServiceDescriptor descriptor : this.myServiceList) {
            serviceIds.add(descriptor.getPresentableName());
        }
        return serviceIds.toString();
    }
}

