/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.launcher.config.impl;

import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.exceptions.BundleStartupException;
import com.jetbrains.bundle.exceptions.LauncherOutdatedConfigException;
import com.jetbrains.bundle.launcher.config.impl.ConsistencyKeeperBase;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.bundle.listener.OnePerClassListener;
import com.jetbrains.bundle.listener.event.StartFinishedEvent;
import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.contexts.StartupContext;
import com.jetbrains.service.util.cmd.ExecutionResult;
import java.util.Collections;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartingConsistencyKeeper
extends ConsistencyKeeperBase<StartupContext> {
    @Override
    protected void processOutdatedConfig(@NotNull Properties outDatedLauncherProperties, @NotNull BundleState bundleState) {
        if (!bundleState.getContextHolder().isRestart()) {
            super.processOutdatedConfig(outDatedLauncherProperties, bundleState);
        } else {
            this.LOG.warn(String.format("Launcher settings [%s] still differs from those used in Application after service RESTART", outDatedLauncherProperties.stringPropertyNames()));
        }
    }

    @Override
    protected void handleLauncherReconfigurationResult(@NotNull Properties outDatedLauncherProperties, @NotNull ExecutionResult result, @NotNull BundleState bundleState) {
        if (result.exitCode == LauncherExitCode.OK.getValue()) {
            throw new LauncherOutdatedConfigException("Reconfiguration of Application Launcher has been successfully finished, It will be restarted. The following properties will be applied: " + outDatedLauncherProperties);
        }
        this.LOG.error(String.format("Reconfiguring of Application launcher exited with erroneous code %s and output [%s]", result.exitCode, result.myCommandOutput));
        throw new BundleStartupException(AppExitCode.EXIT, "Failed to reconfigure application launcher");
    }

    @Override
    public void addBundleLifeCycleListeners(@NotNull BundleState bundleState) {
        bundleState.addStartFinishedListener(new BundleStartFinishedListener());
    }

    public static class BundleStartFinishedListener
    extends OnePerClassListener<StartFinishedEvent> {
        protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

        @Override
        public void onSuccess(@NotNull StartFinishedEvent event) {
        }

        @Override
        public void onFailure(@NotNull StartFinishedEvent event, @NotNull Throwable t) {
            if (t instanceof LauncherOutdatedConfigException) {
                this.LOG.debug("Requesting restart after launcher reconfiguration");
                event.getBundleState().getContextHolder().requestRestart(event.getBundleState().isRunAfterWizardCompletion() ? Collections.emptyMap() : Collections.singletonMap(ApplicationContextHolder.RestartParameters.openBrowserOnStartUp.name(), Boolean.TRUE.toString()));
            }
        }
    }
}

