/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.proxy.jetty;

import com.jetbrains.service.jetty.SimpleJettyService;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketProxySocket
extends WebSocketAdapter {
    static int MaxMessageSize = 0x1400000;
    private static Logger LOG = LoggerFactory.getLogger(WebSocketProxySocket.class);
    private static AtomicInteger myDebugIdCounter = new AtomicInteger();
    private volatile WebSocketClient myWebSocketClient;
    private Future<Session> myClientSessionFuture;
    private URI myRemoteEndpoint;
    private AtomicBoolean myClosing = new AtomicBoolean();
    private final int myDebugId;

    public WebSocketProxySocket(URI remoteEndpoint) {
        this.myRemoteEndpoint = remoteEndpoint;
        this.myDebugId = myDebugIdCounter.incrementAndGet();
    }

    public void onWebSocketConnect(final Session session) {
        super.onWebSocketConnect(session);
        WebSocketProxySocket.logSessionDetails("SERVER", this.myDebugId, "**** Server connects", session);
        LOG.debug("SERVER {} **** Proxied endpoint {}", (Object)this.myDebugId, (Object)this.myRemoteEndpoint);
        this.myWebSocketClient = new WebSocketClient(new SslContextFactory(), null, null){

            public Future<Session> connect(Object webSocket, URI toUri, ClientUpgradeRequest request) throws IOException {
                LOG.debug("SERVER {} **** Connects client {}", (Object)WebSocketProxySocket.this.myDebugId, (Object)(WebSocketClient.class.getSimpleName() + "@" + this.hashCode()));
                request.setCookies(session.getUpgradeRequest().getCookies());
                request.setHeaders(session.getUpgradeRequest().getHeaders());
                return super.connect(webSocket, toUri, request);
            }
        };
        this.myWebSocketClient.getPolicy().setMaxBinaryMessageSize(MaxMessageSize);
        this.myWebSocketClient.getPolicy().setMaxTextMessageSize(MaxMessageSize);
        this.myWebSocketClient.getHttpClient().setRequestBufferSize(SimpleJettyService.getRequestHeaderBufferSize().intValue());
        this.myWebSocketClient.getHttpClient().setResponseBufferSize(SimpleJettyService.getResponseHeaderBufferSize().intValue());
        try {
            this.myWebSocketClient.start();
            this.myClientSessionFuture = this.myWebSocketClient.connect((Object)new WebSocketAdapter(){

                public void onWebSocketBinary(byte[] payload, int offset, int len) {
                    try {
                        LOG.debug("CLIENT {} **** <- [bytes]", (Object)WebSocketProxySocket.this.myDebugId);
                        session.getRemote().sendBytes(ByteBuffer.wrap(payload, offset, len));
                    }
                    catch (Throwable t) {
                        LOG.warn("sendBytes from client", t);
                    }
                }

                public void onWebSocketClose(int statusCode, String reason) {
                    LOG.debug("CLIENT {} *** Client closes connection, statusCode={}, reason={}", new Object[]{WebSocketProxySocket.this.myDebugId, statusCode, reason});
                    if (!WebSocketProxySocket.this.myClosing.getAndSet(true)) {
                        WebSocketProxySocket.logSessionDetails("CLIENT", WebSocketProxySocket.this.myDebugId, "*** Closes server session", session);
                        try {
                            session.close(statusCode, reason);
                        }
                        catch (Throwable sessionCloseError) {
                            LOG.error("CLIENT {} Error closing server session", (Object)WebSocketProxySocket.this.myDebugId, (Object)sessionCloseError);
                        }
                    }
                    super.onWebSocketClose(statusCode, reason);
                }

                public void onWebSocketConnect(Session session2) {
                    WebSocketProxySocket.logSessionDetails("CLIENT", WebSocketProxySocket.this.myDebugId, "**** Client connected", session2);
                    super.onWebSocketConnect(session2);
                }

                public void onWebSocketError(Throwable cause) {
                    super.onWebSocketError(cause);
                    String causeDetails = "";
                    if (cause != null && cause instanceof UpgradeException) {
                        UpgradeException ue = (UpgradeException)cause;
                        causeDetails = String.format("due to %s (requestUri = %s, responseStatusCode = %s)", ue.getClass().getSimpleName(), ue.getRequestURI(), ue.getResponseStatusCode());
                    }
                    LOG.warn(String.format("CLIENT %s  onWebSocketError on client %s", WebSocketProxySocket.this.myDebugId, causeDetails), cause);
                }

                public void onWebSocketText(String message) {
                    try {
                        LOG.debug("CLIENT {} **** <- {}", (Object)WebSocketProxySocket.this.myDebugId, (Object)message);
                        session.getRemote().sendString(message);
                    }
                    catch (Throwable t) {
                        LOG.warn("sendString from client", t);
                    }
                }
            }, this.myRemoteEndpoint);
        }
        catch (Throwable e) {
            LOG.error("SERVER {} Error connecting to endpoint {}", new Object[]{this.myDebugId, this.myRemoteEndpoint, e});
            try {
                session.close();
            }
            catch (Throwable sessionCloseError) {
                LOG.error("SERVER {} Error closing session", (Object)this.myDebugId, (Object)sessionCloseError);
            }
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        LOG.debug("SERVER {} *** Server disconnects, statusCode={}, reason={}", new Object[]{this.myDebugId, statusCode, reason});
        if (!this.myClosing.getAndSet(true)) {
            try {
                WebSocketProxySocket.logSessionDetails("SERVER", this.myDebugId, "*** Closes client session", this.myClientSessionFuture.get());
                this.myClientSessionFuture.get().close(statusCode, reason);
            }
            catch (Throwable t) {
                LOG.warn("SERVER {} *** Error closing client session", (Object)this.myDebugId, (Object)t);
            }
            this.closeWebSocketClient(false);
        } else {
            Thread closeWebSocketClientThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    WebSocketProxySocket.this.closeWebSocketClient(true);
                }
            });
            closeWebSocketClientThread.start();
        }
        WebSocketProxySocket.logSessionDetails("SERVER", this.myDebugId, "*** Server sessions is closed", this.getSession());
        super.onWebSocketClose(statusCode, reason);
    }

    private void closeWebSocketClient(boolean fromSeparateThread) {
        try {
            LOG.debug("SERVER {} *** stopping client {}", (Object)this.myDebugId, (Object)(fromSeparateThread ? "from separate thread" : ""));
            this.myWebSocketClient.stop();
            this.myWebSocketClient = null;
        }
        catch (Throwable t) {
            LOG.warn("SERVER {} *** error stopping client", (Object)this.myDebugId, (Object)t);
        }
    }

    public void onWebSocketError(Throwable cause) {
        super.onWebSocketError(cause);
        LOG.debug("SERVER {} *** onWebSocketError on server", (Object)this.myDebugId, (Object)cause);
    }

    public void onWebSocketText(String message) {
        try {
            LOG.debug("SERVER {} **** -> {}", (Object)this.myDebugId, (Object)message);
            this.myClientSessionFuture.get().getRemote().sendString(message);
        }
        catch (Throwable t) {
            LOG.warn("SERVER {} *** sendString on server", (Object)this.myDebugId, (Object)t);
        }
    }

    public void onWebSocketBinary(byte[] payload, int offset, int len) {
        try {
            LOG.debug("**** -> [bytes]");
            this.myClientSessionFuture.get().getRemote().sendBytes(ByteBuffer.wrap(payload, offset, len));
        }
        catch (Throwable t) {
            LOG.warn("sendBytes", t);
        }
    }

    private static void logSessionDetails(@NotNull String originator, int socketId, @NotNull String message, @NotNull Session session) {
        try {
            InetSocketAddress localAddress = session.getLocalAddress();
            InetSocketAddress remoteAddress = session.getRemoteAddress();
            LOG.debug("{} {} {} {} <-> {}", new Object[]{originator, socketId, message, localAddress, remoteAddress});
        }
        catch (Throwable t) {
            LOG.debug("{} {} {} (Failed to get addresses: {})", new Object[]{originator, socketId, message, t.getMessage()});
        }
    }
}

