/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.services.impl;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.bundle.services.ServicesContainer;
import com.jetbrains.bundle.services.impl.BundledService;
import com.jetbrains.service.util.ConfiguratorUtils;
import java.io.File;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class BundledInternalService
extends BundledService {
    private final BundleEnvironment myBundleEnvironment;

    public BundledInternalService(ServiceDescriptor serviceDescriptor, String serviceStatusURL, BundleEnvironment environment, @NotNull ServicesContainer hostingContainer, @NotNull ApplicationContextHolder applicationContextHolder) {
        super(serviceDescriptor, serviceStatusURL, hostingContainer, applicationContextHolder);
        this.myBundleEnvironment = environment;
    }

    @Override
    public void configure(@NotNull Properties properties) {
        super.configure(properties);
        File configFile = this.getServiceConfigFile();
        ConfiguratorUtils.savePropertiesFile((File)configFile, (Properties)properties);
    }

    @Override
    @NotNull
    public File getServiceConfLocation() {
        return this.myBundleEnvironment.getInternalServiceConfDir(this.getDescriptor().getId());
    }
}

