/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.services.impl;

import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.bundle.services.impl.ServiceBase;
import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.Status;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.cmd.CmdUtil;
import com.jetbrains.service.util.cmd.ExecuteServiceCommandException;
import com.jetbrains.service.util.cmd.ExecutionContext;
import com.jetbrains.service.util.cmd.ExecutionResult;
import com.jetbrains.service.util.contract.BundleContractViolationException;
import com.jetbrains.service.util.contract.ServiceConfLocationResolver;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class CliService
extends ServiceBase {
    private static final int DEFAULT_START_SERVICE_TIMEOUT = 86400000;
    private static final int DEFAULT_STOP_SERVICE_TIMEOUT = 86400000;
    private static final int DEFAULT_LIST_JVM_OPTIONS_SERVICE_TIMEOUT = 5000;

    public CliService(@NotNull ServiceDescriptor serviceDescriptor, @NotNull ApplicationContextHolder applicationContextHolder) {
        super(serviceDescriptor, applicationContextHolder);
    }

    @Override
    public void doStart() {
        ArrayList<String> args = new ArrayList<String>();
        this.addDebugArg(args);
        ExecutionContext context = new ExecutionContext();
        context.put(ExecutionContext.Param.executionTimeoutInMillis, (Object)86400000);
        this.executeServiceCommand(this.getDescriptor().getStartCommand(), args, Arrays.asList(LauncherExitCode.OK.getValue(), LauncherExitCode.ILLEGAL_STATE.getValue()), context);
    }

    @Override
    public void stop(boolean force, @NotNull AppExitCode suggestedExitCode) {
        ArrayList<String> args = new ArrayList<String>();
        this.addDebugArg(args);
        ExecutionContext context = new ExecutionContext();
        context.put(ExecutionContext.Param.executionTimeoutInMillis, (Object)86400000);
        this.executeServiceCommand(this.getDescriptor().getStopCommand(), args, Arrays.asList(LauncherExitCode.OK.getValue(), LauncherExitCode.ILLEGAL_STATE.getValue()), context);
    }

    @Override
    @NotNull
    public StatusDescriptor status() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("short");
        this.addDebugArg(args);
        if (!this.LOG.isDebugEnabled()) {
            args.add("--quiet");
        }
        ExecutionResult result = this.executeServiceCommandWithExitCode(this.getDescriptor().getStatusCommand(), args, null);
        String statusMessage = "Status command for service [" + this.getDescriptor().getId() + "] exited with code [" + result.exitCode + "] and returned the following output: [" + result.myCommandOutput + "]";
        this.LOG.debug(statusMessage);
        StatusDescriptor statusDescriptor = StatusDescriptor.parse((String)result.myCommandOutput);
        if (Status.ERROR == statusDescriptor.getStatus() && !result.myCommandOutput.toUpperCase().contains(Status.ERROR.name()) && !result.myCommandOutput.toUpperCase().contains("UNKNOWN") && result.exitCode == 0) {
            statusDescriptor = new StatusDescriptor(Status.RUNNING, statusMessage);
        }
        return statusDescriptor;
    }

    private void addDebugArg(List<String> args) {
        if (this.getApplicationContextHolder().isDebugEnabled()) {
            args.add("--debug");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(@NotNull Properties properties) {
        super.configure(properties);
        try {
            Path tempFile = Files.createTempFile("configure-args-", ".properties", new FileAttribute[0]);
            try {
                ConfiguratorUtils.savePropertiesFile((File)tempFile.toFile(), (Properties)properties, (String)("Settings for " + this.getDescriptor().getId()));
                ArrayList<String> additionalArguments = new ArrayList<String>();
                this.addDebugArg(additionalArguments);
                additionalArguments.addAll(!this.getDescriptor().getId().contains("teamcity-agent") ? Arrays.asList("-f", tempFile.toString()) : Collections.singletonList(tempFile.toString()));
                this.executeServiceCommand(this.getDescriptor().getConfigureCommand(), additionalArguments, Collections.singletonList(LauncherExitCode.OK.getValue()), null);
            }
            finally {
                Files.delete(tempFile);
            }
        }
        catch (IOException e) {
            throw new StatusException("Error in configure: " + e.getMessage());
        }
    }

    @Override
    @NotNull
    public final File getServiceConfigFile() {
        throw new UnsupportedOperationException(String.format("Service config file of service %s is unknown", this.getDescriptor().getId()));
    }

    @Override
    @NotNull
    public File getServiceConfLocation() {
        try {
            return ServiceConfLocationResolver.resolve((File)this.getServiceHome().toFile());
        }
        catch (BundleContractViolationException e) {
            throw new RuntimeException("Can not resolve service conf location", e);
        }
    }

    @Override
    @NotNull
    public Map<String, String> listSystemProperties() {
        ExecutionContext context = new ExecutionContext();
        context.put(ExecutionContext.Param.executionTimeoutInMillis, (Object)5000);
        context.put(ExecutionContext.Param.logOutputToConsole, (Object)false);
        ExecutionResult result = this.executeServiceCommandWithExitCode(this.getDescriptor().getListCommand(), Arrays.asList("jvm-options"), context);
        if (0 == result.exitCode) {
            String jvmOptions = result.myCommandOutput;
            return CliService.parseSystemProperties(jvmOptions);
        }
        throw new ExecuteServiceCommandException(String.format("Command [list jvm-options] of service %s exited with unexpected code %s", this.getDescriptor().getId(), result.exitCode), result);
    }

    private void executeServiceCommand(List<String> command, List<String> additionalArguments, @NotNull List<Integer> allowedExitCodes, ExecutionContext context) {
        ExecutionResult result = this.executeServiceCommandWithExitCode(command, additionalArguments, context);
        if (!allowedExitCodes.contains(result.exitCode)) {
            throw new ExecuteServiceCommandException("Not allowed exit code " + result.exitCode + " from process: " + ConfiguratorUtils.join(command, (String)" "), result);
        }
    }

    private static Map<String, String> parseSystemProperties(String jvmOptions) {
        String[] lines;
        HashMap<String, String> resultMap = new HashMap<String, String>();
        for (String line : lines = jvmOptions.split(System.lineSeparator())) {
            String nameValuePair;
            String[] parts;
            if (!line.startsWith("-D") || (parts = (nameValuePair = line.substring(2)).split("=")).length != 2 || parts[0].trim().length() <= 0 || parts[1].length() <= 0) continue;
            resultMap.put(parts[0], parts[1]);
        }
        return resultMap;
    }

    public static void main(String[] args) throws Exception {
        File cmdOutput = new File("C:\\Sources\\Git\\git.labs.intellij.net\\ring\\bundle\\dest\\bin\\options.log");
        String str = new String(Files.readAllBytes(cmdOutput.toPath()));
        System.out.println("########################################");
        for (String line : Files.readAllLines(cmdOutput.toPath(), Charset.forName("UTF-8"))) {
            System.out.println(line + "$");
        }
        System.out.println("########################################");
        System.out.println(CliService.parseSystemProperties(str));
        System.out.println("########################################");
    }

    @NotNull
    ExecutionResult executeServiceCommandWithExitCode(List<String> command, @NotNull List<String> additionalArguments, ExecutionContext context) {
        Path serviceDirectory = this.getDescriptor().getFullPath();
        String scriptName = CmdUtil.getScriptName((Path)serviceDirectory, (String)command.get(0));
        return CmdUtil.executeCommandWithExitCode((String)scriptName, (Path)serviceDirectory, (String)this.getDescriptor().getId(), command.subList(1, command.size()), additionalArguments, (ExecutionContext)context);
    }
}

