/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.services.impl;

import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.services.impl.ServiceBase;
import com.jetbrains.bundle.services.impl.jetty.BundleJettyServicesContainer;
import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.StatusDescriptor;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.jetty.context.StartupContextProvider;
import com.jetbrains.service.util.contract.service.context.CommonContextProvider;
import com.jetbrains.service.util.contract.service.context.ConfiguringContextProvider;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class InProcessJettyService<D extends BundleJettyServicesContainer>
extends ServiceBase {
    @NotNull
    private final D myWrappedService;
    @NotNull
    private final BundleState myBundleState;

    public InProcessJettyService(@NotNull D wrappedService, @NotNull ServiceDescriptor descriptor, @NotNull BundleState bundleState) {
        super(descriptor, bundleState.getContextHolder());
        this.myWrappedService = wrappedService;
        this.myBundleState = bundleState;
    }

    @Override
    public void doStart() throws StartupException {
        this.myWrappedService.start((StartupContextProvider)new InProcessServiceContext());
    }

    @Override
    public void stop(boolean force, @NotNull AppExitCode suggestedExitCode) {
        this.myWrappedService.shutdown(force, suggestedExitCode);
    }

    @Override
    @NotNull
    public StatusDescriptor status() {
        return this.myWrappedService.getStatus();
    }

    @Override
    public void configure(@NotNull Properties properties) {
        super.configure(properties);
        ((BundleJettyServicesContainer)this.myWrappedService).configure(properties, (CommonContextProvider)new InProcessServiceContext());
    }

    @Override
    @NotNull
    public File getServiceConfLocation() {
        return this.myBundleState.getEnvironment().getInternalServiceConfDir(this.getDescriptor().getId());
    }

    @Override
    @NotNull
    public File getServiceConfigFile() {
        return new File(this.getServiceConfLocation(), "service-config.properties");
    }

    @NotNull
    public D getWrappedService() {
        return this.myWrappedService;
    }

    private class InProcessServiceContext
    implements StartupContextProvider,
    ConfiguringContextProvider {
        private InProcessServiceContext() {
        }

        public File getServiceHome() {
            return InProcessJettyService.this.getDescriptor().getFullPath().toFile();
        }

        public File getAppConfFolder() {
            return InProcessJettyService.this.getServiceConfLocation();
        }

        public Map<String, String> getNewProperties() {
            throw new UnsupportedOperationException("All properties has been already resolved for in-process service.  Bundle command line should not be taken into account.");
        }

        public boolean isDebugEnabled() {
            return InProcessJettyService.this.myBundleState.getContextHolder().getContext().getLogSettings().getLogLevel().isDebugEnabled();
        }
    }
}

