/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.services.impl.jetty;

import com.jetbrains.bundle.launcher.context.holder.ApplicationContextHolder;
import com.jetbrains.bundle.services.ServicesContainer;
import com.jetbrains.bundle.services.ServicesHolder;
import com.jetbrains.bundle.services.impl.ServiceBase;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.jetty.SimpleConfigurableService;
import com.jetbrains.service.jetty.SimpleJettyService;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ClazzLoader;
import com.jetbrains.service.util.PropertiesUtil;
import com.jetbrains.service.util.StatusException;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.VirtualHostsDefault;
import com.jetbrains.service.util.contract.service.context.CommonContextProvider;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.WebAppClassLoader;
import org.eclipse.jetty.webapp.WebAppContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BundleJettyServicesContainer
extends SimpleJettyService
implements ServicesContainer {
    public static final int REQUEST_TIMEOUT_MS = 10800000;
    private final ServicesHolder myServicesHolder;
    @NotNull
    private final ApplicationContextHolder myApplicationContextHolder;

    public BundleJettyServicesContainer(@NotNull ServicesHolder servicesHolder, @NotNull ApplicationContextHolder applicationContextHolder) {
        this.myServicesHolder = servicesHolder;
        this.myApplicationContextHolder = applicationContextHolder;
    }

    @NotNull
    protected HandlerCollection getHandlerCollection(@NotNull Properties allProperties, @NotNull Server server) throws StartupException, IOException {
        return new ContextHandlerCollection();
    }

    @Override
    @NotNull
    public ClassLoader startServiceInContainer(@NotNull String serviceId) throws StartupException {
        ContextHandlerCollection handlerCollection = this.getContextHandlerCollection();
        WebAppContext context = BundleJettyServicesContainer.findServiceWebAppContext(handlerCollection, serviceId);
        try {
            if (context == null) {
                Server server = this.getServer();
                context = this.addServiceToBundleProcess(this.getAllProperties(), serviceId, server);
                this.startContextInContainer((ServletContextHandler)context, serviceId);
            } else {
                context.start();
            }
            return context.getClassLoader();
        }
        catch (StartupException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StartupException(String.format("Can not start servlet context for the service %s", serviceId), (Throwable)e);
        }
    }

    @NotNull
    protected BundleConfigurableContainer createConfigurableService() {
        return new BundleConfigurableContainer();
    }

    public void configure(@NotNull Properties properties, @NotNull CommonContextProvider contextProvider) {
        ((BundleConfigurableContainer)this.getConfigurableService()).configure(properties, contextProvider);
    }

    protected void startContextInContainer(@NotNull ServletContextHandler contextHandler, @NotNull String serviceId) throws StartupException {
        try {
            ContextHandlerCollection handlerCollection = this.getContextHandlerCollection();
            Server server = this.getServer();
            contextHandler.setServer(server);
            contextHandler.start();
            handlerCollection.addHandler((Handler)contextHandler);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StartupException(String.format("Can not start servlet context for the service %s", serviceId), (Throwable)e);
        }
    }

    @Override
    public void stopServiceInContainer(@NotNull String serviceId) {
        if (this.getServer() == null) {
            return;
        }
        WebAppContext context = BundleJettyServicesContainer.findServiceWebAppContext(this.getContextHandlerCollection(), serviceId);
        if (context != null) {
            this.stopServletContext((ServletContextHandler)context, serviceId);
        } else {
            this.getLogger().debug(String.format("There is no web app context for service %s found. Perhaps, the service has not been started yet", serviceId));
        }
    }

    protected void stopServletContext(ServletContextHandler serviceContextHandler, @Nullable String serviceId) {
        if (this.getServer() == null || serviceContextHandler == null) {
            return;
        }
        try {
            serviceContextHandler.stop();
            this.getContextHandlerCollection().removeHandler((Handler)serviceContextHandler);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StatusException(String.format("Can not stop servlet context %s", serviceId != null ? "for the service " + serviceId : "bind to " + UrlUtil.combineContexts((String)"/", (String)serviceContextHandler.getContextPath())), (Throwable)e);
        }
    }

    @Nullable
    private static WebAppContext findServiceWebAppContext(@NotNull ContextHandlerCollection handlerCollection, @NotNull String serviceId) {
        WebAppContext context = null;
        Handler[] handlers = handlerCollection.getHandlers();
        if (handlers != null) {
            for (Handler handler : handlers) {
                if (!(handler instanceof WebAppContext) || !serviceId.equals(((WebAppContext)handler).getInitParameter("id"))) continue;
                context = (WebAppContext)handler;
                break;
            }
        }
        return context;
    }

    protected WebAppContext addServiceToBundleProcess(Properties allProperties, String serviceId, Server server) throws StartupException, IOException {
        String servicePath = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, serviceId, "service-folder-in-bundle");
        Path bundledServiceHome = Paths.get(servicePath, new String[0]);
        File webApp = this.getWebAppDirectory(allProperties, serviceId, bundledServiceHome);
        String beforeStartCallBackClass = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "before-start-callback-class");
        if (beforeStartCallBackClass != null && !beforeStartCallBackClass.trim().isEmpty()) {
            try {
                this.executeBeforeStartCallback(beforeStartCallBackClass, serviceId, bundledServiceHome);
            }
            catch (NoSuchMethodException e) {
                this.getLogger().error(String.format("before start callback class [%s] has no method 'perform'", beforeStartCallBackClass), (Throwable)e);
            }
        }
        Properties reloadedServiceProperties = this.getBundledServiceProperties(serviceId);
        WebAppContext bundledServiceWebContext = new WebAppContext();
        String additionalClasspath = reloadedServiceProperties.getProperty("additional-web-app-classpath");
        if (additionalClasspath != null) {
            bundledServiceWebContext.setExtraClasspath(additionalClasspath);
        }
        this.setupWebAppClassLoader(allProperties, serviceId, bundledServiceWebContext);
        File webXmlFile = new File(webApp, "WEB-INF/web.xml");
        if (webXmlFile.exists()) {
            bundledServiceWebContext.setDescriptor(webXmlFile.getCanonicalPath());
            String overriddenWebXmlPath = reloadedServiceProperties.getProperty("overridden-web-xml-path");
            if (overriddenWebXmlPath != null) {
                bundledServiceWebContext.setOverrideDescriptor(overriddenWebXmlPath);
            }
        } else if (Boolean.parseBoolean(PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "is-annotation-based"))) {
            Configuration.ClassList classList = Configuration.ClassList.serverDefault((Server)server);
            if (!classList.contains((Object)AnnotationConfiguration.class.getName())) {
                classList.add((Object)AnnotationConfiguration.class.getName());
            }
            bundledServiceWebContext.setConfigurationClasses((List)classList);
        }
        Boolean isParentFirstClassLoading = Boolean.valueOf(PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "is-parent-first-class-loading"));
        if (isParentFirstClassLoading.booleanValue()) {
            bundledServiceWebContext.setParentLoaderPriority(true);
        }
        bundledServiceWebContext.setResourceBase(webApp.getCanonicalPath());
        String serviceContext = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)allProperties, serviceId, "context");
        bundledServiceWebContext.setContextPath(serviceContext);
        bundledServiceWebContext.setThrowUnavailableOnStartupException(true);
        this.setInitParameters(reloadedServiceProperties, (ContextHandler)bundledServiceWebContext);
        if (Boolean.parseBoolean(PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "gzip-enable"))) {
            bundledServiceWebContext.setGzipHandler(this.buildGzipHandler(allProperties, serviceId));
        }
        BundleJettyServicesContainer.setVirtualHosts((ServletContextHandler)bundledServiceWebContext, allProperties);
        return bundledServiceWebContext;
    }

    protected static void setVirtualHosts(ServletContextHandler context, Properties bundleProcessProperties) {
        String[] virtualHosts = BundleJettyServicesContainer.resolveVirtualHosts(bundleProcessProperties);
        context.setVirtualHosts(virtualHosts);
    }

    @NotNull
    protected static String[] resolveVirtualHosts(@NotNull Properties allProperties) {
        VirtualHostsDefault virtualHostsDefault;
        HashSet<String> vHosts = new HashSet<String>();
        String virtualHosts = allProperties.getProperty(BundleProperty.VIRTUAL_HOSTS.getPrefixedName());
        if (!StringUtils.isEmpty((CharSequence)virtualHosts)) {
            vHosts.addAll(Arrays.asList(virtualHosts.split(",")));
        }
        if ((virtualHostsDefault = VirtualHostsDefault.fromName((String)allProperties.getProperty(BundleProperty.VIRTUAL_HOSTS_DEFAULT.getPrefixedName()))) != null) {
            String listenAddress = allProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getPrefixedName());
            vHosts.addAll(virtualHostsDefault.getVirtualHosts(listenAddress));
        }
        return vHosts.toArray(new String[0]);
    }

    private void setupWebAppClassLoader(Properties allProperties, String serviceId, WebAppContext bundledServiceWebContext) throws IOException {
        bundledServiceWebContext.addServerClass("com.jetbrains.bundle.bootstrap.");
        if (!Boolean.valueOf(PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "is-internal-service")).booleanValue()) {
            bundledServiceWebContext.addServerClass("org.slf4j.");
            bundledServiceWebContext.addServerClass("org.apache.log4j.");
            bundledServiceWebContext.addServerClass("org.apache.logging.log4j.");
            bundledServiceWebContext.addServerClass("org.apache.logging.slf4j.");
            bundledServiceWebContext.addServerClass("org.apache.commons.logging.");
            bundledServiceWebContext.addServerClass("com.jetbrains.bundle.api.internal.");
        }
        bundledServiceWebContext.addSystemClass("com.jetbrains.bundle.api.");
        if ("startingPage".equals(serviceId) || "adminService".equals(serviceId) || "bundleBackend".equals(serviceId)) {
            bundledServiceWebContext.addSystemClass("com.jetbrains.bundle.api.internal.");
            bundledServiceWebContext.addServerClass("org.aopalliance.");
            bundledServiceWebContext.setClassLoader((ClassLoader)new WebAppClassLoader(this.getClass().getClassLoader(), (WebAppClassLoader.Context)bundledServiceWebContext));
        } else {
            bundledServiceWebContext.setClassLoader((ClassLoader)new WebAppClassLoader(Server.class.getClassLoader(), (WebAppClassLoader.Context)bundledServiceWebContext));
        }
    }

    @NotNull
    protected WebAppContext getServiceContext(@NotNull Properties serviceProperties, @NotNull Server server) {
        throw new UnsupportedOperationException("Bundle container does not define and use its own service context, instead it hosts service context of bundled services");
    }

    private File getWebAppDirectory(Properties allProperties, String serviceId, Path bundledServiceHome) {
        boolean isInternal = Boolean.valueOf(PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)allProperties, serviceId, "is-internal-service"));
        File webApp = isInternal ? bundledServiceHome.toFile() : bundledServiceHome.resolve("web").toFile();
        return webApp;
    }

    @NotNull
    private Properties getBundledServiceProperties(@NotNull String serviceId) throws StartupException {
        File confFile = this.getBundledServicePropertiesFile(serviceId);
        try {
            return PropertiesUtil.loadProperties((File)confFile);
        }
        catch (IOException e) {
            throw new StartupException(String.format("Can not read service configuration file [%s]", confFile), (Throwable)e);
        }
    }

    @NotNull
    private File getBundledServicePropertiesFile(@NotNull String serviceId) throws StartupException {
        Properties properties;
        ServiceBase service = this.myServicesHolder.getNotNullService(serviceId);
        File propertiesFile = service.getServiceConfigFile();
        try {
            properties = PropertiesUtil.loadProperties((File)propertiesFile);
        }
        catch (IOException e) {
            throw new StartupException(String.format("Can not read service configuration file at [%s]", propertiesFile.getAbsoluteFile()), (Throwable)e);
        }
        String propertiesPointer = properties.getProperty("bundle-in-process-service-config-path");
        if (propertiesPointer == null) {
            return propertiesFile;
        }
        Path customPropertiesPath = Paths.get(propertiesPointer, new String[0]);
        File customPropertiesFile = !customPropertiesPath.isAbsolute() ? service.getServiceConfLocation().toPath().resolve(customPropertiesPath).toFile() : customPropertiesPath.toFile();
        return customPropertiesFile;
    }

    protected ServicesHolder getServicesHolder() {
        return this.myServicesHolder;
    }

    private void executeBeforeStartCallback(@NotNull String beforeStartCallbackClass, @NotNull String serviceId, @NotNull Path bundledServiceHome) throws NoSuchMethodException, StartupException {
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("jetbrains.service.config.file", this.getBundledServicePropertiesFile(serviceId).getCanonicalPath());
            parameters.put("jetbrains.debug.enabled", String.valueOf(this.myApplicationContextHolder.isDebugEnabled()));
            ClazzLoader.callMethod((File[])new File[]{bundledServiceHome.resolve("lib").toFile()}, (String)beforeStartCallbackClass, (String)"perform", (Class[])new Class[]{Map.class}, (Object[])new Object[]{parameters});
        }
        catch (IOException e) {
            this.getLogger().warn("* Service {}: can not prepare before start callback call ", (Object)serviceId, (Object)e);
        }
    }

    protected void logListenAddressStringOnStartup(@NotNull Properties properties) {
    }

    private static class BundleConfigurableContainer
    extends SimpleConfigurableService {
        private BundleConfigurableContainer() {
        }

        public void configure(@NotNull Properties properties, @NotNull CommonContextProvider contextProvider) {
            super.configure(properties, contextProvider);
        }
    }
}

