/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.wizard;

import com.jetbrains.service.util.ConfiguratorUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationFileWatcher {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public Path awaitConfigFile(String configFilePath) throws IOException, InterruptedException {
        Path config = Paths.get(configFilePath, new String[0]);
        this.awaitUntilFileIsCreated(config);
        while (true) {
            Properties properties = null;
            try {
                properties = ConfiguratorUtils.loadPropertiesFile((File)config.toFile());
            }
            catch (Exception e) {
                this.LOG.debug(String.format("File %s was created, but it is not readable still", config.toFile()));
            }
            if (properties != null && properties.containsKey("wizard.configuration.finished")) {
                this.logPropertiesNames(properties);
                return config;
            }
            int timeout = 500;
            if (properties != null) {
                this.LOG.debug(String.format("Retry loading properties in %s milliseconds", 500));
            }
            Thread.sleep(500L);
        }
    }

    private void logPropertiesNames(Properties properties) {
        this.LOG.debug(String.format("There are %s properties found", properties.size()));
        for (String propName : properties.stringPropertyNames()) {
            this.LOG.debug(String.format("Loaded property [%s]", propName));
        }
    }

    private Path awaitUntilFileIsCreated(Path config) throws IOException, InterruptedException {
        WatchKey key;
        WatchService watcher = FileSystems.getDefault().newWatchService();
        config.getParent().register(watcher, StandardWatchEventKinds.ENTRY_CREATE);
        if (Files.exists(config, new LinkOption[0])) {
            return config;
        }
        do {
            key = watcher.take();
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent<?> ev;
                Path createdFile;
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW || !(createdFile = (Path)(ev = event).context()).getFileName().equals(config.getFileName())) continue;
                return config;
            }
        } while (key.reset());
        throw new IOException(String.format("Folder %s is not accessible", config.getParent().toAbsolutePath().toString()));
    }
}

