/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.wizard;

import com.jetbrains.bundle.BundleBuildProperties;
import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.bundle.BundleProperties;
import com.jetbrains.bundle.BundleState;
import com.jetbrains.bundle.ServiceDescriptor;
import com.jetbrains.bundle.hub_client.util.HubUtil;
import com.jetbrains.bundle.services.ServicesContainer;
import com.jetbrains.bundle.services.impl.BundledInternalService;
import com.jetbrains.bundle.services.impl.HubConfiguratorService;
import com.jetbrains.bundle.wizard.WizardConfiguredProperties;
import com.jetbrains.launcher.exceptions.StartupException;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.LocaleUtil;
import com.jetbrains.service.util.SecureMode;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.Version;
import com.jetbrains.service.util.contract.JvmOptions;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigurationWizard
extends BundledInternalService {
    private static final List<Locale> DEFAULT_SUPPORTED_LOCALES = Collections.singletonList(Locale.forLanguageTag("en-US"));
    private final BundleState myBundleState;
    private final WizardConfiguredProperties myWizardConfiguredProperties;
    private final ServiceDescriptor myServiceForRedirection;
    @NotNull
    private final SupportedLocales mySupportedLocales;
    private final Map<String, ServiceDescriptor> myAllServicesInBundle;

    public ConfigurationWizard(@NotNull ServiceDescriptor configurationWizardDescriptor, @NotNull BundleState bundleState, @NotNull ServiceDescriptor serviceForRedirection, @NotNull Map<String, ServiceDescriptor> allServicesInBundle, @NotNull String serviceStatusURL, @NotNull ServicesContainer hostingServletContainer) {
        super(configurationWizardDescriptor, serviceStatusURL, bundleState.getEnvironment(), hostingServletContainer, bundleState.getContextHolder());
        this.myBundleState = bundleState;
        this.myWizardConfiguredProperties = new WizardConfiguredProperties(bundleState.getEnvironment());
        this.myServiceForRedirection = serviceForRedirection;
        this.mySupportedLocales = ConfigurationWizard.getSupportedLocales(allServicesInBundle);
        this.myAllServicesInBundle = allServicesInBundle;
    }

    @Override
    public void doStart() throws StartupException {
        this.myWizardConfiguredProperties.removeProperties(Collections.singleton("wizard.configuration.finished"));
        super.doStart();
    }

    private void setWizardToken(Properties wizardProperties) {
        Path wizardTokenStorage = ConfigurationWizard.getWizardTokenStorage(this.myBundleState.getEnvironment());
        String wizardToken = this.createAndStoreNewToken(wizardTokenStorage);
        wizardProperties.setProperty("jetbrains.bundle.wizard.auth.token", wizardToken);
        wizardProperties.setProperty("jetbrains.bundle.wizard.auth.token.storage", wizardTokenStorage.toString());
    }

    public String getWizardToken() {
        if (this.getProperties() == null || this.getProperty("jetbrains.bundle.wizard.auth.token") == null) {
            throw new IllegalStateException("Configuration wizard properties has not been configured yet");
        }
        return this.getProperty("jetbrains.bundle.wizard.auth.token");
    }

    @NotNull
    private String createAndStoreNewToken(@NotNull Path wizardTokenStorage) {
        String installationWizardToken = this.myBundleState.getEnvironment().getInstallationConfig().getWizardToken();
        String wizardToken = System.getProperty(JvmOptions.Bundle.CONFIGURATION_WIZARD_TOKEN, installationWizardToken != null ? installationWizardToken : ConfiguratorUtils.randomAlphanumeric((int)20));
        try {
            Files.createDirectories(wizardTokenStorage.getParent(), new FileAttribute[0]);
            Files.write(wizardTokenStorage, wizardToken.getBytes(Charset.forName("UTF-8")), new OpenOption[0]);
        }
        catch (IOException e) {
            this.LOG.warn(String.format("Failed to store Configuration Wizard auth token [%s] to file %s", wizardTokenStorage, wizardTokenStorage));
        }
        return wizardToken;
    }

    @NotNull
    private static Path getWizardTokenStorage(@NotNull BundleEnvironment environment) {
        File confDir = environment.getInternalServiceConfDir("configurationWizard");
        return confDir.toPath().resolve("wizard_token.txt");
    }

    @Override
    public void configure(@NotNull Properties properties) {
        Properties wizardProperties = new Properties();
        String configWizardBaseUrl = PropertiesBasedConfigurationHelper.getHelper().getMandatoryServiceProperty((Object)properties, "base-url");
        BundleEnvironment bundleEnvironment = this.myBundleState.getEnvironment();
        BundleBuildProperties buildProperties = this.myBundleState.getBuildProperties();
        BundleInstallationType installationType = bundleEnvironment.getInstallationConfig().getInstallationType();
        wizardProperties.setProperty("jetbrains.installer.output", this.myWizardConfiguredProperties.getPath().toString());
        wizardProperties.setProperty("jetbrains.bundle.wizard.service_for_redirection.url", UrlUtil.ensureEndsWithSlash((String)this.myBundleState.getProperties().getServiceUrl(this.myServiceForRedirection)));
        wizardProperties.setProperty("jetbrains.bundle.wizard.service_for_redirection.context", UrlUtil.ensureEndsWithSlash((String)this.myServiceForRedirection.getContext()));
        wizardProperties.setProperty("jetbrains.bundle.wizard.service_for_redirection.depends_on_bundle_port", String.valueOf(this.myBundleState.getProperties().isDefaultBaseUrl()));
        wizardProperties.setProperty("jetbrains.bundle.wizard.base_url", configWizardBaseUrl);
        ConfigurationWizard.setPropertyIfNotNull(wizardProperties, "jetbrains.bundle.wizard.installation.user", bundleEnvironment.getInstallationConfig().getInstallationUser());
        wizardProperties.setProperty("jetbrains.bundle.wizard.locales", LocaleUtil.toLocaleString(this.mySupportedLocales.getLocales()));
        wizardProperties.setProperty("jetbrains.bundle.wizard.locales.community", LocaleUtil.toLocaleString(this.mySupportedLocales.getCommunityLocales()));
        ConfigurationWizard.setPropertyIfNotNull(wizardProperties, "jetbrains.bundle.wizard.locales.community.link", buildProperties.getLocalesCommunityLink());
        wizardProperties.setProperty("jetbrains.bundle.product.name", buildProperties.getBundleProductName());
        ConfigurationWizard.setPropertyIfNotNull(wizardProperties, "jetbrains.bundle.product.upgrade.minimal.version", buildProperties.getBundleProductUpgradeMinimalVersion());
        wizardProperties.setProperty("jetbrains.bundle.wizard.product.full_version", buildProperties.getProductFullVersionNumber());
        wizardProperties.setProperty("jetbrains.bundle.wizard.product.presentation_name", buildProperties.getBundlePresentationName());
        wizardProperties.setProperty("jetbrains.bundle.wizard.upgrade_available", Boolean.toString(buildProperties.isUpgradeAvailable()));
        wizardProperties.setProperty("jetbrains.bundle.wizard.external_hub_permitted", Boolean.toString(buildProperties.isExternalHubPermitted()));
        wizardProperties.setProperty("jetbrains.bundle.product.manufacturer", buildProperties.getBundleProductManufacturer());
        wizardProperties.setProperty("jetbrains.bundle.wizard.installation.type", installationType.name());
        wizardProperties.setProperty("jetbrains.bundle.wizard.upgrade_detected", String.valueOf(this.myBundleState.getUpgradeProperties().isUpgrade()));
        ConfigurationWizard.setPropertyIfNotNull(wizardProperties, "jetbrains.bundle.upgrade.default-location", this.getDefaultUpgradeSourceLocation(properties, installationType));
        ConfigurationWizard.setPropertyIfNotNull(wizardProperties, "jetbrains.bundle.wizard.product.previous_full_version", PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)properties, BundleProperty.PREVIOUSLY_STARTED_PRODUCT_VERSION.getPrefixedName()));
        wizardProperties.setProperty("jetbrains.bundle.wizard.installation.directory", String.valueOf(this.myBundleState.getEnvironment().getBundleHome()));
        wizardProperties.setProperty("jetbrains.bundle.wizard.product.script.path", this.myBundleState.getContextHolder().getBundleScriptFile().toString());
        Path hubConfiguratorConfigFile = HubConfiguratorService.getConfigFileAbsolutePath(bundleEnvironment);
        Path relativeHubConfiguratorConfigFile = HubConfiguratorService.getConfigFileRelativePath(bundleEnvironment);
        wizardProperties.setProperty("jetbrains.bundle.wizard.hub-configurator-config-file", hubConfiguratorConfigFile.toString());
        wizardProperties.setProperty("jetbrains.bundle.wizard.configurator-config-file-in-backup", relativeHubConfiguratorConfigFile.toString());
        wizardProperties.setProperty("jetbrains.bundle.upgrade.help-link", buildProperties.getBundleUpgradeHelpLink());
        wizardProperties.setProperty("jetbrains.bundle.whats-new-page-link", buildProperties.getBundleProductWhatsNewLink());
        ConfigurationWizard.setPropertyIfNotNull(wizardProperties, "jetbrains.bundle.tls-files-generation-help-page-link", buildProperties.getBundleTlsFilesGenerationPageLink());
        wizardProperties.setProperty("id", properties.getProperty("id"));
        wizardProperties.setProperty("jetbrains.bundle.hub-service-id", properties.getProperty("bundle-hub-service-id", HubUtil.generateHubServiceId()));
        wizardProperties.setProperty("jetbrains.bundle.hub-service-secret", properties.getProperty("bundle-hub-service-secret", HubUtil.generateHubServiceSecret()));
        wizardProperties.setProperty("jetbrains.bundle.enabled.product.services", StringUtils.join(this.myAllServicesInBundle.keySet(), (String)","));
        wizardProperties.setProperty("jetbrains.bundle.conf-path", bundleEnvironment.getConfDir().toString());
        wizardProperties.setProperty("jetbrains.bundle.logs-path", this.myBundleState.getProperties().getAbsoluteBundleDirectory(BundleProperties.FolderType.LOGS).toString());
        wizardProperties.setProperty("jetbrains.bundle.force-warning-on-invalid-base-url", String.valueOf(Boolean.getBoolean("service.configurationWizard.force-warning-on-invalid-base-url")));
        wizardProperties.setProperty("jetbrains.bundle.https-feature-flag", System.getProperty("bundle.wizard.https_feature_flag", String.valueOf(buildProperties.isHttpsInWizardEnabled())));
        this.addFirstMajorReleaseDate(wizardProperties);
        this.setAdditionalKeystoreProperties(wizardProperties);
        this.setDefaultListenPorts(wizardProperties);
        this.addLicenseAgreements(wizardProperties);
        this.addLicenseKeys(wizardProperties);
        this.setWizardToken(wizardProperties);
        this.setServicesInfoAndDefaults(wizardProperties);
        super.configure(wizardProperties);
    }

    @Nullable
    private String getDefaultUpgradeSourceLocation(@NotNull Properties properties, BundleInstallationType installationType) {
        if (installationType == BundleInstallationType.MSI) {
            return null;
        }
        if (installationType == BundleInstallationType.DOCKER) {
            return this.calculateBundleDefaultFolder(properties, BundleProperties.FolderType.BACKUPS);
        }
        return System.getProperty("user.home");
    }

    private void setAdditionalKeystoreProperties(@NotNull Properties wizardProperties) {
        BundleProperties bundleProperties = this.myBundleState.getProperties();
        wizardProperties.setProperty("jetbrains.bundle.additional-keystore-path", bundleProperties.getAdditionalKeystorePath());
        wizardProperties.setProperty("jetbrains.bundle.additional-keystore-store-password", bundleProperties.getAdditionalKeystorePassword());
    }

    private void setDefaultListenPorts(@NotNull Properties properties) {
        BundleProperties bundleProperties = this.myBundleState.getProperties();
        properties.setProperty("jetbrains.bundle.default-non-secure-port", SecureMode.DISABLE.getName().equals(bundleProperties.getSecureMode()) ? String.valueOf(bundleProperties.getListenPort()) : (bundleProperties.getNonSecureRedirectListenPort() != null ? bundleProperties.getNonSecureRedirectListenPort() : String.valueOf(bundleProperties.findFreePort(bundleProperties.getListenAddress(), false))));
        properties.setProperty("jetbrains.bundle.default-secure-port", String.valueOf(SecureMode.DISABLE.getName().equals(bundleProperties.getSecureMode()) ? bundleProperties.findFreePort(bundleProperties.getListenAddress(), true) : bundleProperties.getListenPort()));
    }

    private void addFirstMajorReleaseDate(@NotNull Properties properties) {
        for (ServiceDescriptor descriptor : this.myAllServicesInBundle.values()) {
            if (descriptor.getFirstMajorReleaseDate() == null) continue;
            properties.setProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(descriptor.getId(), "first-major-release-date"), descriptor.getFirstMajorReleaseDate());
        }
    }

    private void addLicenseAgreements(@NotNull Properties properties) {
        boolean licenseAgreementsExists = false;
        for (ServiceDescriptor descriptor : this.myAllServicesInBundle.values()) {
            File licenseAgreement = descriptor.getLicenseAgreementFile();
            if (licenseAgreement == null) continue;
            properties.setProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(descriptor.getId(), "license.agreement.path"), licenseAgreement.getPath());
            properties.setProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(descriptor.getId(), "license.agreement.product.name"), descriptor.getLicenseAgreementProductName());
            licenseAgreementsExists = true;
        }
        if (!licenseAgreementsExists) {
            this.LOG.warn(String.format("No license(s) agreements found for bundle product(s)! Please, set correct '%s' and '%s' properties.", "license.agreement.path", "license.agreement.product.name"));
        }
    }

    private void addLicenseKeys(@NotNull Properties properties) {
        String serviceWithKeyFound = null;
        for (ServiceDescriptor descriptor : this.myAllServicesInBundle.values()) {
            String licenseKey = descriptor.getLicenseKey();
            if (licenseKey == null) continue;
            if (serviceWithKeyFound != null) {
                throw new IllegalStateException(String.format("License keys belonging to different services %s, %s were found. Single service with license key is supported only", serviceWithKeyFound, descriptor.getId()));
            }
            licenseKey = System.getProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(descriptor.getId(), "license-key"), licenseKey);
            String licenseName = System.getProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(descriptor.getId(), "license-user-name"), descriptor.getLicenseUserName());
            properties.setProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(descriptor.getId(), "license-user-name"), licenseName);
            properties.setProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(descriptor.getId(), "license-key"), licenseKey);
            Version version = Version.parseVersion((String)descriptor.getVersion());
            if (version != null) {
                List versionParts = version.getVersionParts();
                Integer majorVersion = (Integer)versionParts.get(0);
                Integer minorVersion = (Integer)versionParts.get(1);
                properties.setProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(descriptor.getId(), "product-major-version"), Integer.toString(majorVersion));
                properties.setProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(descriptor.getId(), "product-minor-version"), Integer.toString(minorVersion));
                if (versionParts.size() == 3) {
                    Integer buildNumber = (Integer)versionParts.get(2);
                    properties.setProperty(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(descriptor.getId(), "product-build-number"), Integer.toString(buildNumber));
                }
            }
            serviceWithKeyFound = descriptor.getId();
        }
        if (serviceWithKeyFound == null) {
            this.LOG.warn(String.format("No license(s) keys found for bundle product(s)! Please, set correct '%s' and '%s' properties.", "license-user-name", "license-key"));
        }
    }

    private void setBundleDefaults(@NotNull Properties properties) {
        BundleState bundleState = this.myBundleState;
        this.setBundleDefaultFolder(properties, BundleProperties.FolderType.DATA);
        this.setBundleDefaultFolder(properties, BundleProperties.FolderType.BACKUPS);
        this.setBundleDefaultFolder(properties, BundleProperties.FolderType.LOGS);
        this.setBundleDefaultFolder(properties, BundleProperties.FolderType.TEMP);
        ConfigurationWizard.setDefaultForProperty(properties, BundleProperty.BASE_URL, bundleState.getProperties().getBaseUrl());
        ConfigurationWizard.setDefaultForProperty(properties, BundleProperty.LISTEN_ADDRESS, bundleState.getProperties().getListenAddress());
        ConfigurationWizard.setDefaultForProperty(properties, BundleProperty.LISTEN_PORT, String.valueOf(bundleState.getProperties().getListenPort()));
        ConfigurationWizard.setDefaultForProperty(properties, BundleProperty.SECURE_MODE, bundleState.getProperties().getSecureMode());
        if (bundleState.getProperties().getNonSecureRedirectListenPort() != null) {
            ConfigurationWizard.setDefaultForProperty(properties, BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT, bundleState.getProperties().getNonSecureRedirectListenPort());
        }
        if (bundleState.getProperties().getTlsServerCertKeyStorePassword() != null) {
            ConfigurationWizard.setDefaultForProperty(properties, BundleProperty.TLS_SERVER_CERT_KEYSTORE_PASSWORD, bundleState.getProperties().getTlsServerCertKeyStorePassword());
        }
        if (bundleState.getProperties().getTlsServerCertKeyStoreAlias() != null) {
            ConfigurationWizard.setDefaultForProperty(properties, BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_ALIAS, bundleState.getProperties().getTlsServerCertKeyStoreAlias());
        }
        if (bundleState.getProperties().getTlsServerCertKeyStoreKeyPassword() != null) {
            ConfigurationWizard.setDefaultForProperty(properties, BundleProperty.TLS_SERVER_CERT_KEYSTORE_KEY_PASSWORD, bundleState.getProperties().getTlsServerCertKeyStoreKeyPassword());
        }
        ConfigurationWizard.setDefaultForProperty(properties, BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG, String.valueOf(bundleState.getProperties().isTlsRedirectionFromHttpEnabled()));
        ConfigurationWizard.setDefaultForProperty(properties, BundleProperty.ROOT_USER, bundleState.getProperties().getRootUser());
        if (bundleState.getProperties().getLocale() != null) {
            ConfigurationWizard.setDefaultForProperty(properties, BundleProperty.LOCALE, bundleState.getProperties().getLocale());
        }
        ConfigurationWizard.setDefaultForDisableServiceProperty(properties, "hub", false);
        properties.setProperty("jetbrains.bundle.listen_address.is_editable", String.valueOf(bundleState.getBuildProperties().isListenAddressEditable()));
        Boolean anonymousAccessAllowed = bundleState.getProperties().isAnonymousAccessAllowed();
        ConfigurationWizard.setDefaultForProperty(properties, BundleProperty.ALLOW_ANONYMOUS_ACCESS, anonymousAccessAllowed == null ? Boolean.TRUE.toString() : String.valueOf(anonymousAccessAllowed));
    }

    private String calculateBundleDefaultFolder(@NotNull Properties properties, @NotNull BundleProperties.FolderType folderType) {
        return this.myBundleState.getUpgradeProperties().isUpgrade() && BundleInstallationType.JAR != this.myBundleState.getEnvironment().getInstallationConfig().getInstallationType() ? this.myBundleState.getProperties().getDefaultAbsoluteBundleDirectory(folderType).toString() : this.myBundleState.getProperties().getAbsoluteBundleDirectory(folderType).toString();
    }

    private void setBundleDefaultFolder(@NotNull Properties properties, @NotNull BundleProperties.FolderType folderType) {
        String defaultFolderValue = this.calculateBundleDefaultFolder(properties, folderType);
        ConfigurationWizard.setDefaultForProperty(properties, folderType.getBundleProperty(), defaultFolderValue);
    }

    private static void setDefaultForProperty(@NotNull Properties properties, BundleProperty bundleProperty, @NotNull String defaultValue) {
        properties.setProperty(ConfigurationWizard.constructDefaultsPropertyName(bundleProperty.getPrefixedName()), defaultValue);
    }

    private static void setDefaultForDisableServiceProperty(@NotNull Properties properties, @NotNull String serviceId, boolean defaultValue) {
        properties.setProperty(ConfigurationWizard.constructDefaultsPropertyName(BundleProperty.constructDisableServiceProperty((String)serviceId)), Boolean.valueOf(defaultValue).toString());
    }

    private static String constructDefaultsPropertyName(String propertyName) {
        return "jetbrains." + propertyName + ".default";
    }

    private void setServicesInfoAndDefaults(@NotNull Properties properties) {
        this.setBundleDefaults(properties);
    }

    private static void setPropertyIfNotNull(@NotNull Properties properties, @NotNull String property, @Nullable String value) {
        if (value != null) {
            properties.setProperty(property, value);
        }
    }

    @NotNull
    private static SupportedLocales getSupportedLocales(Map<String, ServiceDescriptor> serviceMap) {
        SupportedLocales result;
        ArrayList locales = null;
        ArrayList<Locale> allCommunityLocales = new ArrayList<Locale>();
        for (ServiceDescriptor serviceDescriptor : serviceMap.values()) {
            Collection<Locale> serviceCommunityLocales = serviceDescriptor.getSupportedCommunityLocales();
            allCommunityLocales.addAll(serviceCommunityLocales);
            ArrayList<Locale> allServiceSupportedLocales = new ArrayList<Locale>();
            allServiceSupportedLocales.addAll(serviceDescriptor.getSupportedLocales());
            allServiceSupportedLocales.addAll(serviceCommunityLocales);
            if (allServiceSupportedLocales.isEmpty() && !serviceDescriptor.isInternal()) {
                allServiceSupportedLocales.addAll(DEFAULT_SUPPORTED_LOCALES);
            }
            if (allServiceSupportedLocales.isEmpty()) continue;
            if (locales == null) {
                locales = new ArrayList(allServiceSupportedLocales);
                continue;
            }
            locales.retainAll(allServiceSupportedLocales);
        }
        if (locales == null) {
            result = new SupportedLocales(DEFAULT_SUPPORTED_LOCALES, Collections.emptyList());
        } else {
            if (locales.isEmpty()) {
                throw new IllegalStateException("There is no locale exists that is supported by all services in Bundle");
            }
            result = new SupportedLocales();
            for (Locale locale : locales) {
                result.add(locale, allCommunityLocales.contains(locale));
            }
        }
        return result;
    }

    public static class SupportedLocales {
        private final List<Locale> locales;
        private final List<Locale> localesCommunity;

        private SupportedLocales() {
            this(Collections.emptyList(), Collections.emptyList());
        }

        private SupportedLocales(@NotNull List<Locale> locales, @NotNull List<Locale> localesCommunity) {
            this.locales = new ArrayList<Locale>(locales);
            this.localesCommunity = new ArrayList<Locale>(localesCommunity);
        }

        private void add(Locale locale, boolean isCustom) {
            if (isCustom) {
                this.localesCommunity.add(locale);
            } else {
                this.locales.add(locale);
            }
        }

        @NotNull
        List<Locale> getLocales() {
            return this.locales;
        }

        @NotNull
        List<Locale> getCommunityLocales() {
            return this.localesCommunity;
        }
    }
}

