/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.charisma.authentication;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.authentication.IAuthenticationManager;
import jetbrains.charisma.service.UserService;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.userManagement.runtime.SecurityNavigator;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.ControllerOperations;
import webr.framework.runtime.response.ResponseAction;

public abstract class BaseAuthenticationManager
implements IAuthenticationManager {
    protected static Log log = LogFactory.getLog(BaseAuthenticationManager.class);

    @Override
    public final void logout(String returnTo) {
        ((SecurityNavigator)ServiceLocator.getBean((String)"securityNavigator")).saveRequestedUrl(returnTo);
        this.logout(returnTo, this.getLogout().url());
    }

    @Override
    public void logout(String returnTo, String redirectTo) {
        ((SecurityNavigator)ServiceLocator.getBean((String)"securityNavigator")).logout(returnTo, redirectTo);
    }

    @Override
    public ResponseAction redirectToLoginWithError(String state, String error) {
        if (log.isWarnEnabled()) {
            log.warn((Object)("Redirect to login because of error: " + error));
        }
        return ControllerOperations.getRedirectResponseAction((String)this.getLogin().renew().returnTo(state).withMessage(error).url());
    }

    public abstract class LoginUrlBuilder
    implements IAuthenticationManager.LoginUrlBuilder {
        protected String username;
        protected String message;
        protected boolean gateway = false;
        protected boolean renew = false;
        protected String returnTo;

        @Override
        public IAuthenticationManager.LoginUrlBuilder withUsername(String username) {
            this.username = username;
            return this;
        }

        @Override
        public IAuthenticationManager.LoginUrlBuilder withMessage(String message) {
            this.message = message;
            return this;
        }

        @Override
        public IAuthenticationManager.LoginUrlBuilder gateway() {
            this.gateway = !EntityOperations.equals((Entity)((UserService)ServiceLocator.getBean((String)"userService")).getGuest(), null);
            return this;
        }

        @Override
        public IAuthenticationManager.LoginUrlBuilder renew() {
            this.renew = true;
            return this;
        }

        @Override
        public IAuthenticationManager.LoginUrlBuilder returnTo(String returnTo) {
            this.returnTo = returnTo;
            return this;
        }
    }

    public abstract class LogoutUrlBuilder
    implements IAuthenticationManager.LogoutUrlBuilder {
    }
}

